<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Construction extends MY_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('accountingmodel');
        $this->load->model('accountingreportmodel');
        $this->load->model('clientmodel');
        $this->load->model('clientreportmodel');
        $this->load->model('constructionmodel');
        $this->load->model('hrmodel');
        $this->load->model('hrreportmodel');
        $this->load->model('mastermodel');
        $this->load->model('propertyreportmodel');
        $this->load->model('posreportmodel');
        $this->load->model('propertymodel');
        $this->load->model('posmodel');
        $this->load->model('salesmodel');
        
        $this->load->helper('to_pdf');
    }

    public function view($folder, $page) {
        $this->load->view($folder . '/' . $page);
    }

    function get_post_values() {
        $data = array();
        foreach ($_POST as $key => $value) {
            if ($key != "submit") {
                $data[$key] = $this->input->post($key);
            }
        }
        return $data;
    }

    function addformdisplay($page, $directory, $return_page = '') {
        $data = array();
        $data['return_page'] = $return_page;

        $json_data = $this->load->view('' . $directory . '/' . $page . '', $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1));
    }

    function viewinconstructionsearch($modelfunction,$subfolder, $page, $pagenum) {

        $output = $this->constructionmodel->$modelfunction($pagenum);
        $data['viewinfo'] = $output['results'];
        $json_data = $this->load->view('construction/'.$subfolder.'/' . $page . '', $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1));
    }

    function addinconstruction($modelfunction, $resfunction,$subfolder, $page) {
        $postdata = $this->get_post_values();
        $data = $this->constructionmodel->$modelfunction($postdata);
        $json_msg = $this->load->view('message', $data, TRUE);

        $output = $this->constructionmodel->$resfunction($_SESSION['pagenum']);
        $data['viewinfo'] = $output['results'];
        $json_data = $this->load->view('construction/'.$subfolder.'/' .  $page . '', $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1, 'json_msg' => $json_msg));
    }

    function edit_page($id, $table, $field,$subfolder, $page) {
        $data['viewinfo'] = $this->mastermodel->get_data_srow($table, $id, $field);
        $data['id'] = $id;
        $json_data = $this->load->view('construction/'.$subfolder.'/' .$page, $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1));
    }

    function single_page($id, $table, $field,$subfolder, $page) {
        $data['viewinfo'] = $this->mastermodel->get_data_srow($table, $id, $field);
        $data['id'] = $id;
        $this->load->view('master/' . $page, $data);
    }

    function deletedata($table, $id, $field) {
        $data = array();
        $perm = $this->mastermodel->check_user_permission($_SESSION['current_menu'], $_SESSION['profile_id'], 3);
        if (!$perm)
            $data['msg'] = "Permission Denied";
        else
            $data = $this->mastermodel->deletedata($table, $id, $field);
        $arr = array('msg' => $data['msg'], 'res' => $data['res']);
        $this->load->view('message', $data);
    }
    function get_saved_values($model, $main_id)
    {
        $data['viewinfo'] = $this->constructionmodel->$model($main_id);
        echo json_encode($data);
    }
    function get_saved_values_sub($modelfunction,$page,$id)
    {
     $postdata['viewinfo'] = $this->constructionmodel->$modelfunction($id);
     $data['label'] =$this->load->view('construction/inventory/'.$page, $postdata, TRUE);  
     echo json_encode($data);
        
    }
     function do_ajax($model,$modelfn)
    {   
        $postdata = $this->get_post_values();
        $data['value'] = call_user_func_array(array($this->$model, $modelfn), $postdata); 
        echo json_encode($data);
    }
      public function get_requestlist_by_multiple_sites()
    {
        $data['viewinfo'] = $this->constructionmodel->get_requestlist_by_multiple_sites();
        echo json_encode($data);
    }
     public function get_requestlist_tools()
    {
        $data['viewinfo'] = $this->constructionmodel->get_requestlist_tools();
        echo json_encode($data);
    }
      public function get_requestlist_alloc_tools()
    {
        $data['viewinfo'] = $this->constructionmodel->get_requestlist_alloc_tools();
        echo json_encode($data);
    }
    public function load_item_page($modelfunction, $page, $val)
    {
        $array = array();
        $array = explode('~', $val);
        $data['viewinfo'] = $this->constructionmodel->$modelfunction($array);

        $data['view'] = $this->load->view('construction/inventory/' . $page, $data, TRUE);
        echo json_encode($data);
    }
     public function load_tool_page($modelfunction, $page, $val)
    {
        $array = array();
        $array = explode('~', $val);
        $data['viewinfo'] = $this->constructionmodel->$modelfunction($array);

        $data['view'] = $this->load->view('construction/rented/' . $page, $data, TRUE);
        echo json_encode($data);
    }
    function get_quoitem($q_id)
    {
        $data['content'] = $this->constructionmodel->get_quoitem($q_id);
        $value['page'] = $this->load->view('construction/management/order_work_details',$data, TRUE);
        echo json_encode($value);
    }
    public function load_select_category_list()
    {
      
        $data['items'] = $this->constructionmodel->get_search_category($_POST['term']);
        echo json_encode($data);
    }
     public function load_select_costcentre_list()
    {
        $data['items'] = $this->accountingmodel->get_search_costcentre($_POST['term']);
        echo json_encode($data);
    }
     public function load_select_commodity_list($id)
    {
        $data['items'] = $this->constructionmodel->get_commoditymaster_by_category($id, $_POST['term']);
        echo json_encode($data);
    }
     public function get_stock()
    {
          $postdata = $this->get_post_values();
         $data = $this->mastermodel->get_single_field_value('prop_item_stock','prop_item_stock_qty','prop_item_stock_id',$postdata['item_id']);
        echo json_encode($data);
     }
      function set_manager_approval($po_management_id)
    {
        $data['viewinfo'] = $this->constructionmodel->set_manager_approval($po_management_id);
      
        if ($data['viewinfo'] != 0)
        {
            $output['status'] = true;
          
        } else
        {
            $output['status'] = false;
            $output = 0;
        }
        echo json_encode($output);
    }
     function set_gm_approval($po_gm_id)
    {
        $data['viewinfo'] = $this->constructionmodel->set_gm_approval($po_gm_id);
       
        if ($data['viewinfo'] != 0)
        {
            $output['status'] = true;
//            $output['view'] = $this->load->view($_SESSION['project_folder'] . '/purchase/view_po_management', $data, true);
        } else
        {
            $output['status'] = false;
            $output = 0;
        }
        echo json_encode($output);
    }
       public function load_tool_list()
    {
        $data['tools'] = $this->constructionmodel->get_search_tool($_POST['term']);
        echo json_encode($data);
    }
     public function load_tool_order($modelfunction, $page, $val)
    {
        $array = array();
        $array = explode('~', $val);
        $data['viewinfo'] = $this->constructionmodel->$modelfunction($array);

        $data['view'] = $this->load->view('construction/rented/' . $page, $data, TRUE);
        echo json_encode($data);
    }
    function load_details_page($modelfunction,$page)
    { 
        $value['content'] = $this->constructionmodel->$modelfunction($this->get_post_values());
        $data['view'] = $this->load->view('construction/rented/' . $page, $value, TRUE);
        echo json_encode($data);
    }
    
    function delete_pageinpurchase($modelfunction, $id) {
        $data = array();
        $perm = $this->mastermodel->check_user_permission($_SESSION['current_menu'], $_SESSION['profile_id'], 3);
        if (!$perm)
            $data['msg'] = "Permission Denied";
        else
            $data = $this->constructionmodel->$modelfunction($id);
        $arr = array('msg' => $data['msg'], 'res' => $data['res']);
        $this->load->view('message', $data);
    }
    public function load_map_page() {
        

        $this->load->view('construction/map');

    }
    public function edit_map_page() {
        $postdata = $this->get_post_values();
        $data['lat'] = $postdata['lat'];
        $data['long'] = $postdata['long'];
        $data['address'] = $postdata['address'];
//         $data['sub_category_id']=$postdata['sub_category_id'];
        $this->load->view('construction/edit_property_map', $data);
    }
    
      function add_session_invoice_type(){
        $invoice_type_id = $_POST['invoice_type_id'];
        $invoice_type = $_POST['invoice_type'];
        $_SESSION['invoice_type']=$invoice_type;
        $_SESSION['invoice_type_id']=$invoice_type_id;
        echo 1;
    }
}
?>
