<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Constructionreport extends MY_Controller 
{
    public function __construct() 
    {
        parent::__construct();
        $this->load->model('accountingmodel');
        $this->load->model('accountingreportmodel');
        $this->load->model('clientmodel');
        $this->load->model('clientreportmodel');
        $this->load->model('constructionmodel');
        $this->load->model('hrmodel');
        $this->load->model('hrreportmodel');
        $this->load->model('mastermodel');
        $this->load->model('propertyreportmodel');
        $this->load->model('propertymodel');
        $this->load->model('constructionreportmodel');
        
        $this->load->helper('to_pdf');

    }

    function get_post_values()
    {
        $data = array();
        foreach ($_POST as $key => $value)
        {
            if($key != "submit")
            {
                $data[$key] =  $this->input->post($key);
            }
        }
        return $data;
    }
    function viewinreportsearch($modelfunction,$subfolder, $page)
    {
        $output = $this->propertyreportmodel->$modelfunction();
        $data['viewinfo'] = $output['results'];
        $json_data=$this->load->view('construction/'.$subfolder.'/'. $page . '', $data,TRUE);
        echo json_encode(array('json_data'=>$json_data,'json_perm'=>1));
    }
    
    function addinreport($modelfunction, $resfunction,$subfolder, $page)
    {
        $postdata = $this->get_post_values();
        $data = array();
        $data = $this->propertyreportmodel->$modelfunction($postdata);
        $json_msg=$this->load->view('message', $data,TRUE);
        $output = $this->propertyreportmodel->$resfunction($_SESSION['pagenum']);
        $data['viewinfo'] = $output['results'];
        $json_data=$this->load->view('construction/'.$subfolder.'/' . $page . '', $data,TRUE);
        echo json_encode(array('json_data'=>$json_data,'json_perm'=>1,'json_msg'=>$json_msg));
    }

  
     function edit_page($id, $table, $field,$subfolder, $page) {
        $data['viewinfo'] = $this->mastermodel->get_data_srow($table, $id, $field);
        $data['id'] = $id;
        $json_data = $this->load->view('property/'.$subfolder.'/' .$page, $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1));
    }
    
    function single_page($id, $table, $field,$subfolder, $page)
    { 
        $data['viewinfo'] = $this->mastermodel->get_data_srow($table, $id, $field);
        $data['id'] = $id;
        $this->load->view('property/'.$subfolder.'/' . $page, $data);
    }
   
    
  
     function decidetodownload($mainfolder,$subfolder,$page, $viewdata, $filename)
    {

     

        if (isset($_POST['ispdf']) && $_POST['ispdf'] == 1)
        {
            $html = $this->load->view($mainfolder.'/'.$subfolder.'/' . $page, $viewdata, true);
            pdf_create($html, $filename, false);
        } else if (isset($_POST['ispdf']) && $_POST['ispdf'] == 2)
        {
            $html = $this->load->view($mainfolder.'/'.$subfolder.'/' . $page, $viewdata, true);
            header("Content-type: application/octet-stream");
            header("Content-Disposition: attachment; filename=" . $filename . ".xls");
            header("Pragma: no-cache");
            header("Expires: 0");
            echo $html;
            exit;
        } else
        {
            $html = $this->load->view($mainfolder.'/'.$subfolder.'/'  . $page, $viewdata, true);
            echo $html;
        }
    }
    function load_project_report($mainfolder,$subfolder,$page)
    { 
        $viewdata = array();
        $postdata = $this->get_post_values();
        if (empty($postdata['project_id']))
        {
            $viewdata['viewinfo'] = $this->mastermodel->select_data('con_project','con_project_id');
        }
        else
        {
            $viewdata['viewinfo'] = $this->mastermodel->select_data_by_id("con_project","con_project_id",$postdata['project_id']);
        }
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Project Report');
    }
    function load_customer_report($mainfolder,$subfolder,$page)
    { 
        $viewdata = array();
        $postdata = $this->get_post_values();
        if (empty($postdata['contact_id']))
        {
            $viewdata['viewinfo'] = $this->mastermodel->selected_data('contact',array('contact_id','contact_code','contact_first_name','contact_last_name','contact_mobile_1','contact_fax','contact_email'));
        }
        else
        {
            $viewdata['viewinfo'] = $this->mastermodel->selected_data_by_id("contact",array('contact_id','contact_code','contact_first_name','contact_last_name','contact_mobile_1','contact_fax','contact_email',$postdata['contact_id']));
        }
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Customer Report');
    }
     function load_purchase_order_report($mainfolder,$subfolder,$page)
    { 
        $viewdata = array();
        $postdata = $this->get_post_values();
      
            $viewdata['viewinfo'] = $this->constructionreportmodel->purchase_order_report($postdata);
        
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Purchase Order Report');
    }
    function load_quotation_report($mainfolder,$subfolder,$page)
    { 
        $viewdata = array();
        $postdata = $this->get_post_values();
        $viewdata['viewinfo'] = $this->constructionreportmodel->load_quotation_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Quotation Report');
    }
    function load_budgeting_report($mainfolder,$subfolder,$page)
    { 
        $viewdata = array();
        $postdata = $this->get_post_values();
        $viewdata['viewinfo'] = $this->constructionreportmodel->load_budgeting_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Budgeting Report');
    }
    function load_Item_retun_report($mainfolder,$subfolder,$page)
    { 
        $viewdata = array();
        $postdata = $this->get_post_values();
        $viewdata['viewinfo'] = $this->constructionreportmodel->load_Item_retun_report($postdata); 
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Item Return Report');
    }
    function load_workorder_report($mainfolder,$subfolder,$page)
    { 
        $viewdata = array();
        $postdata = $this->get_post_values();
        $viewdata['viewinfo'] = $this->constructionreportmodel->load_workorder_report($postdata); 
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Item Return Report');
    }
    function load_purchase_report($mainfolder,$subfolder,$page)
    { 
        $viewdata = array();
        $postdata = $this->get_post_values();
        $viewdata['viewinfo'] = $this->constructionreportmodel->load_purchase_report($postdata); 
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Item Return Report');
    }
       function load_project_allocation_report($mainfolder,$subfolder,$page)
    { 
        $viewdata = array();
        $postdata = $this->get_post_values();
        $viewdata['viewinfo'] = $this->constructionreportmodel->load_project_allocation_report($postdata); 
        
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Project Allocation Report');
    }
    function load_itemStock_report($mainfolder,$subfolder,$page)
    { 
        $viewdata = array();
        $postdata = $this->get_post_values();
        $viewdata['viewinfo'] = $this->constructionreportmodel->get_itemStock_report($postdata);
       
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Item Stock');
    }
    function load_view_wise_rented_tool_report($mainfolder,$subfolder,$page)
    { 
        $viewdata = array();
        $postdata = $this->get_post_values();
        $viewdata['viewinfo'] = $this->constructionreportmodel->load_view_wise_rented_tool_report($postdata);
       
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Item Stock');
    }
    function view_vendorWise_orderwice_report($mainfolder,$subfolder,$page)
    { 
        $viewdata = array();
        $postdata = $this->get_post_values();
        $viewdata['viewinfo'] = $this->constructionreportmodel->view_vendorWise_orderwice_report($postdata);
       
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Item Stock');
    }
    
}
