<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Hrreport extends MY_Controller 
{
    public function __construct() 
    {
        parent::__construct();
        $this->load->model('accountingmodel');
        $this->load->model('accountingreportmodel');
        $this->load->model('clientmodel');
        $this->load->model('clientreportmodel');
    
        $this->load->model('hrmodel');
        $this->load->model('hrreportmodel');
        $this->load->model('mastermodel');
 
        
        $this->load->helper('to_pdf');

    }

    function get_post_values()
    {
        $data = array();
        foreach ($_POST as $key => $value)
        {
            if($key != "submit")
            {
                $data[$key] =  $this->input->post($key);
            }
        }
        return $data;
    }
    function viewinreportsearch($modelfunction,$subfolder, $page)
    {
        $output = $this->hrreportmodel->$modelfunction();
        $data['viewinfo'] = $output['results'];
        $json_data=$this->load->view('hr/'.$subfolder.'/'. $page . '', $data,TRUE);
        echo json_encode(array('json_data'=>$json_data,'json_perm'=>1));
    }
    
    function addinreport($modelfunction, $resfunction,$subfolder, $page)
    {
        $postdata = $this->get_post_values();
        $data = array();
        $data = $this->hrreportmodel->$modelfunction($postdata);
        $json_msg=$this->load->view('message', $data,TRUE);
        $output = $this->hrreportmodel->$resfunction($_SESSION['pagenum']);
        $data['viewinfo'] = $output['results'];
        $json_data=$this->load->view('hr/'.$subfolder.'/' . $page . '', $data,TRUE);
        echo json_encode(array('json_data'=>$json_data,'json_perm'=>1,'json_msg'=>$json_msg));
    }

  
     function edit_page($id, $table, $field,$subfolder, $page) {
        $data['viewinfo'] = $this->mastermodel->get_data_srow($table, $id, $field);
        $data['id'] = $id;
        $json_data = $this->load->view('hr/'.$subfolder.'/' .$page, $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1));
    }
    
    function single_page($id, $table, $field,$subfolder, $page)
    { 
        $data['viewinfo'] = $this->mastermodel->get_data_srow($table, $id, $field);
        $data['id'] = $id;
        $this->load->view('hr/'.$subfolder.'/' . $page, $data);
    }
   
    
  
     function decidetodownload($mainfolder,$subfolder,$page, $viewdata, $filename)
    {

        //var_dump($_POST['ispdf']);

        if (isset($_POST['ispdf']) && $_POST['ispdf'] == 1)
        {
//            $html = $this->load->view($mainfolder.'/'.$subfolder.'/' . $page, $viewdata, true);
//            pdf_create($html, $filename, false);
                $this->load->library('Pdf');

     $this->load->view($mainfolder.'/'.$subfolder.'/' . $page.'_pdf', $viewdata);
         
        } else if (isset($_POST['ispdf']) && $_POST['ispdf'] == 2)
        {
            $html = $this->load->view($mainfolder.'/'.$subfolder.'/' . $page, $viewdata, true);
            header("Content-type: application/octet-stream");
            header("Content-Disposition: attachment; filename=" . $filename . ".xls");
            header("Pragma: no-cache");
            header("Expires: 0");
            echo $html;
            exit;
        } else
        {
            $html = $this->load->view($mainfolder.'/'.$subfolder.'/'  . $page, $viewdata, true);
            echo $html;
        }
    }
    function load_employee_shift_report($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
        $postdata = $this->get_post_values();
        
        $viewdata['viewinfo'] = $this->hrreportmodel->load_employee_shift_report($postdata);
        $viewdata['hr_assign_shift_employee'] =  $postdata['hr_assign_shift_employee'];
         $viewdata['hr_shift_details_id'] =  $postdata['hr_shift_details_id'];
         
          $viewdata['to_date'] =  $postdata['to_date'];
         $viewdata['from_date'] =  $postdata['from_date'];
         
      $logo = $this->mastermodel->get_srow('company','company_logo');
           
             $viewdata['logo'] = $logo->company_logo;
            
              $add = $this->mastermodel->get_srow('company','company_address');
             $viewdata['company_address'] = $add->company_address;
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Employee Shift Report');
    }
     function load_leave_report($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
        $postdata = $this->get_post_values();
      
        $viewdata['viewinfo'] = $this->hrreportmodel->load_leave_report($postdata);
        
         $viewdata['hr_leave_type_id'] =  $postdata['hr_leave_type_id'];
         $viewdata['hr_employee'] =  $postdata['hr_employee'];
         
          $viewdata['to_date'] =  $postdata['to_date'];
         $viewdata['from_date'] =  $postdata['from_date'];
        $logo = $this->mastermodel->get_srow('company','company_logo');
           
             $viewdata['logo'] = $logo->company_logo;
            
              $add = $this->mastermodel->get_srow('company','company_address');
             $viewdata['company_address'] = $add->company_address;
        
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Leave Report');
    }
        function load_shift_report($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
        $postdata = $this->get_post_values();
        
        $viewdata['viewinfo'] = $this->hrreportmodel->load_shift_report($postdata);
     $logo = $this->mastermodel->get_srow('company','company_logo');
           
             $viewdata['logo'] = $logo->company_logo;
            
              $add = $this->mastermodel->get_srow('company','company_address');
             $viewdata['company_address'] = $add->company_address;
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Shift Report');
    }
     function load_leave_balance_report($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
          $viewdata['frmdate'] = $this->input->post('from_date');
        $viewdata['todate'] = $this->input->post('to_date');
        $postdata = $this->get_post_values();
      
        $viewdata['employee'] = $this->hrreportmodel->leave_balance_employ($postdata);
         $viewdata['viewinfo'] = $this->hrreportmodel->load_leave_balance_report($postdata);
         
         $logo = $this->mastermodel->get_srow('company','company_logo');
           
             $viewdata['logo'] = $logo->company_logo;
            
              $add = $this->mastermodel->get_srow('company','company_address');
             $viewdata['company_address'] = $add->company_address;
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Leave Balance Report');
    }
    public function attendance_report_generation($mainfolder,$subfolder, $page)
    {

        $data = array();
        $output_type = $this->input->post('output_type');
        $data['frmdate'] = $this->input->post('from_date');
        $data['todate'] = $this->input->post('to_date');
        $postdata = $this->get_post_values();
        $data['viewinfo'] = $this->hrreportmodel->get_employees_det($postdata);
        $logo = $this->mastermodel->get_srow('company','company_logo');
           
             $data['logo'] = $logo->company_logo;
            
              $add = $this->mastermodel->get_srow('company','company_address');
             $data['company_address'] = $add->company_address;
        $this->decidetodownload($mainfolder,$subfolder,$page, $data, 'Monthly Attendence Report');
    }
    public function punch_report_generation($mainfolder,$subfolder, $page)
    {

        $data = array();
        $output_type = $this->input->post('output_type');
        $data['frmdate'] = $this->input->post('from_date');
        $data['todate'] = $this->input->post('to_date');
        $postdata = $this->get_post_values();
        $data['viewinfo'] = $this->hrreportmodel->load_punch_report($postdata);
        $logo = $this->mastermodel->get_srow('company','company_logo');
           
             $data['logo'] = $logo->company_logo;
            
              $add = $this->mastermodel->get_srow('company','company_address');
             $data['company_address'] = $add->company_address;
        $this->decidetodownload($mainfolder,$subfolder,$page, $data, 'Monthly Attendence Report');
    }
       public function load_expiry_report($mainfolder,$subfolder, $page)
    {

        $data = array();
        $output_type = $this->input->post('output_type');
        $data['todate'] = $this->input->post('to_date');
        $postdata = $this->get_post_values();
        $data['viewinfo'] = $this->hrreportmodel->load_expiry_report($postdata);
        $logo = $this->mastermodel->get_srow('company','company_logo');
           
             $data['logo'] = $logo->company_logo;
            
              $add = $this->mastermodel->get_srow('company','company_address');
             $data['company_address'] = $add->company_address;
        $this->decidetodownload($mainfolder,$subfolder,$page, $data, 'Expiry Report');
    }
      function get_employee_details($id)
    {
       
        $data['voucher_detail'] = $this->hrreportmodel->employee_details($id);
        $output = $this->load->view('hr/report/single_employee', $data, TRUE);
        echo json_encode($output);
    }
        public function load_employee_late_report($mainfolder,$subfolder, $page)
    {

        $data = array();
        $output_type = $this->input->post('output_type');
        $postdata = $this->get_post_values();
         $data['todate'] = $postdata['to_date'];
          $data['frmdate'] = $postdata['from_date'];
           $data['hr_employees_id'] = $postdata['hr_employees_id'];
            $logo = $this->mastermodel->get_srow('company','company_logo');
           
             $data['logo'] = $logo->company_logo;
            
              $add = $this->mastermodel->get_srow('company','company_address');
             $data['company_address'] = $add->company_address;
        $data['viewinfo'] = $this->hrreportmodel->get_employees_det($postdata);
        
        $this->decidetodownload($mainfolder,$subfolder,$page, $data, 'Employee Late Report');
    }
     public function load_employee_overtime_report($mainfolder,$subfolder, $page)
    {

        $data = array();
        $output_type = $this->input->post('output_type');
        $postdata = $this->get_post_values();
         $data['todate'] = $postdata['to_date'];
          $data['frmdate'] = $postdata['from_date'];
           $data['hr_employees_id'] = $postdata['hr_employees_id'];
        $data['viewinfo'] = $this->hrreportmodel->get_employees_det($postdata);
        $logo = $this->mastermodel->get_srow('company','company_logo');
           
             $data['logo'] = $logo->company_logo;
            
              $add = $this->mastermodel->get_srow('company','company_address');
             $data['company_address'] = $add->company_address;
        $this->decidetodownload($mainfolder,$subfolder,$page, $data, 'Employee Overtime Report');
    }
       public function load_payslip_report($mainfolder,$subfolder, $page)
    {

        $data = array();
        $output_type = $this->input->post('output_type');
        $postdata = $this->get_post_values();
         $data['todate'] = $postdata['to_date'];
          $data['frmdate'] = $postdata['from_date'];
        $data['viewinfo'] = $this->hrreportmodel->get_payslip_det($postdata);
      
        $logo = $this->mastermodel->get_srow('company','company_logo');
           
             $data['logo'] = $logo->company_logo;
            
              $add = $this->mastermodel->get_srow('company','company_address');
             $data['company_address'] = $add->company_address;
        $this->decidetodownload($mainfolder,$subfolder,$page, $data, 'Pay Slip Report');
    }
}
