<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Master extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('accountingmodel');
        $this->load->model('accountingreportmodel');
        $this->load->model('clientmodel');
        $this->load->model('clientreportmodel');
        $this->load->model('constructionmodel');
        $this->load->model('hrmodel');
        $this->load->model('hrreportmodel');
        $this->load->model('mastermodel');
        $this->load->model('propertyreportmodel');
        $this->load->model('propertymodel');
        $this->load->model('posmodel');
        $this->load->model('salesmodel');
        $this->load->helper('to_pdf');
    }

    public function index($menuid = "", $modid = "")
    {
        $ret = $this->mastermodel->chk_url_permission($menuid);
      
        if ($ret != 1)
        {
            $menuid = "";
            $modid = "";
        }
        if (empty($modid))
        {
            $data['module_name'] = 'home';
            $data['module_title'] = 'Home';
            $data['module_id'] = '';
        } else
        {
            $mod_id = $this->mastermodel->get_data_srow('module', $modid, 'module_id');
            $data['module_name'] = $mod_id->module_name;
            $data['module_title'] = $mod_id->module_title;
            $data['module_id'] = $modid;
        }
        if (empty($menuid))
        {
            $target = 'index';
            $data['menu_name'] = '';
            $data['menu_id'] = $menuid;
            $data['is_public'] = 1;
            $data['modulelist'] = $this->mastermodel->getmoduledatamaster();
        } else
        {
            $tar = $this->mastermodel->get_data_srow('menu', $menuid, 'menu_id');


            $target = $tar->target;
            $data['menu_name'] = $tar->caption;
            $data['parent_menu_id'] = $tar->parent_menu_id;
            $data['menu_id'] = $menuid;
        }
 
        $_SESSION['menu_id'] = $data['menu_id'];
        $_SESSION['parent_menu_id'] = $data['parent_menu_id'];
        $_SESSION['searchdata'] = "";
        $_SESSION['current_menu'] = $menuid;
        $_SESSION['current_mode'] = $menuid;
        $_SESSION['current_module'] = $modid;
        $_SESSION['module_name'] = $data['module_name'];
        $_SESSION['menu_name'] = $data['menu_name'];
        $_SESSION['policy'] = $this->mastermodel->get_srow('company', 'company_attendance_policy')->company_attendance_policy;
        $_SESSION['main_menu_id'] = $this->mastermodel->get_single_field_value('menu', 'parent_menu_id', 'menu_id', $_SESSION['parent_menu_id']);
        $currency_format = $this->mastermodel->get_srow('pos_inventory_general_settings', 'currency_format');
         $_SESSION['administrator_privilage'] = $this->mastermodel->get_single_field_value('user_profile', 'administrator_privilage', 'profile_id',$_SESSION['profile_id']);
        $employee_id = $this->mastermodel->get_single_field_value('user', 'employee_id', 'user_id', $_SESSION['user_id']);
        if($employee_id != NULL){
           $_SESSION['employee_branch'] = $this->mastermodel->get_single_field_value('hr_employees', 'hr_employees_branch', 'hr_employees_id',$employee_id);
         
        }
        
          $_SESSION['branch_id'] = $this->mastermodel->get_single_field_value('user', 'branch_id', 'user_id', $_SESSION['user_id']);
       
        $_SESSION['currency_format'] = $currency_format->currency_format;
//          $qty_format = $this->mastermodel->get_srow('pos_inventory_general_settings', 'qty_format');
        $_SESSION['qty_format'] = $currency_format->qty_format;
        $_SESSION['module_title'] = $data['module_title'];
        $_SESSION['unique_form'] = '';
         
        $financial_year = $this->mastermodel->get_financial_year();
          $_SESSION['financial_year_fromdate'] = $financial_year->financial_year_fromdate;
          $_SESSION['financial_year_todate'] =  $financial_year->financial_year_todate;
     
        $data['modules'] = $this->mastermodel->build_module();
        if ($data['module_name'] == 'home'){
             $profile_settings = $this->mastermodel->get_profile_settings();
            if ($profile_settings->collector_profile_id == $_SESSION['profile_id']) {
                $target="collector";
            }else if($profile_settings->lawyer_profile_id == $_SESSION['profile_id']){
                $target="lawyer";
            }else if($profile_settings->agency_profile_id == $_SESSION['profile_id']){
                $target="agency";
            }else if($profile_settings->regional_profile_id == $_SESSION['profile_id']){
                $target="region";
            }
            $this->load->view($data['module_name'] . '/' . $target . '', $data);
        }else{
            $this->load->view($target, $data);
        }
    }

    public function view($folder, $page)
    {

        $this->load->view($folder . '/' . $page);
    }

    function get_post_values()
    {
        $data = array();
        foreach ($_POST as $key => $value)
        {
            if ($key != "submit")
            {
                $data[$key] = $this->input->post($key);
            }
        }
        return $data;
    }

    function addformdisplay($page, $directory, $subfolder = "", $return_page = '')
    {


        $data = array();
        $data['return_page'] = $return_page;
        if (!empty($subfolder))
        {
            $json_data = $this->load->view('' . $directory . '/' . $subfolder . '/' . $page . '', $data, TRUE);
        } else
        {
            $json_data = $this->load->view('' . $directory . '/' . $page . '', $data, TRUE);
        }
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1));
    }

    function viewinmastersearch($modelfunction, $page, $pagenum)
    {
        $output = $this->mastermodel->$modelfunction($pagenum);
        $data['viewinfo'] = $output['results'];
        $json_data = $this->load->view('master/' . $page . '', $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1));
    }

    function addinmaster($modelfunction, $resfunction, $page)
    {
        $postdata = $this->get_post_values();
        $data = $this->mastermodel->$modelfunction($postdata);
        $json_msg = $this->load->view('message', $data, TRUE);
        ;
        $output = $this->mastermodel->$resfunction($_SESSION['pagenum']);
        $data['viewinfo'] = $output['results'];
        $json_data = $this->load->view('master/' . $page . '', $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1, 'json_msg' => $json_msg));
    }

    function edit_page($id, $table, $field, $page)
    {
        $data['viewinfo'] = $this->mastermodel->get_data_srow($table, $id, $field);
        $data['id'] = $id;
        $json_data = $this->load->view('master/' . $page, $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1));
    }

    function get_unit($event_id)
    {
        $data = $this->mastermodel->get_single_field_value('event_category', 'unit_price', 'event_id', $event_id);

        echo $data;
    }

    function rate_page($table, $field, $id, $page)
    {
        $data['viewinfo'] = $this->mastermodel->get_data($table, $id, $field);
        $data['id'] = $id;
        $json_data = $this->load->view('master/' . $page, $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1));
    }

    function single_page($id, $table, $field, $page)
    {
        $data['viewinfo'] = $this->mastermodel->get_data_srow($table, $id, $field);
        $data['id'] = $id;
        $this->load->view('master/' . $page, $data);
    }

    function deletedata($table, $id, $field)
    {
        $data = array();
        $perm = $this->mastermodel->check_user_permission($_SESSION['current_menu'], $_SESSION['profile_id'], 3);
        if (!$perm)
            $data['msg'] = "Permission Denied";
        else
            $data = $this->mastermodel->deletedata($table, $id, $field);
        $arr = array('msg' => $data['msg'], 'res' => $data['res']);
        $this->load->view('message', $data);
    }

    function upload_form($file_record_id, $return_page, $upload_function = '')
    {
        $data = array();
        $data['file_record_id'] = $file_record_id;
        $data['return_page'] = $return_page;
        $data['upload_function'] = $upload_function;
        $data['menu_id'] = $this->mastermodel->get_single_field_value('master', 'menu_id', 'master_id', $file_record_id);
        $json_data = $this->load->view('master/upload_form', $data, TRUE);

        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1));
    }

    function submit_upload()
    {
        $data = array();
        $postdata = $this->get_post_values();
        $path = './assets/uploads';
        $_FILES[0]["name"] = $this->security->sanitize_filename($_FILES[0]["name"]);
        $postdata['document_name'] = $_FILES[0]["name"];
        $_FILES[0]["name"] = date('Y-m-d-h-i-s') . $_FILES[0]["name"];
        if (!is_file("$path" . $_FILES[0]["name"]))
        {
            if (!(move_uploaded_file($_FILES[0]["tmp_name"], $path . "/" . $_FILES[0]["name"])))
            {
                $data['msg'] = "File not uploaded.. Permission denied!";
            } else
            {
                $postdata['document_location'] = $path . "/" . $_FILES[0]["name"];

                $data = $this->mastermodel->upload_file($postdata);
                $data['msg'] = "File Uploaded successfully!";
            }

            $json_perm = 1;
        } else
        {
            $data['msg'] = "File already exists";
            $json_perm = 1;
        }
        $data['return_page'] = $postdata['return_page'];
        $json_data = $this->load->view('master/after_upload', $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => $json_perm, 'json_msg' => $data['msg']));
    }

    function delete_file($file_id)
    {
        $perm = $this->mastermodel->check_user_permission($_SESSION['current_menu'], $_SESSION['profile_id'], 3);
        if (!$perm)
            echo 0;
        else
        {
            $this->mastermodel->deletedata('file', $file_id, 'document_id');
            echo 1;
        }
    }
  function deletedatapayment($table, $id, $field)
    {
        $data = array();
        $perm = $this->mastermodel->check_user_permission($_SESSION['current_menu'], $_SESSION['profile_id'], 3);
        if (!$perm)
            $data['msg'] = "Permission Denied";
        else
            $data = $this->mastermodel->deletedatapayment($id);
        $arr = array('msg' => $data['msg'], 'res' => $data['res']);
        $this->load->view('message', $data);
    }

    function checkexistencearray($table, $field, $value)
    {
        if ($this->mastermodel->checkexistencearray($table, $field, $value) > 0)
        {
            echo 1;
        } else
            echo 0;
    }

    function checkexistence($table, $field, $value)
    {
        if ($this->mastermodel->checkexistence($table, $field, $value) > 0)
        {
            echo 1;
        } else
            echo 0;
    }

    public function load_map_page()
    {


        $this->load->view('master/map');
    }
    public function  set_master_branch()
    {
         $postdata = $this->get_post_values();
           $_SESSION['master_branch'] = $postdata['id'];
             echo json_encode($_SESSION['master_branch']);
         
    }
    public function load_edit_map_page()
    {

        $postdata = $this->get_post_values();
        $data['lat'] = $postdata['lat'];
        $data['long'] = $postdata['long'];
        $data['address'] = $postdata['address'];
        $this->load->view('master/edit_map', $data);
    }

    function compose_mail()
    {

        $subdirectory = $_POST['sub_dir'];
        $modelfunction = $_POST['model_function'];
        $modelname = $_POST['model_name'];
        $data['viewinfo'] = $this->$modelname->$modelfunction($_POST['main_id']);

        $html = $this->load->view($subdirectory . '/' . $_POST['pdf_page'], $data, TRUE);
        //  echo $html;
        pdf_create_email($html, $_POST['main_id']);
        $data1['email'] = $data['viewinfo']->requested_customer_id;
        $data1['main_id'] = $_POST['main_id'];

        $data1['attachment'] = 'assets/email/' . $_POST['main_id'] . '.pdf';

        //die();
        $this->load->view('master/mail_page', $data1);
    }

    public function delimage($id)
    {
        $this->mastermodel->del_vendor_image($id);
        echo '1';
    }

    public function load_single_page($modelfunction, $page)
    {
        $postdata = $this->get_post_values();
        $data['viewinfo'] = $this->mastermodel->$modelfunction($postdata);
//        var_dump($data);
//                die();
//        $data['view'] = $this->load->view( 'home/' . $page, $data, TRUE);
//        echo json_encode($data);
        $output = $this->load->view('home/' . $page, $data);
        echo $output;
    }

    function contact()
    {
        $postdata = $this->get_post_values();
        $data = $this->mastermodel->update_contact_reply($postdata);
//        $json_msg = $this->load->view('message', $data, TRUE);
//      
//        $output = $this->mastermodel->$resfunction($_SESSION['pagenum']);
//        $data['viewinfo'] = $output['results'];
//        $json_data = $this->load->view('master/' . $page . '', $data, TRUE);
//        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1, 'json_msg' => $json_msg));
    }

    public function load_commodity_list()
    {
        $data['items'] = $this->mastermodel->get_search_commoditymaster($_POST['term']);
        echo json_encode($data);
    }

    public function load_item_list_by_transfer()
    {
        $data['items'] = $this->mastermodel->get_search_stock_item($_POST['term']);
        echo json_encode($data);
    }

    function checkexistence_string_masterref($table, $field, $primary_field = '')
    {
        $value = $_POST['value'];
        if ($this->mastermodel->checkexistence_masterref($table, $field, $value, $primary_field) > 0)
        {
            echo 1;
        } else
            echo 0;
    }

    function print_billing($model, $model_fun, $directory, $sub_directory, $page, $billing_id)
    {
        $data['viewinfo'] = $this->$model->$model_fun($billing_id);

        $output = $this->load->view($directory . '/' . $sub_directory . '/' . $page, $data, TRUE);
//        pdf_create($output , $billing_code);
        pdf_create_print($output, 'Billing_' . $billing_id);
        echo "1";
    }

    function download_terms_conditions($id)
    {
        $viewdata['data'] = $this->mastermodel->get_single_field_value('crm_terms_condition', 'crm_terms_condition_name', 'crm_terms_condition_id', $id);
        $this->load->library('Pdf');
        $logo = $this->mastermodel->get_srow('company', 'company_logo');
        $viewdata['logo'] = $logo->company_logo;
        $add = $this->mastermodel->get_srow('company', 'company_address');
        $viewdata['company_address'] = $add->company_address;
        $this->load->view('master/termsandconditions_pdf', $viewdata);
    }
     function do_ajax($model,$modelfn)
    {   
        $postdata = $this->get_post_values();
        $data['value'] = call_user_func_array(array($this->$model, $modelfn), $postdata); 
        echo json_encode($data);
    }
     function task_templates()
    {
//        $data['task'] = $this->sitemodel->get_site_adds();

        $this->load->view('task');
    }
     function lead_templates()
    {
//        $data['task'] = $this->sitemodel->get_site_adds();

        $this->load->view('lead');
    }
    
        public function collector_kpi()
    {   
        $postdata = $this->get_post_values();
        $data = $this->mastermodel->collector_kpi($postdata);
        echo json_encode($data);
    }
          public function overall_graph()
    {   
        $postdata = $this->get_post_values();
        $data = $this->mastermodel->overall_graph($postdata);
        echo json_encode($data);
    }
    
public function getCollectorsByBranch($branchId)
{
    $collectors = $this->mastermodel->select_data_by_id_emp('hr_employees', 'hr_employees_branch',$branchId);
    echo json_encode($collectors);
}
public function getBranchesByRegion($regionId)
{
   $branches = $this->mastermodel->select_data_by_id('regional_branches', 'branch_id', $regionId);
$allowed_branches = explode(',', $this->mastermodel->get_single_field_value('user', 'sub_branch_id', 'user_id', $_SESSION['user_id']));

$filtered_branches = [];

if (is_array($branches)) {
    foreach ($branches as $branch) {
        if (in_array($branch->id, $allowed_branches)) {
            $filtered_branches[] = $branch;
        }
    }
}

echo json_encode($filtered_branches);
}
    function autosuggestdebtor($id) {
    log_message('debug', 'Autocomplete query received: ' . $id);
    $deb_list = $this->mastermodel->get_debtors_autocomplete($id);

    if (!$deb_list) {
        log_message('error', 'No data returned for: ' . $id);
        echo json_encode([]); // Return empty array
        return;
    }

    $res = [];
    foreach ($deb_list as $items) {
        $res[] = [
            "label" => $items['crm_debtor_first_name'] . ' - ' . $items['crm_debtor_agreement_no'],
            "value" => $items['crm_debtor_agreement_no']
        ];
    }

    echo json_encode($res);
}

function update_status($table, $id, $field,$value) {
        $data = array();
        $data = $this->mastermodel->update_level_commsion_status($table, $id, $field,$value);
        $arr = array('msg' => $data['msg'], 'res' => $data['res']);
        $this->load->view('message', $data);
    }
public function check_month_already_selected() {
    $month = $this->input->post('month');
    $exists = $this->mastermodel->is_month_exists($month);
    if ($exists) {
        echo "exists"; 
    } else {
        echo "available";
    }
    
    
}
public function get_branch_collectors($branch_id,$filter=0) {
    $result = $this->mastermodel->get_branch_collectors($branch_id,$filter);
    $decoded_result = json_decode($result, true);
    if (empty($decoded_result) || $decoded_result['status'] === 'error') {
        echo json_encode(["status" => "error", "message" => "No collectors found"]);
        return;
    }
    header('Content-Type: application/json');
    echo json_encode(["status" => "success", "data" => $decoded_result['data']]);
}
public function get_branch_recovery($branch_id) {
    header('Content-Type: application/json');

    $result = $this->mastermodel->get_branch_recovery($branch_id);
    
    echo json_encode($result);
}
public function get_monthly_target_vs_actual($year,$assignee) {
    header('Content-Type: application/json');
    $result = $this->mastermodel->get_monthly_target_vs_actual($year,$assignee);
    echo json_encode($result);
}

 public function get_quaterly_target_vs_actual($year) {
         header('Content-Type: application/json');
    $result = $this->mastermodel->get_quaterly_target_vs_actual($year);
    echo json_encode($result);
    }
    
    public function get_complaint_data() {
           header('Content-Type: application/json'); // Ensure correct response type
        $data = $this->mastermodel->get_complaints_count();
        echo json_encode($data, JSON_PRETTY_PRINT);
        exit; // Stop further output
    }
    
      public function get_case_status_data() {
           header('Content-Type: application/json'); // Ensure correct response type
          $case_type = $this->input->get('case_type'); // Get case type from AJAX request
          $case_type_id=$this->mastermodel->get_single_field_value('crm_lead_type','crm_lead_type_id','crm_lead_type_name',$case_type);
        $data = $this->mastermodel->get_complaints_count_by_status($case_type_id);
        echo json_encode($data, JSON_PRETTY_PRINT);
        exit; // Stop further output
    }
}

