<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Pos extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('accountingmodel');
        $this->load->model('accountingreportmodel');
        $this->load->model('clientmodel');
        $this->load->model('clientreportmodel');
        $this->load->model('constructionmodel');
        $this->load->model('hrmodel');
        $this->load->model('hrreportmodel');
        $this->load->model('mastermodel');
        $this->load->model('propertyreportmodel');
        $this->load->model('propertymodel');
        $this->load->model('posmodel');
        $this->load->model('salesmodel');

        $this->load->helper('to_pdf');
    }

    public function view($folder, $page)
    {

        $this->load->view($folder . '/' . $page);
    }

    function get_post_values()
    {
        $data = array();
        foreach ($_POST as $key => $value)
        {
            if ($key != "submit")
            {
                $data[$key] = $this->input->post($key);
            }
        }
        return $data;
    }

    function addformdisplay($page, $directory, $return_page = '')
    {
        $data = array();
        $data['return_page'] = $return_page;

        $json_data = $this->load->view('' . $directory . '/' . $page . '', $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1));
    }

    function viewinpossearch($modelfunction, $subfolder, $page, $pagenum)
    {

        $output = $this->posmodel->$modelfunction($pagenum);
        $data['viewinfo'] = $output['results'];
        $json_data = $this->load->view('pos/' . $subfolder . '/' . $page . '', $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1));
    }

    function addinpos($modelfunction, $resfunction, $subfolder, $page)
    {
        $postdata = $this->get_post_values();
        $data = $this->posmodel->$modelfunction($postdata);
        $json_msg = $this->load->view('message', $data, TRUE);

        $output = $this->posmodel->$resfunction($_SESSION['pagenum']);
        $data['viewinfo'] = $output['results'];
        $json_data = $this->load->view('pos/' . $subfolder . '/' . $page . '', $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1, 'json_msg' => $json_msg));
    }

    function edit_page($id, $table, $field, $subfolder, $page)
    {
        $data['viewinfo'] = $this->mastermodel->get_data_srow($table, $id, $field);
        $data['id'] = $id;
        $json_data = $this->load->view('pos/' . $subfolder . '/' . $page, $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1));
    }

    function single_page($id, $table, $field, $subfolder, $page)
    {
        $data['viewinfo'] = $this->mastermodel->get_data_srow($table, $id, $field);
        $data['id'] = $id;
        $this->load->view('pos/' . $subfolder . '/' . $page, $data);
    }

    function deletedata($table, $id, $field)
    {
        $data = array();
        $perm = $this->mastermodel->check_user_permission($_SESSION['current_menu'], $_SESSION['profile_id'], 3);
        if (!$perm)
            $data['msg'] = "Permission Denied";
        else
            $data = $this->mastermodel->deletedata($table, $id, $field);
        $arr = array('msg' => $data['msg'], 'res' => $data['res']);
        $this->load->view('message', $data);
    }
    function delete_pageinpurchase($modelfunction, $id) {
        $data = array();
        $perm = $this->mastermodel->check_user_permission($_SESSION['current_menu'], $_SESSION['profile_id'], 3);
        if (!$perm)
            $data['msg'] = "Permission Denied";
        else
            $data = $this->posmodel->$modelfunction($id);
        $arr = array('msg' => $data['msg'], 'res' => $data['res']);
        $this->load->view('message', $data);
    }
    public function load_det_view($modelfunction, $id)
    {
        $data['viewinfo'] = $this->posmodel->$modelfunction($id);

        echo json_encode($data);
    }
     public function load_det_view_barcode()
    {
           $postdata = $this->get_post_values();
           $id = $postdata['id'];
         
       
        $data['viewinfo'] = $this->mastermodel->get_single_field_value('pos_item_master','product_id','barcode',$id);
        $data['item_name'] = $this->mastermodel->get_single_field_value('pos_item_master','product_name','barcode',$id);
        $data['stock_id'] = $this->mastermodel->get_data_srow_joined('pos_item_stock','pos_item_batch','batch_id ','batch_id', $data['viewinfo'],'item_id');

        echo json_encode($data);
    }

    public function load_select_list()
    {
        $data['items'] = $this->posmodel->get_search_product($_POST['term']);
        echo json_encode($data);
    }
    public function select_item_report()
    {
        $data['items'] = $this->posmodel->select_item_report($_POST['term']);
        echo json_encode($data);
    }

    public function load_view_det_page($modelfunction, $sub, $page, $id)
    {
        $data['viewinfo'] = $this->posmodel->$modelfunction($id);
        $data['view'] = $this->load->view('pos/' . $sub . '/' . $page, $data, TRUE);
        echo json_encode($data);
    }
    
    public function do_detail($modelfunction, $sub, $page, $id,$id1)
    {
        $data['viewinfo'] = $this->posmodel->$modelfunction($id);
        if(!empty($id1)){
            $data['po_id'] = $id1;
        }
        else{
             $data['po_id'] = "";
        }
        $data['view'] = $this->load->view('pos/' . $sub . '/' . $page, $data, TRUE);
        echo json_encode($data);
    }

    function get_productmaster_det($id)
    {

        $data = $this->posmodel->get_product_master_by_id($id);
        echo json_encode($data);
    }

    public function load_single_page($modelfunction, $page, $val)
    {


        $data['viewinfo'] = $this->posmodel->$modelfunction($val);
        $data['view'] = $this->load->view('pos' . '/purchase/' . $page, $data, TRUE);
        echo json_encode($data);
    }

    function load_product($id)
    {
        $data['sub_details'] = $this->mastermodel->select_data_by_id('pos_lpr_details', 'rfq', $id);
        $value['amount'] = $this->mastermodel->get_single_field_value('pos_lpr', 'rfq_amount', 'rfq_id', $id);
        $data['item_details'] = $this->mastermodel->select_data_by_id('item_master', 'project_id', $_SESSION['project_id'], 'item_master_id', 'item_master_id');
        $value['page'] = $this->load->view('pos/purchase/purchase_order_details', $data, TRUE);
        echo json_encode($value);
    }

    function fill_po_det($pu_id)
    {
        $data['sub_details'] = $this->posmodel->selected_data_by_id('pos_po_details', '*', 'po_management', $pu_id);
//        $value['amount'] = $this->mastermodel->get_single_field_value('pos_po','po_amount','po_management_id',$pu_id);
//        $data['item_details'] = $this->mastermodel->selected_data('item_master',array('item_master_id','item_master_name','item_parchasing_rate'),'item_master_id');
        $value['page'] = $this->load->view('pos/purchase/receipt_note_details', $data, TRUE);
        echo json_encode($value);
    }

    function get_vendor_balance($id)
    {
        $ledeger = $this->accountingmodel->get_accountmaster_id('vendor', 'vendor_id', 'vendor_ledger', $id);
        $data['opening_balance'] = $this->mastermodel->get_single_field_value('account_ledger', 'opening_balance', 'ledger_id', $ledeger);
        $data['balance'] = $this->posmodel->get_ledger_balance($ledeger);
        echo json_encode($data);
    }

    public function get_subcategory($id)
    {
        $parent_id = array();
        array_push($parent_id, $id);
        $data['item_category_name'] = array();
        $data['item_category_id'] = array();

        if (!empty($parent_id))
        {
            while (!empty($parent_id))
            {
                $view = $this->posmodel->get_subcategory($parent_id);

                if (!empty($view))
                {
                    unset($parent_id);
                    $parent_id = array();
                    foreach ($view as $view)
                    {

                        array_push($parent_id, $view->item_category_id);
                        array_push($data['item_category_name'], $view->item_category_name);
                        array_push($data['item_category_id'], $view->item_category_id);
                    }
                } else
                {
                    unset($parent_id);
                    $parent_id = array();
                }
            }
        }
        echo json_encode($data);
    }
      function set_managerapproval($po_management_id)
    {
        $data['viewinfo'] = $this->posmodel->set_managerapproval($po_management_id);
       
        if ($data['viewinfo'] != 0)
        {
            $output['status'] = true;
  } else
        {
            $output['status'] = false;
            $output = 0;
        }
        echo json_encode($output);
    }
     function set_gmapproval($po_gm_id)
    {
        $data['viewinfo'] = $this->posmodel->set_gmapproval($po_gm_id);
       
        if ($data['viewinfo'] != 0)
        {
            $output['status'] = true;
    } else
        {
            $output['status'] = false;
            $output = 0;
        }
        echo json_encode($output);
    }
    function get_product_entry_details()
    {
        $id = $this->get_post_values();
        $data['id'] = $this->mastermodel->get_single_field_value('pos_production_bom','bom_id','bom_product_id',$id['id']);
        $data['lowest_unit_id'] = $this->mastermodel->get_single_field_value('pos_item_master','lowest_unit','product_id',$id['id']);
        $data['page'] = $this->load->view('pos/production/production_details', $data, true);
        echo json_encode($data);
    }
    function load_purchase_item_details()
    {
        $item = $this->get_post_values();
        $value['data'] = $this->posmodel->load_purchase_item_details($item['item_id']);
        $data['view'] = $this->load->view('pos/production/'.$item['page'], $value, true);
        echo json_encode($data);
    }
    function load_product_item_details()
    {
        $item = $this->get_post_values();
        $value['data'] = $this->posmodel->load_product_item_details($item['item_id']);
        $data['view'] = $this->load->view('pos/production/'.$item['page'], $value, true);
        echo json_encode($data);
    }
    function get_price_lowest_unit()
    {
        $item_id = $this->get_post_values()['value'];
        $data['price'] = $this->mastermodel->get_single_field_value('pos_item_master','last_purchase_price','product_id', $item_id);
        $data['lowest_unit_id'] = $this->mastermodel->get_single_field_value('pos_item_master','lowest_unit','product_id',$item_id);
        echo json_encode($data);
    }
    function get_purchase_details($id)
    {
        $data['value'] = $this->posmodel->get_purchase_details($id);
        $data['page'] = $this->load->view('pos/purchase/purchase_return_details', $data, true);
        echo json_encode($data);
    }
    

}

/* End of file master.php */
/* Location: ./application/controllers/master.php */
