<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Posreport extends MY_Controller 
{
    public function __construct() 
    {
        parent::__construct();
        $this->load->model('accountingmodel');
        $this->load->model('accountingreportmodel');
        $this->load->model('clientmodel');
        $this->load->model('clientreportmodel');
        $this->load->model('constructionmodel');
        $this->load->model('hrmodel');
        $this->load->model('hrreportmodel');
        $this->load->model('mastermodel');
        $this->load->model('propertyreportmodel');
        $this->load->model('propertymodel');
        $this->load->model('posreportmodel');
        $this->load->model('salesmodel');
        $this->load->model('posmodel');
        
        $this->load->helper('to_pdf');

    }

    function get_post_values()
    {
        $data = array();
        foreach ($_POST as $key => $value)
        {
            if($key != "submit")
            {
                $data[$key] =  $this->input->post($key);
            }
        }
        return $data;
    }
    function viewinreportsearch($modelfunction,$subfolder, $page)
    {
        $output = $this->propertyreportmodel->$modelfunction();
        $data['viewinfo'] = $output['results'];
        $json_data=$this->load->view('pos/'.$subfolder.'/'. $page . '', $data,TRUE);
        echo json_encode(array('json_data'=>$json_data,'json_perm'=>1));
    }
    
    function addinreport($modelfunction, $resfunction,$subfolder, $page)
    {
        $postdata = $this->get_post_values();
        $data = array();
        $data = $this->propertyreportmodel->$modelfunction($postdata);
        $json_msg=$this->load->view('message', $data,TRUE);
        $output = $this->propertyreportmodel->$resfunction($_SESSION['pagenum']);
        $data['viewinfo'] = $output['results'];
        $json_data=$this->load->view('pos/'.$subfolder.'/' . $page . '', $data,TRUE);
        echo json_encode(array('json_data'=>$json_data,'json_perm'=>1,'json_msg'=>$json_msg));
    }

  
     function edit_page($id, $table, $field,$subfolder, $page) {
        $data['viewinfo'] = $this->mastermodel->get_data_srow($table, $id, $field);
        $data['id'] = $id;
        $json_data = $this->load->view('pos/'.$subfolder.'/' .$page, $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1));
    }
    
    function single_page($id, $table, $field,$subfolder, $page)
    { 
        $data['viewinfo'] = $this->mastermodel->get_data_srow($table, $id, $field);
        $data['id'] = $id;
        $this->load->view('pos/'.$subfolder.'/' . $page, $data);
    }
   
    
  
    function decidetodownload($mainfolder,$subfolder,$page, $viewdata, $filename)
    {

        //var_dump($_POST['ispdf']);

        if (isset($_POST['ispdf']) && $_POST['ispdf'] == 1)
        {
//            $html = $this->load->view($mainfolder.'/'.$subfolder.'/' . $page, $viewdata, true);
//            pdf_create($html, $filename, false);
                $this->load->library('Pdf');

     $this->load->view($mainfolder.'/'.$subfolder.'/' . $page.'_pdf', $viewdata);
         
        } else if (isset($_POST['ispdf']) && $_POST['ispdf'] == 2)
        {
            $html = $this->load->view($mainfolder.'/'.$subfolder.'/' . $page, $viewdata, true);
            header("Content-type: application/octet-stream");
            header("Content-Disposition: attachment; filename=" . $filename . ".xls");
            header("Pragma: no-cache");
            header("Expires: 0");
            echo $html;
            exit;
        } else
        {
            $html = $this->load->view($mainfolder.'/'.$subfolder.'/'  . $page, $viewdata, true);
            echo $html;
        }
    }
    function load_production_entry_report($mainfolder,$subfolder,$page)
    {   
        $viewdata = array();
        $postdata = $this->get_post_values();
        
        $logo = $this->mastermodel->get_srow('company','company_logo');
        $viewdata['logo'] = $logo->company_logo;
        $add = $this->mastermodel->get_srow('company','company_address');
        $viewdata['company_address'] = $add->company_address;
        
        $viewdata['viewinfo'] = $this->posreportmodel->load_production_entry_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Production Entry');
    }
    function load_wow_bom_balance_report($mainfolder,$subfolder,$page)
    {   
        $viewdata = array();
        $postdata = $this->get_post_values();
        
        $logo = $this->mastermodel->get_srow('company','company_logo');
        $viewdata['logo'] = $logo->company_logo;
        $add = $this->mastermodel->get_srow('company','company_address');
        $viewdata['company_address'] = $add->company_address;
        
        $viewdata['viewinfo'] = $this->posreportmodel->load_wow_bom_balance_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Work Order Wise Purchase-Production Report');
    }
    function load_wow_purchase_production_report($mainfolder,$subfolder,$page)
    {   
        $viewdata = array();
        $postdata = $this->get_post_values();
        
        $logo = $this->mastermodel->get_srow('company','company_logo');
        $viewdata['logo'] = $logo->company_logo;
        $add = $this->mastermodel->get_srow('company','company_address');
        $viewdata['company_address'] = $add->company_address;
        
        $viewdata['viewinfo'] = $this->posreportmodel->load_wow_purchase_production_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Work Order Wise Purchase-Production Report');
    }
    function load_po_report($mainfolder,$subfolder,$page)
    {   
        $viewdata = array();
        $postdata = $this->get_post_values();
        
        $logo = $this->mastermodel->get_srow('company','company_logo');
        $viewdata['logo'] = $logo->company_logo;
        $add = $this->mastermodel->get_srow('company','company_address');
        $viewdata['company_address'] = $add->company_address;
        
        $viewdata['viewinfo'] = $this->posreportmodel->load_po_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'PO Report');
    }
    function load_purchase_report($mainfolder,$subfolder,$page)
    {   
        $viewdata = array();
        $postdata = $this->get_post_values();
        
        $logo = $this->mastermodel->get_srow('company','company_logo');
        $viewdata['logo'] = $logo->company_logo;
        $add = $this->mastermodel->get_srow('company','company_address');
        $viewdata['company_address'] = $add->company_address;
        
        $viewdata['viewinfo'] = $this->posreportmodel->load_purchase_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Purchaser Report');
    }
    function load_monthwise_purchase_report($mainfolder,$subfolder,$page)
    {   
        $viewdata = array();
        $postdata = $this->get_post_values();
        
        $logo = $this->mastermodel->get_srow('company','company_logo');
        $viewdata['logo'] = $logo->company_logo;
        $add = $this->mastermodel->get_srow('company','company_address');
        $viewdata['company_address'] = $add->company_address;
        
        $viewdata['viewinfo'] = $this->posreportmodel->load_monthwise_purchase_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Purchase Report');
    }
    function load_stock_report($mainfolder,$subfolder,$page)
    {   
        $viewdata = array();
        $postdata = $this->get_post_values();
        
        $logo = $this->mastermodel->get_srow('company','company_logo');
        $viewdata['logo'] = $logo->company_logo;
        $add = $this->mastermodel->get_srow('company','company_address');
        $viewdata['company_address'] = $add->company_address;
        
        $viewdata['viewinfo'] = $this->posreportmodel->load_stock_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Stock Report');
    }
    function load_datewise_item_stock_report($mainfolder,$subfolder,$page)
    {   
        $viewdata = array();
        $postdata = $this->get_post_values();
        
        $logo = $this->mastermodel->get_srow('company','company_logo');
        $viewdata['logo'] = $logo->company_logo;
        $add = $this->mastermodel->get_srow('company','company_address');
        $viewdata['company_address'] = $add->company_address;
        
        $viewdata['viewinfo'] = $this->posreportmodel->load_datewise_item_stock_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Stock Report');
    }
    function load_item_wise_report($mainfolder,$subfolder,$page)
    {   
        $viewdata = array();
        $postdata = $this->get_post_values();
        
        $logo = $this->mastermodel->get_srow('company','company_logo');
        $viewdata['logo'] = $logo->company_logo;
        $add = $this->mastermodel->get_srow('company','company_address');
        $viewdata['company_address'] = $add->company_address;
        
        $viewdata['viewinfo'] = $this->posreportmodel->load_item_wise_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Item Wise Report');
    }
    function load_vendorwise_item_report($mainfolder,$subfolder,$page)
    {   
        $viewdata = array();
        $postdata = $this->get_post_values();
        
        $logo = $this->mastermodel->get_srow('company','company_logo');
        $viewdata['logo'] = $logo->company_logo;
        $add = $this->mastermodel->get_srow('company','company_address');
        $viewdata['company_address'] = $add->company_address;
        
        $viewdata['viewinfo'] = $this->posreportmodel->load_vendorwise_item_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Vendor Wise Item Report');
    }
    function load_vat_sale_invoice_report($mainfolder,$subfolder,$page)
    {   
        $viewdata = array();
        $postdata = $this->get_post_values();$_POST['ispdf'] = 1;
        
        $logo = $this->mastermodel->get_srow('company','company_logo');
        $viewdata['logo'] = $logo->company_logo;
        $add = $this->mastermodel->get_srow('company','company_address');
        $viewdata['company_address'] = $add->company_address;
        
        $viewdata['viewinfo'] = $this->posreportmodel->load_vat_sale_invoice_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'VAT SALE INVOICE Report');
    }
    function loadsave_vat_sale_invoice_report($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
        $postdata = $this->get_post_values();
        
        $logo = $this->mastermodel->get_srow('company','company_logo');
        $viewdata['logo'] = $logo->company_logo;
        $add = $this->mastermodel->get_srow('company','company_address');
        $viewdata['company_address'] = $add->company_address;
        
        $viewdata['viewinfo'] = $this->posreportmodel->load_vat_sale_invoice_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'VAT SALE INVOICE Report');
    }
    function bill_wise_sales_report($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
        $postdata = $this->get_post_values();
        
        $logo = $this->mastermodel->get_srow('company','company_logo');
        $viewdata['logo'] = $logo->company_logo;
        $add = $this->mastermodel->get_srow('company','company_address');
        $viewdata['company_address'] = $add->company_address;
        
        $viewdata['viewinfo'] = $this->posreportmodel->bill_wise_sales_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Bill Wise Sale Report');
    }
    function item_wise_sales_report($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
        $postdata = $this->get_post_values();
        
        $logo = $this->mastermodel->get_srow('company','company_logo');
        $viewdata['logo'] = $logo->company_logo;
        $add = $this->mastermodel->get_srow('company','company_address');
        $viewdata['company_address'] = $add->company_address;
        
        $viewdata['viewinfo'] = $this->posreportmodel->item_wise_sales_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Item Wise Sale Report');
    }
    function tax_wise_sales_report($mainfolder,$subfolder,$page)
    {
        $viewdata = array();
        $postdata = $this->get_post_values();
        
        $logo = $this->mastermodel->get_srow('company','company_logo');
        $viewdata['logo'] = $logo->company_logo;
        $add = $this->mastermodel->get_srow('company','company_address');
        $viewdata['company_address'] = $add->company_address;
        
        $viewdata['viewinfo'] = $this->posreportmodel->tax_wise_sales_report($postdata);
        $this->decidetodownload($mainfolder,$subfolder,$page, $viewdata, 'Tax Category Wise Sale Tax Collection Report');
    }
}

/* End of file master.php */
/* Location: ./application/controllers/posreport.php */