<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Sales extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('accountingmodel');
        $this->load->model('accountingreportmodel');
        $this->load->model('clientmodel');
        $this->load->model('clientreportmodel');
        $this->load->model('constructionmodel');
        $this->load->model('hrmodel');
        $this->load->model('hrreportmodel');
        $this->load->model('mastermodel');
        $this->load->model('propertyreportmodel');
        $this->load->model('propertymodel');
        $this->load->model('salesmodel');
        $this->load->model('posmodel');
        
        $this->load->helper('to_pdf');
       
    }

   

    public function view($folder, $page)
    {
   
        $this->load->view($folder . '/' . $page);
    }

    function get_post_values()
    {
        $data = array();
        foreach ($_POST as $key => $value)
        {
            if ($key != "submit")
            {
                $data[$key] = $this->input->post($key);
            }
        }
        return $data;
    }

    function addformdisplay($page, $directory, $return_page = '') {
        $data = array();
        $data['return_page'] = $return_page;

        $json_data = $this->load->view('' . $directory . '/' . $page . '', $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1));
    }

    function viewinsalessearch($modelfunction,$subfolder, $page, $pagenum) {

        $output = $this->salesmodel->$modelfunction($pagenum);
        $data['viewinfo'] = $output['results'];
        $json_data = $this->load->view('pos/'.$subfolder.'/' .$page . '', $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1));
    }

    function addinsales($modelfunction, $resfunction,$subfolder, $page) {
        $postdata = $this->get_post_values();
        $data = $this->salesmodel->$modelfunction($postdata);
        $json_msg = $this->load->view('message', $data, TRUE);
            
        $output = $this->salesmodel->$resfunction($_SESSION['pagenum']);
        $data['viewinfo'] = $output['results'];
        $json_data = $this->load->view('pos/'.$subfolder.'/'  . $page . '', $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1, 'json_msg' => $json_msg));
    }

    function edit_page($id, $table, $field,$subfolder, $page) {
        $data['viewinfo'] = $this->mastermodel->get_data_srow($table, $id, $field);
        $data['id'] = $id;
        $json_data = $this->load->view('pos/'.$subfolder.'/' . $page, $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'json_perm' => 1));
    }

    function single_page($id, $table, $field,$subfolder, $page) {
        $data['viewinfo'] = $this->mastermodel->get_data_srow($table, $id, $field);
        $data['id'] = $id;
        $this->load->view('pos/'.$subfolder.'/'. $page, $data);
    }

    function deletedata($table, $id, $field) {
        $data = array();
        $perm = $this->mastermodel->check_user_permission($_SESSION['current_menu'], $_SESSION['profile_id'], 3);
        if (!$perm)
            $data['msg'] = "Permission Denied";
        else
            $data = $this->mastermodel->deletedata($table, $id, $field);
        $arr = array('msg' => $data['msg'], 'res' => $data['res']);
        $this->load->view('message', $data);
    }
    public function load_det_view($modelfunction, $id)
    {   
        $data['viewinfo'] = $this->salesmodel->$modelfunction($id);
        echo json_encode($data);
    }
    public function load_select_list()
    {
        $data['items'] = $this->salesmodel->get_search_product($_POST['term']);
        echo json_encode($data);
    }
    public function load_view_det_page($modelfunction, $sub, $page, $id)
    {
        $data['viewinfo'] = $this->salesmodel->$modelfunction($id);
        $data['view'] = $this->load->view('pos/' . $sub . '/' . $page, $data, TRUE);
        echo json_encode($data);
    }
    function load_sale_details_by_purchase_id()
    {
        $postdata = $this->get_post_values();
        $data['order_details'] = $this->salesmodel->load_sale_details_by_purchase_id($postdata);
        $data['sale_details'] = $this->mastermodel->selected_data_by_id('pos_sale_details','sale_order_detailsId','sale_id',$postdata['sale_id']);
        $data['view'] = $this->load->view('pos/sales/customer_invoice_details', $data, TRUE);
        echo json_encode($data);
    }
    //load sale deatils for direct sale return
    function load_sale_details_for_sate_return()
    {
        $postdata = $this->get_post_values();
        $data['customer_details'] = $this->salesmodel->load_sale_customer_dtls($postdata);
        $output['sale_details'] = $this->mastermodel->select_data_by_id('pos_sale_details','sale_id',$postdata['id']);
        $data['view'] = $this->load->view('pos/sales/sale_return_details', $output, TRUE);
        echo json_encode($data);
    }
    function addinsales_bill($modelfunction, $resfunction,$subfolder, $page) {
        $postdata = $this->get_post_values();
        $data = $this->salesmodel->$modelfunction($postdata);
        $json_msg = $this->load->view('message', $data, TRUE);
            
        $output = $this->salesmodel->$resfunction($_SESSION['pagenum']);
        $data['viewinfo'] = $output['results'];
        $json_data = $this->load->view('pos/'.$subfolder.'/'  . $page . '', $data, TRUE);
        echo json_encode(array('json_data' => $json_data, 'masterid' =>$data['masterid'], 'json_perm' => 1, 'json_msg' => $json_msg));
    }
}

/* End of file master.php */
/* Location: ./application/controllers/master.php */
