<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); ?>
<?php

class MY_Controller extends CI_Controller
{

    function MY_Controller()
    {
        parent::__construct();
        $this->load->model('mastermodel');
        if (!session_id())
        {
            session_start();
        }
        if (!isset($_SESSION['loggedin']))
        {
            redirect('sessions/login');
        }

        if (isset($_SESSION['user_id']))
        {
            if (!empty($_SESSION['current_menu']) && isset($_SESSION['current_menu']))
            {
                $menu = $_SESSION['current_menu'];
                $array_mod = explode(',', $_SESSION['user_modules']);
                $this->checkUrlPermission($menu, $array_mod);
            }
        }
    }

    function checkUrlPermission($menu, $array_mod)
    {
        $array_perm = explode(',', $_SESSION['modules_permission']);
        $index = array_search($menu, $array_mod);
        $ar = str_split(sprintf('%04u', decbin($array_perm[$index])));

        if ($ar[0] == 1)
        {
            $this->crudPermission($menu, $array_mod, $array_perm);
            $_SESSION['Previous_URL'] = $_SERVER['REQUEST_URI'];
        }
        else
        {
            if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest')
            {
                $data['msg'] = "Permission Denied";
               
                $json_data = $this->load->view('message', array('msg' => 'Permission Denied'), TRUE);
                echo json_encode(array('json_data' => $json_data, 'json_perm' => 0));
                die();
            }
            else
            {
                header("Location: " . site_url());
            }
        }
    }

    function crudPermission($menu, $array_mod, $array_perm)
    {
        $found = array_search($menu, $array_mod);
        $val = 0;
        if (isset($array_perm[$found]))
        {
            $val = $array_perm[$found];
        }
        $a = decbin($val);
        $d = sprintf('%03u', $a);
        $ar = str_split($d);
        if (isset($_REQUEST['action']))
        {
            $check = 0;
            if ($_REQUEST['action'] == 'edit')
            {
                $check = 2;
            }
            if ($_REQUEST['action'] == 'add')
            {
                $check = 1;
            }
            if ($ar[$check] != 1)
            {
                $json_data = $this->load->view('message', array('msg' => 'Permission Denied'), TRUE);
                echo json_encode(array('json_data' => $json_data, 'json_perm' => 0));
                die();
            }
        }
    }

}

?>