<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Accountingmodel extends CI_Model {

    function __construct() {
        // Call the Model constructor
        parent::__construct();
    }
function search_accounting_head() {
        $data = array();
        $this->db->select('*');
        $this->db->from('account_head');
        $this->db->order_by('account_head.id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    function search_account_groups() {
        $data = array();
        $this->db->select('*');
        $this->db->from('account_group');
        $this->db->where('account_group.parent',0);
             $this->db->join('master', 'master.master_id=account_group.account_group_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('account_group.account_group_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    function search_financial_year(){
        $data = array();
        $user_branch = $_SESSION['user_branch'];
        $this->db->select('*');
        $this->db->from('financial_year');
        $this->db->join('master', 'master.master_id=financial_year.financial_year_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
            $query = "(";            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";         $query.=")";         $this->db->where($query);
        $this->db->order_by('financial_year.financial_year_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
            function get_account_groups_code()
    {
        $data = array();
        $this->db->select('MAX(account_group_count) as count');
        $this->db->from('account_group');
        $this->db->join('master', 'master.master_id=account_group.account_group_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->where('account_group.parent', 0);
        $data = $this->db->get()->row();
      if(empty($data) ||$data->count == NULL ){
          $data = 1;
      }
 else {
          
      }
        $data = $data->count + 1;
        return $data;
    }
    public function insert_account_groups($postdata) {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $count = $this->accountingmodel->get_account_groups_code();
        $account_group_code = "ACG".$count;
        $account_group_count = $count;
        
        $tblValues = array(
           'account_group_id' => $masterid,
           'account_group_code' => $account_group_code,
             'account_group_count' => $account_group_count,
           'account_group_name' => $postdata['account_group_name'],
           'group_under' => $postdata['group_under'],
           'narration' => $postdata['narration']
       );
        $this->db->insert('account_group', $tblValues);
        $output = $this->mastermodel->save_user_activities('Add Account Group',$masterid, 'account_group');  //ss
        
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_account_groups($postdata) {
        $data = array();
        $this->db->trans_begin();
       
        $tblValues = array(
         
           'account_group_name' => $postdata['account_group_name'],
           'group_under' => $postdata['group_under'],
           'narration' => $postdata['narration']
       );
        $this->db->where('account_group_id',$postdata['account_group_id']);
        $this->db->update('account_group', $tblValues);
        $output = $this->mastermodel->save_user_activities('Edit Account Group',$postdata['account_group_id'], 'account_group');  //ss
        
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    function search_account_ledger() {
        $data = array();
        $user_branch = $_SESSION['user_branch'];
        $this->db->select('*');
        $this->db->from('account_ledger');
           $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
         $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        $this->db->order_by('account_ledger.ledger_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    
    
    public function insert_account_ledger($postdata) {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
           'ledger_id' => $masterid,
           'account_group_id' => $postdata['account_group_id'],
           'ledger_name' => $postdata['ledger_name'],
           'mailing_name' => $postdata['mailing_name'],
           'opening_balance' => $postdata['opening_balance'],
           'cr_or_dr' => 'Debit',
       );
        $this->db->insert('account_ledger', $tblValues);
        $output = $this->mastermodel->save_user_activities('Add Account Ledger',$masterid, 'account_ledger');  //ss
        
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_account_ledger($postdata) {
        $data = array();
        $this->db->trans_begin();
      
       $this->mastermodel->update_master_branch($postdata['ledger_id']);   
        $tblValues = array(
         
           'account_group_id' => $postdata['account_group_id'],
           'ledger_name' => $postdata['ledger_name'],
           'mailing_name' => $postdata['mailing_name'],
           'opening_balance' => $postdata['opening_balance'],
           'cr_or_dr' => 'Debit',
       );
        $this->db->where('ledger_id',$postdata['ledger_id']);
        $this->db->update('account_ledger', $tblValues);
        $output = $this->mastermodel->save_user_activities('Edit Account Ledger',$postdata['ledger_id'], 'account_ledger');  //ss
        
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    function get_account_subgroup()
    {
        $this->db->select('account_group_id,account_group_name');
        $this->db->from('account_group');
        $this->db->join('account_head', 'account_head.id=account_group.group_under');
             $this->db->join('master', 'master.master_id=account_group.account_group_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('account_group.account_group_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }
    function search_account_subgroup() {
        $data = array();
        $this->db->select('*');
        $this->db->from('account_group');
        $this->db->join('account_head', 'account_head.id=account_group.group_under', 'left');
        $this->db->where('account_group.parent !=', 0);
         $this->db->join('master', 'master.master_id=account_group.account_group_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('account_group.account_group_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    
       function get_account_subgroups_code($parent)
    {
        $data = array();
        $this->db->select('MAX(account_group_count) as count');
        $this->db->from('account_group');
              $this->db->join('master', 'master.master_id=account_group.account_group_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->where('account_group.parent',$parent);
        $data = $this->db->get()->row();
        if(empty($data) ||$data->count == NULL ){
            
           $count = $this->mastermodel->get_single_field_value('account_group', 'account_group_count', 'account_group_id', $parent);
        $data = $count."01";
        }
        else{
    
        $data = $data->count + 1;
        }
        return $data;
    }
    
     public function insert_account_sub_group($postdata) {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $count =$this->accountingmodel->get_account_subgroups_code($postdata['parent']);
         $dcode ="ACG".$count;
         $account_group_count = $count;
        $hd = $this->mastermodel->get_single_field_value('account_group', 'group_under', 'account_group_id', $postdata['parent']);
        $tblValues = array(
           'account_group_id' => $masterid,
            'account_group_code' => $dcode,
             'account_group_count' => $account_group_count,
            'account_group_name' => $postdata['account_group_name'],
            'group_under' => $hd,
            'narration' => $postdata['narration'],
            'parent' => $postdata['parent']
       );
        $this->db->insert('account_group', $tblValues);
        $output = $this->mastermodel->save_user_activities('Add Account Sub-Group',$masterid, 'account_group');  //ss
        
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
     public function update_account_sub_group($postdata) {
        $data = array();
        $this->db->trans_begin();
      
        $hd = $this->mastermodel->get_single_field_value('account_group', 'group_under', 'account_group_id', $postdata['parent']);
        $tblValues = array(

            'account_group_name' => $postdata['account_group_name'],
            'group_under' => $hd,
            'narration' => $postdata['narration'],
            'parent' => $postdata['parent']
       );
        $this->db->where('account_group_id',$postdata['account_group_id']);
        $this->db->update('account_group', $tblValues);
        $output = $this->mastermodel->save_user_activities('Edit Account Sub-Group',$postdata['account_group_id'], 'account_group');  //ss
        
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    function get_general_settings()
    {
          $user_branch = $_SESSION['master_branch'];
        $this->db->select('*');
        $this->db->from('general_settings');
             $this->db->join('master', 'master.master_id=general_settings.general_settings_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
         $query = "(";    
         $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";       
         $query.=")";      
         $this->db->where($query);
        $this->db->order_by('general_settings.general_settings_id', 'desc');
        $data['results'] = $this->db->get()->row();
        return $data;
    }
       public function update_genaral_settings($postdata)
    {  
           
        $this->db->trans_begin();
         if (isset($postdata['is_item_account']))
        {
            $is_item_account = 1;
        } else
        {
            $is_item_account = 0;
        }
        if (empty($postdata['general_settings_id']))
        {
            $masterid = $this->mastermodel->insertmasterdata();

            $tblValues = array(
                'general_settings_id' => $masterid,
                'sales' => $postdata['sales'],
                'purchase' => $postdata['purchase'],
                'expense' => $postdata['expense'],
                'customer_payment' => $postdata['customer_payment'],
                'vendor_payment' => $postdata['vendor_payment'],
                'employee' => $postdata['employee'],
                'adjust_account' => $postdata['adjust_account'],
                'salary' => $postdata['salary'],
                'customer' => $postdata['customer'],
                'vendor' => $postdata['vendor'],
                'agency' => $postdata['agency'],
                'subcontractor' => $postdata['subcontractor'],
                'subcontractor_allocation' => $postdata['subcontractor_allocation'],
                'subcontractor_payment' => $postdata['subcontractor_payment'],
                'site' => $postdata['site'],
                'payable' => $postdata['payable'],
                'receivable' => $postdata['receivable'],
                'purchase_discounts' => $postdata['purchase_discounts'],
                'cash_account' => $postdata['cash_account'],
                  'lawyer' => $postdata['lawyer'],
                'sales_discounts' => $postdata['sales_discounts'],
                  'bank_account' => $postdata['bank_account'],
                  'tax' => $postdata['tax'],
                  'is_item_account' => $is_item_account,

            );
            $output = $this->db->insert('general_settings', $tblValues);
             $output = $this->mastermodel->save_user_activities('Edit Genral Settngs',$masterid, 'general_settings');  //ss
        } else
        {
            
            $this->mastermodel->update_master_branch($postdata['general_settings_id']);   
            $tblValues = array(
               
               'sales' => $postdata['sales'],
                'purchase' => $postdata['purchase'],
                'expense' => $postdata['expense'],
                'customer_payment' => $postdata['customer_payment'],
                'vendor_payment' => $postdata['vendor_payment'],
                'adjust_account' => $postdata['adjust_account'],
                'employee' => $postdata['employee'],
                'salary' => $postdata['salary'],
                'customer' => $postdata['customer'],
                'vendor' => $postdata['vendor'],
                'subcontractor' => $postdata['subcontractor'],
                'subcontractor_allocation' => $postdata['subcontractor_allocation'],
                'subcontractor_payment' => $postdata['subcontractor_payment'],
                'site' => $postdata['site'],
                'payable' => $postdata['payable'],
                'receivable' => $postdata['receivable'],
                'purchase_discounts' => $postdata['purchase_discounts'],
                 'cash_account' => $postdata['cash_account'],
                'sales_discounts' => $postdata['sales_discounts'],
                   'bank_account' => $postdata['bank_account'],
                   'tax' => $postdata['tax'],
                  'is_item_account' => $is_item_account,
                  'lawyer' => $postdata['lawyer'],

            );
            $this->db->where('general_settings_id', $postdata['general_settings_id']);
            $output = $this->db->update('general_settings', $tblValues);
             $output = $this->mastermodel->save_user_activities('Edit Genral Settngs',$postdata['general_settings_id'], 'general_settings');  //ss
        }
        
        
          $contra_voucher_settings_id = $this->accountingmodel->get_voucher_settings('account_group', 'contra_voucher_settings', 'contra_voucher_settings_id');
        foreach ($contra_voucher_settings_id as $contraid)
        {
            $this->db->where('contra_voucher_settings_id', $contraid->contra_voucher_settings_id);
            $this->db->delete('contra_voucher_settings');
        }

        for ($i = 0; $i < count($postdata['contra']); $i++)
        {
            $contraid = $this->mastermodel->insertmasterdata();
            $tblValues = array(
                'contra_voucher_settings_id' => $contraid,
                'account_group' => $postdata['contra'][$i],
            );
            $output = $this->db->insert('contra_voucher_settings', $tblValues);
        }

        $purchase_voucher_settings_id = $this->accountingmodel->get_voucher_settings('account_group', 'purchase_voucher_settings', 'purchase_voucher_settings_id');
        foreach ($purchase_voucher_settings_id as $purchaseid)
        {
            $this->db->where('purchase_voucher_settings_id', $purchaseid->purchase_voucher_settings_id);
            $this->db->delete('purchase_voucher_settings');
        }
        for ($i = 0; $i < count($postdata['purchase_voucher']); $i++)
        {
            $purchaseid = $this->mastermodel->insertmasterdata();
            $tblValues = array(
                'purchase_voucher_settings_id' => $purchaseid,
                'account_group' => $postdata['purchase_voucher'][$i],
            );
            $output = $this->db->insert('purchase_voucher_settings', $tblValues);
        }
        $sales_voucher_settings_id = $this->accountingmodel->get_voucher_settings('account_group', 'sales_voucher_settings', 'sales_voucher_settings_id');

        foreach ($sales_voucher_settings_id as $salesid)
        {
            $this->db->where('sales_voucher_settings_id', $salesid->sales_voucher_settings_id);
            $this->db->delete('sales_voucher_settings');
        }
        for ($i = 0; $i < count($postdata['sales_voucher']); $i++)
        {
            $salesid = $this->mastermodel->insertmasterdata();
            $tblValues = array(
                'sales_voucher_settings_id' => $salesid,
                'account_group' => $postdata['sales_voucher'][$i],
            );
            $output = $this->db->insert('sales_voucher_settings', $tblValues);
        }
        
        if (empty($postdata['general_report_settings_id']))
        {
            $masterid = $this->mastermodel->insertmasterdata();

            $tblValues = array(
                'general_report_settings_id' => $masterid,
                'purchase_account' => $postdata['purchase_account'],
                'direct_expense' => $postdata['direct_expense'],
                'indirect_expense' => $postdata['indirect_expense'],
                'sales_account' => $postdata['sales_account'],
                'other_incomes' => $postdata['other_incomes'],
                'loans' => $postdata['loans'],
                'current_liabilities' => $postdata['current_liabilities'],
                'capital_account' => $postdata['capital_account'],
                'fixed_assets' => $postdata['fixed_assets'],
                'current_assets' => $postdata['current_assets'],
                'branch_division' => $postdata['branch_division'],
                'investments' => $postdata['investments'],
                'suspence_ac' => $postdata['suspence_ac'],
                'direct_incomes' => $postdata['direct_incomes'],
                'cash_settings' => $postdata['cash_settings'],
            );
            $output = $this->db->insert('general_report_settings', $tblValues);
        } else
        {
             $this->mastermodel->update_master_branch($postdata['general_report_settings_id']);   
            $tblValues = array(
                'purchase_account' => $postdata['purchase_account'],
                'direct_expense' => $postdata['direct_expense'],
                'indirect_expense' => $postdata['indirect_expense'],
                'sales_account' => $postdata['sales_account'],
                'other_incomes' => $postdata['other_incomes'],
                'loans' => $postdata['loans'],
                'current_liabilities' => $postdata['current_liabilities'],
                'capital_account' => $postdata['capital_account'],
                'fixed_assets' => $postdata['fixed_assets'],
                'current_assets' => $postdata['current_assets'],
                'branch_division' => $postdata['branch_division'],
                'investments' => $postdata['investments'],
                'suspence_ac' => $postdata['suspence_ac'],
                'direct_incomes' => $postdata['direct_incomes'],
                'cash_settings' => $postdata['cash_settings'],
            );
            $this->db->where('general_report_settings_id', $postdata['general_report_settings_id']);
            $output = $this->db->update('general_report_settings', $tblValues);
        }

       


        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = 'Error on adding record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = 'Record Updated successfully';
            return $data;
        }
    }

    function search_journal_entry($pagenum,$type,$posted) {
        $this->db->select('*');
        $user_branch = $_SESSION['user_branch'];
        $this->db->from('journal_entry');
        $this->db->where('journal_entry.voucher_type', $type);
        $this->db->where('journal_entry.posted', $posted);
            $this->db->join('master', 'master.master_id=journal_entry.journal_entry_id');
             $query = "(";            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";         $query.=")";         $this->db->where($query);
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('journal_entry.journal_entry_id', 'desc');
        
    
        $data['results'] = $this->db->get();
        return $data;
    }
   


     public function insert_journal_entry($postdata) {
        $data = array();
        $this->db->trans_begin();
        $voucher_no = $this->mastermodel->autogen_vouchercode($postdata['voucher_type'], 'journal_entry', 'journal_voucher_no', 'journal_entry_id');
        $pdc = 0;
        $cheque_ref_no = "";
        $cheque_date = "00/00/0000";
        $bank_date = "00/00/0000";
        $is_posted = (bool) '0';
        $is_reconcile = 0;
         if (isset($postdata['is_posted']))
        {
            $is_posted = (bool) '1';
        }
         if (isset($postdata['ref_no']))
        {
            $cheque_ref_no = $postdata['ref_no'];
        }
          if (isset($postdata['cheque_date']))
        {
            $cheque_date = $postdata['cheque_date'];
        }
         if (isset($postdata['is_pdc']))
        {
            $pdc = 1;
        }
        if (isset($postdata['is_cdc']))
        {
            $pdc = 1;
        }
        $ledger_id = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'ledger_book_id' => $ledger_id,
            'voucher_no' => $voucher_no,
            'voucher_date' => $this->mastermodel->convert_date_format($postdata['journal_date']),
            'is_posted' => $is_posted,
            'is_pdc' => $pdc,
            'cheque_ref_no' => $cheque_ref_no,
            'cheque_date' => $this->mastermodel->convert_date_format($cheque_date),
            'bank_date' => $this->mastermodel->convert_date_format($bank_date),
            'is_reconcile' => $is_reconcile,
        );
        $output = $this->db->insert('ledger_book', $tblValues);
         
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'journal_entry_id' => $masterid,
//            'journal_ref_no' => $postdata['journal_ref_no'],
            'journal_voucher_no' => $voucher_no,
            'journal_date' => $this->mastermodel->convert_date_format($postdata['journal_date']),
            'journal_description' => $postdata['journal_description'],
            'voucher_type' => $postdata['voucher_type'],
            'posted' => $is_posted,
            'is_pdc' => $pdc,
            'cheque_ref_no' => $cheque_ref_no,
            'cheque_date' => $this->mastermodel->convert_date_format($cheque_date),
            'bank_date' => $this->mastermodel->convert_date_format($bank_date),
            'is_reconcile' => $is_reconcile,
            'journal_ledger' => $ledger_id,
        );
        $output = $this->db->insert('journal_entry', $tblValues);
        $x = 1;
        while (isset($postdata['j_account_' . $x]))
        {
             $journal_entry_details_id = $this->mastermodel->insertmasterdata();
            $tblValues = array(
                'journal_entry_details_id' => $journal_entry_details_id,
                'journal_entry' => $masterid,
                'journal_account' => $this->db->escape_str($postdata['j_account_' . $x]),
//                'journal_description' => $this->db->escape_str($postdata['j_des_' . $x]),
                'journal_debit' => $this->db->escape_str($postdata['j_debit_' . $x]),
                'journal_credit' => $this->db->escape_str($postdata['j_credit_' . $x]),
            );
            $output = $this->db->insert('journal_entry_details', $tblValues);
            
              $ledger_book_details_id = $this->mastermodel->insertmasterdata();
             $tblValues = array(
                 'ledger_book_details_id' => $ledger_book_details_id,
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $this->db->escape_str($postdata['j_account_' . $x]),
                'debit' => $this->db->escape_str($postdata['j_debit_' . $x]),
                'credit' => $this->db->escape_str($postdata['j_credit_' . $x]),
//                'narration' => $this->db->escape_str($postdata['j_des_' . $x]),
            );
//        var_dump($tblValues);
            $output = $this->db->insert('ledger_book_details', $tblValues);
            $det_id = $this->db->insert_id();

            $j = 1;
            while (isset($postdata['subledeger' . $x . '_' . $j]))
            {
//                var_dump($postdata['subledeger' . $x . '_' . $j]);
                $credit = 0;
                $debit = 0;
                if ($postdata['transaction_type_' . $x] == 'debit')
                {


                    $debit = $postdata['refamount' . $x . '_' . $j];
                } else
                {
                    $credit = $postdata['refamount' . $x . '_' . $j];
                }
                if ($postdata['subledeger' . $x . '_' . $j] != "")
                {
                    $tblValues = array(
                        'ledger_book_details' => $det_id,
                        'ref_ledger' => $this->db->escape_str($postdata['subledeger' . $x . '_' . $j]),
                        'ref_amount' => $this->db->escape_str($postdata['refamount' . $x . '_' . $j]),
                        'credit' => $credit,
                        'debit' => $debit,
                    );
                    $output = $this->db->insert('ledger_book_reference', $tblValues);
                }

                $j++;
            }
            $x++;
        }
        $output = $this->mastermodel->save_user_activities('Add Journal Entry',$masterid, 'journal_entry');  //ss
            
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    
    function search_cost_centre_ledger() {
        $data = array();
        $user_branch = $_SESSION['user_branch'];
        $this->db->select('*');
        $this->db->from('cost_centre_ledger');
          $this->db->join('master', 'master.master_id=cost_centre_ledger.ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
         $query = "(";            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";         $query.=")";         $this->db->where($query);
        $this->db->order_by('cost_centre_ledger.ledger_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    
    
    public function insert_cost_centre_ledger($postdata) {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
           'ledger_id' => $masterid,
           'ledger_name' => $postdata['ledger_name'],
           'group_id' => $postdata['group_id'],
           'opening_balance' => $postdata['opening_balance']
       );
        $this->db->insert('cost_centre_ledger', $tblValues);
        $output = $this->mastermodel->save_user_activities('Add Cost Center Ledger',$masterid, 'cost_centre_ledger');  //ss
        
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_cost_centre_ledger($postdata) {
        $data = array();
        $this->db->trans_begin();
        $this->mastermodel->update_master_branch($postdata['ledger_id']); 
        $tblValues = array(
           'ledger_name' => $postdata['ledger_name'],
           'group_id' => $postdata['group_id'],
           'opening_balance' => $postdata['opening_balance']
       );
        $this->db->where('ledger_id',$postdata['ledger_id']);
        $this->db->update('cost_centre_ledger', $tblValues);
        $output = $this->mastermodel->save_user_activities('Edit Cost Center Ledger',$postdata['ledger_id'], 'cost_centre_ledger');  //ss
        
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    function search_cost_centre_group() {
        $data = array();
        $this->db->select('*');
        $this->db->from('cost_centre_group');
               $this->db->join('master', 'master.master_id=cost_centre_group.cost_centre_group_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('cost_centre_group.cost_centre_group_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    
    
    public function insert_cost_centre_group($postdata) {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
           'cost_centre_group_id' => $masterid,
           'group_name' => $postdata['group_name']
        );
        $this->db->insert('cost_centre_group', $tblValues);
        $output = $this->mastermodel->save_user_activities('Add Cost Center Group',$masterid, 'cost_centre_group');  //ss
        
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_cost_centre_group($postdata) {
        $data = array();
        $this->db->trans_begin();
      
        $tblValues = array(
           'group_name' => $postdata['group_name']
       );
        $this->db->where('cost_centre_group_id',$postdata['cost_centre_group_id']);
        $this->db->update('cost_centre_group', $tblValues);
        
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
     function get_general_report_settings()
    {
           $user_branch = $_SESSION['master_branch'];
        $this->db->select('*');
        $this->db->from('general_report_settings');
          $this->db->join('master', 'master.master_id=general_report_settings.general_report_settings_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
                $query = "(";        
                $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";       
                $query.=")";      
                $this->db->where($query);
     
        $this->db->order_by('general_report_settings.general_report_settings_id', 'desc');
        $data = $this->db->get()->row();
        return $data;
    }
      function get_accountgroup()
    {
        $this->db->select('account_group_id,account_group_name');
        $this->db->from('account_group');
             $this->db->join('master', 'master.master_id=account_group.account_group_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->join('account_head', 'account_head.id=account_group.group_under');
        $this->db->order_by('account_group.account_group_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }
     function get_voucher_settings($field, $table, $table_id)
    {

        $this->db->select($field . ',' . $table_id);
        $this->db->from($table);
        $result = $this->db->get()->result();
        if ($result)
        {
            return $result;
        } else
        {
            return "";
        }
    }
     function get_account_settings($field)
    {
   $user_branch = $_SESSION['master_branch'];
        $this->db->select($field);
        $this->db->from('general_settings');
             $this->db->join('master', 'master.master_id=general_settings.general_settings_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
          $query = "(";        
                $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";       
                $query.=")";      
                $this->db->where($query);
        $result = $this->db->get()->row();
        if ($result)
        {
            return $result->$field;
        } else
        {
            return "";
        }
    }
     function get_accountledger_by_groups($id)
    {
          $user_branch = $_SESSION['user_branch'];
        $this->db->select('ledger_id,ledger_name');
        $this->db->from('account_ledger');
        $this->db->join('account_group', 'account_group.account_group_id=account_ledger.account_group_id');
//        $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
//        $this->db->where('master.project_id', 3);
        $this->db->where_in('account_ledger.account_group_id', $id);
                  $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
         $query = "(";        
                $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";       
                $query.=")";      
                $this->db->where($query);
        $this->db->order_by('account_ledger.account_group_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }
      function get_search_costcentre($val)
    {
           $user_branch = $_SESSION['user_branch'];
        $this->db->select('ledger_id as id,ledger_name');
        $this->db->from('cost_centre_ledger');
        $this->db->like('cost_centre_ledger.ledger_name', $val);
                $this->db->join('master', 'master.master_id=cost_centre_ledger.ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
         $query = "(";        
                $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";       
                $query.=")";      
                $this->db->where($query);
        $this->db->order_by('cost_centre_ledger.ledger_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }
     function get_accountmaster_id($table, $field, $tableid, $idval)
    {
          $user_branch = $_SESSION['user_branch'];
        $this->db->select('ledger_id');
        $this->db->from('account_ledger');
        $this->db->join($table, 'account_ledger.ledger_id=' . $table . '.' . $tableid);
        $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where($table . '.' . $field, $idval);
        $this->db->where('master.project_id', $_SESSION['project_id']);
           $query = "(";        
                $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";       
                $query.=")";      
                $this->db->where($query);
        $result = $this->db->get()->row();
        if ($result)
        {
            return $result->ledger_id;
        } else
        {
            return "";
        }
    }
    function get_accountledger()
    {
         $user_branch = $_SESSION['user_branch'];
        $this->db->select('ledger_id,ledger_name');
        $this->db->from('account_ledger');
        $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
          $query = "(";        
                $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";       
                $query.=")";      
                $this->db->where($query);
        $this->db->order_by('account_ledger.account_group_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }
     function get_customer_det()
    {
        $this->db->select('contact_id,contact_code,contact_first_name');
        $this->db->from('contact');
        $this->db->join('master', 'master.master_id=contact.contact_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('contact.contact_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }
      function get_costcentremaster_id($table, $field, $tableid, $idval)
    {
           $user_branch = $_SESSION['user_branch'];
        $this->db->select('ledger_id');
        $this->db->from('cost_centre_ledger');
        $this->db->join($table, 'cost_centre_ledger.ledger_id=' . $table . '.' . $tableid);
        $this->db->join('master', 'master.master_id=cost_centre_ledger.ledger_id');
        $this->db->where($table . '.' . $field, $idval);
        $this->db->where('master.project_id', $_SESSION['project_id']);
          $query = "(";        
                $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";       
                $query.=")";      
                $this->db->where($query);
        $result = $this->db->get()->row();
        if ($result)
        {
            return $result->ledger_id;
        } else
        {
            return "";
        }
    }
      public function delete_journal_entry($id)
    {
        $this->db->trans_begin();

        $pid = $this->db->query("select ledger_book_details_id from ledger_book_details where ledger_book_id='$id'order by ledger_book_details_id desc");
        $result = $pid->result();
        if (!empty($result))
        {
            foreach ($result as $value)
            {
                $pdetid = $value->ledger_book_details_id;
                $this->db->where('ledger_book_reference.ledger_book_details', $pdetid);
                $output = $this->db->delete('ledger_book_reference');
            }
        }

        $this->db->where('ledger_book_details.ledger_book_id', $id);
        $output = $this->db->delete('ledger_book_details');
        $q = $this->db->query("select journal_entry_id from journal_entry where journal_ledger='$id'order by journal_ledger desc limit 1");
        $result = $q->row();
        if (!empty($result))
        {
            $jno = $result->journal_entry_id;
        }

        $this->db->where('journal_entry_details.journal_entry', $jno);
        $output = $this->db->delete('journal_entry_details');
        $this->db->where('journal_entry.journal_ledger', $id);
        $output = $this->db->delete('journal_entry');
        $this->db->where('ledger_book.ledger_book_id', $id);
        $output = $this->db->delete('ledger_book');
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = "Unable to delete Record..!";
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = "Data Deleted Successfully..!";
            return $data;
        }
    }
    function search_opening_stock() {
        $data = array();
        $this->db->select('*');
        $this->db->from('pos_opening_stock_entry');
        $this->db->join('master', 'master.master_id=opening_stock_entry_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('opening_stock_entry_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    public function insert_opening_stock($postdata) {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $opening_stock_no = $this->mastermodel->get_ref('opening_stock_no', 'pos_opening_stock_entry', 'opening_stock_no');
        $tblValues = array(
           'opening_stock_entry_id' => $masterid,
           'opening_stock_no' => $opening_stock_no,
           'date' => $this->mastermodel->convert_date_format($postdata['date']),
           'note' => $postdata['note'],
       );
        $this->db->insert('pos_opening_stock_entry', $tblValues);
        
        $i = 1;
        while (isset($postdata['product_master_'. $i])) {
            $details_id = $this->mastermodel->insertmasterdata();
            $tblValues = array(
           'opening_stock_entry_details_id' => $details_id,
           'opening_stock_entry_id' => $masterid,
           'item_id' =>$postdata['item_id_'.$i],
           'stock_id' =>$postdata['product_master_'.$i],
           'godown_id' => $postdata['godown_id_'.$i],
           'qty' =>$postdata['qty_'.$i],
           'unit' =>$postdata['unit_'.$i],
           'price' =>$postdata['price_'.$i],
           'total_amt' =>$postdata['total_amt_'.$i],
       );
        $this->db->insert('pos_opening_stock_entry_details', $tblValues);
        
        $this->db->where('stock_id', $postdata['product_master_'. $i]);
        $this->db->set('quantity', 'quantity +' . $postdata['qty_'.$i], FALSE);
        $this->db->update('pos_item_stock');
        
         $stock_register_id = $this->mastermodel->insertmasterdata();
            $stockRegtbl = array(
                'stock_register_id' => $stock_register_id,
                'trans_id' => $masterid,
                'trans_details_id' => $details_id,
                'trans_date' => $this->mastermodel->convert_date_format($postdata['date']),
                'qty' => $postdata['qty_'.$i],
                'stock_type' => 1,
                'item_id' => $postdata['item_id_' . $i],
//                'bar_code' => $discount[$i],
                'batch_id' => $postdata['batch_id_' . $i],
                'expiry_date' => $postdata['expiry_date_' . $i],
//                        'price' => $postdata['batch_id_'.$i],
                'trans_category' => 7,
                'godown_id' => $postdata['godown_id_' . $i],
//                'rack_id' => $expiry_date[$i],
//                'bin' => $unit[$i],
//                'status' => $sub_total[$i],
            );
            $this->db->insert('pos_stock_register', $stockRegtbl);
        $i++;
            }
        $output = $this->mastermodel->save_user_activities('Add Pos Opening Stock Entry',$masterid, 'pos_opening_stock_entry');  //ss
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    public function update_opening_stock($postdata) {
        $data = array();
        $this->db->trans_begin();
        $masterid = $postdata['opening_stock_entry_id'];
        $tblValues = array(
           'date' => $this->mastermodel->convert_date_format($postdata['date']),
           'note' => $postdata['note'],
       );
        $this->db->where('opening_stock_entry_id',$masterid);
        $this->db->update('pos_opening_stock_entry', $tblValues);
        
        $i = 1;
        while (isset($postdata['product_master_'. $i])) {
            $details_id = $postdata['opening_stock_entry_details_id_'.$i];
            $tblValues = array(
           'godown_id' => $postdata['godown_id_'.$i],
           'qty' =>$postdata['qty_'.$i],
           'total_amt' =>$postdata['total_amt_'.$i],
       );
        $this->db->where('opening_stock_entry_details_id',$details_id);
        $this->db->update('pos_opening_stock_entry_details', $tblValues);
        
        $prev_qty=$postdata['prv_qty_'. $i];
        $cur_qty=$postdata['qty_'. $i];
        $new_qty=$prev_qty-$cur_qty;
        $this->db->where('stock_id', $postdata['product_master_'. $i]);
        $this->db->set('quantity', 'quantity -' . $new_qty, FALSE);
        $this->db->update('pos_item_stock');
        
        $stockRegtbl = array(
                'trans_date' => $this->mastermodel->convert_date_format($postdata['date']),
                'qty' => $s_qty,
//                        'price' => $postdata['batch_id_'.$i],
                'trans_category' => 7,
                'godown_id' => $postdata['godown_id_' . $i],
//                'rack_id' => $expiry_date[$i],
//                'bin' => $unit[$i],
//                'status' => $sub_total[$i],
            );
            $this->db->where('trans_details_id', $details_id);
            $this->db->update('pos_stock_register', $stockRegtbl);
        $i++;
            }
        $output = $this->mastermodel->save_user_activities('Edit Pos Opening Stock Entry',$masterid, 'pos_opening_stock_entry');  //ss
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    var $table = 'account_group'; // define table
    var $select = array('account_group_code','account_group_name','group_under','narration','account_group_id'); //specify the columns you want to fetch from table
    var $column_order = array('account_group_code','account_group_name','group_under','narration'); //set column field database for datatable orderable
    var $column_search =array('account_group_code','account_group_name','group_under','narration');//set column field database for datatable searchable
    var $order = array('account_group.account_group_id' => 'desc'); // default order

    public function get_datatables()
    {
        $this->_get_datatables_query();
       
        if($_POST['length'] != -1)
            $this->db->limit($_POST['length'], $_POST['start']);
    

        $query = $this->db->get();
        
        return $query->result();
    }

    public function count_filtered()
    {
        $this->_get_datatables_query();
  
        $query = $this->db->get();
       
        return $query->num_rows();
    }

    public function count_all()
    {
        $this->db->from($this->table);
          $this->db->join('master', 'master.master_id=account_group.account_group_id');
       $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->where('account_group.parent',0);
        return $this->db->count_all_results();
    }

    private function _get_datatables_query()
    {

        $this->db
             ->select($this->select)
             ->from($this->table)
          ->join('master', 'master.master_id=account_group.account_group_id')
       ->where('master.project_id',$_SESSION['project_id'])
                 ->where('account_group.parent',0);

       

        $i = 0;
        foreach ($this->column_search as $item) // loop column
        {
            if($_POST['search']['value']) // if datatable send POST for search
            {

                if($i===0) // first loop
                {
                    $this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
                    $this->db->like($item, $_POST['search']['value']);
                }
                else
                {
                    $this->db->or_like($item, $_POST['search']['value']);
                }

                if(count($this->column_search) - 1 == $i) //last loop
                    $this->db->group_end(); //close bracket
            }
            $i++;
        }

        if(isset($_POST['order'])) // here order processing
        {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);

        }
        elseif (isset($this->order)) // default order processing
        {
            $order = $this->order;

            $this->db->order_by(key($order), $order[key($order)]);

        }
    }
    function search_ageing_opening() {
        $data = array();
        $this->db->select('pos_ageing_open.*,account_ledger.ledger_name');
        $this->db->from('pos_ageing_open');
        $this->db->join('master', 'master.master_id=pos_ageing_open.ageing_id');
        $this->db->join('account_ledger', 'account_ledger.ledger_id=pos_ageing_open.acc_ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('ageing_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
     public function insert_ageing_opening($postdata) {
        $data = array();
        $this->db->trans_begin();
        $i=1;
//         var_dump($postdata);die();
        while(!empty($postdata['acc_ledger_id_'.$i])){
            $masterid = $this->mastermodel->insertmasterdata();
            $tblValues = array(
               'ageing_id' => $masterid,
               'acc_ledger_id' => $postdata['acc_ledger_id_'.$i],
               'category' => $postdata['category_'.$i],
               'receivable' => $postdata['receivable_'.$i],
               'payable' => $postdata['payable_'.$i],
               'bill_no' => $postdata['bill_no_'.$i],
               'bill_date' => $this->mastermodel->convert_date_format($postdata['bill_date_'.$i]),
               'narration' => $postdata['narration_'.$i]
           );
            $this->db->insert('pos_ageing_open', $tblValues);
        $i++;
        }
        $output = $this->mastermodel->save_user_activities('Add Pos Ageing Opening',$masterid, 'pos_ageing_open');  //ss
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
     public function update_ageing_opening($postdata) {
        $data = array();
        $this->db->trans_begin();
        $i=1;
        if(!empty($postdata['acc_ledger_id_'.$i])){
            $tblValues = array(
               'acc_ledger_id' => $postdata['acc_ledger_id_'.$i],
               'category' => $postdata['category_'.$i],
               'receivable' => $postdata['receivable_'.$i],
               'payable' => $postdata['payable_'.$i],
               'bill_no' => $postdata['bill_no_'.$i],
               'bill_date' => $this->mastermodel->convert_date_format($postdata['bill_date_'.$i]),
               'narration' => $postdata['narration_'.$i]
           );
             $this->db->where('ageing_id',$postdata['ageing_id']);
            $this->db->update('pos_ageing_open', $tblValues);
        $output = $this->mastermodel->save_user_activities('Edit Pos Ageing Opening',$postdata['ageing_id'], 'pos_ageing_open');  //ss
        $i++;
        }
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
     function get_accountledger_by_head($id)
    {
        $this->db->select('ledger_id,ledger_name');
        $this->db->from('account_ledger');
        $this->db->join('account_group', 'account_group.account_group_id=account_ledger.account_group_id');
        $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('account_group.group_under', $id);
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('account_ledger.account_group_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }
    function get_account_name($id)
    {
        $this->db->select('ledger');
        $this->db->from('contact');
        
        $this->db->join('master', 'master.master_id=contact.contact_id');
        $this->db->join('crm_lead_details', 'crm_lead_details.crm_lead_contact_id=contact.contact_id');
        $this->db->where('crm_lead_details.crm_lead_details_id', $id);
        $this->db->where('master.project_id', $_SESSION['project_id']);
       
        $data = $this->db->get()->row();
         
        return $data->ledger;
    }
    function insert_financial_year($postdata)
    {
       
        $data = array();
        $this->db->trans_begin();
       
            $masterid = $this->mastermodel->insertmasterdata();
            $tblValues = array(
              'financial_year_id'=>$masterid,
              'financial_year_fromdate'=>$this->mastermodel->convert_date_format($postdata['financial_year_fromdate']),
              'financial_year_todate'=>$this->mastermodel->convert_date_format($postdata['financial_year_todate']),
           );
            $this->db->insert('financial_year', $tblValues);
     
        $output = $this->mastermodel->save_user_activities('Add financial year',$masterid, 'financial_year');  //ss
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    function update_financial_year($postdata)
    {
         $data = array();
        $this->db->trans_begin();
       $this->mastermodel->update_master_branch($postdata['financial_year_id']); 
            $tblValues = array(
               'financial_year_fromdate'=>$this->mastermodel->convert_date_format($postdata['financial_year_fromdate']),
              'financial_year_todate'=>$this->mastermodel->convert_date_format($postdata['financial_year_todate']),
           );
             $this->db->where('financial_year_id',$postdata['financial_year_id']);
            $this->db->update('financial_year', $tblValues);
        $output = $this->mastermodel->save_user_activities('Edit Financial Year',$postdata['financial_year_id'], 'financial_year');  //ss
       
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    function change_status($table, $id, $field)
    {   $data = array();
        $this->db->trans_begin();
        $tblValues= array(
            'financial_year_status'=> 0
        );
        $where = "$field != $id";
       $this->db->where($where);
       $this->db->update($table, $tblValues);
        
        $tblValues= array(
            'financial_year_status'=> 1
        );
       $this->db->where($field,$id);
       $this->db->update($table, $tblValues);
        $this->db->trans_status();
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Unable to Change status';
        }
        else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Status Changed';
        }
        return $data;
    }
      function update_reconcile_bank($postdata)
    {
          
         
           $data = array();
        $this->db->trans_begin();
        $i = 1;
        while((isset($postdata['bank_date'.$i])) && (!empty($postdata['bank_date'.$i]))){
          
        $tblValues= array(
            'bank_date'=> $this->mastermodel->convert_date_format($postdata['bank_date'.$i])
        );
       
       $this->db->where('ledger_book_id',$postdata['ledger_book_id'.$i]);
       $this->db->update('ledger_book', $tblValues);
      $i++;  }
        $this->db->trans_status();
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Unable to Updated Bank Date';
        }
        else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Updated Bank Date';
        }
        return $data;
      
    }
     function get_reconcile_bank()
    {

      
    }
     function get_account_type() {
        $data = array();
        $account_group_id = $this->accountingmodel->get_account_settings('bank_account');
        $master_branch = $_SESSION['master_branch'];
        $this->db->select('*');
        $this->db->from('account_ledger');
           $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
         $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $master_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
          $this->db->where('account_ledger.account_group_id',$account_group_id);
        $this->db->order_by('account_ledger.ledger_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }
}
