<?php


if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Accountingreportmodel extends CI_Model
{

    function __construct()
    {
        // Call the Model constructor
        parent::__construct();
    }

    function search_report()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('report');
        $this->db->where('report_module_id', $_SESSION['current_menu']);
        $this->db->order_by('report_sort', 'asc');
        $data['results'] = $this->db->get();
        return $data;
    }
     function load_journal_report($postdata)
    {
        $frmdate = $postdata['from_date'];
        $todate = $postdata['to_date'];
         $user_branch = $_SESSION['user_branch'];
        $this->db->select('*,ledger_book_details.debit as debit_val,ledger_book_details.credit as credit_val');
        $this->db->from('account_ledger');
        $this->db->join('ledger_book_details', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->join('account_group', 'account_group.account_group_id=account_ledger.account_group_id');
        $this->db->where('ledger_book.is_posted', '1');

 $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        if(empty($postdata['branch'])){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$postdata['branch']); 
        }
        if ($frmdate != '')
        {
            $frmdate = $this->db->escape($this->mastermodel->convert_date_format($frmdate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )>=', $frmdate, false);
        }
        if ($todate != '')
        {
            $todate = $this->db->escape($this->mastermodel->convert_date_format($todate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<=', $todate, false);
        }

        $this->db->order_by('ledger_book.voucher_date', 'desc');
       
        $result = $this->db->get();
        return $result->result();
    }
     function load_costcentre_leadger_report($postdata)
    { 

         $frmdate = $postdata['from_date'];
        $todate = $postdata['to_date'];
 $user_branch = $_SESSION['user_branch'];
        $this->db->select('*,sum(ledger_book_reference.debit) as debit_val,sum(ledger_book_reference.credit) as credit_val,sum(ledger_book_reference.debit-ledger_book_reference.credit) as amount');
         $this->db->from('cost_centre_ledger');
        $this->db->join('ledger_book_reference', 'ledger_book_reference.ref_ledger=cost_centre_ledger.ledger_id');
        $this->db->join('cost_centre_group', 'cost_centre_group.cost_centre_group_id=cost_centre_ledger.group_id');
        $this->db->join('ledger_book_details', 'ledger_book_details.ledger_book_details_id=ledger_book_reference.ledger_book_details');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->where('ledger_book.is_posted', '1');
 $this->db->join('master', 'master.master_id=cost_centre_ledger.ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
            if(empty($postdata['branch'])){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$postdata['branch']); 
        }
        if ($frmdate != ''){
            $this->db->where('voucher_date >=', $this->mastermodel->convert_date_format($frmdate));
        }
        if ($todate != ''){
            $this->db->where('voucher_date <=', $this->mastermodel->convert_date_format($todate));
        }
        $this->db->group_by('cost_centre_group.cost_centre_group_id');
        $this->db->order_by('ledger_book.voucher_date', 'desc');
        $result = $this->db->get();
        return $result->result();
    }
     function get_costcentre_ledger_list($id,$frmdate,$todate)
    {
        $this->db->select('cost_centre_group.cost_centre_group_id as row_id,cost_centre_ledger.ledger_id as main_id,cost_centre_ledger.ledger_name as name,sum(ledger_book_reference.debit) as debit_val,sum(ledger_book_reference.credit) as credit_val,sum(ledger_book_reference.debit-ledger_book_reference.credit) as amount');
        $this->db->from('cost_centre_ledger');
        $this->db->join('ledger_book_reference', 'ledger_book_reference.ref_ledger=cost_centre_ledger.ledger_id');
        $this->db->join('cost_centre_group', 'cost_centre_group.cost_centre_group_id=cost_centre_ledger.group_id');
        $this->db->join('ledger_book_details', 'ledger_book_details.ledger_book_details_id=ledger_book_reference.ledger_book_details');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->where('ledger_book.is_posted', '1');
        $this->db->where('cost_centre_group.cost_centre_group_id', $id);
         $this->db->join('master', 'master.master_id=cost_centre_ledger.ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        if ($frmdate != '')
            $this->db->where('voucher_date >=', $frmdate);
        if ($todate != '')
            $this->db->where('voucher_date <=', $todate);
        $this->db->group_by('cost_centre_ledger.ledger_id');
        $this->db->order_by('ledger_book.voucher_date', 'desc');
        $result = $this->db->get();

        return $result->result();
    }
       function load_ledger_report($postdata)
    {
           
            $frmdate = $postdata['from_date'];
        $todate = $postdata['to_date'];
        $acc =$postdata['ledger_id'];
        $user_branch = $_SESSION['user_branch'];
        
        $this->db->select('*,sum(ledger_book_details.debit) as debit_val,sum(ledger_book_details.credit) as credit_val,ledger_book_details.narration as description,account_ledger.ledger_id');
        $this->db->from('account_ledger');
        $this->db->join('ledger_book_details', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->where('ledger_book.is_posted', '1');
        $this->db->group_by('ledger_book.ledger_book_id');
        $this->db->where('ledger_book_details.account_ledger_id', $acc);
        $this->db->order_by('ledger_book.voucher_date');
         $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
         if(empty($postdata['branch'])){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$postdata['branch']); 
        }
        if ($frmdate != '')
        {
            $frmdate = $this->db->escape($this->mastermodel->convert_date_format($frmdate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )>=', $frmdate, false);
        }
        if ($todate != '')
        {
            $todate = $this->db->escape($this->mastermodel->convert_date_format($todate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<=', $todate, false);
        }


        $res = $this->db->get();
 
        return $res->result();
    }
     function open_deb_cred($postdata)
    {
        $frmdate = $postdata['from_date'];
        $user_branch = $_SESSION['user_branch'];
        $acc =$postdata['ledger_id'];
        $this->db->select('sum(ledger_book_details.debit) as open_debit,sum(ledger_book_details.credit) as open_credit,account_ledger.opening_balance');
        $this->db->from('account_ledger');
        $this->db->join('ledger_book_details', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->where('ledger_book.is_posted', '1');
         $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        if ($frmdate != '')
        {
            $frmdate = $this->db->escape($this->mastermodel->convert_date_format($frmdate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<', $frmdate, false);
        }
        if(empty($postdata['branch'])){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$postdata['branch']); 
        }

        $this->db->where('account_ledger.ledger_id', $acc);
        $res = $this->db->get();

        return $res->result();
    }
     function get_ledger_book_narration($id, $detid)
    {
        $this->db->select('*');
        $this->db->from('ledger_book_details');
        $this->db->join('account_ledger', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->where('ledger_book_details.ledger_book_id', $id);
        $this->db->where('ledger_book_details.ledger_book_details_id !=', $detid);
        $this->db->order_by('ledger_book_details.ledger_book_details_id', 'desc');
//         $this->db->join('master', 'master.master_id=ledger_book_details.ledger_book_details_id');
//        $this->db->where('master.project_id',$_SESSION['project_id']);
        $data = $this->db->get()->row();
        if (!empty($data))
        {
            $result = $data->ledger_name;
        } else
        {
            $result = "";
        }
        return $result;
    }
     function voucher_detail($id)
    {
            $user_branch = $_SESSION['user_branch'];
        $this->db->select('*,account_head.id as account_head_id,sum(ledger_book_details.debit) as debit_val,sum(ledger_book_details.credit) as credit_val,sum(ledger_book_details.debit-ledger_book_details.credit) as amount');
        $this->db->from('account_ledger');
        $this->db->join('ledger_book_details', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->join('account_group', 'account_group.account_group_id=account_ledger.account_group_id');
        $this->db->join('account_head', 'account_head.id=account_group.group_under');
        $this->db->where('ledger_book.ledger_book_id', $id);
        $this->db->where('ledger_book.is_posted', '1');
        $this->db->group_by('ledger_book.ledger_book_id');
        $this->db->order_by('ledger_book.voucher_date', 'desc');
        $this->db->order_by('ledger_book_details.ledger_book_details_id', 'asc');
          $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $query = "(";        
                $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";       
                $query.=")";      
                $this->db->where($query);
        $result = $this->db->get();

        return $result->result();
    }
      function get_ledger_book_details($id)
    {
        $this->db->select('*,ledger_book_details.debit as debit,ledger_book_details.credit as credit');
        $this->db->from('ledger_book_details');
        $this->db->join('account_ledger', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->where('ledger_book_details.ledger_book_id', $id);
        $this->db->order_by('ledger_book_details.ledger_book_details_id', 'desc');
//            $this->db->join('master', 'master.master_id=ledger_book_details.ledger_book_details_id');
//        $this->db->where('master.project_id',$_SESSION['project_id']);
        $data = $this->db->get()->result();
      
        return $data;
    }
       function get_report_account_settings($field)
    {
            $user_branch = $_SESSION['master_branch'];
        $this->db->select($field);
        $this->db->from('general_report_settings');
          $this->db->join('master', 'master.master_id=general_report_settings.general_report_settings_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
           $query = "(";        
                $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";       
                $query.=")";      
                $this->db->where($query);
        $result = $this->db->get()->row();
        if ($result)
        {
            return $result->$field;
        } else
        {
            return "";
        }
    }
      function load_trial_balance_report($postdata)
    {
           $user_branch = $_SESSION['user_branch'];
          $capitalid = (int)$this->accountingreportmodel->get_report_account_settings('capital_account');
        $loanid = (int)$this->accountingreportmodel->get_report_account_settings('loans');
        $currentid = (int)$this->accountingreportmodel->get_report_account_settings('current_liabilities');
        $fixedassetid = (int)$this->accountingreportmodel->get_report_account_settings('fixed_assets');
        $current_assetsid = (int)$this->accountingreportmodel->get_report_account_settings('current_assets');
        $investmentsid = (int)$this->accountingreportmodel->get_report_account_settings('investments');
        $purchase_id = (int)$this->accountingreportmodel->get_report_account_settings('purchase_account');
        $directid = (int)$this->accountingreportmodel->get_report_account_settings('direct_expense');
        $directincomesid = (int)$this->accountingreportmodel->get_report_account_settings('direct_incomes');
        $branchdivisionid = (int)$this->accountingreportmodel->get_report_account_settings('branch_division');
        $salesid = (int)$this->accountingreportmodel->get_report_account_settings('sales_account');
        $indirectid = (int)$this->accountingreportmodel->get_report_account_settings('indirect_expense');
        $otherincomes_id = (int)$this->accountingreportmodel->get_report_account_settings('other_incomes');
           
            $frmdate = $postdata['from_date'];
        $todate = $postdata['to_date'];
        
         $this->db->select('account_group.account_group_name,account_group.account_group_id as account_group_id,account_group.group_under as account_head_id');
        $this->db->from('account_group');

       
        $this->db->join('account_head', 'account_head.id=account_group.group_under');

        $this->db->where('account_group.parent', 0);
         $this->db->_protect_identifiers = FALSE;
       $this->db->order_by('FIELD ( account_group_id, ' . $otherincomes_id . ',' . $directid . ',' . $directincomesid . ',' . $purchase_id . ',' . $salesid . ',' . $branchdivisionid . ',' . $investmentsid . ',' . $current_assetsid . ',' . $fixedassetid . ',' . $currentid . ',' . $loanid . ',' . $capitalid . ')', 'DESC', FALSE);
             $this->db->_protect_identifiers = TRUE;
$this->db->join('master', 'master.master_id=account_group.account_group_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
         
//        $array_of_ordered_ids = array($otherincomes_id ,$directid,$directincomesid, $purchase_id,$salesid,$branchdivisionid,$investmentsid,$current_assetsid,$fixedassetid,$currentid,$loanid,$capitalid);
//
//        $order = sprintf("FIELD(account_group_id, %s)", implode(',', $array_of_ordered_ids));
// $this->db->_protect_identifiers = FALSE;
//        $this->db->order_by($order);
//        $this->db->_protect_identifiers = TRUE;
        $result = $this->db->get();

        return $result->result();
    }
       function get_trialbalance_group_by_settings_id($id, $frmdate, $todate,$branch)
    {
        $ids[] = $id;
        $child_list = $this->accountingreportmodel->get_child_id_list($id);
        foreach ($child_list as $child)
        {
            $ids[] = $child->account_group_id;
//            $subids[] = $child->account_group_id;

            $subchild_list = $this->accountingreportmodel->get_child_id_list($child->account_group_id);
//            $countids = count($subchild_list);
            foreach ($subchild_list as $subchild)
            {

                $ids[] = $subchild->account_group_id;
                $subchild_listone = $this->accountingreportmodel->get_child_id_list($subchild->account_group_id);

                foreach ($subchild_listone as $subchildone)
                {

                    $ids[] = $subchildone->account_group_id;
                    $subchild_listtwo = $this->accountingreportmodel->get_child_id_list($subchildone->account_group_id);
                    foreach ($subchild_listtwo as $subchildtwo)
                    {

                        $ids[] = $subchildtwo->account_group_id;
                        $subchild_listthree = $this->accountingreportmodel->get_child_id_list($subchildtwo->account_group_id);
                        foreach ($subchild_listthree as $subchildthree)
                        {

                            $ids[] = $subchildthree->account_group_id;
                        }
                    }
                }
            }
        }
         $user_branch = $_SESSION['user_branch'];
        $this->db->select('account_head.id as row_id,account_group.account_group_name as name,account_group.account_group_id as account_group_id,sum(ledger_book_details.debit) as debit,sum(ledger_book_details.credit) as credit,sum(ledger_book_details.debit-ledger_book_details.credit) as amount');

        $this->db->from('account_ledger');
        $this->db->join('ledger_book_details', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->join('account_group', 'account_group.account_group_id=account_ledger.account_group_id');
        $this->db->join('account_head', 'account_head.id=account_group.group_under');
$this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->where('ledger_book.is_posted', '1');
            if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }

        if ($frmdate != '')
        {
            $frmdate = $this->db->escape($this->mastermodel->convert_date_format($frmdate));
        }
        if ($todate != '')
        {
            $todate = $this->db->escape($this->mastermodel->convert_date_format($todate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<=', $todate, false);
        }
        $this->db->where_in('account_ledger.account_group_id', $ids);
        $this->db->order_by('ledger_book.voucher_date', 'desc');
        $result = $this->db->get();

        $res = $result->row();
        return $res;

    }
      function get_child_id_list($id)
    {

        $this->db->select('account_group_id');
        $this->db->from('account_group');
        $this->db->where('account_group.parent', $id);
        $this->db->join('master', 'master.master_id=account_group.account_group_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $result = $this->db->get()->result();
        return $result;
    }
      function close_violated_debit_credit($id, $todate,$branch)
    {
           $user_branch = $_SESSION['user_branch'];
//        $this->db->select('if((min(account_group.account_group_id)>account_group.account_group_id),(if(account_head.account_type="Debit" && sum(ledger_book_details.credit)>sum(ledger_book_details.debit),sum(ledger_book_details.credit),"0")),"0") as violate_credit',TRUE);
//        $this->db->select('(if(account_head.account_type="Debit" && sum(ledger_book_details.credit)>sum(ledger_book_details.debit) && (min(account_group.account_group_id)>account_group.account_group_id),sum(ledger_book_details.credit),"0")) as violate_credit',FALSE);
        $this->db->select('(if(account_head.account_type="Credit" && sum(ledger_book_details.debit)>sum(ledger_book_details.credit),sum(ledger_book_details.debit-ledger_book_details.credit),"0"))as violate_debit', FALSE);
        $this->db->select('(if(account_head.account_type="Debit" && sum(ledger_book_details.credit)>sum(ledger_book_details.debit),sum(ledger_book_details.debit-ledger_book_details.credit),"0"))as violate_credit', FALSE);
        $this->db->from('account_ledger');
        $this->db->join('ledger_book_details', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->join('account_group', 'account_group.account_group_id=account_ledger.account_group_id');
        $this->db->join('account_head', 'account_head.id=account_group.group_under');

        $this->db->where('ledger_book.is_posted', '1');
       $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
          if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
        if ($todate != '')
        {
            $todate = $this->db->escape($this->mastermodel->convert_date_format($todate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<=', $todate, false);
        }
        $this->db->where('account_ledger.account_group_id', $id);
        $this->db->group_by('account_ledger.ledger_id');
        $this->db->order_by('ledger_book.voucher_date', 'desc');
        $result = $this->db->get();
//        );
        $res = $result->result();
        if (!empty($res))
        {
            foreach ($res as $value)
            {
                $row->violate_debit = $row->violate_debit + $value->violate_debit;
                $row->violate_credit = $row->violate_credit + $value->violate_credit;
            }
        }
        return $row;
    }
        function violated_debit_credit($id, $frmdate, $todate,$branch)
    {
            $user_branch = $_SESSION['user_branch'];
//        $this->db->select('if((min(account_group.account_group_id)>account_group.account_group_id),(if(account_head.account_type="Debit" && sum(ledger_book_details.credit)>sum(ledger_book_details.debit),sum(ledger_book_details.credit),"0")),"0") as violate_credit',TRUE);
//        $this->db->select('(if(account_head.account_type="Debit" && sum(ledger_book_details.credit)>sum(ledger_book_details.debit) && (min(account_group.account_group_id)>account_group.account_group_id),sum(ledger_book_details.credit),"0")) as violate_credit',FALSE);
        $this->db->select('(if(account_head.account_type="Credit" && sum(ledger_book_details.debit)>sum(ledger_book_details.credit),sum(ledger_book_details.debit-ledger_book_details.credit),"0"))as violate_debit', FALSE);
        $this->db->select('(if(account_head.account_type="Debit" && sum(ledger_book_details.credit)>sum(ledger_book_details.debit),sum(ledger_book_details.debit-ledger_book_details.credit),"0"))as violate_credit', FALSE);
        $this->db->from('account_ledger');
        $this->db->join('ledger_book_details', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->join('account_group', 'account_group.account_group_id=account_ledger.account_group_id');
        $this->db->join('account_head', 'account_head.id=account_group.group_under');

        $this->db->where('ledger_book.is_posted', '1');
 $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
         if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
        if ($frmdate != '')
        {
            $frmdate = $this->db->escape($this->mastermodel->convert_date_format($frmdate));
//            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )>=', $frmdate, false);
        }
        if ($todate != '')
        {
            $todate = $this->db->escape($this->mastermodel->convert_date_format($todate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<=', $todate, false);
        }
        $this->db->where('account_ledger.account_group_id', $id);

        $this->db->order_by('ledger_book.voucher_date', 'desc');
        $result = $this->db->get();
//        $res = $result->row();
        $res = $result->result();
        if (!empty($res))
        {
            foreach ($res as $value)
            {
                $row->violate_debit = $row->violate_debit + $value->violate_debit;
                $row->violate_credit = $row->violate_credit + $value->violate_credit;
            }
        }
        return $row;
    }
      function open_deb_cred_balance_by_accgroup($data)
    {
           $user_branch = $_SESSION['user_branch'];
        $frmdate = $data['frmdate'];
        $branch = $data['branch'];
        $id = $data['id'];

        $ids[] = $id;
        $child_list = $this->accountingreportmodel->get_child_id_list($id);
        foreach ($child_list as $child)
        {
            $ids[] = $child->account_group_id;
//            $subids[] = $child->account_group_id;

            $subchild_list = $this->accountingreportmodel->get_child_id_list($child->account_group_id);
//            $countids = count($subchild_list);
            foreach ($subchild_list as $subchild)
            {

                $ids[] = $subchild->account_group_id;
                $subchild_listone = $this->accountingreportmodel->get_child_id_list($subchild->account_group_id);

                foreach ($subchild_listone as $subchildone)
                {

                    $ids[] = $subchildone->account_group_id;
                    $subchild_listtwo = $this->accountingreportmodel->get_child_id_list($subchildone->account_group_id);
                    foreach ($subchild_listtwo as $subchildtwo)
                    {

                        $ids[] = $subchildtwo->account_group_id;
                    }
                    $subchild_listthree = $this->accountingreportmodel->get_child_id_list($subchildtwo->account_group_id);
                    foreach ($subchild_listthree as $subchildthree)
                    {

                        $ids[] = $subchildthree->account_group_id;
                    }
                }
            }
        }

        $this->db->select('sum(ledger_book_details.debit) as open_debit,sum(ledger_book_details.credit) as open_credit,account_ledger.opening_balance');
        $this->db->from('account_ledger');
        $this->db->join('ledger_book_details', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->where('ledger_book.is_posted', '1');
         $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
         if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
        if ($frmdate != '')
        {
            $frmdate = $this->db->escape($this->mastermodel->convert_date_format($frmdate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<', $frmdate, false);
        }

//        if ($frmdate != '')
//            $this->db->where('voucher_date <=', $this->mastermodel->convert_date_format($frmdate));
        $this->db->where_in('account_ledger.account_group_id', $ids);
//        $this->db->where('account_ledger.account_group_id', $id);
//        $this->db->order_by('ledger_id', 'desc');
        $res = $this->db->get();
//        );
        return $res->row();
    }
     function stock_receiving_prev($frmdate,$branch)
    {
         $user_branch = $_SESSION['user_branch'];
         if($_SESSION['project_id']==3){
             
        
        $this->db->select('sum(con_purchase_details.total) as receivingamount');
        $this->db->from('con_purchase_details');
        $this->db->join('con_purchase', 'con_purchase.con_purchase_id=con_purchase_details.con_purchase_id', 'left');
       $this->db->join('item_master', 'item_master.item_master_id=con_purchase_details.item');
         $this->db->order_by('con_purchase_details.con_purchase_details_id', 'desc');
        $this->db->order_by('con_purchase.con_purchase_id', 'desc');
        $this->db->where('po_date <', $this->mastermodel->convert_date_format($frmdate));
         $this->db->join('master', 'master.master_id=con_purchase_details.con_purchase_details_id');
         if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
        $result = $this->db->get();
        $res = $result->row();
        if ($res)
        {
            return $res->receivingamount;
        } else
        {
            return "";
        }
         }
         if($_SESSION['project_id']==2){
             
        
        $this->db->select('sum(prop_sub_purchase_item.prop_sub_purchase_item_total_amount) as receivingamount');
        $this->db->from('prop_sub_purchase_item');
        $this->db->join('prop_purchase_item', 'prop_purchase_item.prop_purchase_item_id=prop_sub_purchase_item.prop_sub_purchase_item_purchase_item_id', 'left');
        $this->db->join('item_master', 'item_master.item_master_id=prop_sub_purchase_item.prop_sub_purchase_item_item_id');
        $this->db->order_by('prop_sub_purchase_item.prop_sub_purchase_item_id', 'desc');
        $this->db->order_by('prop_purchase_item.prop_purchase_item_id', 'desc');
        $this->db->where('prop_purchase_item_date <', $this->mastermodel->convert_date_format($frmdate));
         $this->db->join('master', 'master.master_id=prop_sub_purchase_item.prop_sub_purchase_item_id');
         if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
        $result = $this->db->get();
        $res = $result->row();
        if ($res)
        {
            return $res->receivingamount;
        } else
        {
            return "";
        }
         }
          if($_SESSION['project_id']==4){
             
        
        $this->db->select('sum(pos_purchase_details.amount) as receivingamount');
        $this->db->from('pos_purchase_details');
        $this->db->join('pos_purchase', 'pos_purchase.purchase_id=pos_purchase_details.purchase_id', 'left');
        $this->db->join('pos_item_master', 'pos_item_master.product_id=pos_purchase_details.product_master');
        $this->db->order_by('pos_purchase_details.purchase_details_id', 'desc');
        $this->db->order_by('pos_purchase.purchase_id', 'desc');
        $this->db->where('purchase_date <', $this->mastermodel->convert_date_format($frmdate));
         $this->db->join('master', 'master.master_id=pos_purchase_details.purchase_details_id');
         if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
        $result = $this->db->get();
        $res = $result->row();
        if ($res)
        {
            return $res->receivingamount;
        } else
        {
            return "";
        }
         }
    }
     function stock_allocation_prev($frmdate,$branch)
    {
//            if($_SESSION['project_id']==3){
//             
//        
//        $this->db->select('COALESCE(sum(transfer_total),"0") as transferamount');
//        $this->db->from('con_item_transfer_details');
//        $this->db->join('item_transfer_to_site', 'con_item_transfer_details.item_transfer_to_site=item_transfer_to_site.item_transfer_to_site_id');
//        $this->db->join('item_master', 'item_master.item_master_id=con_item_transfer_details.transfer_item');
//        $this->db->where('transfer_date <', $this->mastermodel->convert_date_format($frmdate));
//        $result = $this->db->get();
//        $res = $result->row();
//        if ($res)
//        {
//            return $res->transferamount;
//        } else
//        {
//            return "";
//        }
//            }
    }
      function get_opening_stock_in_construction($date,$branch)
    {
           $user_branch = $_SESSION['user_branch'];
        $this->db->select('sum(price*prop_item_stock_qty) as openingstock');
        $this->db->from('prop_item_stock ');

        $this->db->join('(select AVG(price*prop_item_stock_qty) as totalamnt, max(stock_date) as TopDate,prop_item_stock_id as stock_id   FROM prop_item_stock construction_stocks JOIN master ON master.master_id=construction_stocks.prop_item_stock_id where stock_date <"' . $this->mastermodel->convert_date_format($date) . '" AND master.project_id = "'.$_SESSION['project_id'].'" GROUP BY construction_stocks.prop_item_id)as EachItem', 'EachItem.TopDate = prop_item_stock.stock_date  and EachItem.stock_id = prop_item_stock.prop_item_stock_id', 'inner');
         $this->db->join('master', 'master.master_id=prop_item_stock.prop_item_stock_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
         if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
        $data = $this->db->get()->row();
        if (!empty($data))
        {
            $result = $data->openingstock;
        } else
        {
            $result = 0;
        }
        return $result;
    }
     function get_expensesamount_prev($frmdate, $todate,$branch)
    {
           $user_branch = $_SESSION['user_branch'];
        $this->db->select('*,sum(ledger_book_details.debit-ledger_book_details.credit) as amount');
//        $this->db->select('sum( case when voucher_date <='.$frmdate. 'then ledger_book_details.debit else 0 end) as open_debit,sum(case when voucher_date <='.$frmdate. 'then ledger_book_details.credit else 0 end) as open_credit');
        $this->db->from('account_ledger');
        $this->db->join('ledger_book_details', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->join('account_group', 'account_group.account_group_id=account_ledger.account_group_id');
        $this->db->join('account_head', 'account_head.id=account_group.group_under');
        $this->db->where('ledger_book.is_posted', '1');
        $this->db->where_in('account_group.group_under', '3');
 $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
         if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
        if ($frmdate != '')
        {
            $frmdate = $this->db->escape($this->mastermodel->convert_date_format($frmdate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<', $frmdate, false);
        }
        if ($todate != '')
        {
//            $todate = $this->db->escape($this->mastermodel->convert_date_format($todate));
//            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<=', $todate, false);
        }

//        if ($frmdate != '')
//            $this->db->where('voucher_date >=', $this->mastermodel->convert_date_format($frmdate));
//        if ($todate != '')
//            $this->db->where('voucher_date <=', $this->mastermodel->convert_date_format($todate));


        $this->db->group_by('account_head.id');
        $this->db->order_by('ledger_book.voucher_date', 'desc');
        $result = $this->db->get();
//        );

        $res = $result->row();
        if ($res)
        {
            return $res->amount;
        } else
        {
            return "";
        }
    }
     function get_incomeamount_prev($frmdate, $todate,$branch)
    {
         $user_branch = $_SESSION['user_branch'];
        $this->db->select('*,sum(ledger_book_details.debit-ledger_book_details.credit) as amount');
//        $this->db->select('sum( case when voucher_date <='.$frmdate. 'then ledger_book_details.debit else 0 end) as open_debit,sum(case when voucher_date <='.$frmdate. 'then ledger_book_details.credit else 0 end) as open_credit');
        $this->db->from('account_ledger');
        $this->db->join('ledger_book_details', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->join('account_group', 'account_group.account_group_id=account_ledger.account_group_id');
        $this->db->join('account_head', 'account_head.id=account_group.group_under');
        $this->db->where('ledger_book.is_posted', '1');
        $this->db->where_in('account_head.id', '4');
 $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
         if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
        if ($frmdate != '')
        {
            $frmdate = $this->db->escape($this->mastermodel->convert_date_format($frmdate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<', $frmdate, false);
        }
        if ($todate != '')
        {
            $todate = $this->db->escape($this->mastermodel->convert_date_format($todate));
//            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<=', $todate, false);
        }

//        if ($frmdate != '')
//            $this->db->where('voucher_date >=', $this->mastermodel->convert_date_format($frmdate));
//        if ($todate != '')
//            $this->db->where('voucher_date <=', $this->mastermodel->convert_date_format($todate));


        $this->db->group_by('account_head.id');
        $this->db->order_by('ledger_book.voucher_date', 'desc');
        $result = $this->db->get();
//        );

        $res = $result->row();
        if ($res)
        {
            return $res->amount;
        } else
        {
            return "";
        }
    }
     function get_account_ledger_list($data)
    {
         $user_branch = $_SESSION['user_branch'];
        $frmdate = $data['frmdate'];
        $todate = $data['todate'];
        $id = $data['id'];
          $branch = $data['branch'];
        $this->db->select('account_head.id as main_id,account_group.account_group_id as row_id,account_ledger.ledger_name as name,account_ledger.ledger_id as s_id,sum(ledger_book_details.debit) as debit_val,sum(ledger_book_details.credit) as credit_val,sum(ledger_book_details.debit-ledger_book_details.credit) as amount');
        $this->db->from('account_ledger');
        $this->db->join('ledger_book_details', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->join('account_group', 'account_group.account_group_id=account_ledger.account_group_id');
        $this->db->join('account_head', 'account_head.id=account_group.group_under');
        $this->db->where('ledger_book.is_posted', '1');
        $this->db->where('account_group.account_group_id', $id);
 $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
         if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
        if ($frmdate != '')
        {
            $frmdate = $this->db->escape($this->mastermodel->convert_date_format($frmdate));
//            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )>=', $frmdate, false);
        }
        if ($todate != '')
        {
            $todate = $this->db->escape($this->mastermodel->convert_date_format($todate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<=', $todate, false);
        }


//        if ($frmdate != '')
//            $this->db->where('voucher_date >=', $this->mastermodel->convert_date_format($frmdate));
//        if ($todate != '')
//            $this->db->where('voucher_date <=', $this->mastermodel->convert_date_format($todate));
        $this->db->group_by('account_ledger.ledger_id');
        $this->db->order_by('ledger_book.voucher_date', 'desc');
        $result = $this->db->get();
        return $result->result();
    }
     function get_account_group_list_by_parent($data)
    {
           $user_branch = $_SESSION['user_branch'];
        $frmdate = $data['frmdate'];
        $todate = $data['todate'];
        $id = $data['id'];
          $branch = $data['branch'];
        $ids[] = $id;
        $child_list = $this->accountingreportmodel->get_child_id_list($id);
        foreach ($child_list as $child)
        {
            $ids[] = $child->account_group_id;
//            $subids[] = $child->account_group_id;

            $subchild_list = $this->accountingreportmodel->get_child_id_list($child->account_group_id);
//            $countids = count($subchild_list);
            foreach ($subchild_list as $subchild)
            {

                $ids[] = $subchild->account_group_id;
                $subchild_listone = $this->accountingreportmodel->get_child_id_list($subchild->account_group_id);

                foreach ($subchild_listone as $subchildone)
                {

                    $ids[] = $subchildone->account_group_id;
                    $subchild_listtwo = $this->accountingreportmodel->get_child_id_list($subchildone->account_group_id);
                    foreach ($subchild_listtwo as $subchildtwo)
                    {

                        $ids[] = $subchildtwo->account_group_id;
                    }
                    $subchild_listthree = $this->accountingreportmodel->get_child_id_list($subchildtwo->account_group_id);
                    foreach ($subchild_listthree as $subchildthree)
                    {

                        $ids[] = $subchildthree->account_group_id;
                    }
                }
            }
        }
        $this->db->select('account_head.id as row_id,account_group.account_group_name as name,account_group.account_group_id as account_group_id,sum(ledger_book_details.debit) as debit_val,sum(ledger_book_details.credit) as credit_val,sum(ledger_book_details.debit-ledger_book_details.credit) as amount');
        $this->db->from('account_ledger');
        $this->db->join('ledger_book_details', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->join('account_group', 'account_group.account_group_id=account_ledger.account_group_id');
        $this->db->join('account_head', 'account_head.id=account_group.group_under');
        $this->db->where('ledger_book.is_posted', '1');
        $this->db->where('account_group.parent', $id);
         $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
//         $this->db->where('(`account_group`.`parent` in (' . $indirectid . ') or `account_group`.`account_group_id` in (' . $indirectid . '))');
         if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
        if ($frmdate != '')
        {
            $frmdate = $this->db->escape($this->mastermodel->convert_date_format($frmdate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )>=', $frmdate, false);
        }
        if ($todate != '')
        {
            $todate = $this->db->escape($this->mastermodel->convert_date_format($todate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<=', $todate, false);
        }

//        if ($frmdate != '')
//            $this->db->where('voucher_date >=', $this->mastermodel->convert_date_format($frmdate));
//        if ($todate != '')
//            $this->db->where('voucher_date <=', $this->mastermodel->convert_date_format($todate));
        $this->db->group_by('account_group.account_group_id');
        $this->db->order_by('ledger_book.voucher_date', 'desc');

        $result = $this->db->get();
// );
        return $result->result();
    }
     function list_account_group_by_parent($id)
    {



        $this->db->select('account_head.id as row_id,account_group.account_group_name as name,account_group.account_group_id as account_group_id,');
        $this->db->from('account_group');
        $this->db->join('account_head', 'account_head.id=account_group.group_under');
        $this->db->where('account_group.parent', $id);
        $this->db->group_by('account_group.account_group_id');

 $this->db->join('master', 'master.master_id=account_group.account_group_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $result = $this->db->get();
// );
        return $result->result();
    }

    function account_group_amount_calculation($data)
    {
        $frmdate = $data['frmdate'];
        $todate = $data['todate'];
        $id = $data['id'];
          $user_branch = $_SESSION['user_branch'];
         $branch = $data['branch'];
        $ids[] = $id;
        $child_list = $this->accountingreportmodel->get_child_id_list($id);
        foreach ($child_list as $child)
        {
            $ids[] = $child->account_group_id;
//            $subids[] = $child->account_group_id;

            $subchild_list = $this->accountingreportmodel->get_child_id_list($child->account_group_id);
//            $countids = count($subchild_list);
            foreach ($subchild_list as $subchild)
            {

                $ids[] = $subchild->account_group_id;
                $subchild_listone = $this->accountingreportmodel->get_child_id_list($subchild->account_group_id);

                foreach ($subchild_listone as $subchildone)
                {

                    $ids[] = $subchildone->account_group_id;
                    $subchild_listtwo = $this->accountingreportmodel->get_child_id_list($subchildone->account_group_id);
                    foreach ($subchild_listtwo as $subchildtwo)
                    {

                        $ids[] = $subchildtwo->account_group_id;
                    }
                    $subchild_listthree = $this->accountingreportmodel->get_child_id_list($subchildtwo->account_group_id);
                    foreach ($subchild_listthree as $subchildthree)
                    {

                        $ids[] = $subchildthree->account_group_id;
                    }
                }
            }
        }
        $this->db->select('sum(ledger_book_details.debit-ledger_book_details.credit) as amount');
        $this->db->from('account_ledger');
        $this->db->join('ledger_book_details', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->join('account_group', 'account_group.account_group_id=account_ledger.account_group_id');
        $this->db->join('account_head', 'account_head.id=account_group.group_under');
        $this->db->where('ledger_book.is_posted', '1');
        $this->db->where_in('account_group.account_group_id', $ids);
 $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
         if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
        if ($frmdate != '')
        {
            $frmdate = $this->db->escape($this->mastermodel->convert_date_format($frmdate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )>=', $frmdate, false);
        }
        if ($todate != '')
        {
            $todate = $this->db->escape($this->mastermodel->convert_date_format($todate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<=', $todate, false);
        }

//        if ($frmdate != '')
//            $this->db->where('voucher_date >=', $this->mastermodel->convert_date_format($frmdate));
//        if ($todate != '')
//            $this->db->where('voucher_date <=', $this->mastermodel->convert_date_format($todate));

        $this->db->order_by('ledger_book.voucher_date', 'desc');

        $result = $this->db->get()->row();
// );

        if (!empty($result))
        {
            $data = $result->amount;
        } else
        {
            $data = 0;
        }
        return $data;
    }
    function balancesheet_account_group_amount($data)
    {
        $frmdate = $data['frmdate'];
        $todate = $data['todate'];
        $id = $data['id'];
         $user_branch = $_SESSION['user_branch'];
         $branch = $data['branch'];
        $ids[] = $id;
        $child_list = $this->accountingreportmodel->get_child_id_list($id);
        foreach ($child_list as $child)
        {
            $ids[] = $child->account_group_id;
//            $subids[] = $child->account_group_id;

            $subchild_list = $this->accountingreportmodel->get_child_id_list($child->account_group_id);
//            $countids = count($subchild_list);
            foreach ($subchild_list as $subchild)
            {

                $ids[] = $subchild->account_group_id;
                $subchild_listone = $this->accountingreportmodel->get_child_id_list($subchild->account_group_id);

                foreach ($subchild_listone as $subchildone)
                {

                    $ids[] = $subchildone->account_group_id;
                    $subchild_listtwo = $this->accountingreportmodel->get_child_id_list($subchildone->account_group_id);
                    foreach ($subchild_listtwo as $subchildtwo)
                    {

                        $ids[] = $subchildtwo->account_group_id;
                    }
                    $subchild_listthree = $this->accountingreportmodel->get_child_id_list($subchildtwo->account_group_id);
                    foreach ($subchild_listthree as $subchildthree)
                    {

                        $ids[] = $subchildthree->account_group_id;
                    }
                }
            }
        }
        $this->db->select('sum(ledger_book_details.debit-ledger_book_details.credit) as amount');
        $this->db->from('account_ledger');
        $this->db->join('ledger_book_details', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->join('account_group', 'account_group.account_group_id=account_ledger.account_group_id');
        $this->db->join('account_head', 'account_head.id=account_group.group_under');
        $this->db->where('ledger_book.is_posted', '1');
        $this->db->where_in('account_group.account_group_id', $ids);
         $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
           if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
//        $this->db->where('account_group.parent', $id);
//        $this->db->where('account_head.id', $id);

        if ($frmdate != '')
        {
//            $frmdate = $this->db->escape($this->mastermodel->convert_date_format($frmdate));
//            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )>=', $frmdate, false);
        }
        if ($todate != '')
        {
            $todate = $this->db->escape($this->mastermodel->convert_date_format($todate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<=', $todate, false);
        }

//        if ($frmdate != '')
//            $this->db->where('voucher_date >=', $this->mastermodel->convert_date_format($frmdate));
//        if ($todate != '')
//            $this->db->where('voucher_date <=', $this->mastermodel->convert_date_format($todate));
//        $this->db->group_by('account_group.account_group_id', 'desc');
        $this->db->order_by('ledger_book.voucher_date', 'desc');

        $result = $this->db->get()->row();
// );

        if (!empty($result))
        {
            $data = $result->amount;
        } else
        {
            $data = 0;
        }
        return $data;
    }
     function open_deb_cred_balance_by_ledger($data)
    {
        $frmdate = $data['frmdate'];
         $user_branch = $_SESSION['user_branch'];
           $branch = $data['branch'];
        $acc = $data['id'];
        $this->db->select('sum(ledger_book_details.debit) as open_debit,sum(ledger_book_details.credit) as open_credit,account_ledger.opening_balance,account_ledger.ledger_name as name');
        $this->db->from('account_ledger');
        $this->db->join('ledger_book_details', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->where('ledger_book.is_posted', '1');
         $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
        if ($frmdate != '')
        {
            $frmdate = $this->db->escape($this->mastermodel->convert_date_format($frmdate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<', $frmdate, false);
        }

//        if ($frmdate != '')
//            $this->db->where('voucher_date <=', $this->mastermodel->convert_date_format($frmdate));
        $this->db->where('account_ledger.ledger_id', $acc);
//        $this->db->order_by('ledger_id', 'desc');
        $res = $this->db->get();
        return $res->row();
    }
      function get_profit_account_ledger_list($data)
    {
            $user_branch = $_SESSION['user_branch'];
        $frmdate = $data['frmdate'];
        $todate = $data['todate'];
        $id = $data['id'];
          $branch = $data['branch'];
        $this->db->select('account_head.id as main_id,account_group.account_group_id as row_id,account_ledger.ledger_name as name,account_ledger.ledger_id as s_id,sum(ledger_book_details.debit) as debit_val,sum(ledger_book_details.credit) as credit_val,sum(ledger_book_details.debit-ledger_book_details.credit) as amount');
        $this->db->from('account_ledger');
        $this->db->join('ledger_book_details', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->join('account_group', 'account_group.account_group_id=account_ledger.account_group_id');
        $this->db->join('account_head', 'account_head.id=account_group.group_under');
        $this->db->where('ledger_book.is_posted', '1');
        $this->db->where('account_group.account_group_id', $id);
 $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
          
          if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
        if ($frmdate != '')
        {
            $frmdate = $this->db->escape($this->mastermodel->convert_date_format($frmdate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )>=', $frmdate, false);
        }
        if ($todate != '')
        {
            $todate = $this->db->escape($this->mastermodel->convert_date_format($todate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<=', $todate, false);
        }


//        if ($frmdate != '')
//            $this->db->where('voucher_date >=', $this->mastermodel->convert_date_format($frmdate));
//        if ($todate != '')
//            $this->db->where('voucher_date <=', $this->mastermodel->convert_date_format($todate));
        $this->db->group_by('account_ledger.ledger_id');
        $this->db->order_by('ledger_book.voucher_date', 'desc');
        $result = $this->db->get();
//        );
        return $result->result();
    }
    function get_close_accountgroup_amount_by_settings_id($val, $frmdate, $todate,$branch)
    {
         $user_branch = $_SESSION['user_branch'];
        $id = $this->accountingreportmodel->get_report_account_settings($val);
        $ids[] = $id;
        $child_list = $this->accountingreportmodel->get_child_id_list($id);
        foreach ($child_list as $child)
        {
            $ids[] = $child->account_group_id;
//            $subids[] = $child->account_group_id;

            $subchild_list = $this->accountingreportmodel->get_child_id_list($child->account_group_id);
//            $countids = count($subchild_list);
            foreach ($subchild_list as $subchild)
            {

                $ids[] = $subchild->account_group_id;
                $subchild_listone = $this->accountingreportmodel->get_child_id_list($subchild->account_group_id);

                foreach ($subchild_listone as $subchildone)
                {

                    $ids[] = $subchildone->account_group_id;
                    $subchild_listtwo = $this->accountingreportmodel->get_child_id_list($subchildone->account_group_id);
                    foreach ($subchild_listtwo as $subchildtwo)
                    {

                        $ids[] = $subchildtwo->account_group_id;
                    }
                    $subchild_listthree = $this->accountingreportmodel->get_child_id_list($subchildtwo->account_group_id);
                    foreach ($subchild_listthree as $subchildthree)
                    {

                        $ids[] = $subchildthree->account_group_id;
                    }
                }
            }
        }

        $this->db->select('account_head.id as row_id,account_group.account_group_name as name,account_group.account_group_id as account_group_id,sum(ledger_book_details.debit) as debit_val,sum(ledger_book_details.credit) as credit_val,sum(ledger_book_details.debit-ledger_book_details.credit) as amount');
        $this->db->from('account_ledger');
        $this->db->join('ledger_book_details', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->join('account_group', 'account_group.account_group_id=account_ledger.account_group_id');
        $this->db->join('account_head', 'account_head.id=account_group.group_under');
 $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
        $this->db->where('ledger_book.is_posted', '1');

        if ($frmdate != '')
        {
            $frmdate = $this->db->escape($this->mastermodel->convert_date_format($frmdate));
//            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )>=', $frmdate, false);
        }
        if ($todate != '')
        {
            $todate = $this->db->escape($this->mastermodel->convert_date_format($todate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<=', $todate, false);
        }
//        $this->db->where('account_group.account_group_id', $id);
//        $this->db->or_where('account_group.parent', $id,null,false);
        $this->db->where_in('account_ledger.account_group_id', $ids);
//        $this->db->where('if(`parent`!="0",`parent`  ,`account_group`.`account_group_id` )=', $id, false);
//        $this->db->where('if(`parent`="0",`account_group`.`account_group_id`  ,`parent` )<=', $id, false);
//        $this->db->where('account_group.account_group_id ='.$id .' or account_group.parent='.$id .'');
        $this->db->order_by('ledger_book.voucher_date', 'desc');
        $result = $this->db->get();
//         );
        $res = $result->row();
        return $res;
//        if ($res)
//        {
//            return $res->amount;
//        } else
//        {
//            return "";
//        }
    }
      function get_assetamount($frmdate, $todate,$branch)
    {
           $user_branch = $_SESSION['user_branch'];
        $this->db->select('*,sum(ledger_book_details.debit-ledger_book_details.credit) as amount');
//        $this->db->select('sum( case when voucher_date <='.$frmdate. 'then ledger_book_details.debit else 0 end) as open_debit,sum(case when voucher_date <='.$frmdate. 'then ledger_book_details.credit else 0 end) as open_credit');
        $this->db->from('account_ledger');
        $this->db->join('ledger_book_details', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->join('account_group', 'account_group.account_group_id=account_ledger.account_group_id');
        $this->db->join('account_head', 'account_head.id=account_group.group_under');
        $this->db->where('ledger_book.is_posted', '1');
        $this->db->where_in('account_head.id', '1');
         $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
        if ($frmdate != '')
        {
            $frmdate = $this->db->escape($this->mastermodel->convert_date_format($frmdate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )>=', $frmdate, false);
        }
        if ($todate != '')
        {
            $todate = $this->db->escape($this->mastermodel->convert_date_format($todate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<=', $todate, false);
        }

//        if ($frmdate != '')
//            $this->db->where('voucher_date >=', $this->mastermodel->convert_date_format($frmdate));
//        if ($todate != '')
//            $this->db->where('voucher_date <=', $this->mastermodel->convert_date_format($todate));

        $this->db->group_by('account_head.id');
        $this->db->order_by('ledger_book.voucher_date', 'desc');
        $result = $this->db->get();
        //);

        $res = $result->row();
        if ($res)
        {
            return $res->amount;
        } else
        {
            return "";
        }
    }
     function get_liabilityamount($frmdate, $todate,$branch)
    {
         $user_branch = $_SESSION['user_branch'];
        $this->db->select('*,sum(ledger_book_details.debit-ledger_book_details.credit) as amount');
//        $this->db->select('sum( case when voucher_date <='.$frmdate. 'then ledger_book_details.debit else 0 end) as open_debit,sum(case when voucher_date <='.$frmdate. 'then ledger_book_details.credit else 0 end) as open_credit');
        $this->db->from('account_ledger');
        $this->db->join('ledger_book_details', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->join('account_group', 'account_group.account_group_id=account_ledger.account_group_id');
        $this->db->join('account_head', 'account_head.id=account_group.group_under');
        $this->db->where('ledger_book.is_posted', '1');
        $this->db->where_in('account_head.id', '2');
 $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
        if ($frmdate != '')
        {
            $frmdate = $this->db->escape($this->mastermodel->convert_date_format($frmdate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )>=', $frmdate, false);
        }
        if ($todate != '')
        {
            $todate = $this->db->escape($this->mastermodel->convert_date_format($todate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<=', $todate, false);
        }

//        if ($frmdate != '')
//            $this->db->where('voucher_date >=', $this->mastermodel->convert_date_format($frmdate));
//        if ($todate != '')
//            $this->db->where('voucher_date <=', $this->mastermodel->convert_date_format($todate));


        $this->db->group_by('account_head.id');
        $this->db->order_by('ledger_book.voucher_date', 'desc');
        $result = $this->db->get();
        //);

        $res = $result->row();
        if ($res)
        {
            return $res->amount;
        } else
        {
            return "";
        }
    }
    
    function stock_summary_total_prevpurchase($frmdate,$branch)
    {
         $user_branch = $_SESSION['user_branch'];
           if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
        }
        else{
        $query = "master.master_branch_id ='".$branch."'"; 
        }
        $this->db->select('sum(t.tquantity*t.prate) as pamount');
 $this->db->from('(select  sum((pos_purchase_details.quantity*pos_purchase_details.purchase_rate))/sum(pos_purchase_details.quantity*pos_item_master.purchase_unit) AS prate,sum(pos_purchase_details.quantity*pos_item_master.purchase_unit) as tquantity FROM `pos_item_stock` stocks
                            INNER JOIN `pos_purchase_details` ON `pos_purchase_details`.`stock_id` = `stocks`.`stock_id`
                             INNER JOIN `pos_item_batch` ON `pos_item_batch`.`batch_id` = `stocks`.`batch_id`
                            INNER JOIN `pos_item_master` ON `pos_item_master`.`product_id` = `pos_item_batch`.`item_id`
                            INNER JOIN `pos_purchase` ON `pos_purchase_details`.`purchase_id` = `pos_purchase`.`purchase_id`
                            INNER JOIN `pos_purchase_invoice_details` ON `pos_purchase_invoice_details`.`purchase` = `pos_purchase`.`purchase_id`
                            INNER JOIN `pos_purchase_invoice` ON `pos_purchase_invoice_details`.`vendor_invoice` = `pos_purchase_invoice`.`vendor_invoice_id`
                             INNER JOIN `master` ON `master`.`master_id` = `stocks`.`stock_id`
                             WHERE `vendor_invoice_date` < "' . $this->mastermodel->convert_date_format($frmdate) . '" AND "'.$query.'"  group by `stocks`.`stock_id`)t');
  $result = $this->db->get();
//        );
        $res = $result->row();
        if ($res)
        {
            return $res->pamount;
        } else
        {
            return "";
        }
    }
      function stock_purchase_rteurn_prev($frmdate,$branch)
    {
           $user_branch = $_SESSION['user_branch'];
           if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
        }
        else{
        $query = "master.master_branch_id ='".$branch."'"; 
        }
     $this->db->select('*,COALESCE(sum(t.returnquantity*t.prate),"0") as returnamount',FALSE);
        $this->db->from('(select sum((`pos_purchase_details`.`quantity`*`pos_purchase_details`.`purchase_rate`))/sum(`pos_purchase_details`.`quantity`*`pos_item_master`.`purchase_unit`) AS prate,(sum(`pos_purchase_return_details`.`quantity`*`pos_item_master`.`purchase_unit`)) as `returnquantity` FROM `pos_item_stock` stocks
                             INNER JOIN `pos_purchase_details` ON `pos_purchase_details`.`stock_id` = `stocks`.`stock_id`
                             INNER JOIN `pos_item_batch` ON `pos_item_batch`.`batch_id` = `stocks`.`batch_id`
                            INNER JOIN `pos_item_master` ON `pos_item_master`.`product_id` = `pos_item_batch`.`item_id`
                            INNER JOIN `pos_purchase` ON `pos_purchase_details`.`purchase_id` = `pos_purchase`.`purchase_id`
                            INNER JOIN `pos_purchase_invoice_details` ON `pos_purchase_invoice_details`.`purchase` = `pos_purchase`.`purchase_id`
                            INNER JOIN `pos_purchase_invoice` ON `pos_purchase_invoice_details`.`vendor_invoice` = `pos_purchase_invoice`.`vendor_invoice_id`
                 INNER JOIN `pos_purchase_return_details` ON `pos_purchase_return_details`.`purchase_details_id` = `pos_purchase_details`.`purchase_details_id`
                            INNER JOIN `pos_purchase_return` ON `pos_purchase_return`.`purchase_return_id` = `pos_purchase_return_details`.`purchase_return_id`
                               INNER JOIN `master` ON `master`.`master_id` = `stocks`.`stock_id`
                             WHERE `vendor_invoice_date` < "' . $this->mastermodel->convert_date_format($frmdate) . '" AND "'.$query.'"  and `return_date` < "' . $this->mastermodel->convert_date_format($frmdate) . '" group by `stocks`.`stock_id`)t');

        $result = $this->db->get();
        $res = $result->row();
        if ($res)
        {
            return $res->returnamount;
        } else
        {
            return "";
        }
    }
    
    function stock_sales_prev($frmdate,$branch)
    {
        
  $user_branch = $_SESSION['user_branch'];
           if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
        }
        else{
        $query = "master.master_branch_id ='".$branch."'"; 
        }
 $this->db->select('*,COALESCE(sum(t.squantity*t.prate),"0") as samount',FALSE);

        $this->db->from('(select sum((`pos_purchase_details`.`quantity`*`pos_purchase_details`.`purchase_rate`))/sum(`pos_purchase_details`.`quantity`*`pos_item_master`.`purchase_unit`) AS prate,(sum(`pos_sale_details`.`item_qty`*`pos_item_master`.`sale_unit`)) as `squantity` FROM `pos_item_stock` `stocks`
                                     INNER JOIN `pos_purchase_details` ON `pos_purchase_details`.`stock_id` = `stocks`.`stock_id`
                             INNER JOIN `pos_item_batch` ON `pos_item_batch`.`batch_id` = `stocks`.`batch_id`
                            INNER JOIN `pos_item_master` ON `pos_item_master`.`product_id` = `pos_item_batch`.`item_id`
                            INNER JOIN `pos_purchase` ON `pos_purchase_details`.`purchase_id` = `pos_purchase`.`purchase_id`
                            INNER JOIN `pos_purchase_invoice_details` ON `pos_purchase_invoice_details`.`purchase` = `pos_purchase`.`purchase_id`
                            INNER JOIN `pos_purchase_invoice` ON `pos_purchase_invoice_details`.`vendor_invoice` = `pos_purchase_invoice`.`vendor_invoice_id`
                 INNER JOIN `pos_sale_details` ON `pos_sale_details`.`stock_id` = `stocks`.`stock_id`
                            INNER JOIN `pos_sale` ON `pos_sale`.`sale_id` = `pos_sale_details`.`sale_id`
                                INNER JOIN `master` ON `master`.`master_id` = `stocks`.`stock_id`
                             WHERE `vendor_invoice_date` < "' . $this->mastermodel->convert_date_format($frmdate) . '" AND "'.$query.'" and   `pos_sale`.`date` < "' . $this->mastermodel->convert_date_format($frmdate) . '" group by `stocks`.`stock_id`)t');

        $result = $this->db->get();
        $res = $result->row();

        if ($res)
        {
            return $res->samount;
        } else
        {
            return "";
        }
    }
      function stock_sales_return_prev($frmdate,$branch)
    {
           $user_branch = $_SESSION['user_branch'];
           if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
        }
        else{
        $query = "master.master_branch_id ='".$branch."'"; 
        }
         $this->db->select('*,COALESCE(sum(t.squantity*t.prate),"0") as samount',FALSE);

        $this->db->from('(select sum((`pos_purchase_details`.`quantity`*`pos_purchase_details`.`purchase_rate`))/sum(`pos_purchase_details`.`quantity`*`pos_item_master`.`purchase_unit`) AS prate,(sum(`pos_sale_return_details`.`item_qty`*`pos_item_master`.`sale_unit`)) as `squantity` FROM `pos_item_stock` `stocks`
                             INNER JOIN `pos_purchase_details` ON `pos_purchase_details`.`stock_id` = `stocks`.`stock_id`
                             INNER JOIN `pos_item_batch` ON `pos_item_batch`.`batch_id` = `stocks`.`batch_id`
                            INNER JOIN `pos_item_master` ON `pos_item_master`.`product_id` = `pos_item_batch`.`item_id`
                            INNER JOIN `pos_purchase` ON `pos_purchase_details`.`purchase_id` = `pos_purchase`.`purchase_id`
                            INNER JOIN `pos_purchase_invoice_details` ON `pos_purchase_invoice_details`.`purchase` = `pos_purchase`.`purchase_id`
                            INNER JOIN `pos_purchase_invoice` ON `pos_purchase_invoice_details`.`vendor_invoice` = `pos_purchase_invoice`.`vendor_invoice_id`
                 INNER JOIN `pos_sale_details` ON `pos_sale_details`.`stock_id` = `stocks`.`stock_id`
                            INNER JOIN `pos_sale` ON `pos_sale`.`sale_id` = `pos_sale_details`.`sale_id`
                             INNER JOIN `pos_sale_return` ON `pos_sale_return`.`sale_id` = `pos_sale_details`.`sale_id`
                             INNER JOIN `pos_sale_return_details` ON `pos_sale_details`.`details_id` = `pos_sale_return_details`.`sale_return_detailsId`
                                  INNER JOIN `master` ON `master`.`master_id` = `stocks`.`stock_id`
                             WHERE `vendor_invoice_date` < "' . $this->mastermodel->convert_date_format($frmdate) . '" AND "'.$query.'" and `pos_sale_return`.`date` < "' . $this->mastermodel->convert_date_format($frmdate) . '" group by `stocks`.`stock_id`)t');
     
        $result = $this->db->get();
        $res = $result->row();

        if ($res)
        {
            return $res->samount;
        } else
        {
            return "";
        }
    }
     function stock_invoice_sales_prev($frmdate,$branch)
    {
             $user_branch = $_SESSION['user_branch'];
           if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
        }
        else{
        $query = "master.master_branch_id ='".$branch."'"; 
        }
         //                 INNER JOIN `pos_customer_invoice_details` ON `pos_customer_invoice_details`.`stock_id` = `stocks`.`stock_id`
//                            INNER JOIN `invoice` ON `invoice`.`invoice_id` = `invoice_details`.`invoice`
         $this->db->select('*,COALESCE(sum(t.invoicequantity*t.prate),"0") as invoiceamount',FALSE);
        $this->db->from('(select sum((`pos_purchase_details`.`quantity`*`pos_purchase_details`.`purchase_rate`))/sum(`pos_purchase_details`.`quantity`*`pos_item_master`.`purchase_unit`) AS prate,(sum(`pos_sale_details`.`item_qty`*`pos_item_master`.`sale_unit`)) as `invoicequantity` FROM `pos_item_stock` stocks
                                    INNER JOIN `pos_purchase_details` ON `pos_purchase_details`.`stock_id` = `stocks`.`stock_id`
                             INNER JOIN `pos_item_batch` ON `pos_item_batch`.`batch_id` = `stocks`.`batch_id`
                            INNER JOIN `pos_item_master` ON `pos_item_master`.`product_id` = `pos_item_batch`.`item_id`
                            INNER JOIN `pos_purchase` ON `pos_purchase_details`.`purchase_id` = `pos_purchase`.`purchase_id`
                            INNER JOIN `pos_purchase_invoice_details` ON `pos_purchase_invoice_details`.`purchase` = `pos_purchase`.`purchase_id`
                            INNER JOIN `pos_purchase_invoice` ON `pos_purchase_invoice_details`.`vendor_invoice` = `pos_purchase_invoice`.`vendor_invoice_id`
                             INNER JOIN `pos_sale_details` ON `pos_sale_details`.`stock_id` = `stocks`.`stock_id`
                            INNER JOIN `pos_sale` ON `pos_sale`.`sale_id` = `pos_sale_details`.`sale_id`
                                 INNER JOIN `master` ON `master`.`master_id` = `stocks`.`stock_id`
                             WHERE `vendor_invoice_date` < "' . $this->mastermodel->convert_date_format($frmdate) . '" AND "'.$query.'" group by `stocks`.`stock_id`)t');

        $result = $this->db->get();
        $res = $result->row();
        if ($res)
        {
            return $res->invoiceamount;
        } else
        {
            return "";
        }
    }
       function stock_invoice_sales_current($todate,$branch)
    {
             $user_branch = $_SESSION['user_branch'];
           if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
        }
        else{
        $query = "master.master_branch_id ='".$branch."'"; 
        }
//              INNER JOIN `invoice_details` ON `invoice_details`.`stock_id` = `stocks`.`stock_id`
//                            INNER JOIN `invoice` ON `invoice`.`invoice_id` = `invoice_details`.`invoice`
//           and `invoice_date` <= "' . $this->mastermodel->convert_date_format($todate) . '"
         $this->db->select('*,COALESCE(sum(t.invoicequantity*t.prate),"0") as invoiceamount',FALSE);
        $this->db->from('(select sum((`pos_purchase_details`.`quantity`*`pos_purchase_details`.`purchase_rate`))/sum(`pos_purchase_details`.`quantity`*`pos_item_master`.`purchase_unit`) AS prate,(sum(`pos_sale_details`.`item_qty`*`pos_item_master`.`sale_unit`)) as `invoicequantity` FROM `pos_item_stock` stocks
                                  INNER JOIN `pos_purchase_details` ON `pos_purchase_details`.`stock_id` = `stocks`.`stock_id`
                             INNER JOIN `pos_item_batch` ON `pos_item_batch`.`batch_id` = `stocks`.`batch_id`
                            INNER JOIN `pos_item_master` ON `pos_item_master`.`product_id` = `pos_item_batch`.`item_id`
                            INNER JOIN `pos_purchase` ON `pos_purchase_details`.`purchase_id` = `pos_purchase`.`purchase_id`
                            INNER JOIN `pos_purchase_invoice_details` ON `pos_purchase_invoice_details`.`purchase` = `pos_purchase`.`purchase_id`
                            INNER JOIN `pos_purchase_invoice` ON `pos_purchase_invoice_details`.`vendor_invoice` = `pos_purchase_invoice`.`vendor_invoice_id`
                             INNER JOIN `pos_sale_details` ON `pos_sale_details`.`stock_id` = `stocks`.`stock_id`
                            INNER JOIN `pos_sale` ON `pos_sale`.`sale_id` = `pos_sale_details`.`sale_id`
                            
                             WHERE `vendor_invoice_date` < "' . $this->mastermodel->convert_date_format($todate) . '" AND "'.$query.'"  group by `stocks`.`stock_id`)t');

        $result = $this->db->get();
        $res = $result->row();
        if ($res)
        {
            return $res->invoiceamount;
        } else
        {
            return "";
        }
    }
      function stock_summary_total_purchase_current($todate,$branch)
    {
           $user_branch = $_SESSION['user_branch'];
           if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
        }
        else{
        $query = "master.master_branch_id ='".$branch."'"; 
        }
        $this->db->select('sum(t.tquantity*t.prate) as pamount',FALSE);
        $this->db->from('(select sum((pos_purchase_details.quantity*pos_purchase_details.purchase_rate))/sum(pos_purchase_details.quantity*pos_item_master.purchase_unit) AS prate,sum(pos_purchase_details.quantity*pos_item_master.purchase_unit) as tquantity FROM `pos_item_stock` stocks
                         INNER JOIN `pos_purchase_details` ON `pos_purchase_details`.`stock_id` = `stocks`.`stock_id`
                             INNER JOIN `pos_item_batch` ON `pos_item_batch`.`batch_id` = `stocks`.`batch_id`
                            INNER JOIN `pos_item_master` ON `pos_item_master`.`product_id` = `pos_item_batch`.`item_id`
                            INNER JOIN `pos_purchase` ON `pos_purchase_details`.`purchase_id` = `pos_purchase`.`purchase_id`
                            INNER JOIN `pos_purchase_invoice_details` ON `pos_purchase_invoice_details`.`purchase` = `pos_purchase`.`purchase_id`
                            INNER JOIN `pos_purchase_invoice` ON `pos_purchase_invoice_details`.`vendor_invoice` = `pos_purchase_invoice`.`vendor_invoice_id`
                             WHERE `vendor_invoice_date` < "' . $this->mastermodel->convert_date_format($todate) . '" AND "'.$query.'" group by `stocks`.`stock_id`)t');

        $result = $this->db->get();
        $res = $result->row();
        if ($res)
        {
            return $res->pamount;
        } else
        {
            return "";
        }
    }
       function stock_purchase_rteurn_current($todate,$branch)
    {
             $user_branch = $_SESSION['user_branch'];
           if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
        }
        else{
        $query = "master.master_branch_id ='".$branch."'"; 
        }
         $this->db->select('*,COALESCE(sum(t.returnquantity*t.prate),"0") as returnamount',FALSE);
        $this->db->from('(select sum((`pos_purchase_details`.`quantity`*`pos_purchase_details`.`purchase_rate`))/sum(`pos_purchase_details`.`quantity`*`pos_item_master`.`purchase_unit`) AS prate,(sum(`pos_purchase_return_details`.`quantity`*`pos_item_master`.`purchase_unit`)) as `returnquantity` FROM `pos_item_stock` stocks
                             INNER JOIN `pos_purchase_details` ON `pos_purchase_details`.`stock_id` = `stocks`.`stock_id`
                             INNER JOIN `pos_item_batch` ON `pos_item_batch`.`batch_id` = `stocks`.`batch_id`
                            INNER JOIN `pos_item_master` ON `pos_item_master`.`product_id` = `pos_item_batch`.`item_id`
                            INNER JOIN `pos_purchase` ON `pos_purchase_details`.`purchase_id` = `pos_purchase`.`purchase_id`
                            INNER JOIN `pos_purchase_invoice_details` ON `pos_purchase_invoice_details`.`purchase` = `pos_purchase`.`purchase_id`
                            INNER JOIN `pos_purchase_invoice` ON `pos_purchase_invoice_details`.`vendor_invoice` = `pos_purchase_invoice`.`vendor_invoice_id`
                 INNER JOIN `pos_purchase_return_details` ON `pos_purchase_return_details`.`purchase_details_id` = `pos_purchase_details`.`purchase_details_id`
                            INNER JOIN `pos_purchase_return` ON `pos_purchase_return`.`purchase_return_id` = `pos_purchase_return_details`.`purchase_return_id`
                            WHERE `vendor_invoice_date` < "' . $this->mastermodel->convert_date_format($todate) . '" AND "'.$query.'" and `return_date` <= "' . $this->mastermodel->convert_date_format($todate) . '" group by `stocks`.`stock_id`)t');

        $result = $this->db->get();
        $res = $result->row();
        if ($res)
        {
            return $res->returnamount;
        } else
        {
            return "";
        }
    }
     function stock_sales_current($todate,$branch)
    {
          $user_branch = $_SESSION['user_branch'];
           if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
        }
        else{
        $query = "master.master_branch_id ='".$branch."'"; 
        }
         $this->db->select('*,COALESCE(sum(t.squantity*t.prate),"0") as samount',FALSE);
        $this->db->from('(select sum((`pos_purchase_details`.`quantity`*`pos_purchase_details`.`purchase_rate`))/sum(`pos_purchase_details`.`quantity`*`pos_item_master`.`purchase_unit`) AS prate,(sum(`pos_sale_details`.`item_qty`*`pos_item_master`.`sale_unit`)) as `squantity` FROM `pos_item_stock` `stocks`
                            INNER JOIN `pos_purchase_details` ON `pos_purchase_details`.`stock_id` = `stocks`.`stock_id`
                             INNER JOIN `pos_item_batch` ON `pos_item_batch`.`batch_id` = `stocks`.`batch_id`
                            INNER JOIN `pos_item_master` ON `pos_item_master`.`product_id` = `pos_item_batch`.`item_id`
                            INNER JOIN `pos_purchase` ON `pos_purchase_details`.`purchase_id` = `pos_purchase`.`purchase_id`
                            INNER JOIN `pos_purchase_invoice_details` ON `pos_purchase_invoice_details`.`purchase` = `pos_purchase`.`purchase_id`
                            INNER JOIN `pos_purchase_invoice` ON `pos_purchase_invoice_details`.`vendor_invoice` = `pos_purchase_invoice`.`vendor_invoice_id`
                 INNER JOIN `pos_sale_details` ON `pos_sale_details`.`stock_id` = `stocks`.`stock_id`
                            INNER JOIN `pos_sale` ON `pos_sale`.`sale_id` = `pos_sale_details`.`sale_id`
                             WHERE `vendor_invoice_date` < "' . $this->mastermodel->convert_date_format($todate) . '" AND "'.$query.'"  and `pos_sale`.`date` < "' . $this->mastermodel->convert_date_format($todate) . '" group by `stocks`.`stock_id`)t');

        $result = $this->db->get();
        $res = $result->row();

        if ($res)
        {
            return $res->samount;
        } else
        {
            return "";
        }
    }
        function stock_sales_return_current($todate,$branch)
    {
             $user_branch = $_SESSION['user_branch'];
           if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
        }
        else{
        $query = "master.master_branch_id ='".$branch."'"; 
        }
          $this->db->select('*,COALESCE(sum(t.squantity*t.prate),"0") as samount',FALSE);
        $this->db->from('(select sum((`pos_purchase_details`.`quantity`*`pos_purchase_details`.`purchase_rate`))/sum(`pos_purchase_details`.`quantity`*`pos_item_master`.`purchase_unit`) AS prate,(sum(`pos_sale_return_details`.`item_qty`*`pos_item_master`.`sale_unit`)) as `squantity` FROM `pos_item_stock` `stocks`
                             INNER JOIN `pos_purchase_details` ON `pos_purchase_details`.`stock_id` = `stocks`.`stock_id`
                             INNER JOIN `pos_item_batch` ON `pos_item_batch`.`batch_id` = `stocks`.`batch_id`
                            INNER JOIN `pos_item_master` ON `pos_item_master`.`product_id` = `pos_item_batch`.`item_id`
                            INNER JOIN `pos_purchase` ON `pos_purchase_details`.`purchase_id` = `pos_purchase`.`purchase_id`
                            INNER JOIN `pos_purchase_invoice_details` ON `pos_purchase_invoice_details`.`purchase` = `pos_purchase`.`purchase_id`
                            INNER JOIN `pos_purchase_invoice` ON `pos_purchase_invoice_details`.`vendor_invoice` = `pos_purchase_invoice`.`vendor_invoice_id`
                 INNER JOIN `pos_sale_details` ON `pos_sale_details`.`stock_id` = `stocks`.`stock_id`
                            INNER JOIN `pos_sale` ON `pos_sale`.`sale_id` = `pos_sale_details`.`sale_id`
                             INNER JOIN `pos_sale_return` ON `pos_sale_return`.`sale_id` = `pos_sale_details`.`sale_id`
                             INNER JOIN `pos_sale_return_details` ON `pos_sale_details`.`details_id` = `pos_sale_return_details`.`sale_return_detailsId`
                             WHERE `vendor_invoice_date` < "' . $this->mastermodel->convert_date_format($todate) . '" AND "'.$query.'"  and `pos_sale_return`.`date` < "' . $this->mastermodel->convert_date_format($todate) . '" group by `stocks`.`stock_id`)t');
//      
        $result = $this->db->get();
        $res = $result->row();
//        );
        if ($res)
        {
            return $res->samount;
        } else
        {
            return "";
        }
    }
    
    
    function get_incomeamount($frmdate, $todate,$branch)
    {
         $user_branch = $_SESSION['user_branch'];
        $this->db->select('*,sum(ledger_book_details.debit-ledger_book_details.credit) as amount');
          $this->db->from('account_ledger');
        $this->db->join('ledger_book_details', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->join('account_group', 'account_group.account_group_id=account_ledger.account_group_id');
        $this->db->join('account_head', 'account_head.id=account_group.group_under');
        $this->db->where('ledger_book.is_posted', '1');
        $this->db->where_in('account_head.id', '4');
 $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
         if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
        if ($frmdate != '')
        {
            $frmdate = $this->db->escape($this->mastermodel->convert_date_format($frmdate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )>=', $frmdate, false);
        }
        if ($todate != '')
        {
            $todate = $this->db->escape($this->mastermodel->convert_date_format($todate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<=', $todate, false);
        }


        $this->db->group_by('account_head.id');
        $this->db->order_by('ledger_book.voucher_date', 'desc');
        $result = $this->db->get();
    

        $res = $result->row();
        if ($res)
        {
            return $res->amount;
        } else
        {
            return "";
        }
    }

    function get_expensesamount($frmdate, $todate,$branch)
    {
         $user_branch = $_SESSION['user_branch'];
        $this->db->select('*,sum(ledger_book_details.debit-ledger_book_details.credit) as amount');
//        $this->db->select('sum( case when voucher_date <='.$frmdate. 'then ledger_book_details.debit else 0 end) as open_debit,sum(case when voucher_date <='.$frmdate. 'then ledger_book_details.credit else 0 end) as open_credit');
        $this->db->from('account_ledger');
        $this->db->join('ledger_book_details', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->join('account_group', 'account_group.account_group_id=account_ledger.account_group_id');
        $this->db->join('account_head', 'account_head.id=account_group.group_under');
        $this->db->where('ledger_book.is_posted', '1');
        $this->db->where_in('account_group.group_under', '3');
 $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
         if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
        if ($frmdate != '')
        {
            $frmdate = $this->db->escape($this->mastermodel->convert_date_format($frmdate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )>=', $frmdate, false);
        }
        if ($todate != '')
        {
            $todate = $this->db->escape($this->mastermodel->convert_date_format($todate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<=', $todate, false);
        }

//        if ($frmdate != '')
//            $this->db->where('voucher_date >=', $this->mastermodel->convert_date_format($frmdate));
//        if ($todate != '')
//            $this->db->where('voucher_date <=', $this->mastermodel->convert_date_format($todate));


        $this->db->group_by('account_head.id');
        $this->db->order_by('ledger_book.voucher_date', 'desc');
        $result = $this->db->get();
//        );

        $res = $result->row();
        if ($res)
        {
            return $res->amount;
        } else
        {
            return "";
        }
    }
      function stock_receiving_current($todate,$branch)
    {
          
          
          
          
//        $this->db->select('sum(receiving_adding_details.total) as receivingamount');
//        $this->db->from('receiving_adding_details');
//        $this->db->join('receiving_adding_stock', 'receiving_adding_stock.receiving_adding_stock_id=receiving_adding_details.stock_management', 'left');
//        $this->db->join('commodity_master', 'commodity_master.commodity_master_id=receiving_adding_details.item');
//        $this->db->order_by('receiving_adding_details.receiving_adding_details_id', 'desc');
//        $this->db->order_by('receiving_adding_stock.receiving_adding_stock_id', 'desc');
//        $this->db->where('po_date <=', $this->mastermodel->convert_date_format($todate));
//        $result = $this->db->get();
//        $res = $result->row();
//        if ($res)
//        {
//            return $res->receivingamount;
//        } else
//        {
//            return "";
//        }
          
           $user_branch = $_SESSION['user_branch'];
           if($_SESSION['project_id']==3){
             
        
        $this->db->select('sum(con_purchase_details.total) as receivingamount');
        $this->db->from('con_purchase_details');
        $this->db->join('con_purchase', 'con_purchase.con_purchase_id=con_purchase_details.con_purchase_id', 'left');
       $this->db->join('item_master', 'item_master.item_master_id=con_purchase_details.item');
         $this->db->order_by('con_purchase_details.con_purchase_details_id', 'desc');
        $this->db->order_by('con_purchase.con_purchase_id', 'desc');
        $this->db->where('po_date <=', $this->mastermodel->convert_date_format($frmdate));
         $this->db->join('master', 'master.master_id=con_purchase_details.con_purchase_details_id');
         if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
        $result = $this->db->get();
        $res = $result->row();
        if ($res)
        {
            return $res->receivingamount;
        } else
        {
            return "";
        }
         }
         if($_SESSION['project_id']==2){
             
        
        $this->db->select('sum(prop_sub_purchase_item.prop_sub_purchase_item_total_amount) as receivingamount');
        $this->db->from('prop_sub_purchase_item');
        $this->db->join('prop_purchase_item', 'prop_purchase_item.prop_purchase_item_id=prop_sub_purchase_item.prop_sub_purchase_item_purchase_item_id', 'left');
        $this->db->join('item_master', 'item_master.item_master_id=prop_sub_purchase_item.prop_sub_purchase_item_item_id');
        $this->db->order_by('prop_sub_purchase_item.prop_sub_purchase_item_id', 'desc');
        $this->db->order_by('prop_purchase_item.prop_purchase_item_id', 'desc');
        $this->db->where('prop_purchase_item_date <=', $this->mastermodel->convert_date_format($frmdate));
          $this->db->join('master', 'master.master_id=prop_sub_purchase_item.prop_sub_purchase_item_id');
         if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
        $result = $this->db->get();
        $res = $result->row();
        if ($res)
        {
            return $res->receivingamount;
        } else
        {
            return "";
        }
         }
          if($_SESSION['project_id']==4){
             
        
        $this->db->select('sum(pos_purchase_details.amount) as receivingamount');
        $this->db->from('pos_purchase_details');
        $this->db->join('pos_purchase', 'pos_purchase.purchase_id=pos_purchase_details.purchase_id', 'left');
        $this->db->join('pos_item_master', 'pos_item_master.product_id=pos_purchase_details.product_master');
        $this->db->order_by('pos_purchase_details.purchase_details_id', 'desc');
        $this->db->order_by('pos_purchase.purchase_id', 'desc');
        $this->db->where('purchase_date <=', $this->mastermodel->convert_date_format($frmdate));
         $this->db->join('master', 'master.master_id=pos_purchase_details.purchase_details_id');
         if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
        $result = $this->db->get();
        $res = $result->row();
        if ($res)
        {
            return $res->receivingamount;
        } else
        {
            return "";
        }
         }
    }
    
    function stock_allocation_current($todate,$branch)
    {
//        $this->db->select('COALESCE(sum(transfer_total),"0") as transferamount');
//        $this->db->from('item_transfer_details');
//        $this->db->join('item_transfer_to_site', 'item_transfer_details.item_transfer_to_site=item_transfer_to_site.item_transfer_to_site_id');
//        $this->db->join('commodity_master', 'commodity_master.commodity_master_id=item_transfer_details.transfer_item');
//        $this->db->where('transfer_date <=', $this->mastermodel->convert_date_format($todate));
//        $result = $this->db->get();
//        $res = $result->row();
//        if ($res)
//        {
//            return $res->transferamount;
//        } else
//        {
//            return "";
//        }
    }
    
     function get_current_stock_in_construction($date,$branch)
    {
         
         
         
         
//        $this->db->select('sum(closing_amount) as currentstock');
//
//        $this->db->from('construction_stock ');
//        $this->db->join('(select max(date) as TopDate,construction_stock_id as stock_id   FROM `construction_stock` construction_stocks where date <="' . $this->mastermodel->convert_date_format($date) . '" GROUP BY `construction_stocks`.`commodity_id`
//                            
//                               )as EachItem', '`EachItem`.`TopDate` = `construction_stock`.`date`  and `EachItem`.`stock_id` = `construction_stock`.`construction_stock_id`', 'inner');
//
//
//        $data = $this->db->get()->row();
//        if (!empty($data))
//        {
//            $result = $data->currentstock;
//        } else
//        {
//            $result = 0;
//        }
//        return $result;
         
          $user_branch = $_SESSION['user_branch'];
           if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
        }
        else{
        $query = "master.master_branch_id ='".$branch."'"; 
        }
            $this->db->select('sum(price * prop_item_stock_qty)  as openingstock');
        $this->db->from('prop_item_stock ');

        $this->db->join('(select max(stock_date) as TopDate,prop_item_stock_id as stock_id   FROM prop_item_stock construction_stocks JOIN master ON master.master_id=construction_stocks.prop_item_stock_id where stock_date <="' . $this->mastermodel->convert_date_format($date) . '" AND master.project_id = "'.$_SESSION['project_id'].'"  AND "'.$query.'" GROUP BY construction_stocks.prop_item_id)as EachItem', 'EachItem.TopDate = prop_item_stock.stock_date  and EachItem.stock_id = prop_item_stock.prop_item_stock_id', 'inner');
         $this->db->join('master', 'master.master_id=prop_item_stock.prop_item_stock_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
          if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
        $data = $this->db->get()->row();
        if (!empty($data))
        {
            $result = $data->openingstock;
        } else
        {
            $result = 0;
        }
        return $result;
    }
       function closing_balnce($acc, $frmdate,$branch)
    {
            $user_branch = $_SESSION['user_branch'];
        $this->db->select('sum(ledger_book_details.debit-ledger_book_details.credit) as open_balance,sum(ledger_book_details.debit) as open_debit,sum(ledger_book_details.credit) as open_credit,account_ledger.opening_balance');
        $this->db->from('account_ledger');
        $this->db->join('ledger_book_details', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->join('account_group', 'account_group.account_group_id=account_ledger.account_group_id');
        $this->db->where('ledger_book.is_posted', '1');
         $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
          if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
        if ($frmdate != '')
        {
            $frmdate = $this->db->escape($this->mastermodel->convert_date_format($frmdate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<', $frmdate, false);
        }

//        if ($frmdate != '')
//            $this->db->where('voucher_date <=', $this->mastermodel->convert_date_format($frmdate));
        $this->db->where('account_group.group_under', $acc);
//        $this->db->order_by('ledger_id', 'desc');
        $res = $this->db->get();
        return $res->row();
    }
      function get_current_accountgroupamount_by_settings_id($val, $frmdate, $todate,$branch)
    {
             $user_branch = $_SESSION['user_branch'];
        $id = $this->accountingreportmodel->get_report_account_settings($val);
        $ids[] = $id;
        $child_list = $this->accountingreportmodel->get_child_id_list($id);
        foreach ($child_list as $child)
        {
            $ids[] = $child->account_group_id;
//            $subids[] = $child->account_group_id;

            $subchild_list = $this->accountingreportmodel->get_child_id_list($child->account_group_id);
//            $countids = count($subchild_list);
            foreach ($subchild_list as $subchild)
            {

                $ids[] = $subchild->account_group_id;
                $subchild_listone = $this->accountingreportmodel->get_child_id_list($subchild->account_group_id);

                foreach ($subchild_listone as $subchildone)
                {

                    $ids[] = $subchildone->account_group_id;
                    $subchild_listtwo = $this->accountingreportmodel->get_child_id_list($subchildone->account_group_id);
                    foreach ($subchild_listtwo as $subchildtwo)
                    {

                        $ids[] = $subchildtwo->account_group_id;
                    }
                    $subchild_listthree = $this->accountingreportmodel->get_child_id_list($subchildtwo->account_group_id);
                    foreach ($subchild_listthree as $subchildthree)
                    {

                        $ids[] = $subchildthree->account_group_id;
                    }
                }
            }
        }
//       
        $this->db->select('account_head.id as row_id,account_group.account_group_name as name,account_group.account_group_id as account_group_id,sum(ledger_book_details.debit) as debit_val,sum(ledger_book_details.credit) as credit_val,sum(ledger_book_details.debit-ledger_book_details.credit) as amount');
        $this->db->from('account_ledger');
        $this->db->join('ledger_book_details', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->join('account_group', 'account_group.account_group_id=account_ledger.account_group_id');
        $this->db->join('account_head', 'account_head.id=account_group.group_under');
 $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->where('ledger_book.is_posted', '1');
         if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
        if ($frmdate != '')
        {
            $frmdate = $this->db->escape($this->mastermodel->convert_date_format($frmdate));
//            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )>=', $frmdate, false);
        }
        if ($todate != '')
        {
            $todate = $this->db->escape($this->mastermodel->convert_date_format($todate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<=', $todate, false);
        }
//        $this->db->where('if(`parent`!="0",`parent`  ,`account_group`.`account_group_id` )=', $id, false);
        $this->db->where_in('account_ledger.account_group_id', $ids);
//        $this->db->where('account_group.account_group_id', $id);
//        $this->db->or_where('account_group.parent', $id,null,false);
        $this->db->order_by('ledger_book.voucher_date', 'desc');
        $result = $this->db->get();
//         );
        $res = $result->row();
//         return $res;
        if ($res)
        {
            return $res->amount;
        } else
        {
            return 0;
        }
    }
     function get_accountgroupamount_by_settings_id($val, $frmdate, $todate,$branch)
    {
           $user_branch = $_SESSION['user_branch'];
        $id = $this->accountingreportmodel->get_report_account_settings($val);
        $this->db->select('account_head.id as row_id,account_group.account_group_name as name,account_group.account_group_id as account_group_id,sum(ledger_book_details.debit) as debit_val,sum(ledger_book_details.credit) as credit_val,sum(ledger_book_details.debit-ledger_book_details.credit) as amount');
        $this->db->from('account_ledger');
        $this->db->join('ledger_book_details', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->join('account_group', 'account_group.account_group_id=account_ledger.account_group_id');
        $this->db->join('account_head', 'account_head.id=account_group.group_under');
 $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->where('ledger_book.is_posted', '1');
          if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
        if ($frmdate != '')
        {
            $frmdate = $this->db->escape($this->mastermodel->convert_date_format($frmdate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )>=', $frmdate, false);
        }
        if ($todate != '')
        {
            $todate = $this->db->escape($this->mastermodel->convert_date_format($todate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<=', $todate, false);
        }
        $this->db->where('if(`parent`!="0",`parent`  ,`account_group`.`account_group_id` )=', $id, false);
//        $this->db->where('if(`parent`="0",`account_group`.`account_group_id`  ,`parent` )<=', $id, false);
//        $this->db->where('account_group.account_group_id', $id);
//        $this->db->or_where('account_group.parent', $id,null,false);
        $this->db->order_by('ledger_book.voucher_date', 'desc');
        $result = $this->db->get();
//         );
        $res = $result->row();
//         return $res;
        if ($res)
        {
            return $res->amount;
        } else
        {
            return 0;
        }
    }
      function balance_sheet($data)
    {
        $output = $this->mastermodel->save_user_activities( 'View- Balance Report', '0', 'Report');
        $frmdate = $data['frmdate'];
        $todate = $data['todate'];
        $branch =  $data['branch'];
         $user_branch = $_SESSION['user_branch'];
        $this->db->select('*,sum(ledger_book_details.debit-ledger_book_details.credit) as amount,account_head.id as account_head_id');
        $this->db->from('account_ledger');
        $this->db->join('ledger_book_details', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->join('account_group', 'account_group.account_group_id=account_ledger.account_group_id');
        $this->db->join('account_head', 'account_head.id=account_group.group_under');
        $this->db->join('master', 'master.master_id=ledger_book.ledger_book_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        
        $this->db->where('ledger_book.is_posted', '1');
        $this->db->where('account_group.group_under = 1 OR account_group.group_under = 2');

        if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
        if ($frmdate != '')
        {
            $frmdate = $this->db->escape($this->mastermodel->convert_date_format($frmdate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )>=', $frmdate, false);
        }
        if ($todate != '')
        {
            $todate = $this->db->escape($this->mastermodel->convert_date_format($todate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<=', $todate, false);
        }


//        if ($frmdate != '')
//            $this->db->where('voucher_date >=', $this->mastermodel->convert_date_format($frmdate));
//        if ($todate != '')
//            $this->db->where('voucher_date <=', $this->mastermodel->convert_date_format($todate));
        $this->db->group_by('account_head.id', 'desc');
        $this->db->order_by('ledger_book.voucher_date', 'desc');
        $result = $this->db->get();

        return $result->result();
    }
    function get_prev_accountgroupamount_by_settings_id($val, $frmdate, $todate,$branch)
    {
         $user_branch = $_SESSION['user_branch'];
        $id = $this->accountingreportmodel->get_report_account_settings($val);
        $this->db->select('account_head.id as row_id,account_group.account_group_name as name,account_group.account_group_id as account_group_id,sum(ledger_book_details.debit) as debit_val,sum(ledger_book_details.credit) as credit_val,sum(ledger_book_details.debit-ledger_book_details.credit) as amount');
        $this->db->from('account_ledger');
        $this->db->join('ledger_book_details', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->join('account_group', 'account_group.account_group_id=account_ledger.account_group_id');
        $this->db->join('account_head', 'account_head.id=account_group.group_under');
 $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->where('ledger_book.is_posted', '1');
         if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
        if ($frmdate != '')
        {
            $frmdate = $this->db->escape($this->mastermodel->convert_date_format($frmdate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<', $frmdate, false);
        }
        if ($todate != '')
        {
            $todate = $this->db->escape($this->mastermodel->convert_date_format($todate));
//            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<=', $todate, false);
        }
        $this->db->where('if(`parent`!="0",`parent`  ,`account_group`.`account_group_id` )=', $id, false);
//        $this->db->where('if(`parent`="0",`account_group`.`account_group_id`  ,`parent` )<=', $id, false);
//        $this->db->where('account_group.account_group_id', $id);
//        $this->db->or_where('account_group.parent', $id,null,false);
        $this->db->order_by('ledger_book.voucher_date', 'desc');
        $result = $this->db->get();
//         );
        $res = $result->row();
//         return $res;
        if ($res)
        {
            return $res->amount;
        } else
        {
            return 0;
        }
    }
      function closing_balnce_group($acc, $frmdate,$branch)
    {
           $user_branch = $_SESSION['user_branch'];
        $this->db->select('sum(ledger_book_details.debit-ledger_book_details.credit) as open_balance,sum(ledger_book_details.debit) as open_debit,sum(ledger_book_details.credit) as open_credit,account_ledger.opening_balance');
        $this->db->from('account_ledger');
        $this->db->join('ledger_book_details', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->join('account_group', 'account_group.account_group_id=account_ledger.account_group_id');
        $this->db->where('ledger_book.is_posted', '1');
         $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
         if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
        if ($frmdate != '')
        {
//            $frmdate = $this->db->escape($this->mastermodel->convert_date_format($frmdate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<', $frmdate, false);
        }

//        if ($frmdate != '')
//            $this->db->where('voucher_date <=', $this->mastermodel->convert_date_format($frmdate));
        $this->db->where('account_ledger.account_group_id', $acc);
//        $this->db->order_by('ledger_id', 'desc');
        $res = $this->db->get();
        return $res->row();
    }
     function get_balancesheet_account_group_list_by_parent($data)
    {
        $frmdate = $data['frmdate'];
        $todate = $data['todate'];
        $branch = $data['branch'];
        $id = $data['id'];
        $user_branch = $_SESSION['user_branch'];
        $this->db->select('account_group.parent as parentid,account_head.id as row_id,account_group.account_group_name as name,account_group.account_group_id as account_group_id,sum(ledger_book_details.debit) as debit_val,sum(ledger_book_details.credit) as credit_val,sum(ledger_book_details.debit-ledger_book_details.credit) as amount');
        $this->db->from('account_ledger');
        $this->db->join('ledger_book_details', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->join('account_group', 'account_group.account_group_id=account_ledger.account_group_id');
        $this->db->join('account_head', 'account_head.id=account_group.group_under');
        $this->db->where('ledger_book.is_posted', '1');
        $this->db->where('account_group.parent', $id);
         $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
         if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
//        $this->db->where('account_head.id', $id);

        if ($frmdate != '')
        {
//            $frmdate = $this->db->escape($this->mastermodel->convert_date_format($frmdate));
//            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )>=', $frmdate, false);
        }
        if ($todate != '')
        {
            $todate = $this->db->escape($this->mastermodel->convert_date_format($todate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<=', $todate, false);
        }

//        if ($frmdate != '')
//            $this->db->where('voucher_date >=', $this->mastermodel->convert_date_format($frmdate));
//        if ($todate != '')
//            $this->db->where('voucher_date <=', $this->mastermodel->convert_date_format($todate));
        $this->db->group_by('account_group.account_group_id', 'desc');
        $this->db->order_by('ledger_book.voucher_date', 'desc');
        $result = $this->db->get();

        return $result->result();
    }
     function get_accountgroup_amount_by_settings_id($val, $frmdate, $todate,$branch)
    {
         $user_branch = $_SESSION['user_branch'];
        $id = $this->accountingreportmodel->get_report_account_settings($val);
        $ids[] = $id;
        $child_list = $this->accountingreportmodel->get_child_id_list($id);
        foreach ($child_list as $child)
        {
            $ids[] = $child->account_group_id;
//            $subids[] = $child->account_group_id;

            $subchild_list = $this->accountingreportmodel->get_child_id_list($child->account_group_id);
//            $countids = count($subchild_list);
            foreach ($subchild_list as $subchild)
            {

                $ids[] = $subchild->account_group_id;
                $subchild_listone = $this->accountingreportmodel->get_child_id_list($subchild->account_group_id);

                foreach ($subchild_listone as $subchildone)
                {

                    $ids[] = $subchildone->account_group_id;
                    $subchild_listtwo = $this->accountingreportmodel->get_child_id_list($subchildone->account_group_id);
                    foreach ($subchild_listtwo as $subchildtwo)
                    {

                        $ids[] = $subchildtwo->account_group_id;
                    }
                    $subchild_listthree = $this->accountingreportmodel->get_child_id_list($subchildtwo->account_group_id);
                    foreach ($subchild_listthree as $subchildthree)
                    {

                        $ids[] = $subchildthree->account_group_id;
                    }
                }
            }
        }
        $this->db->select('account_head.id as row_id,account_group.account_group_name as name,account_group.account_group_id as account_group_id,sum(ledger_book_details.debit) as debit_val,sum(ledger_book_details.credit) as credit_val,sum(ledger_book_details.debit-ledger_book_details.credit) as amount');
        $this->db->from('account_ledger');
        $this->db->join('ledger_book_details', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->join('account_group', 'account_group.account_group_id=account_ledger.account_group_id');
        $this->db->join('account_head', 'account_head.id=account_group.group_under');

        $this->db->where('ledger_book.is_posted', '1');
 $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
          if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
        if ($frmdate != '')
        {
            $frmdate = $this->db->escape($this->mastermodel->convert_date_format($frmdate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )>=', $frmdate, false);
        }
        if ($todate != '')
        {
            $todate = $this->db->escape($this->mastermodel->convert_date_format($todate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<=', $todate, false);
        }
        $this->db->where_in('account_ledger.account_group_id', $ids);
        $this->db->order_by('ledger_book.voucher_date', 'desc');
        $result = $this->db->get();
//         );
        $res = $result->row();
        return $res;
//        if ($res)
//        {
//            return $res->amount;
//        } else
//        {
//            return "";
//        }
    }
        function get_balancesheet_parentaccount_group_list($data)
    {
        $frmdate = $data['frmdate'];
        $todate = $data['todate'];
        $branch = $data['branch'];
        $id = $data['id'];
        $user_branch = $_SESSION['user_branch'];


        $this->db->select('account_head.id as row_id,account_group.account_group_name as name,account_group.account_group_id as account_group_id,sum(ledger_book_details.debit) as debit_val,sum(ledger_book_details.credit) as credit_val,sum(ledger_book_details.debit-ledger_book_details.credit) as amount');
        $this->db->from('account_ledger');
        $this->db->join('ledger_book_details', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->join('account_group', 'account_group.account_group_id=account_ledger.account_group_id');
        $this->db->join('account_head', 'account_head.id=account_group.group_under');
        $this->db->join('master', 'master.master_id=ledger_book.ledger_book_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
         if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
        $this->db->where('ledger_book.is_posted', '1');
        $this->db->where('account_head.id', $id);
        $this->db->where('account_group.parent', 0);

        if ($frmdate != '')
        {
            $frmdate = $this->db->escape($this->mastermodel->convert_date_format($frmdate));
//            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )>=', $frmdate, false);
        }
        if ($todate != '')
        {
            $todate = $this->db->escape($this->mastermodel->convert_date_format($todate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<=', $todate, false);
        }

//        if ($frmdate != '')
//            $this->db->where('voucher_date >=', $this->mastermodel->convert_date_format($frmdate));
//        if ($todate != '')
//            $this->db->where('voucher_date <=', $this->mastermodel->convert_date_format($todate));
        $this->db->group_by('account_group.account_group_id', 'desc');
        $this->db->order_by('ledger_book.voucher_date', 'desc');
        $result = $this->db->get();

        return $result->result();
    }
       function get_expensesamount_open($frmdate, $todate,$branch)
    {
            $user_branch = $_SESSION['user_branch'];
        $this->db->select('*,sum(ledger_book_details.debit-ledger_book_details.credit) as amount');
         $this->db->from('account_ledger');
        $this->db->join('ledger_book_details', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->join('account_group', 'account_group.account_group_id=account_ledger.account_group_id');
        $this->db->join('account_head', 'account_head.id=account_group.group_under');
        $this->db->join('master', 'master.master_id=ledger_book.ledger_book_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
         if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
        $this->db->where('ledger_book.is_posted', '1');
        $this->db->where_in('account_group.group_under', '3');

        if ($frmdate != '')
        {
//            $frmdate = $this->db->escape($this->mastermodel->convert_date_format($frmdate));
//            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )>=', $frmdate, false);
        }
        if ($todate != '')
        {
            $todate = $this->db->escape($this->mastermodel->convert_date_format($todate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<=', $todate, false);
        }

//        if ($frmdate != '')
//            $this->db->where('voucher_date >=', $this->mastermodel->convert_date_format($frmdate));
//        if ($todate != '')
//            $this->db->where('voucher_date <=', $this->mastermodel->convert_date_format($todate));


        $this->db->group_by('account_head.id');
        $this->db->order_by('ledger_book.voucher_date', 'desc');
        $result = $this->db->get();
//        );

        $res = $result->row();
        if ($res)
        {
            return $res->amount;
        } else
        {
            return "";
        }
    }
     function get_incomeamount_open($frmdate, $todate,$branch)
    {
          $user_branch = $_SESSION['user_branch'];
        $this->db->select('*,sum(ledger_book_details.debit-ledger_book_details.credit) as amount');
//        $this->db->select('sum( case when voucher_date <='.$frmdate. 'then ledger_book_details.debit else 0 end) as open_debit,sum(case when voucher_date <='.$frmdate. 'then ledger_book_details.credit else 0 end) as open_credit');
        $this->db->from('account_ledger');
        $this->db->join('ledger_book_details', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->join('account_group', 'account_group.account_group_id=account_ledger.account_group_id');
        $this->db->join('account_head', 'account_head.id=account_group.group_under');
        $this->db->join('master', 'master.master_id=ledger_book.ledger_book_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
         if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
        $this->db->where('ledger_book.is_posted', '1');
        $this->db->where_in('account_head.id', '4');

        if ($frmdate != '')
        {
            $frmdate = $this->db->escape($this->mastermodel->convert_date_format($frmdate));
//            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )>=', $frmdate, false);
        }
        if ($todate != '')
        {
            $todate = $this->db->escape($this->mastermodel->convert_date_format($todate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<=', $todate, false);
        }

//        if ($frmdate != '')
//            $this->db->where('voucher_date >=', $this->mastermodel->convert_date_format($frmdate));
//        if ($todate != '')
//            $this->db->where('voucher_date <=', $this->mastermodel->convert_date_format($todate));


        $this->db->group_by('account_head.id');
        $this->db->order_by('ledger_book.voucher_date', 'desc');
        $result = $this->db->get();
        //);

        $res = $result->row();
        if ($res)
        {
            return $res->amount;
        } else
        {
            return "";
        }
    }
     function daybook_report($frmdate,$todate,$branch)
    {
//        $output = $this->mastermodel->save_user_activities($this->input->post('output_type') . '- Daybook Report', '0', 'Report');
//        $frmdate = $this->input->post('from_date');
//        $todate = $this->input->post('to_date');
          $user_branch = $_SESSION['user_branch'];
        $this->db->select('*,(ledger_book_details.debit) as debit_val,(ledger_book_details.credit) as credit_val');
        $this->db->from('account_ledger');
        $this->db->join('ledger_book_details', 'ledger_book_details.account_ledger_id=account_ledger.ledger_id');
        $this->db->join('ledger_book', 'ledger_book.ledger_book_id=ledger_book_details.ledger_book_id');
        $this->db->join('master', 'master.master_id=ledger_book.ledger_book_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->where('ledger_book.is_posted', '1');
        $this->db->group_by('ledger_book.ledger_book_id');
        $this->db->order_by('ledger_book.voucher_date');
        $this->db->order_by('ledger_book_details.ledger_book_details_id', 'desc');
         if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
         $this->db->where($query);
        }
        else{
            $this->db->where('master.master_branch_id',$branch); 
        }
     
        if ($frmdate != '')
        {
            $frmdate = $this->db->escape($this->mastermodel->convert_date_format($frmdate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )>=', $frmdate, false);
        }
        if ($todate != '')
        {
            $todate = $this->db->escape($this->mastermodel->convert_date_format($todate));
            $this->db->where('if(`is_pdc`="1",`cheque_date`  ,`voucher_date` )<=', $todate, false);
        }



//        if ($frmdate != '')
//            $this->db->where('voucher_date >=', $this->mastermodel->convert_date_format($frmdate));
//        if ($todate != '')
//            $this->db->where('voucher_date <=', $this->mastermodel->convert_date_format($todate));

        $result = $this->db->get();
        return $result->result();
    }
        function recievable_report_function($start_date,$branch)
    {
        $start_date = $this->mastermodel->convert_date_format($start_date);
        $recivable_id = $this->accountingmodel->get_account_settings('receivable');
        $ids[] = $recivable_id;

        $child_list = $this->accountingreportmodel->get_child_id_list($recivable_id);
        foreach ($child_list as $child)
        {
            $ids[] = $child->account_group_id;
//            $subids[] = $child->account_group_id;

            $subchild_list = $this->accountingreportmodel->get_child_id_list($child->account_group_id);
//            $countids = count($subchild_list);
            foreach ($subchild_list as $subchild)
            {

                $ids[] = $subchild->account_group_id;
                $subchild_listone = $this->accountingreportmodel->get_child_id_list($subchild->account_group_id);

                foreach ($subchild_listone as $subchildone)
                {

                    $ids[] = $subchildone->account_group_id;
                    $subchild_listtwo = $this->accountingreportmodel->get_child_id_list($subchildone->account_group_id);
                    foreach ($subchild_listtwo as $subchildtwo)
                    {

                        $ids[] = $subchildtwo->account_group_id;
                        $subchild_listthree = $this->accountingreportmodel->get_child_id_list($subchildtwo->account_group_id);
                        foreach ($subchild_listthree as $subchildthree)
                        {

                            $ids[] = $subchildthree->account_group_id;
                        }
                    }
                }
            }
        }
        $ids = join("','", $ids);
         $user_branch = $_SESSION['user_branch'];
           if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
        }
        else{
        $query = "master.master_branch_id ='".$branch."'"; 
        }
        $st = " SELECT
                    `account_ledger`.`ledger_name`
                    , account_group.`account_group_name`
                    , SUM(`ledger_book_details`.`credit` - `ledger_book_details`.`debit`) AS outstanding
                    , SUM(IF(DATEDIFF('$start_date' ,`ledger_book`.`voucher_date` ) <  60 ,`ledger_book_details`.`debit` - `ledger_book_details`.`credit`, 0 )) AS 'less_60' 
                    , SUM(IF(DATEDIFF('$start_date' ,`ledger_book`.`voucher_date` ) BETWEEN 60 AND 90 ,`ledger_book_details`.`debit` - `ledger_book_details`.`credit`, 0 )) AS ' greater60_less90' 
                    , SUM(IF(DATEDIFF('$start_date' ,`ledger_book`.`voucher_date` ) BETWEEN 90 AND 120 ,`ledger_book_details`.`debit` - `ledger_book_details`.`credit`, 0 )) AS ' greater90_less120' 
                    , SUM(IF(DATEDIFF('$start_date' ,`ledger_book`.`voucher_date` ) BETWEEN 120 AND 150 ,`ledger_book_details`.`debit` - `ledger_book_details`.`credit`, 0 )) AS ' greater120_less150'
                    , SUM(IF(DATEDIFF('$start_date' ,`ledger_book`.`voucher_date` ) BETWEEN 150 AND 180 ,`ledger_book_details`.`debit` - `ledger_book_details`.`credit`, 0 )) AS ' greater150_less180'  
                    , SUM(IF(DATEDIFF('$start_date' ,`ledger_book`.`voucher_date` ) > 180 ,`ledger_book_details`.`debit` - `ledger_book_details`.`credit`, 0 )) AS ' greater180' 

                FROM
                    `ledger_book_details`
                    INNER JOIN `ledger_book` 
                        ON (`ledger_book_details`.`ledger_book_id` = `ledger_book`.`ledger_book_id`)
                    INNER JOIN `account_ledger` 
                        ON (`ledger_book_details`.`account_ledger_id` = `account_ledger`.`ledger_id`)
                    INNER JOIN `account_group` 
                        ON (`account_ledger`.`account_group_id` = `account_group`.`account_group_id`)
                            INNER JOIN `master`
                            ON (`master`.`master_id` = `account_ledger`.`ledger_id`)
                WHERE (`ledger_book`.`is_posted` ='1') AND (account_group.`account_group_id` IN ('$ids') )  AND ".$query."
                GROUP BY `account_ledger`.`ledger_id`";
        $data = $this->db->query($st);
        //  );
        return $data->result();
    }
      function payable_report_function($start_date,$branch)
    {
        $payable_id = $this->accountingmodel->get_account_settings('payable');
        $ids[] = $payable_id;
        $child_list = $this->accountingreportmodel->get_child_id_list($payable_id);
        foreach ($child_list as $child)
        {
            $ids[] = $child->account_group_id;
//            $subids[] = $child->account_group_id;

            $subchild_list = $this->accountingreportmodel->get_child_id_list($child->account_group_id);
//            $countids = count($subchild_list);
            foreach ($subchild_list as $subchild)
            {

                $ids[] = $subchild->account_group_id;
                $subchild_listone = $this->accountingreportmodel->get_child_id_list($subchild->account_group_id);

                foreach ($subchild_listone as $subchildone)
                {

                    $ids[] = $subchildone->account_group_id;
                    $subchild_listtwo = $this->accountingreportmodel->get_child_id_list($subchildone->account_group_id);
                    foreach ($subchild_listtwo as $subchildtwo)
                    {

                        $ids[] = $subchildtwo->account_group_id;
                        $subchild_listthree = $this->accountingreportmodel->get_child_id_list($subchildtwo->account_group_id);
                        foreach ($subchild_listthree as $subchildthree)
                        {

                            $ids[] = $subchildthree->account_group_id;
                        }
                    }
                }
            }
        }
        $ids = join("','", $ids);
        $start_date = $this->mastermodel->convert_date_format($start_date);
         $user_branch = $_SESSION['user_branch'];
           if(empty($branch)){
            $query = "(";
            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";
         $query.=")";
        }
        else{
        $query = "master.master_branch_id ='".$branch."'"; 
        }
        $st = " SELECT
                    `account_ledger`.`ledger_name`
                    , account_group.`account_group_name`
                    , SUM(`ledger_book_details`.`credit` - `ledger_book_details`.`debit`) AS outstanding
                    , SUM(IF(DATEDIFF('$start_date' ,`ledger_book`.`voucher_date` ) <  60 ,`ledger_book_details`.`credit` - `ledger_book_details`.`debit`, 0 )) AS 'less_60' 
                    , SUM(IF(DATEDIFF('$start_date' ,`ledger_book`.`voucher_date` ) BETWEEN 60 AND 90 ,`ledger_book_details`.`credit` - `ledger_book_details`.`debit`, 0 )) AS ' greater60_less90' 
                    , SUM(IF(DATEDIFF('$start_date' ,`ledger_book`.`voucher_date` ) BETWEEN 90 AND 120 ,`ledger_book_details`.`credit` - `ledger_book_details`.`debit`, 0 )) AS ' greater90_less120' 
                    , SUM(IF(DATEDIFF('$start_date' ,`ledger_book`.`voucher_date` ) BETWEEN 120 AND 150 ,`ledger_book_details`.`credit` - `ledger_book_details`.`debit`, 0 )) AS ' greater120_less150'
                    , SUM(IF(DATEDIFF('$start_date' ,`ledger_book`.`voucher_date` ) BETWEEN 150 AND 180 ,`ledger_book_details`.`credit` - `ledger_book_details`.`debit`, 0 )) AS ' greater150_less180'  
                    , SUM(IF(DATEDIFF('$start_date' ,`ledger_book`.`voucher_date` ) > 180 ,`ledger_book_details`.`credit` - `ledger_book_details`.`debit`, 0 )) AS ' greater180' 

                FROM
                    `ledger_book_details`
                    INNER JOIN `ledger_book` 
                        ON (`ledger_book_details`.`ledger_book_id` = `ledger_book`.`ledger_book_id`)
                    INNER JOIN `account_ledger` 
                        ON (`ledger_book_details`.`account_ledger_id` = `account_ledger`.`ledger_id`)
                    INNER JOIN `account_group` 
                        ON (`account_ledger`.`account_group_id` = `account_group`.`account_group_id`)
                           INNER JOIN `master`
                            ON (`master`.`master_id` = `account_ledger`.`ledger_id`)
                WHERE (`ledger_book`.`is_posted` ='1') AND (account_group.`account_group_id` IN ('$ids') )  AND ".$query."
                GROUP BY `account_ledger`.`ledger_id`";
        $data = $this->db->query($st);
//        );
        return $data->result();
    }
}