<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Constructionmodel extends CI_Model
{

    function __construct()
    {
        // Call the Model constructor
        parent::__construct();
    }

    function search_unit()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('unit');
        $this->db->join('master', 'master.master_id=unit.unit_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('unit_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_unit($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'unit_id' => $masterid,
            'unit_name' => $postdata['con_unit_name']
        );
        $this->db->insert('unit', $tblValues);

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_unit($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'unit_name' => $postdata['unit_name']
        );
        $this->db->where('unit_id', $postdata['con_unit_id']);
        $this->db->update('unit', $tblValues);

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    function search_item_category()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('item_category');
        $this->db->join('master', 'master.master_id=item_category.item_category_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('item_category_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_item_category($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'item_category_id' => $masterid,
            'item_category_name' => $postdata['con_item_category_name']
        );
        $this->db->insert('item_category', $tblValues);

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_item_category($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'item_category_name' => $postdata['con_item_category_name']
        );
        $this->db->where('item_category_id', $postdata['con_item_category_id']);
        $this->db->update('item_category', $tblValues);

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    function search_item_type()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('item_type');
        $this->db->join('master', 'master.master_id=item_type.item_type_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('item_type.item_type_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_item_type($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'item_type_id' => $masterid,
            'item_type_name' => $postdata['con_item_type_name']
        );
        $this->db->insert('item_type', $tblValues);

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_item_type($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'item_type_name' => $postdata['con_item_type_name']
        );
        $this->db->where('item_type_id', $postdata['con_item_type_id']);
        $this->db->update('item_type', $tblValues);

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    function search_customer()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('contact');
        $this->db->join('master', 'master.master_id=contact.contact_id');
        $this->db->where('contact_status', 'active');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('contact.contact_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_customer($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $customer_code = $this->mastermodel->get_ref('contact_code', 'contact', 'contact_code');

        $set = $this->accountingmodel->get_account_settings('customer');
        $ledger_id = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'ledger_id' => $ledger_id,
            'account_group_id' => $set,
            'ledger_name' => $postdata['con_customer_fname'] . " " . $postdata['con_customer_lname'],
            'mailing_name' => $postdata['con_customer_fname'] . " " . $postdata['con_customer_lname'],
            'address' => $postdata['con_customer_address'],
            'phone' => $postdata['con_customer_phone'],
            'mobile' => $postdata['con_customer_mobile1'],
            'email' => $postdata['con_customer_email'],
            'is_party' => 1,
        );
        $output = $this->db->insert('account_ledger', $tblValues);
        $tblValues = array(
            'contact_id' => $masterid,
            'contact_code' => $customer_code,
            'contact_status' => 'active',
            'contact_salutation_id' => $postdata['con_customer_selutation'],
            'contact_company_name' => $postdata['con_customer_comp_name'],
            'contact_first_name' => $postdata['con_customer_fname'],
            'contact_last_name' => $postdata['con_customer_lname'],
            'contact_address' => $postdata['con_customer_address'],
            'contact_designation' => $postdata['con_customer_designation'],
            'contact_official_department' => $postdata['con_customer_department'],
            'contact_mobile_1' => $postdata['con_customer_mobile1'],
            'contact_mobile_2' => $postdata['con_customer_mobile2'],
            'contact_phone' => $postdata['con_customer_phone'],
            'contact_fax' => $postdata['con_customer_fax'],
            'contact_email' => $postdata['con_customer_email'],
//            'con_customer_sec_email' => $postdata['con_customer_sec_email'],
            'contact_skype_id' => $postdata['con_customer_skype'],
            'contact_website' => $postdata['con_customer_website'],
            'customer_credit_period' => $postdata['con_customer_credit_period'],
            'customer_credit_limit' => $postdata['con_customer_credit_limit'],
            'contact_residential_address' => $postdata['con_customer_res_address'],
            'contact_residential_street' => $postdata['con_customer_res_street'],
            'contact_residential_zipcode' => $postdata['con_customer_res_zipcode'],
            'contact_residential_country' => $postdata['con_customer_res_country'],
            'contact_residential_city' => $postdata['con_customer_res_city'],
            'contact_residential_state' => $postdata['con_customer_res_state'],
            'contact_residential_phone' => $postdata['con_customer_res_phone'],
            'contact_residential_DOB' => $this->mastermodel->convert_date_format($postdata['con_customer_res_DOB']),
            'contact_official_location' => $postdata['address'],
            'contact_official_long' => $postdata['longclicked'],
            'contact_official_lat' => $postdata['latclicked'],
            'ledger' => $ledger_id,
        );
        $this->db->insert('contact', $tblValues);

        $i = 1;
        while (!empty($postdata['con_customer_contact_name' . $i]))
        {
            $contact = $this->mastermodel->insertmasterdata();
            $Values = array(
                'contact_sub_id' => $contact,
                'contact_sub_contact_id' => $masterid,
                'contact_sub_name' => $postdata['con_customer_contact_name' . $i],
                'contact_sub_designation' => $postdata['con_customer_contact_designation' . $i],
                'contact_sub_mobile' => $postdata['con_customer_contact_mobile' . $i],
                'contact_sub_phone' => $postdata['con_customer_contact_phone' . $i],
                'contact_sub_email' => $postdata['con_customer_contact_email' . $i],
            );
            $this->db->insert('contact_sub', $Values);
            $i++;
        }
        $output = $this->mastermodel->save_user_activities('Add Customer',$masterid, 'contact');  //ss

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_customer($postdata)
    {
        $data = array();
        $this->db->trans_begin();

        $set = $this->accountingmodel->get_account_settings('customer');

        $tblValues = array(
            'account_group_id' => $set,
            'ledger_name' => $postdata['con_customer_fname'] . " " . $postdata['con_customer_lname'],
            'mailing_name' => $postdata['con_customer_fname'] . " " . $postdata['con_customer_lname'],
            'address' => $postdata['con_customer_address'],
            'phone' => $postdata['con_customer_phone'],
            'mobile' => $postdata['con_customer_mobile1'],
            'email' => $postdata['con_customer_email'],
            'is_party' => 1,
        );
        $this->db->where('ledger_id', $postdata['ledger_id']);
        $output = $this->db->update('account_ledger', $tblValues);

        $tblValues = array(
            'contact_salutation_id' => $postdata['con_customer_selutation'],
            'contact_company_name' => $postdata['con_customer_comp_name'],
            'contact_first_name' => $postdata['con_customer_fname'],
            'contact_last_name' => $postdata['con_customer_lname'],
            'contact_address' => $postdata['con_customer_address'],
            'contact_designation' => $postdata['con_customer_designation'],
            'contact_official_department' => $postdata['con_customer_department'],
            'contact_mobile_1' => $postdata['con_customer_mobile1'],
            'contact_mobile_2' => $postdata['con_customer_mobile2'],
            'contact_phone' => $postdata['con_customer_phone'],
            'contact_fax' => $postdata['con_customer_fax'],
            'contact_email' => $postdata['con_customer_email'],
//            'con_customer_sec_email' => $postdata['con_customer_sec_email'],
            'contact_skype_id' => $postdata['con_customer_skype'],
            'contact_website' => $postdata['con_customer_website'],
            'customer_credit_period' => $postdata['con_customer_credit_period'],
            'customer_credit_limit' => $postdata['con_customer_credit_limit'],
            'contact_residential_address' => $postdata['con_customer_res_address'],
            'contact_residential_street' => $postdata['con_customer_res_street'],
            'contact_residential_zipcode' => $postdata['con_customer_res_zipcode'],
            'contact_residential_country' => $postdata['con_customer_res_country'],
            'contact_residential_city' => $postdata['con_customer_res_city'],
            'contact_residential_state' => $postdata['con_customer_res_state'],
            'contact_residential_phone' => $postdata['con_customer_res_phone'],
            'contact_residential_DOB' => $this->mastermodel->convert_date_format($postdata['con_customer_res_DOB']),
            'contact_official_location' => $postdata['address'],
            'contact_official_lat' => $postdata['longclicked'],
            'contact_official_long' => $postdata['latclicked']
        );
        $this->db->where('contact_id', $postdata['con_customer_id']);
        $this->db->update('contact', $tblValues);
        $i = 1;
        $this->db->where('contact_sub_contact_id', $postdata['con_customer_id']);
        $this->db->delete('contact_sub');
        while (!empty($postdata['con_customer_contact_name' . $i]))
        {
            $contact = $this->mastermodel->insertmasterdata();
            $Values = array(
                'contact_sub_id' => $contact,
                'contact_sub_contact_id' => $postdata['con_customer_id'],
                'contact_sub_name' => $postdata['con_customer_contact_name' . $i],
                'contact_sub_designation' => $postdata['con_customer_contact_designation' . $i],
                'contact_sub_mobile' => $postdata['con_customer_contact_mobile' . $i],
                'contact_sub_phone' => $postdata['con_customer_contact_phone' . $i],
                'contact_sub_email' => $postdata['con_customer_contact_email' . $i],
            );
            $this->db->insert('contact_sub', $Values);
            $i++;
        $output = $this->mastermodel->save_user_activities('Update Customer',$postdata['con_customer_id'], 'contact');  //ss
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    function search_project()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('con_project');
        $this->db->join('master', 'master.master_id=con_project.con_project_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('con_project.con_project_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_project($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $project_code = $this->mastermodel->get_ref('con_project_code', 'con_project', 'con_project_code');


        $set = $this->accountingmodel->get_account_settings('site');
        $ledger_id = $this->mastermodel->insertmasterdata();

        $tblValues = array(
            'ledger_id' => $ledger_id,
            'group_id' => $set,
            'ledger_name' => $postdata['con_project_name'],
            'mailing_name' => $postdata['con_project_name'],
            'address' => $postdata['con_project_address'],
        );
        $output = $this->db->insert('cost_centre_ledger', $tblValues);

        $tblValues = array(
            'con_project_id' => $masterid,
            'con_project_code' => $project_code,
            'con_project_name' => $postdata['con_project_name'],
            'con_project_address' => $postdata['con_project_address'],
            'con_project_description' => $postdata['con_project_description'],
            'con_project_exp_s_date' => $this->mastermodel->convert_date_format($postdata['con_project_exp_s_date']),
            'con_project_exp_f_date' => $this->mastermodel->convert_date_format($postdata['con_project_exp_f_date']),
            'con_project_staus' => $postdata['con_project_staus'],
            'con_project_status_reson' => $postdata['con_project_status_reson'],
            'con_project_customer_id' => $postdata['con_project_customer_id'],
            'ledger' => $ledger_id,
        );
        $this->db->insert('con_project', $tblValues);

        $i = 1;
        while (!empty($postdata['con_project_contact_details_contact_id' . $i]))
        {
            $contact = $this->mastermodel->insertmasterdata();
            $Values = array(
                'con_project_contact_details_id' => $contact,
                'con_project_contact_details_project_id' => $masterid,
                'con_project_contact_details_contact_id' => $postdata['con_project_contact_details_contact_id' . $i],
                'con_project_contact_details_remarks' => $postdata['con_project_contact_details_remarks' . $i]
            );
            $this->db->insert('con_project_contact_details', $Values);
            $i++;
        }
        $output = $this->mastermodel->save_user_activities('Add Project',$masterid, 'con_project');  //ss

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_project($postdata)
    {
        $data = array();
        $this->db->trans_begin();


        $set = $this->accountingmodel->get_account_settings('site');

        $tblValues = array(
            'group_id' => $set,
            'ledger_name' => $postdata['con_project_name'],
            'mailing_name' => $postdata['con_project_name'],
            'address' => $postdata['con_project_address'],
        );
        $this->db->where('ledger_id', $postdata['ledger_id']);
        $output = $this->db->update('cost_centre_ledger', $tblValues);
        $this->db->where('ledger_id', $postdata['ledger_id']);
        $output = $this->db->update('cost_centre_ledger', $tblValues);
        $tblValues = array(
            'con_project_name' => $postdata['con_project_name'],
            'con_project_address' => $postdata['con_project_address'],
            'con_project_description' => $postdata['con_project_description'],
            'con_project_exp_s_date' => $this->mastermodel->convert_date_format($postdata['con_project_exp_s_date']),
            'con_project_exp_f_date' => $this->mastermodel->convert_date_format($postdata['con_project_exp_f_date']),
            'con_project_staus' => $postdata['con_project_staus'],
            'con_project_status_reson' => $postdata['con_project_status_reson'],
            'con_project_customer_id' => $postdata['con_project_customer_id']
        );
        $this->db->where('con_project_id', $postdata['con_project_id']);
        $this->db->update('con_project', $tblValues);
        $i = 1;
        $this->db->where('con_project_contact_details_project_id', $postdata['con_project_id']);
        $this->db->delete('con_project_contact_details');
        while (!empty($postdata['con_project_contact_details_contact_id' . $i]))
        {
            $contact = $this->mastermodel->insertmasterdata();
            $Values = array(
                'con_project_contact_details_id' => $contact,
                'con_project_contact_details_project_id' => $postdata['con_project_id'],
                'con_project_contact_details_contact_id' => $postdata['con_project_contact_details_contact_id' . $i],
                'con_project_contact_details_remarks' => $postdata['con_project_contact_details_remarks' . $i]
            );
            $this->db->insert('con_project_contact_details', $Values);
            $i++;
        }
        $output = $this->mastermodel->save_user_activities('Update Project',$postdata['con_project_id'], 'con_project');  //ss
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    function get_emp_details($id)
    {
        $this->db->select('hr_employees_designation_id , hr_employees_contact_no');
        $this->db->from('hr_employees');
        $this->db->where('hr_employees_id', $id);
        $data['emp'] = $this->db->get()->result();

        $this->db->select('*');
        $this->db->from('hr_designation');
        $this->db->where('hr_designation_id', $data['emp'][0]->hr_employees_designation_id);
        $data['des'] = $this->db->get()->result();

        return $data;
    }

    function search_godown()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('godown');
        $this->db->order_by('godown_id', 'desc');
        $this->db->join('master', 'master.master_id=godown_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_godown($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'godown_id' => $masterid,
            'godown_name' => $postdata['con_godown_name'],
            'head_office' => $postdata['head_office'],
            'location' => $postdata['address'],
            'location_lat' => $postdata['latclicked'],
            'location_long' => $postdata['longclicked']
        );
        if (isset($postdata['head_office']))
        {
            $tblValues['head_office'] = 1;
        }
        else
            $tblValues['head_office'] = 0;
        $this->db->insert('godown', $tblValues);

        $i = 1;
        while (!empty($postdata['con_rack_name' . $i]))
        {
            $rackid = $this->mastermodel->insertmasterdata();
            $Values = array(
                'godown_rack_id' => $rackid,
                'godown_rack_godown_id' => $masterid,
                'godown_rack_name' => $postdata['con_rack_name' . $i]
            );
            $this->db->insert('godown_rack', $Values);
            $i++;
        }

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_godown($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'godown_name' => $postdata['con_godown_name'],
            'head_office' => $postdata['head_office'],
            'location' => $postdata['address'],
            'location_lat' => $postdata['latclicked'],
            'location_long' => $postdata['longclicked']
        );
        if (isset($postdata['head_office']))
        {
            $tblValues['head_office'] = 1;
        }
        $this->db->where('godown_id', $postdata['con_godown_id']);
        $this->db->update('godown', $tblValues);
        $i = 1;
        $this->db->where('godown_rack_godown_id', $postdata['con_godown_id']);
        $this->db->delete('godown_rack');
        while (!empty($postdata['con_rack_name' . $i]))
        {
            $rackid = $this->mastermodel->insertmasterdata();
            $Values = array(
                'godown_rack_id' => $rackid,
                'godown_rack_godown_id' => $postdata['con_godown_id'],
                'godown_rack_name' => $postdata['con_rack_name' . $i]
            );
            $this->db->insert('godown_rack', $Values);
            $i++;
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    function search_vendor()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('vendor');
        $this->db->join('master', 'master.master_id=vendor_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('vendor_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_vendor($postdata)
    {
        $data = array();
        $this->db->trans_begin();

        $vendor_code = $this->mastermodel->get_ref('vendor_code', 'vendor', 'vendor_code');

        $set = $this->accountingmodel->get_account_settings('vendor');
        $ledger_id = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'ledger_id' => $ledger_id,
            'account_group_id' => $set,
            'ledger_name' => $postdata['con_vendor_name'],
            'mailing_name' => $postdata['con_vendor_name'],
            'address' => $postdata['con_vendor_address'],
            'phone' => $postdata['con_vendor_mobile'],
            'email' => $postdata['con_vendor_email'],
        );
        $output = $this->db->insert('account_ledger', $tblValues);
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'vendor_id' => $masterid,
            'vendor_code' => $vendor_code,
            'vendor_name' => $postdata['con_vendor_name'],
            'vendor_address' => $postdata['con_vendor_address'],
            'vendor_contact_person' => $postdata['con_vendor_contact_person'],
            'vendor_mobile' => $postdata['con_vendor_mobile'],
            'vendor_phone' => $postdata['con_vendor_phone'],
            'vendor_fax' => $postdata['con_vendor_fax'],
            'vendor_ledger' => $ledger_id,
            'vendor_email' => $postdata['con_vendor_email'],
            'vendor_sec_email' => $postdata['con_vendor_sec_email'],
            'vendor_skype_id' => $postdata['con_vendor_skype_id'],
            'vendor_website' => $postdata['con_vendor_website'],
            'vendor_credit_period' => $postdata['con_vendor_credit_period'],
            'vendor_credit_limit' => $postdata['con_vendor_credit_limit'],
            'vendor_account' => $postdata['con_vendor_acount'],
            'vendor_bank_name' => $postdata['con_vendor_bank_name'],
            'vendor_bank_branch' => $postdata['con_vendor_bank_branch'],
            'vendor_ifsc_code' => $postdata['con_vendor_ifsc_code'],
            'vendor_remarks' => $postdata['con_vendor_remarks'],
            'vendor_lat' => $postdata['latclicked'],
            'vendor_long' => $postdata['longclicked'],
            'vendor_location' => $postdata['address'],
        );
        $this->db->insert('vendor', $tblValues);
        $i = 1;
        while (!empty($postdata['con_vendor_contacts_name' . $i]))
        {
            $vendor_contacts_id = $this->mastermodel->insertmasterdata();
            $tblValues_sub_document = array(
                'vendor_contacts_id' => $vendor_contacts_id,
                'vendor_contacts_vendor_id' => $masterid,
                'vendor_contacts_name' => $postdata['con_vendor_contacts_name' . $i],
                'vendor_contacts_designation' => $postdata['con_vendor_contacts_designation' . $i],
                'vendor_contacts_mobile' => $postdata['con_vendor_contacts_mobile' . $i],
                'vendor_contacts_phone' => $postdata['con_vendor_contacts_phone' . $i],
                'vendor_contacts_email' => $postdata['con_vendor_contacts_email' . $i],
            );
            $i++;
            $output = $this->db->insert('vendor_contacts', $tblValues_sub_document);
        }
        $output = $this->mastermodel->save_user_activities('Add Vendor',$masterid, 'vendor');  //ss
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_vendor($postdata)
    {
        $data = array();
        $this->db->trans_begin();

        $set = $this->accountingmodel->get_account_settings('vendor');
        $tblValues = array(
            'account_group_id' => $set,
            'ledger_name' => $postdata['con_vendor_name'],
            'mailing_name' => $postdata['con_vendor_name'],
            'address' => $postdata['con_vendor_address'],
            'phone' => $postdata['con_vendor_mobile'],
            'email' => $postdata['con_vendor_email'],
        );
        $this->db->where('ledger_id', $postdata['ledger_id']);
        $output = $this->db->update('account_ledger', $tblValues);
        $tblValues = array(
            'vendor_name' => $postdata['con_vendor_name'],
            'vendor_address' => $postdata['con_vendor_address'],
            'vendor_contact_person' => $postdata['con_vendor_contact_person'],
            'vendor_mobile' => $postdata['con_vendor_mobile'],
            'vendor_phone' => $postdata['con_vendor_phone'],
            'vendor_fax' => $postdata['con_vendor_fax'],
            'vendor_email' => $postdata['con_vendor_email'],
            'vendor_sec_email' => $postdata['con_vendor_sec_email'],
            'vendor_skype_id' => $postdata['con_vendor_skype_id'],
            'vendor_website' => $postdata['con_vendor_website'],
            'vendor_credit_period' => $postdata['con_vendor_credit_period'],
            'vendor_credit_limit' => $postdata['con_vendor_credit_limit'],
            'vendor_account' => $postdata['con_vendor_acount'],
            'vendor_bank_name' => $postdata['con_vendor_bank_name'],
            'vendor_bank_branch' => $postdata['con_vendor_bank_branch'],
            'vendor_ifsc_code' => $postdata['con_vendor_ifsc_code'],
            'vendor_remarks' => $postdata['con_vendor_remarks'],
            'vendor_lat' => $postdata['latclicked'],
            'vendor_long' => $postdata['longclicked'],
            'vendor_location' => $postdata['address'],
        );
        $this->db->where('vendor_id', $postdata['con_vendor_id']);
        $this->db->update('vendor', $tblValues);

        $this->db->where('vendor_contacts_vendor_id', $postdata['con_vendor_id']);
        $this->db->delete('vendor_contacts');
        $i = 1;
        while (isset($postdata['con_vendor_contacts_name' . $i]))
        {
            $vendor_contacts_id = $this->mastermodel->insertmasterdata();
            $tblValues_sub_document = array(
                'vendor_contacts_id' => $vendor_contacts_id,
                'vendor_contacts_vendor_id' => $postdata['con_vendor_id'],
                'vendor_contacts_name' => $postdata['con_vendor_contacts_name' . $i],
                'vendor_contacts_designation' => $postdata['con_vendor_contacts_designation' . $i],
                'vendor_contacts_mobile' => $postdata['con_vendor_contacts_mobile' . $i],
                'vendor_contacts_phone' => $postdata['con_vendor_contacts_phone' . $i],
                'vendor_contacts_email' => $postdata['con_vendor_contacts_email' . $i],
            );
            $i++;
            $output = $this->db->insert('vendor_contacts', $tblValues_sub_document);
        }
        $output = $this->mastermodel->save_user_activities('Add Vendor',$postdata['con_vendor_id'], 'vendor');  //ss
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    function search_item_master()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('item_master');
        $this->db->join('master', 'master.master_id=item_master.item_master_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('item_master_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_item_master($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $item_code = $this->mastermodel->get_ref('item_master_code', 'item_master', 'item_master_code');
        if (isset($postdata['con_item_master_account']))
        {
            $con_item_master_account = $postdata['con_item_master_account'];
        } else
        {
            $con_item_master_account = NULL;
        }
        $tblValues = array(
            'item_master_id' => $masterid,
            'item_master_code' => $item_code,
            'item_master_name' => $postdata['con_item_master_name'],
            'item_master_unit_id' => $postdata['con_item_master_unit_id'],
            'item_master_category_id' => $postdata['con_item_master_category_id'],
            'item_master_type_id' => $postdata['con_item_master_type_id'],
            'item_master_account' => $con_item_master_account,
            'item_master_description' => $postdata['con_item_master_description'],
            'item_master_tax' => $postdata['con_item_master_tax']
        );
        $this->db->insert('item_master', $tblValues);

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_item_master($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        if (isset($postdata['con_item_master_account']))
        {
            $con_item_master_account = $postdata['con_item_master_account'];
        } else
        {
            $con_item_master_account = NULL;
        }
        $tblValues = array(
            'item_master_name' => $postdata['con_item_master_name'],
            'item_master_unit_id' => $postdata['con_item_master_unit_id'],
            'item_master_category_id' => $postdata['con_item_master_category_id'],
            'item_master_type_id' => $postdata['con_item_master_type_id'],
            'item_master_account' => $con_item_master_account,
            'item_master_description' => $postdata['con_item_master_description'],
            'item_master_tax' => $postdata['con_item_master_tax']
        );
        $this->db->where('item_master_id', $postdata['con_item_master_id']);
        $this->db->update('item_master', $tblValues);

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    function search_budgeting()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('con_budgeting');
        $this->db->join('master', 'master.master_id=con_budgeting.con_budgeting_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('con_budgeting_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_budgeting($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $budgeting_code = $this->mastermodel->get_ref('con_budgeting_code', 'con_budgeting', 'con_budgeting_code');
        $tblValues = array(
            'con_budgeting_id' => $masterid,
            'con_budgeting_date' => $this->mastermodel->convert_date_format($postdata['con_budgeting_date']),
            'con_budgeting_project_id' => $postdata['con_budgeting_project_id'],
            'con_budgeting_incharge_id' => $postdata['con_budgeting_incharge_id'],
            'con_budgeting_remarks' => $postdata['con_budgeting_remarks'],
            'con_budgeting_code' => $budgeting_code,
            'con_budgeting_allotment_grand_total' => $postdata['con_budgeting_allotment_grand_total']
        );
        $this->db->insert('con_budgeting', $tblValues);

        $i = 1;
        while (!empty($postdata['con_budgeting_allotment_item_id' . $i]))
        {
            $rackid = $this->mastermodel->insertmasterdata();
            $Values = array(
                'con_budgeting_allotment_id' => $rackid,
                'con_budgeting_allotment_budject_id' => $masterid,
                'con_budgeting_allotment_item_id' => $postdata['con_budgeting_allotment_item_id' . $i],
                'con_budgeting_allotment_qty' => $postdata['con_budgeting_allotment_qty' . $i],
                'con_budgeting_allotment_price' => $postdata['con_budgeting_allotment_price' . $i],
                'con_budgeting_allotment_tax' => $postdata['con_budgeting_allotment_tax' . $i],
                'con_budgeting_allotment_tax_amt' => $postdata['con_budgeting_allotment_tax_amt' . $i],
                'con_budgeting_allotment_total' => $postdata['con_budgeting_allotment_total' . $i]
            );
            $this->db->insert('con_budgeting_allotment', $Values);
            $i++;
        }
        $output = $this->mastermodel->save_user_activities('Add Budgeting',$masterid, 'con_budgeting');  //ss

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    function get_item_cat($id)
    {
        $this->db->select('item_master_category_id');
        $this->db->from('item_master');
        $this->db->where('item_master_id', $id);
        $c_id = $this->db->get()->row();

        $this->db->select('item_category_name,item_category_id');
        $this->db->from('item_category');
        $this->db->where('item_category_id', $c_id->item_master_category_id);
        $data = $this->db->get()->row();
        return $data;
    }

    public function update_budgeting($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'con_budgeting_date' => $this->mastermodel->convert_date_format($postdata['con_budgeting_date']),
            'con_budgeting_project_id' => $postdata['con_budgeting_project_id'],
            'con_budgeting_incharge_id' => $postdata['con_budgeting_incharge_id'],
            'con_budgeting_remarks' => $postdata['con_budgeting_remarks'],
            'con_budgeting_allotment_grand_total' => $postdata['con_budgeting_allotment_grand_total']
        );
        $this->db->where('con_budgeting_id', $postdata['con_budgeting_id']);
        $this->db->update('con_budgeting', $tblValues);

        $this->db->where('con_budgeting_allotment_budject_id', $postdata['con_budgeting_id']);
        $this->db->delete('con_budgeting_allotment');
        $i = 1;
        while (!empty($postdata['con_budgeting_allotment_item_id' . $i]))
        {
            $rackid = $this->mastermodel->insertmasterdata();
            $Values = array(
                'con_budgeting_allotment_id' => $rackid,
                'con_budgeting_allotment_budject_id' => $postdata['con_budgeting_id'],
                'con_budgeting_allotment_item_id' => $postdata['con_budgeting_allotment_item_id' . $i],
                'con_budgeting_allotment_qty' => $postdata['con_budgeting_allotment_qty' . $i],
                'con_budgeting_allotment_price' => $postdata['con_budgeting_allotment_price' . $i],
                'con_budgeting_allotment_tax' => $postdata['con_budgeting_allotment_tax' . $i],
                'con_budgeting_allotment_tax_amt' => $postdata['con_budgeting_allotment_tax_amt' . $i],
                'con_budgeting_allotment_total' => $postdata['con_budgeting_allotment_total' . $i]
            );
            $this->db->insert('con_budgeting_allotment', $Values);
            $i++;
        }
        $output = $this->mastermodel->save_user_activities('Edit Budgeting',$postdata['con_budgeting_id'], 'con_budgeting');  //ss

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    function search_quotation()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('con_quotation');
        $this->db->join('master', 'master.master_id=con_quotation.con_quotation_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('con_quotation.con_quotation_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_quotation($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $item_code = $this->mastermodel->get_ref('con_quotation_code', 'con_quotation', 'con_quotation_code');
        $tblValues = array(
            'con_quotation_id' => $masterid,
            'con_quotation_code' => $item_code,
            'con_quotation_customer' => $postdata['con_quotation_customer'],
            'con_quotation_subject' => $postdata['con_quotation_subject'],
            'con_quotation_validity' => $postdata['con_quotation_validity'],
            'con_quotation_remarks' => $postdata['con_quotation_remarks'],
            'con_quotation_location' => $postdata['con_quotation_location'],
            'con_quotation_date' => $this->mastermodel->convert_date_format($postdata['con_quotation_date']),
            'con_quotation_total' => $postdata['con_quotation_total']
        );
        $this->db->insert('con_quotation', $tblValues);
        $i = 1;
        while (!empty($postdata['con_quotation_item_item_id' . $i]))
        {
            $detailsid = $this->mastermodel->insertmasterdata();
            $Values = array(
                'con_quotation_item_id' => $detailsid,
                'con_quotation_item_quotation_id' => $masterid,
                'con_quotation_item_item_id' => $postdata['con_quotation_item_item_id' . $i],
                'con_quotation_item_qty' => $postdata['con_quotation_item_qty' . $i],
                'con_quotation_item_price' => $postdata['con_quotation_item_price' . $i],
                'con_quotation_item_taxper' => $postdata['con_quotation_item_taxper' . $i],
                'con_quotation_item_taxamt' => $postdata['con_quotation_item_taxamt' . $i],
                'con_quotation_item_total' => $postdata['con_quotation_item_total' . $i]
            );
            $this->db->insert('con_quotation_item', $Values);
            $i++;
        }
        $output = $this->mastermodel->save_user_activities('Add Quotation',$masterid, 'con_quotation');  //ss

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_quotation($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'con_quotation_customer' => $postdata['con_quotation_customer'],
            'con_quotation_subject' => $postdata['con_quotation_subject'],
            'con_quotation_validity' => $postdata['con_quotation_validity'],
            'con_quotation_remarks' => $postdata['con_quotation_remarks'],
            'con_quotation_location' => $postdata['con_quotation_location'],
            'con_quotation_date' => $this->mastermodel->convert_date_format($postdata['con_quotation_date']),
            'con_quotation_total' => $postdata['con_quotation_total']
        );
        $this->db->where('con_quotation_id', $postdata['con_quotation_id']);
        $this->db->update('con_quotation', $tblValues);

        $this->db->where('con_quotation_item_quotation_id', $postdata['con_quotation_id']);
        $this->db->delete('con_quotation_item');
        $i = 1;
        while (!empty($postdata['con_quotation_item_item_id' . $i]))
        {
            $detailsid = $this->mastermodel->insertmasterdata();
            $Values = array(
                'con_quotation_item_id' => $detailsid,
                'con_quotation_item_quotation_id' => $postdata['con_quotation_id'],
                'con_quotation_item_item_id' => $postdata['con_quotation_item_item_id' . $i],
                'con_quotation_item_qty' => $postdata['con_quotation_item_qty' . $i],
                'con_quotation_item_price' => $postdata['con_quotation_item_price' . $i],
                'con_quotation_item_taxper' => $postdata['con_quotation_item_taxper' . $i],
                'con_quotation_item_taxamt' => $postdata['con_quotation_item_taxamt' . $i],
                'con_quotation_item_total' => $postdata['con_quotation_item_total' . $i]
            );
            $this->db->insert('con_quotation_item', $Values);
            $i++;
        }
        $output = $this->mastermodel->save_user_activities('Edit Quotation',$postdata['con_quotation_id'], 'con_quotation');  //ss

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    function search_item_request()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('con_item_request');
        $this->db->join('master', 'master.master_id=con_item_request.con_item_request_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('con_item_request_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_item_request($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $request_code = $this->mastermodel->get_ref('con_item_request_code', 'con_item_request', 'con_item_request_code');
        $tblValues = array(
            'con_item_request_id' => $masterid,
            'con_item_request_code' => $request_code,
            'con_item_request_date' => $this->mastermodel->convert_date_format($postdata['con_item_request_date']),
            'con_item_request_project' => $postdata['con_item_request_project'],
            'con_item_request_user' => $postdata['con_item_request_user'],
            'con_item_request_remarks' => $postdata['con_item_request_remarks'],
        );
        $this->db->insert('con_item_request', $tblValues);

        $i = 1;
        while (!empty($postdata['con_item_request_details_item_id' . $i]))
        {
            $details_id = $this->mastermodel->insertmasterdata();
            $Values = array(
                'con_item_request_details_id' => $details_id,
                'con_item_request_details_item_request_id' => $masterid,
                'con_item_request_details_item_id' => $postdata['con_item_request_details_item_id' . $i],
                'con_item_request_details_category_id' => $postdata['con_item_request_details_category_id' . $i],
                'con_item_request_details_qty' => $postdata['con_item_request_details_qty' . $i],
                'con_item_request_details_remarks' => $postdata['con_item_request_details_remarks' . $i],
            );
            $this->db->insert('con_item_request_details', $Values);
            $i++;
        }
        $output = $this->mastermodel->save_user_activities('Add Item request',$masterid, 'con_item_request');  //ss

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_item_request($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'con_item_request_date' => $this->mastermodel->convert_date_format($postdata['con_item_request_date']),
            'con_item_request_project' => $postdata['con_item_request_project'],
            'con_item_request_user' => $postdata['con_item_request_user'],
            'con_item_request_remarks' => $postdata['con_item_request_remarks'],
        );
        $this->db->where('con_item_request_id', $postdata['con_item_request_id']);
        $this->db->update('con_item_request', $tblValues);


        $i = 1;
        while (!empty($postdata['con_item_request_details_item_id' . $i]))
        {
            if (empty($postdata['approval_quantity' . $i]))
            {
                $this->db->where('con_item_request_details_id', $postdata['con_item_request_details_id' . $i]);
                $this->db->delete('con_item_request_details');
                $details_id = $this->mastermodel->insertmasterdata();
                $Values = array(
                    'con_item_request_details_id' => $details_id,
                    'con_item_request_details_item_request_id' => $postdata['con_item_request_id'],
                    'con_item_request_details_item_id' => $postdata['con_item_request_details_item_id' . $i],
                    'con_item_request_details_category_id' => $postdata['con_item_request_details_category_id' . $i],
                    'con_item_request_details_qty' => $postdata['con_item_request_details_qty' . $i],
                    'con_item_request_details_remarks' => $postdata['con_item_request_details_remarks' . $i],
                );
                $this->db->insert('con_item_request_details', $Values);
            } else
            {
                $Values = array(
                    'con_item_request_details_item_id' => $postdata['con_item_request_details_item_id' . $i],
                    'con_item_request_details_category_id' => $postdata['con_item_request_details_category_id' . $i],
                    'con_item_request_details_qty' => $postdata['con_item_request_details_qty' . $i],
                    'con_item_request_details_remarks' => $postdata['con_item_request_details_remarks' . $i],
                );
                $this->db->where('con_item_request_details_id', $postdata['con_item_request_details_id' . $i]);
                $this->db->update('con_item_request_details', $Values);
            }
            $i++;
        }
        $output = $this->mastermodel->save_user_activities('Edit Item request',$postdata['con_item_request_id'], 'con_item_request');  //ss

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    function search_purchase_order()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('con_po');
        $this->db->join('vendor', 'vendor.vendor_id=con_po.con_po_vendor_id');
        $this->db->join('master', 'master.master_id=con_po.con_po_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('con_po_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    function get_requestlist_by_multiple_sites()
    {
        $arr = $_POST['id'];
        $this->db->select('*');
        $this->db->from('con_item_request');
//        $this->db->join('con_item_request_details', 'con_item_request_details.con_item_request_details_item_request_id=con_item_request.con_item_request_id','inner');
       
        $this->db->where('con_item_request.con_item_request_id in', '(SELECT  `con_item_request`.`con_item_request_id` 
                            FROM `con_item_request`
                            INNER JOIN `con_item_request_details` ON `con_item_request`.`con_item_request_id` = `con_item_request_details`.`con_item_request_details_item_request_id`
        
                            WHERE `po_completed_qty` < `con_item_request_details_approval_qty`)', false);
        
         $this->db->where('con_item_request.con_item_request_project IN ( ' . $arr . ')', null, true);
        $this->db->order_by('con_item_request.con_item_request_id', 'desc');
        $this->db->group_by('con_item_request.con_item_request_id');
        $data = $this->db->get()->result();
        return $data;
    }

    function get_requestlist_tools()
    {
        $arr = $_POST['id'];
        $this->db->select('*');
        $this->db->from('con_tool_request');
        $this->db->join('con_tool_request_details', 'con_tool_request_details.tool_request_id=con_tool_request.tool_request_id');
        $this->db->where_in('con_tool_request.tool_request_project', $arr);
        $this->db->where('con_tool_request.tool_request_id in', '(SELECT  `con_tool_request`.`tool_request_id` 
                            FROM `con_tool_request`
                            INNER JOIN `con_tool_request_details` ON `con_tool_request`.`tool_request_id` = `con_tool_request_details`.`tool_request_id`
        
                            WHERE `request_completed_qty` < `qty`)', false);
        $this->db->order_by('con_tool_request.tool_request_id', 'desc');
        $this->db->group_by('con_tool_request.tool_request_id');
        $data = $this->db->get()->result();
        
        return $data;
    }
      function get_requestlist_alloc_tools()
    {
         $arr = $_POST['id'];
        $this->db->select('*');
        $this->db->from('con_tool_request');
        $this->db->join('con_tool_request_details', 'con_tool_request_details.tool_request_id=con_tool_request.tool_request_id');
        $this->db->where('con_tool_request.tool_request_project' , $arr);
//        $this->db->where('item_request_from_site.item_request_from_site_id in', '(SELECT  `item_request_from_site`.`item_request_from_site_id` 
//                            FROM `item_request_from_site`
//                            INNER JOIN `item_request_details` ON `item_request_from_site`.`item_request_from_site_id` = `item_request_details`.`item_request_from_site`
//        
//                            WHERE `po_completed_qty` < `request_quantity`)', false);
        $this->db->order_by('con_tool_request.tool_request_id', 'desc');
        $this->db->group_by('con_tool_request.tool_request_id');
        $data = $this->db->get()->result();
        return $data;
    }

    function get_tool_multiple_requests($arr)
    {
        $this->db->select('*');
        $this->db->from('con_tool_request_details');
        $this->db->join('con_tool_request', 'con_tool_request_details.tool_request_id=con_tool_request.tool_request_id');
        $this->db->join('tools', 'tools.tools_id=con_tool_request_details.tool_id');
        $this->db->where_in('con_tool_request_details.tool_request_id', $arr);

        $this->db->order_by('con_tool_request_details.tool_request_details_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }

    function get_tool_order_detailes($arr)
    {
        $this->db->select('*');
        $this->db->from('con_order_rented_tools_details');
        $this->db->join('con_order_rented_tools', 'con_order_rented_tools_details.order_id=con_order_rented_tools.order_rented_tools_id');
        $this->db->join('tools', 'tools.tools_id=con_order_rented_tools_details.rended_tool_id');
        $this->db->where_in('con_order_rented_tools_details.order_id', $arr);

        $this->db->order_by('con_order_rented_tools_details.con_order_rented_tools_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }

    function get_approvedet_multiple_requests($arr)
    {
        $this->db->select('*');
        $this->db->from('con_item_request_details');
        $this->db->join('con_item_request', 'con_item_request_details.con_item_request_details_item_request_id=con_item_request.con_item_request_id');
        $this->db->join('item_master', 'item_master.item_master_id=con_item_request_details.con_item_request_details_item_id');
        $this->db->where_in('con_item_request_details.con_item_request_details_item_request_id', $arr);

        $this->db->order_by('con_item_request_details.con_item_request_details_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }

    function get_po_item_by_request($rid, $id)
    {
        $this->db->select('sum(con_po_details.con_po_details_quantity) as po_quantity');
        $this->db->from('con_po_details');
        $this->db->where('con_po_details.item_request_details', $rid);
        $this->db->where('con_po_details.con_po_item', $id);
        $data = $this->db->get()->row();
        if ($data)
        {
            return $data->po_quantity;
        } else
        {
            return "";
        }
    }

    function get_item_transfer_by_request($rid, $id)
    {
        $this->db->select('sum(con_item_transfer_details.con_item_transfer_details_qty) as po_quantity');
        $this->db->from('con_item_transfer_details');
        $this->db->where('con_item_transfer_details.con_item_request_details_id', $rid);
        $this->db->where('con_item_transfer_details.item_master_id', $id);
        $data = $this->db->get()->row();
        if ($data)
        {
            return $data->po_quantity;
        } else
        {
            return "";
        }
    }

    function get_category_by_commodity($id)
    {
        $this->db->select('item_category_id,item_category_name as category_name,item_master_tax');
        $this->db->from('item_master');
        $this->db->join('master', 'master.master_id=item_master.item_master_id');
        $this->db->join('item_category', 'item_category.item_category_id=item_master.item_master_category_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->where('item_master.item_master_id', $id);
        $this->db->order_by('item_master.item_master_id', 'desc');
        $data = $this->db->get()->row();
        return $data;
    }
    //function to get item category bu stock id
    function get_category_by_stock($id)
    {
        $stock=$this->mastermodel->get_data_srow('prop_item_stock',$id,'prop_item_stock_id');
        
        $data['item_id']=$stock->prop_item_id;
        $data['stock_qty']=$stock->prop_item_stock_qty;
        $data['godown']=$this->mastermodel->get_data_srow('godown',$stock->prop_godown_id,'godown_id');
        
        $this->db->select('item_category_id,item_category_name as category_name,item_master_tax');
        $this->db->from('item_master');
        $this->db->join('master', 'master.master_id=item_master.item_master_id');
        $this->db->join('item_category', 'item_category.item_category_id=item_master.item_master_category_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->where('item_master.item_master_id', $stock->prop_item_id);
        $this->db->order_by('item_master.item_master_id', 'desc');
        $data['category'] = $this->db->get()->row();
        return $data;
    }
    function get_po_rate_details($id)
    {
        $this->db->select('con_po_details_price');
        $this->db->from('con_po_details');
        $this->db->where('con_po_details.con_po_item', $id);
        $this->db->order_by('con_po_details.con_po_details_id', 'desc');
        $data = $this->db->get()->row();
        return $data;
    }

    function get_item_details($id)
    {
        $this->db->select('*');
        $this->db->from('item_master');
        $this->db->where('item_master_id', $id);
        $c_id = $this->db->get()->row();
//        price
        $data['price'] = $c_id->item_parchasing_rate;
//        category
        $this->db->select('item_category_name');
        $this->db->from('item_category');
        $this->db->where('item_category_id', $c_id->item_master_category_id);
        $data['cat'] = $this->db->get()->row();
//        type
        $this->db->select('item_type_name');
        $this->db->from('item_type');
        $this->db->where('item_type_id', $c_id->item_master_type_id);
        $data['type'] = $this->db->get()->row();
        return $data;
    }

    function check_budgeted($p_id)
    {
        $budget_id = $this->mastermodel->get_single_field_value('con_budgeting', 'con_budgeting_id', 'con_budgeting_project_id', $p_id);
        if (!empty($budget_id))
        {
            $this->db->select('item_master_id,item_master_name');
            $this->db->from('item_master');
            $this->db->join('con_budgeting_allotment', 'con_budgeting_allotment.con_budgeting_allotment_item_id= item_master.item_master_id');
            $this->db->where('con_budgeting_allotment_budject_id', $budget_id);
            $value['result'] = $this->db->get()->result();
            $value['item'] = 1;
            return $value;
        } else if (empty($budget_id))
        {
            $value['result'] = $this->mastermodel->select_data_by_id('item_master', 'project_id', $_SESSION['project_id'], 'item_master_id', 'item_master_id');
            $value['item'] = 0;
            return $value;
        }
    }

    function approve_item($postdata)
    {
        $this->db->trans_begin();
        $this->db->where('con_item_request_details_item_request_id', $postdata['con_item_request_id']);
        $this->db->delete('con_item_request_details');
        $i = 1;
        while (!empty($postdata['con_item_request_details_item_id' . $i]))
        {
            $details_id = $this->mastermodel->insertmasterdata();
            $Values = array(
                'con_item_request_details_id' => $details_id,
                'con_item_request_details_item_request_id' => $postdata['con_item_request_id'],
                'con_item_request_details_item_id' => $postdata['con_item_request_details_item_id' . $i],
                'con_item_request_details_category_id' => $postdata['con_item_request_details_category_id' . $i],
                'con_item_request_details_qty' => $postdata['con_item_request_details_qty' . $i],
                'con_item_request_details_remarks' => $postdata['con_item_request_details_remarks' . $i],
                'con_item_request_details_approval_qty' => $postdata['con_item_request_details_approval_qty' . $i],
                'con_item_request_details_approve_remarks' => $postdata['con_item_request_details_approve_remarks' . $i]
            );
            $this->db->insert('con_item_request_details', $Values);
            $i++;
        }
        
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = 'Error on adding record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = 'Record Updated  successfully';
            return $data;
        }
    }

    public function insert_purchase_order($postdata)
    {


        $this->db->trans_begin();

        $dcode = $this->mastermodel->get_ref('con_po_code', 'con_po', 'con_po_code');



        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'con_po_id' => $masterid,
            'con_po_code' => $dcode,
            'con_po_vendor_id' => $postdata['con_po_vendor_id'],
            'con_po_date' => $this->mastermodel->convert_date_format($postdata['con_po_date']),
            'con_po_remarks' => $postdata['con_po_remarks'],
            'con_po_total_amt' => $postdata['con_po_total_amt'],
            'con_po_ship_date' => $this->mastermodel->convert_date_format($postdata['con_po_ship_date']),
        );
        $output = $this->db->insert('con_po', $tblValues);

        for ($i = 0; $i < count($postdata['con_po_project_id']); $i++)
        {
            $projmasterid = $this->mastermodel->insertmasterdata();
            $tblValues = array(
                'con_po_project_id' => $projmasterid,
                'con_po_project_po_id' => $masterid,
                'con_po_project_project_id' => $postdata['con_po_project_id'][$i],
            );
            $output = $this->db->insert('con_po_project', $tblValues);
        }

        for ($i = 0; $i < count($postdata['con_po_item_req_id']); $i++)
        {
            $itemmasterid = $this->mastermodel->insertmasterdata();
            $tblValues = array(
                'con_po_item_req_id' => $itemmasterid,
                'con_po_item_req_po_id' => $masterid,
                'con_po_item_req_item_request_id' => $postdata['con_po_item_req_id'][$i],
            );
            $output = $this->db->insert('con_po_item_req', $tblValues);
        }

        $x = 1;
        while (isset($postdata['q_item_' . $x]))
        {

            $pomasterid = $this->mastermodel->insertmasterdata();
            $tblValues = array(
                'con_po_details_id' => $pomasterid,
                'con_po_details_po_id' => $masterid,
                'con_po_item' => $this->db->escape_str($postdata['q_item_' . $x]),
                'con_po_details_quantity' => $this->db->escape_str($postdata['q_reqqnty_' . $x]),
                'con_po_details_price' => $this->db->escape_str($postdata['q_price_' . $x]),
                'con_po_details_discount' => $this->db->escape_str($postdata['q_discount_' . $x]),
                'con_po_details_tax_per' => $this->db->escape_str($postdata['q_taxper_' . $x]),
                'con_po_details_tax_amt' => $this->db->escape_str($postdata['q_taxamt_' . $x]),
//                'work_type' => $this->db->escape_str($postdata['work_type_' . $x]),
                'con_po_details_total' => $this->db->escape_str($postdata['q_total_' . $x]),
                'item_request_details' => $this->db->escape_str($postdata['q_item_request_details_' . $x]),
            );
            $this->db->insert('con_po_details', $tblValues);
            if ($postdata['q_item_request_details_' . $x] != '')
            {
                $output = $this->db->query("UPDATE con_item_request_details SET po_completed_qty = po_completed_qty +" . $postdata['q_reqqnty_' . $x] . " WHERE con_item_request_details_id = " . $postdata['q_item_request_details_' . $x]);
            }

            $x++;
        }

        $output = $this->mastermodel->save_user_activities('Add C-PO',$masterid, 'con_po');  //ss


        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = 'Error on adding record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = 'Record Added  successfully';
            return $data;
        }
    }

    public function update_purchase_order($postdata)
    {


        $this->db->trans_begin();

        $tblValues = array(
            'con_po_vendor_id' => $postdata['con_po_vendor_id'],
            'con_po_date' => $this->mastermodel->convert_date_format($postdata['con_po_date']),
            'con_po_remarks' => $postdata['con_po_remarks'],
            'con_po_total_amt' => $postdata['con_po_total_amt'],
            'con_po_ship_date' => $this->mastermodel->convert_date_format($postdata['con_po_ship_date']),
        );
        $this->db->where('con_po_id', $postdata['con_po_id']);
        $output = $this->db->update('con_po', $tblValues);




        $x = 1;
        while (isset($postdata['q_item_' . $x]))
        {
            if ($postdata['q_item_' . $x] != '')
            {
                if ($postdata['status_' . $x] == 0)
                {
                    $prev_qnt = $this->mastermodel->get_single_field_value('con_po_details', 'con_po_details_quantity', 'con_po_details_id', $postdata['po_details_id_' . $x]);
                    $new_qnt[$x] = $postdata['q_reqqnty_' . $x] - $prev_qnt;

                    $tblValues = array(
                        'con_po_item' => $this->db->escape_str($postdata['q_item_' . $x]),
                        'con_po_details_quantity' => $this->db->escape_str($postdata['q_reqqnty_' . $x]),
                        'con_po_details_price' => $this->db->escape_str($postdata['q_price_' . $x]),
                        'con_po_details_discount' => $this->db->escape_str($postdata['q_discount_' . $x]),
                        'con_po_details_tax_per' => $this->db->escape_str($postdata['q_taxper_' . $x]),
                        'con_po_details_tax_amt' => $this->db->escape_str($postdata['q_taxamt_' . $x]),
//                'work_type' => $this->db->escape_str($postdata['work_type_' . $x]),
                        'con_po_details_total' => $this->db->escape_str($postdata['q_total_' . $x]),
                    );
                    $this->db->where('con_po_details_id', $postdata['po_details_id_' . $x]);
                    $this->db->update('con_po_details', $tblValues);
                    if ($postdata['q_item_request_details_' . $x] != '')
                    {
                        $output = $this->db->query("UPDATE con_item_request_details SET po_completed_qty = po_completed_qty +" . $new_qnt[$x] . " WHERE con_item_request_details_id = " . $postdata['q_item_request_details_' . $x]);
                    }
                } elseif ($postdata['status_' . $x] == 1)
                {
                    $pomasterid = $this->mastermodel->insertmasterdata();
                    $tblValues = array(
                        'con_po_details_id' => $pomasterid,
                        'con_po_details_po_id' => $postdata['con_po_id'],
                        'con_po_item' => $this->db->escape_str($postdata['q_item_' . $x]),
                        'con_po_details_quantity' => $this->db->escape_str($postdata['q_reqqnty_' . $x]),
                        'con_po_details_price' => $this->db->escape_str($postdata['q_price_' . $x]),
                        'con_po_details_discount' => $this->db->escape_str($postdata['q_discount_' . $x]),
                        'con_po_details_tax_per' => $this->db->escape_str($postdata['q_taxper_' . $x]),
                        'con_po_details_tax_amt' => $this->db->escape_str($postdata['q_taxamt_' . $x]),
                        'con_po_details_total' => $this->db->escape_str($postdata['q_total_' . $x]),
                        'item_request_details' => $this->db->escape_str($postdata['q_item_request_details_' . $x]),
                    );
                    $this->db->insert('con_po_details', $tblValues);
                    if ($postdata['q_item_request_details_' . $x] != '')
                    {
                        $output = $this->db->query("UPDATE con_item_request_details SET po_completed_qty = po_completed_qty +" . $postdata['q_reqqnty_' . $x] . " WHERE con_item_request_details_id = " . $postdata['q_item_request_details_' . $x]);
                    }
                } else
                {
                    $this->db->where('con_po_details_id', $postdata['po_details_id_' . $x]);
                    $this->db->delete('con_po_details');
                    $output = $this->db->query("UPDATE con_item_request_details SET po_completed_qty = po_completed_qty -" . $postdata['q_reqqnty_' . $x] . " WHERE con_item_request_details_id = " . $postdata['q_item_request_details_' . $x]);
                }

                $x++;
            }
        }
        $output = $this->mastermodel->save_user_activities('Edit C-PO',$postdata['con_po_id'], 'con_po');  //ss



        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = 'Error on adding record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = 'Record Updated  successfully';
            return $data;
        }
    }

    public function insert_purchase($postdata)
    {


        $this->db->trans_begin();
        
        $dcode = $this->mastermodel->get_ref('con_purchase_code', 'con_purchase', 'purchase_no');
        $masterid = $this->mastermodel->insertmasterdata();
        if ($postdata['con_po_management'] != '')
        {
            $po = $postdata['con_po_management'];
        } else
        {
            $po = NULL;
        }
        $ledger_id = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'ledger_book_id' => $ledger_id,
            'voucher_no' => $postdata['con_purchase_billno'],
            'voucher_date' => $this->mastermodel->convert_date_format($postdata['con_purchase_date']),
        );

        $output = $this->db->insert('ledger_book', $tblValues);
        $tblValues = array(
            'con_purchase_id' => $masterid,
            'purchase_no' => $dcode,
            'po_id' => $po,
            'vendor' => $postdata['con_purchase_vendor'],
            'bill_no' => $postdata['con_purchase_billno'],
            'po_date' => $this->mastermodel->convert_date_format($postdata['con_purchase_date']),
            'po_payment_term' => $postdata['con_purchase_type'],
            'po_remarks' => $postdata['con_purchase_remarks'],
            'po_amount' => $postdata['po_amount'],
            'po_ledger' => $ledger_id,
        );
        $upload_data = $this->mastermodel->upload_image('con_purchase_file');

        if (!empty($upload_data['file_name']))
        {
            $tblValues['purchase_file'] = $upload_data['file_name'];
        }


        $output = $this->db->insert('con_purchase', $tblValues);

          if($postdata['con_purchase_type']=='Credit')
        {
           
          
        $ret = $this->accountingmodel->get_accountmaster_id('vendor', 'vendor_id', 'vendor_ledger', $postdata['con_purchase_vendor']);
        $ret_name = $this->mastermodel->get_single_field_value('vendor', 'vendor_name', 'vendor_id', $postdata['con_purchase_vendor']);

        $x = 1;
        $sum = $postdata['po_amount'] - $postdata['invoice_discount'];

        $tblValues_led = array(
            'ledger_book_id' => $ledger_id,
            'account_ledger_id' => $ret,
            'credit' => $sum,
        );
        $output = $this->db->insert('ledger_book_details', $tblValues_led);
        $cdet_id = $this->db->insert_id();
        }
         else{
            $cash_account=  $this->get_account_settings('cash_account');
            $x = 1;
            $sum = $postdata['po_amount'] - $postdata['invoice_discount'];

            $tblValues_led = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $cash_account,
                'credit' => $sum,
            );
            $output = $this->db->insert('ledger_book_details', $tblValues_led);
            $cdet_id = $this->db->insert_id();
         }
        while (isset($postdata['q_item_' . $x]))
        {

            $item[$x] = $this->db->escape_str($postdata['q_item_id_' . $x]);
            $item_id[$x] = $this->db->escape_str($postdata['q_item_' . $x]);

            $quantity[$x] = $this->db->escape_str($postdata['q_qnty_' . $x]);
            $price[$x] = $this->db->escape_str($postdata['q_price_' . $x]);
            $discount[$x] = $this->db->escape_str($postdata['q_discount_' . $x]);

            $costcentre[$x] = $this->db->escape_str($postdata['q_costcentre_' . $x]);
            $total[$x] = $this->db->escape_str($postdata['q_total_' . $x]);
            $item_request_details[$x] = $this->db->escape_str($postdata['q_item_request_details_' . $x]);
            $po_details_id[$x] = $this->db->escape_str($postdata['po_details_id_' . $x]);
            $commodity_ledger_id[$x] = $this->db->escape_str($postdata['ledger_id_' . $x]);
            $godown_id[$x] = $this->db->escape_str($postdata['godown_' . $x]);
            $taxper[$x] = $this->db->escape_str($postdata['q_taxper_' . $x]);
            $taxamt[$x] = $this->db->escape_str($postdata['q_taxamt_' . $x]);
            $x++;
        }
        $discount_sum = 0;
        $i = 1;
        $disc = $this->accountingmodel->get_account_settings('purchase_discounts');
        while ($x != 1)
        {

            $stock_master = $this->propertymodel->get_search_stockmaster($item_id[$i], $godown_id[$i],$price[$i]);
            $prop_item_stock_id = 0;

            if (!empty($stock_master))
            {

                $prop_item_stock_id = $stock_master->prop_item_stock_id;
                $new_qnt = $stock_master->prop_item_stock_qty + $quantity[$i];
                $tblValues = array(
                    'prop_item_id' => $item_id[$i],
                    'prop_godown_id' => $godown_id[$i],
                    'prop_item_stock_qty' => $new_qnt,
                    'price' => $price[$i],
                    'discount' => $discount[$i],
                    'total' => $new_qnt * $price[$i],
                     'stock_date' => $this->mastermodel->convert_date_format($postdata['con_purchase_date']),
                );
                $this->db->where('prop_item_stock_id', $prop_item_stock_id);
                $output = $this->db->update('prop_item_stock', $tblValues);
            } else
            {
                $prop_item_stock_id = $this->mastermodel->insertmasterdata();
                $addtblValues = array(
                    'prop_item_stock_id' => $prop_item_stock_id,
                    'prop_item_id' => $item_id[$i],
                    'prop_godown_id' => $godown_id[$i],
                    'prop_item_stock_qty' => $quantity[$i],
                    'price' => $price[$i],
                    'discount' => $discount[$i],
                    'total' => $total[$i],
                      'stock_date' => $this->mastermodel->convert_date_format($postdata['con_purchase_date']),
                );
                $this->db->insert('prop_item_stock', $addtblValues);
            }
            $query = $this->db->query("insert into con_purchase_details(`con_purchase_id`, `headoffice_stock`, `stock_item`,  `quantity`, `price`, `discount`,  `total`,`item_request_details`,`item`,`costcentre`,`po_details`,`godown_id`,`taxper`,`taxamt`) values ('$masterid', $prop_item_stock_id,'$item[$i]','$quantity[$i]','$price[$i]','$discount[$i]','$total[$i]','$item_request_details[$i]','$item_id[$i]','$costcentre[$i]','$po_details_id[$i]',' $godown_id[$i]','$taxper[$i]','$taxamt[$i]')");
            if (!empty($po_details_id[$i]))
            {
                $output = $this->db->query("UPDATE con_po_details SET purchase_quantity = purchase_quantity +" . $quantity[$i] . " WHERE con_po_details_id = " . $po_details_id[$i]);
            }




            $tblValues = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $commodity_ledger_id[$i],
                'debit' => $total[$i],
            );
            $output = $this->db->insert('ledger_book_details', $tblValues);
            $det_id = $this->db->insert_id();
            $credit = 0;
            $debit = $total[$i];

            $tblValues = array(
                'ledger_book_details' => $det_id,
                'ref_ledger' => $costcentre[$i],
                'ref_amount' => $total[$i],
                'credit' => $credit,
                'debit' => $debit,
            );
            $output = $this->db->insert('ledger_book_reference', $tblValues);

            $discount_sum = $discount_sum + $discount[$i];
            $x--;
            $i++;
        }
        if ($postdata['invoice_discount'] != "0")
        {
            $tblValues = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $disc,
                'credit' => $postdata['invoice_discount'],
            );
            $output = $this->db->insert('ledger_book_details', $tblValues);
        }
        $output = $this->mastermodel->save_user_activities('Add C-Purchase',$masterid, 'con_purchase');  //ss
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_purchase($postdata)
    {


        $this->db->trans_begin();
        if ($postdata['con_po_management'] != '')
        {
            $po = $postdata['con_po_management'];
        } else
        {
            $po = NULL;
        }

        $tblValues = array(
            'voucher_no' => $postdata['con_purchase_billno'],
            'voucher_date' => $this->mastermodel->convert_date_format($postdata['con_purchase_date']),
        );
        $this->db->where('ledger_book_id', $postdata['ledger_book_id']);
        $output = $this->db->update('ledger_book', $tblValues);



        $tblValues = array(
            'bill_no' => $postdata['con_purchase_billno'],
            'po_date' => $this->mastermodel->convert_date_format($postdata['con_purchase_date']),
//            'po_payment_term' => $postdata['con_purchase_type'],
            'po_remarks' => $postdata['con_purchase_remarks'],
            'po_amount' => $postdata['po_amount'],
        );

        $upload_data = $this->mastermodel->upload_image('con_purchase_file');
        if (!empty($upload_data['file_name']))
        {
            $tblValues['purchase_file'] = $upload_data['file_name'];
        }

        $this->db->where('con_purchase_id', $postdata['con_purchase_id']);
        $output = $this->db->update('con_purchase', $tblValues);

        $masterid = $postdata['con_purchase_id'];
        $ledger_id = $postdata['ledger_book_id'];
        $pid = $this->db->query("select ledger_book_details_id from ledger_book_details where ledger_book_id='$ledger_id'order by ledger_book_details_id desc");
        $result = $pid->result();
        if (!empty($result))
        {
            foreach ($result as $value)
            {
                $pdetid = $value->ledger_book_details_id;
                $this->db->where('ledger_book_reference.ledger_book_details', $pdetid);
                $output = $this->db->delete('ledger_book_reference');
            }
        }

        $this->db->where('ledger_book_id', $postdata['ledger_book_id']);
        $this->db->delete('ledger_book_details');
        
        if($postdata['con_purchase_type']=='Credit') {
           
        $ret = $this->accountingmodel->get_accountmaster_id('vendor', 'vendor_id', 'vendor_ledger', $postdata['con_purchase_vendor']);
        $ret_name = $this->mastermodel->get_single_field_value('vendor', 'vendor_name', 'vendor_id', $postdata['con_purchase_vendor']);

        $x = 1;
        $sum = $postdata['po_amount'] - $postdata['invoice_discount'];

        $tblValues_led = array(
            'ledger_book_id' => $ledger_id,
            'account_ledger_id' => $ret,
            'credit' => $sum,
        );
        $output = $this->db->insert('ledger_book_details', $tblValues_led);
        $cdet_id = $this->db->insert_id();
        }
         else{
            $cash_account=  $this->get_account_settings('cash_account');
            $x = 1;
            $sum = $postdata['po_amount'] - $postdata['invoice_discount'];

            $tblValues_led = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $cash_account,
                'credit' => $sum,
            );
            $output = $this->db->insert('ledger_book_details', $tblValues_led);
            $cdet_id = $this->db->insert_id();
         }
        
        $discount_sum = 0;
        $x = 1;
        $disc = $this->accountingmodel->get_account_settings('purchase_discounts');
        while (isset($postdata['q_item_' . $x]))
        {

            if ($postdata['q_item_' . $x] != '')
            {
                if(!empty($postdata['prev_q_qnty_' . $x])){
                    $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty -' . $postdata['prev_q_qnty_' . $x], false)
                             ->set('total',  'prop_item_stock_qty * price' ,false);
                    $this->db->where('prop_item_stock_id', $postdata['stock_id_'.$x]);
                    $this->db->update('prop_item_stock');
                    
                    
                     $output = $this->db->query("UPDATE con_po_details SET purchase_quantity = purchase_quantity -" . $postdata['prev_q_qnty_' . $x]. " WHERE con_po_details_id = " . $postdata['po_details_' . $x]);
                }
                if ($postdata['status_' . $x] == 0)
                {
                    $stock_master = $this->propertymodel->get_search_stockmaster($postdata['q_item_' . $x],$postdata['godown_'.$x],$postdata['q_price_'. $x]);
                    $prop_item_stock_id = 0;

                    if (!empty($stock_master))
                        {

                            $prop_item_stock_id = $stock_master->prop_item_stock_id;

                        }
                        if($prop_item_stock_id==0){
                            
                             $prop_item_stock_id = $this->mastermodel->insertmasterdata();
                        $tblValues = array(
                            'prop_item_stock_id	' => $prop_item_stock_id,
                            'prop_item_id' => $postdata['q_item_' . $x],
                            'prop_item_stock_qty' => $postdata['q_qnty_' . $x],
                            'price' => $postdata['q_price_' . $x],
                            'prop_godown_id' => $postdata['godown_' . $x],
                            'discount' => $postdata['q_discount_' . $x],
                            'total' => $postdata['q_price_' . $x] * $postdata['q_qnty_' . $x],
                              'stock_date' => $this->mastermodel->convert_date_format($postdata['con_purchase_date']),
                        );
                        $this->db->insert('prop_item_stock', $tblValues);
                        }
                        else{
                             $stock_quantity= $stock_master->prop_item_stock_qty;
                             $updated_qty=$stock_quantity+$postdata['q_qnty_' . $x];
                            $tblValues = array(
                        'prop_item_stock_qty' =>  $updated_qty,
                        'price' => $postdata['q_price_' . $x],
                        'discount' => $postdata['q_discount_' . $x],
                        'total' => $postdata['q_price_' . $x] * $updated_qty,
                          'stock_date' => $this->mastermodel->convert_date_format($postdata['con_purchase_date']),
                    );
                    $this->db->where('prop_item_stock_id', $prop_item_stock_id);
                    $output = $this->db->update('prop_item_stock', $tblValues); 
                        }
                   
                    $output = $this->db->query("UPDATE con_po_details SET purchase_quantity = purchase_quantity +" . $postdata['q_qnty_' . $x] . " WHERE con_po_details_id = " . $postdata['po_details_' . $x]);
                    $tblValues = array(
                        'stock_item' => $postdata['q_item_id_' . $x],
                        'quantity' => $postdata['q_qnty_' . $x],
                        'price' => $postdata['q_price_' . $x],
                        'discount' => $postdata['q_discount_' . $x],
                        'total' => $postdata['q_total_' . $x],
                        'headoffice_stock'=> $prop_item_stock_id,                       
                        'item_request_details' => $postdata['item_request_details_' . $x],
                        'item' => $postdata['q_item_' . $x],
                        'costcentre' => $postdata['q_costcentre_' . $x],
                        'godown_id' => $postdata['godown_' . $x],
                        'taxper' => $postdata['q_taxper_' . $x],
                        'taxamt' => $postdata['q_taxamt_' . $x],
                    );
                    $this->db->where('con_purchase_details_id', $postdata['con_purchase_details_id_' . $x]);
                    $this->db->update('con_purchase_details', $tblValues);
                } elseif ($postdata['status_' . $x] == 1)
                {
                    $stock_master = $this->propertymodel->get_search_stockmaster($postdata['q_item_' . $x],$postdata['godown_'.$x],$postdata['q_price_'. $x]);
                    $prop_item_stock_id = 0;

                    if (!empty($stock_master))
                        {

                            $prop_item_stock_id = $stock_master->prop_item_stock_id;

                        }
                        if($prop_item_stock_id==0){
                            
                             $prop_item_stock_id = $this->mastermodel->insertmasterdata();
                        $tblValues = array(
                            'prop_item_stock_id	' => $prop_item_stock_id,
                            'prop_item_id' => $postdata['q_item_' . $x],
                            'prop_item_stock_qty' => $postdata['q_qnty_' . $x],
                            'price' => $postdata['q_price_' . $x],
                            'prop_godown_id' => $postdata['godown_' . $x],
                            'discount' => $postdata['q_discount_' . $x],
                            'total' => $postdata['q_price_' . $x] * $postdata['q_qnty_' . $x],
                              'stock_date' => $this->mastermodel->convert_date_format($postdata['con_purchase_date']),
                        );
                        $this->db->insert('prop_item_stock', $tblValues);
                        }
                        else{
                             $stock_quantity= $stock_master->prop_item_stock_qty;
                             $updated_qty=$stock_quantity+$postdata['q_qnty_' . $x];
                            $tblValues = array(
                        'prop_item_stock_qty' =>  $updated_qty,
                        'price' => $postdata['q_price_' . $x],
                        'discount' => $postdata['q_discount_' . $x],
                        'total' => $postdata['q_price_' . $x] * $updated_qty,
                          'stock_date' => $this->mastermodel->convert_date_format($postdata['con_purchase_date']),
                    );
                    $this->db->where('prop_item_stock_id', $prop_item_stock_id);
                    $output = $this->db->update('prop_item_stock', $tblValues); 
                        }
                    $tblValues = array(
                        'con_purchase_id' => $masterid,
                        'headoffice_stock' => $prop_item_stock_id,
                        'stock_item' => $postdata['q_item_id_' . $x],
                        'quantity' => $postdata['q_qnty_' . $x],
                        'price' => $postdata['q_price_' . $x],
                        'discount' => $postdata['q_discount_' . $x],
                        'total' => $postdata['q_total_' . $x],
                        'item_request_details' => $postdata['item_request_details_' . $x],
                        'item' => $postdata['q_item_' . $x],
                        'costcentre' => $postdata['q_costcentre_' . $x],
                        'po_details' => $postdata['po_details_' . $x],
                        'godown_id' => $postdata['godown_' . $x],
                        'taxper' => $postdata['q_taxper_' . $x],
                        'taxamt' => $postdata['q_taxamt_' . $x],
                    );
                    $this->db->insert('con_purchase_details', $tblValues);
                    if (!empty($postdata['po_details_' . $x]))
                    {
                        $output = $this->db->query("UPDATE con_po_details SET purchase_quantity = purchase_quantity +" . $postdata['q_qnty_' . $x] . " WHERE con_po_details_id = " . $postdata['po_details_' . $x]);
                    }
                } else
                {
                   
                    $this->db->where('con_purchase_details_id', $postdata['con_purchase_details_id_' . $x]);
                    $this->db->delete('con_purchase_details');
                }

                $tblValues = array(
                    'ledger_book_id' => $ledger_id,
                    'account_ledger_id' => $postdata['ledger_id_' . $x],
                    'debit' => $postdata['q_total_' . $x],
                );
                $output = $this->db->insert('ledger_book_details', $tblValues);
                $det_id = $this->db->insert_id();
                $credit = 0;
                $debit = $postdata['q_total_' . $x];

                $tblValues = array(
                    'ledger_book_details' => $det_id,
                    'ref_ledger' => $postdata['q_costcentre_' . $x],
                    'ref_amount' => $postdata['q_total_' . $x],
                    'credit' => $credit,
                    'debit' => $debit,
                );
                $output = $this->db->insert('ledger_book_reference', $tblValues);
                $discount_sum = $discount_sum + $postdata['q_discount_' . $x];

                $x++;
            }
        }

        if ($postdata['invoice_discount'] != "0")
        {
            $tblValues = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $disc,
                'credit' => $postdata['invoice_discount'],
            );
            $output = $this->db->insert('ledger_book_details', $tblValues);
        }
        $output = $this->mastermodel->save_user_activities('Edit C-Purchase',$postdata['con_purchase_id'], 'con_purchase');  //ss
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    function get_item_request_from_site()
    {

        $qury = $this->db->query("SELECT * ,con_project.con_project_name as name 
            FROM `con_item_request`
            JOIN `con_project` ON `con_item_request`.`con_item_request_project` = `con_project`.`con_project_id`
            WHERE `con_item_request`.`con_item_request_id` IN (
                            SELECT  `con_item_request`.`con_item_request_id` 
                            FROM `con_item_request`
                            INNER JOIN `con_item_request_details` ON `con_item_request`.`con_item_request_id` = `con_item_request_details`.`con_item_request_details_item_request_id`
        
                            WHERE `po_completed_qty` < `con_item_request_details_qty`) 
                            order by `con_item_request`.`con_item_request_id` DESC ");

        $data = $qury->result();
//        echo $this->db->last_query();
        return $data;
    }

    function search_work_order()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('con_work_order');
        $this->db->join('master', 'master.master_id=con_work_order.con_work_order_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('con_work_order_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_work_order($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $CWO_code = $this->mastermodel->get_ref('con_work_order_code', 'con_work_order', 'con_work_order_code');
        $tblValues = array(
            'con_work_order_id' => $masterid,
            'con_work_order_code' => $CWO_code,
            'con_work_order_date' => $this->mastermodel->convert_date_format($postdata['con_work_order_date']),
            'con_work_order_customer_id' => $postdata['con_work_order_customer_id'],
            'con_work_order_quotation_id' => $postdata['con_work_order_quotation_id'],
            'con_work_order_delivery_date' => $this->mastermodel->convert_date_format($postdata['con_work_order_delivery_date']),
            'con_work_order_address' => $postdata['con_work_order_address'],
            'con_work_order_delevery_address' => $postdata['con_work_order_delevery_address'],
            'con_work_order_status' => $postdata['con_work_order_status'],
            'con_work_order_status_reason' => $postdata['con_work_order_status_reason'],
            'con_work_order_project_id' => $postdata['con_work_order_project_id'],
            'con_work_order_total' => $postdata['con_work_order_total']
        );
        $this->db->insert('con_work_order', $tblValues);

        $i = 1;
        while (!empty($postdata['con_workorder_details_item_id' . $i]))
        {
            $detailsid = $this->mastermodel->insertmasterdata();
            $Values = array(
                'con_workorder_details_id' => $detailsid,
                'con_workorder_details_workoder_id' => $masterid,
                'con_workorder_details_item_id' => $postdata['con_workorder_details_item_id' . $i],
                'con_workorder_details_qty' => $postdata['con_workorder_details_qty' . $i],
                'con_workorder_details_price' => $postdata['con_workorder_details_price' . $i],
                'con_workorder_details_tax_perc' => $postdata['con_workorder_details_tax_perc' . $i],
                'con_workorder_details_tax_amount' => $postdata['con_workorder_details_tax_amount' . $i],
                'con_workorder_details_total' => $postdata['con_workorder_details_total' . $i]
            );
            $this->db->insert('con_workorder_details', $Values);
            $i++;
        }

        $i = 1;
        while (!empty($postdata['con_workorder_payment_term_id' . $i]))
        {
            $paymentid = $this->mastermodel->insertmasterdata();
            $Values = array(
                'con_workorder_payment_id' => $paymentid,
                'con_workorder_payment_work_order_id' => $masterid,
                'con_workorder_payment_term_id' => $postdata['con_workorder_payment_term_id' . $i],
                'con_workorder_payment_date' => $this->mastermodel->convert_date_format($postdata['con_workorder_payment_date' . $i]),
                'con_workorder_payment_percentage' => $postdata['con_workorder_payment_percentage' . $i],
                'con_workorder_payment_amount' => $postdata['con_workorder_payment_amount' . $i],
                'con_workorder_payment_status' => $postdata['con_workorder_payment_status' . $i],
                'con_workorder_payment_remarks' => $postdata['con_workorder_payment_remarks' . $i]
            );
            $this->db->insert('con_workorder_payment', $Values);
            $i++;
        }
        $output = $this->mastermodel->save_user_activities('Add C-Wrok Order',$masterid, 'con_work_order');  //ss

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_work_order($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'con_work_order_delivery_date' => $this->mastermodel->convert_date_format($postdata['con_work_order_delivery_date']),
            'con_work_order_status' => $postdata['con_work_order_status'],
            'con_work_order_status_reason' => $postdata['con_work_order_status_reason'],
            'con_work_order_project_id' => $postdata['con_work_order_project_id'],
            'con_work_order_total' => $postdata['con_work_order_total']
        );
        $this->db->where('con_work_order_id', $postdata['con_work_order_id']);
        $this->db->update('con_work_order', $tblValues);

        $this->db->where('con_workorder_details_workoder_id', $postdata['con_work_order_id']);
        $this->db->delete('con_workorder_details');

        $i = 1;
        while (!empty($postdata['con_workorder_details_item_id' . $i]))
        {
            $detailsid = $this->mastermodel->insertmasterdata();
            $dValues = array(
                'con_workorder_details_id' => $detailsid,
                'con_workorder_details_workoder_id' => $postdata['con_work_order_id'],
                'con_workorder_details_item_id' => $postdata['con_workorder_details_item_id' . $i],
                'con_workorder_details_qty' => $postdata['con_workorder_details_qty' . $i],
                'con_workorder_details_price' => $postdata['con_workorder_details_price' . $i],
                'con_workorder_details_tax_perc' => $postdata['con_workorder_details_tax_perc' . $i],
                'con_workorder_details_tax_amount' => $postdata['con_workorder_details_tax_amount' . $i],
                'con_workorder_details_total' => $postdata['con_workorder_details_total' . $i]
            );
            $this->db->insert('con_workorder_details', $dValues);
            $i++;
        }

        $this->db->where('con_workorder_payment_work_order_id', $postdata['con_work_order_id']);
        $this->db->delete('con_workorder_payment');

        $i = 1;
        while (!empty($postdata['con_workorder_payment_term_id' . $i]))
        {
            $detailsid = $this->mastermodel->insertmasterdata();
            $dValues = array(
                'con_workorder_payment_id' => $detailsid,
                'con_workorder_payment_work_order_id' => $postdata['con_work_order_id'],
                'con_workorder_payment_term_id' => $postdata['con_workorder_payment_term_id' . $i],
                'con_workorder_payment_date' => $this->mastermodel->convert_date_format($postdata['con_workorder_payment_date' . $i]),
                'con_workorder_payment_percentage' => $postdata['con_workorder_payment_percentage' . $i],
                'con_workorder_payment_amount' => $postdata['con_workorder_payment_amount' . $i],
                'con_workorder_payment_status' => $postdata['con_workorder_payment_status' . $i],
                'con_workorder_payment_remarks' => $postdata['con_workorder_payment_remarks' . $i]
            );
            $this->db->insert('con_workorder_payment', $dValues);
            $i++;
        }
        $output = $this->mastermodel->save_user_activities('Edit C-Wrok Order',$postdata['con_work_order_id'], 'con_work_order');  //ss

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    function search_client_payment_details()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('client_payment_term');
        $this->db->join('master', 'master.master_id=client_payment_term.payment_term_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('payment_term_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_client_payment_details($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'payment_term_id' => $masterid,
            'payment_term_name' => $postdata['payment_term_name'],
            'payment_term_description' => $postdata['payment_term_description']
        );
        $this->db->insert('client_payment_term', $tblValues);

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_client_payment_details($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'payment_term_name' => $postdata['payment_term_name'],
            'payment_term_description' => $postdata['payment_term_description']
        );
        $this->db->where('payment_term_id', $postdata['payment_term_id']);
        $this->db->update('client_payment_term', $tblValues);

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    function get_customer_data($c_id)
    {
        $data['address'] = $this->mastermodel->get_single_field_value('contact', 'contact_official_location', 'contact_id', $c_id);
        $data['quotation'] = $this->mastermodel->select_data_by_id('con_quotation', 'con_quotation_customer', $c_id);
        $data['project'] = $this->mastermodel->select_data_by_id('con_project', 'con_project_customer_id', $c_id);
        return $data;
    }

    function get_quoitem($q_id)
    {
        $this->db->select('*');
        $this->db->from('con_quotation_item');
        $this->db->where('con_quotation_item.con_quotation_item_quotation_id', $q_id);
        $this->db->join('item_master', 'item_master.item_master_id=con_quotation_item.con_quotation_item_item_id');
        $result = $this->db->get()->result();
        return $result;
    }

    function search_purchase()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('con_purchase');
        $this->db->join('master', 'master.master_id=con_purchase.con_purchase_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('con_purchase_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    function get_pomanagement_by_vendor($id)
    {
        $this->db->select('*');
        $this->db->from('con_po');
        $this->db->where('con_po.con_po_id in', '(SELECT  `con_po`.`con_po_id` 
                            FROM `con_po`
                            INNER JOIN `con_po_details` ON `con_po`.`con_po_id` = `con_po_details`.`con_po_details_po_id`
        
                            WHERE `purchase_quantity` < `con_po_details_quantity`)', false);
        $this->db->order_by('con_po.con_po_id', 'desc');
        $this->db->where('con_po.con_po_vendor_id', $id);
        $this->db->where('con_po.po_manager_approval', 1);
        $this->db->where('con_po.po_gm_approval', 1);
        $data = $this->db->get()->result();
        return $data;
    }

    function get_po_by_id($id)
    {
        $this->db->select('*');
        $this->db->from('con_po');
        $this->db->where('con_po.con_po_id', $id);
        $data = $this->db->get()->row();
        return $data;
    }

    function get_po_det($id)
    {
        $this->db->select('*');
        $this->db->from('con_po_details');
        $this->db->where('con_po_details.con_po_details_po_id', $id);
        $this->db->order_by('con_po_details.con_po_details_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }

    function get_costcentre_by_requset($id)
    {
        $this->db->select('*');
        $this->db->from('con_item_request_details');
        $this->db->join('con_item_request', 'con_item_request_details.con_item_request_details_item_request_id=con_item_request.con_item_request_id', 'left');
        $this->db->join('con_project', 'con_item_request.con_item_request_project=con_project.con_project_id', 'left');
        $this->db->join('cost_centre_ledger', 'cost_centre_ledger.ledger_id=con_project.ledger', 'left');
        $this->db->where('con_item_request_details.con_item_request_details_id', $id);
        $this->db->order_by('con_item_request.con_item_request_id', 'desc');
        $data = $this->db->get()->row();
        return $data;
    }

   

    function get_search_category($val)
    {
        $this->db->select('item_category_id as id,item_category_name');
        $this->db->from('item_category');
        $this->db->join('master', 'master.master_id=item_category.item_category_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->like('item_category.item_category_name', $val);
        $this->db->order_by('item_category.item_category_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }

    function get_commoditymaster_by_category($id, $val)
    {
        $this->db->select('item_master_id as id,item_master_name,item_master_code');
        $this->db->from('item_master');
        $this->db->join('master', 'master.master_id=item_master.item_master_id');

        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->where('item_master.item_master_category_id', $id);
        $this->db->like('item_master.item_master_name', $val);
        $this->db->order_by('item_master.item_master_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }

    function search_item_transfer()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('con_item_transfer');
        $this->db->join('master', 'master.master_id=con_item_transfer.con_item_transfer_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('con_item_transfer_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    function insert_item_transfer($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $item_transfer_code = $this->mastermodel->get_ref('con_item_transfer_code', 'con_item_transfer', 'con_item_transfer_code');
        $tblValues = array(
            'con_item_transfer_id' => $masterid,
            'con_item_transfer_code' => $item_transfer_code,
            'con_item_transfer_date' => $this->mastermodel->convert_date_format($postdata['con_item_transfer_date']),
            'con_item_transfer_project' => $postdata['con_item_transfer_project'],
            'con_item_transfer_remarks' => $postdata['con_item_transfer_remarks'],
        );
        $this->db->insert('con_item_transfer', $tblValues);
        for ($j = 0; $j < count($postdata['con_item_request_id']); $j++)
        {
            $itemmasterid = $this->mastermodel->insertmasterdata();
            $tblValues = array(
                'con_item_transfer_request_id' => $itemmasterid,
                'con_item_transfer_id' => $masterid,
                'con_item_request_id' => $postdata['con_item_request_id'][$j],
            );
            $output = $this->db->insert('con_item_transfer_request', $tblValues);
        }
        $i = 1;
        while (isset($postdata['q_item_' . $i]))
        {
            $stock_detailes = $this->mastermodel->get_data_srow('prop_item_stock',$postdata['q_stock_item_'. $i],'prop_item_stock_id');
      
            
            $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty -' . $postdata['con_item_transfer_details_qty_' . $i], false);
            $this->db->where('prop_item_stock_id', $postdata['q_stock_item_' . $i]);
            $this->db->update('prop_item_stock');
            
            $this->db->select('*');
            $this->db->from('prop_item_stock');
            $this->db->where('prop_item_id', $postdata['q_item_'.$i]);
            $this->db->where('price', $stock_detailes->price);
            $this->db->where('prop_godown_id', $postdata['con_to_godown_'.$i]);
            $count = $this->db->count_all_results();
            
            if ($count > 0) {
                $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty +' . $postdata['con_item_transfer_details_qty_' . $i], false);
                $this->db->set('stock_date', $this->mastermodel->convert_date_format($postdata['con_item_transfer_date']));
                $this->db->set('total', 'prop_item_stock_qty * price', false);
             
                $this->db->where('prop_item_id',$postdata['q_item_' . $i]);
                $this->db->where('price', $stock_detailes->price);
                $this->db->where('prop_godown_id', $postdata['con_to_godown_'.$i]);
                $this->db->update('prop_item_stock');
                $stock_master = $this->propertymodel->get_search_stockmaster($stock_detailes->prop_item_id,$postdata['con_to_godown_'.$i],$stock_detailes->price);
                if (!empty($stock_master)){
                    $prop_item_stock_id = $stock_master->prop_item_stock_id;
            
                     }
                } 
                else {
                    $prop_item_stock_id = $this->mastermodel->insertmasterdata();
                    $addtblValues = array(
                         'prop_item_stock_id'=>$prop_item_stock_id,
                        'prop_item_id' => $stock_detailes->prop_item_id,
                        'price' => $stock_detailes->price,
                        'total' => $stock_detailes->price * $postdata['con_item_transfer_details_qty_' . $i],
                        'prop_godown_id' => $postdata['con_to_godown_'. $i],
                        'prop_item_stock_qty' => $postdata['con_item_transfer_details_qty_' . $i],
                        'stock_date' => $this->mastermodel->convert_date_format($postdata['con_item_transfer_date'])
                    );
                $this->db->insert('prop_item_stock', $addtblValues);
//                $prop_item_stock_id =  $this->db->insert_id();
                }
            $sub_masterid = $this->mastermodel->insertmasterdata();
            $sub_tblValues = array(
                'con_item_transfer_details_id' => $sub_masterid,
                'con_item_transfer_id' => $masterid,
                'con_item_request_id' => $postdata['con_item_request_id_' . $i],
                'con_item_request_details_id' => $postdata['q_item_request_details_' . $i],
                'item_master_id' => $postdata['q_item_' . $i],
                'con_from_godown' => $postdata['con_from_godown_' . $i],
                'con_to_godown' => $postdata['con_to_godown_' . $i],
                'con_item_transfer_details_qty' => $postdata['con_item_transfer_details_qty_' . $i],
                'con_item_transfer_details_remarks' => $postdata['con_item_transfer_details_remarks_' . $i],
                'stock_id'=>$prop_item_stock_id,
                'from_stock_id'=>$postdata['q_stock_item_'. $i],
            );
            $this->db->insert('con_item_transfer_details', $sub_tblValues);


            $i++;
        }
        $output = $this->mastermodel->save_user_activities('Add C-Item Transfer',$masterid, 'con_item_transfer');  //ss
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    function update_item_transfer($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'con_item_transfer_date' => $this->mastermodel->convert_date_format($postdata['con_item_transfer_date']),
            'con_item_transfer_remarks' => $postdata['con_item_transfer_remarks'],
        );
        $this->db->where('con_item_transfer_id', $postdata['con_item_transfer_id']);
        $output = $this->db->update('con_item_transfer', $tblValues);

        $masterid = $postdata['con_item_transfer_id'];
//       
        $this->db->where('con_item_transfer_id',$postdata['con_item_transfer_id']);
        $this->db->delete('con_item_transfer_details');
        $x = 1;
        while (isset($postdata['q_item_' . $x]))
        {
            if ($postdata['q_item_' . $x] != '')
            {   
                if(empty($postdata['previus_qty_'. $x])){
                    $postdata['previus_qty_'. $x]=0;
                }
                
                $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty +' . $postdata['previus_qty_'. $x], false);
                $this->db->where('prop_item_stock_id', $postdata['q_item_' . $x]);
                $this->db->update('prop_item_stock');
            
                $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty -' . $postdata['previus_qty_'. $x], false);
                $this->db->where('prop_item_stock_id', $postdata['stock_id_' . $x]);
                $this->db->update('prop_item_stock');
            
                if ($postdata['status_' . $x] == 0 || $postdata['status_' . $x] == 1  )
                {
            $stock_detailes = $this->mastermodel->get_data_srow('prop_item_stock',$postdata['q_item_'. $x],'prop_item_stock_id');
      
            
            $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty -' . $postdata['q_reqqnty_' . $x], false);
            $this->db->where('prop_item_stock_id', $postdata['q_item_' . $x]);
            $this->db->update('prop_item_stock');
            
            $this->db->select('*');
            $this->db->from('prop_item_stock');
            $this->db->where('prop_item_id', $stock_detailes->prop_item_id);
            $this->db->where('price', $stock_detailes->price);
            $this->db->where('prop_godown_id', $postdata['con_to_godown_'.$x]);
            $count = $this->db->count_all_results();
            
            if ($count > 0) {
                $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty +' . $postdata['q_reqqnty_' . $x], false);
                $this->db->set('stock_date', $this->mastermodel->convert_date_format($postdata['con_item_transfer_date']));
                $this->db->set('total', 'prop_item_stock_qty * price', false);
             
                $this->db->where('prop_item_id',$stock_detailes->prop_item_id);
                $this->db->where('price', $stock_detailes->price);
                $this->db->where('prop_godown_id', $postdata['con_to_godown_'.$x]);
                $this->db->update('prop_item_stock');
                $stock_master = $this->propertymodel->get_search_stockmaster($stock_detailes->prop_item_id,$postdata['con_to_godown_'.$x],$stock_detailes->price);
                if (!empty($stock_master)){
                    $prop_item_stock_id = $stock_master->prop_item_stock_id;
            
                     }
                } 
                else {
                    $prop_item_stock_id = $this->mastermodel->insertmasterdata();
                    $addtblValues = array(
                         'prop_item_stock_id'=>$prop_item_stock_id,
                        'prop_item_id' => $stock_detailes->prop_item_id,
                        'price' => $stock_detailes->price,
                        'total' => $stock_detailes->price * $postdata['con_item_transfer_details_qty_' . $x],
                        'prop_godown_id' => $postdata['con_to_godown_'. $x],
                        'prop_item_stock_qty' => $postdata['q_qnty_' . $x],
                        'stock_date' => $this->mastermodel->convert_date_format($postdata['con_item_transfer_date'])
                    );
                $this->db->insert('prop_item_stock', $addtblValues);
//                $prop_item_stock_id =  $this->db->insert_id();
                }
            $sub_masterid = $this->mastermodel->insertmasterdata();
            $sub_tblValues = array(
                'con_item_transfer_details_id' => $sub_masterid,
                'con_item_transfer_id' => $masterid,
                'con_item_request_id' => $postdata['con_item_request_id_' . $x],
                'con_item_request_details_id' => $postdata['q_item_request_details_' . $x],
                'item_master_id' => $stock_detailes->prop_item_id,
                'con_from_godown' => $postdata['con_from_godown_' . $x],
                'con_to_godown' => $postdata['con_to_godown_' . $x],
                'con_item_transfer_details_qty' => $postdata['q_reqqnty_' . $x],
                'con_item_transfer_details_remarks' => $postdata['con_item_transfer_details_remarks_' . $x],
                'stock_id'=>$prop_item_stock_id,
                'from_stock_id'=>$postdata['q_item_'. $x],
            );
            $this->db->insert('con_item_transfer_details', $sub_tblValues);


                }
                $x++;
            }
        }

        $i = 1;
        $output = $this->mastermodel->save_user_activities('Edit C-Item Transfer',$postdata['con_item_transfer_id'], 'con_item_transfer');  //ss

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = 'Error on Updating record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = 'Record Updated  successfully';
            return $data;
        }
    }

    function search_item_stock()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('prop_item_stock');
        $this->db->join('item_master', 'item_master.item_master_id=prop_item_stock.prop_item_id');
        $this->db->join('godown', 'godown.godown_id=prop_item_stock.prop_godown_id');

        $this->db->join('master', 'master.master_id=prop_item_stock.prop_item_stock_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->where('prop_item_stock.prop_item_stock_qty >', 0);
        $this->db->order_by('prop_item_stock.prop_item_stock_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    function search_item_return()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('con_item_return');
        $this->db->join('master', 'master.master_id=con_item_return.con_item_return_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('con_item_return_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    function insert_item_return($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'con_item_return_id' => $masterid,
            'con_item_return_date' => $this->mastermodel->convert_date_format($postdata['con_item_return_date']),
            'con_item_return_project' => $postdata['con_item_return_project'],
            'con_item_return_remarks' => $postdata['con_item_return_remarks'],
        );
        $this->db->insert('con_item_return', $tblValues);

        $i = 1;
        while (isset($postdata['q_item_' . $i]))
        {
            
            
            
            $stock_detailes = $this->mastermodel->get_data_srow('prop_item_stock',$postdata['q_stock_item_'. $i],'prop_item_stock_id');
      
            
            $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty -' . $postdata['con_item_return_details_qty_' . $i], false);
            $this->db->set('stock_date', $this->mastermodel->convert_date_format($postdata['con_item_return_date']));
            $this->db->where('prop_item_stock_id', $postdata['q_stock_item_' . $i]);
            $this->db->update('prop_item_stock');
            
            $this->db->select('*');
            $this->db->from('prop_item_stock');
            $this->db->where('prop_item_id', $postdata['q_item_'.$i]);
            $this->db->where('price', $stock_detailes->price);
            $this->db->where('prop_godown_id', $postdata['con_to_godown_'.$i]);
            $count = $this->db->count_all_results();
            
            if ($count > 0) {
                $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty +' . $postdata['con_item_return_details_qty_' . $i], false);
                $this->db->set('stock_date', $this->mastermodel->convert_date_format($postdata['con_item_return_date']));
                $this->db->set('total', 'prop_item_stock_qty * price', false);
             
                $this->db->where('prop_item_id',$postdata['q_item_' . $i]);
                $this->db->where('price', $stock_detailes->price);
                $this->db->where('prop_godown_id', $postdata['con_to_godown_'.$i]);
                $this->db->update('prop_item_stock');
                $stock_master = $this->propertymodel->get_search_stockmaster($stock_detailes->prop_item_id,$postdata['con_to_godown_'.$i],$stock_detailes->price);
                if (!empty($stock_master)){
                    $prop_item_stock_id = $stock_master->prop_item_stock_id;
            
                     }
                } 
            
            $sub_masterid = $this->mastermodel->insertmasterdata();
            $sub_tblValues = array(
                'con_item_return_details_id' => $sub_masterid,
                'con_item_return_id' => $masterid,
                'item_master_id' => $postdata['q_item_' . $i],
                'con_from_godown' => $postdata['con_from_godown_' . $i],
                'con_to_godown' => $postdata['con_to_godown_' . $i],
                'con_item_return_details_qty' => $postdata['con_item_return_details_qty_' . $i],
                'con_item_return_details_remarks' => $postdata['con_item_return_details_remarks_' . $i],
                'from_stock_id' => $postdata['q_stock_item_'. $i],
                'to_stock_id'=>$prop_item_stock_id
            );
            $this->db->insert('con_item_return_details', $sub_tblValues);


           

            $i++;
        }
        $output = $this->mastermodel->save_user_activities('Add C-Item Return',$masterid, 'con_item_return');  //ss
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    function update_item_return($postdata)
    {
        $data = array();
        $this->db->trans_begin();

        $tblValues = array(
            'con_item_return_date' => $this->mastermodel->convert_date_format($postdata['con_item_return_date']),
            'con_item_return_remarks' => $postdata['con_item_return_remarks'],
        );
        $this->db->where('con_item_return_id', $postdata['con_item_return_id']);
        $output = $this->db->update('con_item_return', $tblValues);

        $masterid = $postdata['con_item_return_id'];
//       
        $x = 1;
        while (isset($postdata['q_item_' . $x]))
        {
            if ($postdata['q_item_' . $x] != '')
            {
                                
                $this->db->where('con_item_return_id', $postdata['con_item_return_id']);
                $this->db->delete('con_item_return_details');
                
                if(empty($postdata['previous_qty_'. $x])){
                    $postdata['previous_qty_'. $x]=0;
                }
                
                $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty +' . $postdata['previous_qty_'. $x], false);
                $this->db->where('prop_item_stock_id', $postdata['q_item_' . $x]);
                $this->db->update('prop_item_stock');
            
                $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty -' . $postdata['previous_qty_'. $x], false);
                $this->db->where('prop_item_stock_id', $postdata['stock_id_' . $x]);
                $this->db->update('prop_item_stock');
                if ($postdata['status_' . $x] == 0 || $postdata['status_' . $x] == 1)
                {


                   $stock_detailes = $this->mastermodel->get_data_srow('prop_item_stock',$postdata['q_item_'. $x],'prop_item_stock_id');
      
                  
            $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty -' . $postdata['con_item_return_details_qty_' . $x], false);
            $this->db->set('stock_date', $this->mastermodel->convert_date_format($postdata['con_item_return_date']));
            $this->db->where('prop_item_stock_id', $postdata['q_item_' . $x]);
            $this->db->update('prop_item_stock');
            
            $this->db->select('*');
            $this->db->from('prop_item_stock');
            $this->db->where('prop_item_id', $stock_detailes->prop_item_id);
            $this->db->where('price', $stock_detailes->price);
            $this->db->where('prop_godown_id', $postdata['con_to_godown_'.$x]);
           
            $count = $this->db->count_all_results();
            if ($count > 0) {
                $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty +' . $postdata['con_item_return_details_qty_' . $x], false);
                $this->db->set('stock_date', $this->mastermodel->convert_date_format($postdata['con_item_return_date']));
                $this->db->set('total', 'prop_item_stock_qty * price', false);
             
                $this->db->where('prop_item_id',$stock_detailes->prop_item_id);
                $this->db->where('price', $stock_detailes->price);
                $this->db->where('prop_godown_id', $postdata['con_to_godown_'.$x]);
                $this->db->update('prop_item_stock');
                $stock_master = $this->propertymodel->get_search_stockmaster($stock_detailes->prop_item_id,$postdata['con_to_godown_'.$x],$stock_detailes->price);
                if (!empty($stock_master)){
                    $prop_item_stock_id = $stock_master->prop_item_stock_id;
            
                     }
                } 
            
            $sub_masterid = $this->mastermodel->insertmasterdata();
            $sub_tblValues = array(
                'con_item_return_details_id' => $sub_masterid,
                'con_item_return_id' => $masterid,
                'item_master_id' => $stock_detailes->prop_item_id,
                'con_from_godown' => $postdata['con_from_godown_' . $x],
                'con_to_godown' => $postdata['con_to_godown_' . $x],
                'con_item_return_details_qty' => $postdata['con_item_return_details_qty_' . $x],
                'con_item_return_details_remarks' => $postdata['con_item_return_details_remarks_' . $x],
                'from_stock_id' => $postdata['q_item_'. $x],
                'to_stock_id'=>$prop_item_stock_id
            );
            $this->db->insert('con_item_return_details', $sub_tblValues);


           
                } 

                $x++;
            }
        }
        $output = $this->mastermodel->save_user_activities('Edit C-Item Return',$postdata['con_item_return_id'], 'con_item_return');  //ss

        $i = 1;

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = 'Error on Updating record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = 'Record Updated  successfully';
            return $data;
        }
    }

    function search_sub_contractor()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('con_sub_contractor');
        $this->db->join('master', 'master.master_id=con_sub_contractor.con_sub_contractor_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('con_sub_contractor_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_sub_contractor($postdata)
    {
        $this->db->trans_begin();
        $set = $this->accountingmodel->get_account_settings('subcontractor');
        $ledger_id = $this->mastermodel->insertmasterdata();
        $code = $this->mastermodel->get_ref('con_contractor_code', 'con_sub_contractor', 'con_contractor_code');
        $tblValues = array(
            'ledger_id' => $ledger_id,
            'account_group_id' => $set,
            'ledger_name' => $postdata['con_contractor_name'],
            'mailing_name' => $postdata['con_contractor_name'],
            'address' => $postdata['con_contractor_address'],
            'phone' => $postdata['con_contractor_phone_no'],
            'mobile' => $postdata['con_contractor_phone_no'],
            'email' => $postdata['con_contractor_email'],
        );
        $output = $this->db->insert('account_ledger', $tblValues);
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'con_sub_contractor_id' => $masterid,
            'con_contractor_code' => $code,
            'con_contractor_name' => $postdata['con_contractor_name'],
            'con_contractor_address' => $postdata['con_contractor_address'],
            'con_contractor_phone_no' => $postdata['con_contractor_phone_no'],
            'con_contractor_email' => $postdata['con_contractor_email'],
            'con_contractor_ledger' => $ledger_id,
        );
        $output = $this->db->insert('con_sub_contractor', $tblValues);
        $output = $this->mastermodel->save_user_activities('Add Sub Contractor',$masterid, 'con_sub_contractor');  //ss

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = 'Error on adding record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = 'Record Added  successfully';
            return $data;
        }
    }

    public function update_sub_contractor($postdata)
    {
        $this->db->trans_begin();
        $tblValues = array(
            'ledger_name' => $postdata['con_contractor_name'],
            'mailing_name' => $postdata['con_contractor_name'],
            'address' => $postdata['con_contractor_address'],
            'phone' => $postdata['con_contractor_phone_no'],
            'mobile' => $postdata['con_contractor_phone_no'],
            'email' => $postdata['con_contractor_email'],
        );
        $this->db->where('ledger_id', $postdata['con_contractor_ledger']);
        $output = $this->db->update('account_ledger', $tblValues);
        $tblValues = array(
            'con_contractor_name' => $postdata['con_contractor_name'],
            'con_contractor_address' => $postdata['con_contractor_address'],
            'con_contractor_phone_no' => $postdata['con_contractor_phone_no'],
            'con_contractor_email' => $postdata['con_contractor_email'],
        );
        $this->db->where('con_sub_contractor_id', $postdata['con_sub_contractor_id']);
        $output = $this->db->update('con_sub_contractor', $tblValues);
        $output = $this->mastermodel->save_user_activities('Edit Sub Contractor',$postdata['con_sub_contractor_id'], 'con_sub_contractor');  //ss

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = 'Error on adding record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = 'Record Added  successfully';
            return $data;
        }
    }

    function search_subcontractor_allocation()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('con_subcontractor_allocation');
        $this->db->join('master', 'master.master_id=con_subcontractor_allocation.subcontractor_allocation_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('subcontractor_allocation_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    function insert_subcontractor_allocation($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $cwa_code = $this->mastermodel->get_ref('subcontractor_allocation_code', 'con_subcontractor_allocation', 'subcontractor_allocation_code');

        $tblValues = array(
            'subcontractor_allocation_id' => $masterid,
            'subcontractor_allocation_code' => $cwa_code,
            'subcontractor' => $postdata['subcontractor'],
            'allocation_date' => $this->mastermodel->convert_date_format($postdata['allocation_date']),
            'site' => $postdata['site'],
            'estimation_amount' => $postdata['estimation_amount'],
            'no_of_days' => $postdata['no_of_days'],
            'account' => $postdata['account'],
        );
        $this->db->insert('con_subcontractor_allocation', $tblValues);

        $i = 1;
        while (!empty($postdata['work_type' . $i]))
        {
            $detailsid = $this->mastermodel->insertmasterdata();
            $Values = array(
                'subcontractor_allocation_details_id' => $detailsid,
                'subcontractor_allocation' => $masterid,
                'work_type' => $postdata['work_type' . $i],
                'start_date' => $this->mastermodel->convert_date_format($postdata['start_date' . $i]),
                'end_date' => $this->mastermodel->convert_date_format($postdata['end_date' . $i]),
                'amount' => $postdata['amount' . $i]
            );
            $this->db->insert('con_subcontractor_allocation_details', $Values);
            $i++;
        }
        $output = $this->mastermodel->save_user_activities('Add Sub Contractor Allocation',$masterid, 'con_subcontractor_allocation');  //ss

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    function update_subcontractor_allocation($postdata)
    {
        $data = array();
        $this->db->trans_begin();

        $tblValues = array(
            'subcontractor' => $postdata['subcontractor'],
            'allocation_date' => $this->mastermodel->convert_date_format($postdata['allocation_date']),
            'site' => $postdata['site'],
            'estimation_amount' => $postdata['estimation_amount'],
            'no_of_days' => $postdata['no_of_days'],
            'account' => $postdata['account'],
        );
        $this->db->where('subcontractor_allocation_id', $postdata['subcontractor_allocation_id']);
        $this->db->update('con_subcontractor_allocation', $tblValues);

        $this->db->where('subcontractor_allocation', $postdata['subcontractor_allocation_id']);
        $this->db->delete('con_subcontractor_allocation_details');
        $i = 1;
        while (!empty($postdata['work_type' . $i]))
        {
            $detailsid = $this->mastermodel->insertmasterdata();
            $Values = array(
                'subcontractor_allocation_details_id' => $detailsid,
                'subcontractor_allocation' => $postdata['subcontractor_allocation_id'],
                'work_type' => $postdata['work_type' . $i],
                'start_date' => $this->mastermodel->convert_date_format($postdata['start_date' . $i]),
                'end_date' => $this->mastermodel->convert_date_format($postdata['end_date' . $i]),
                'amount' => $postdata['amount' . $i]
            );
            $this->db->insert('con_subcontractor_allocation_details', $Values);
            $i++;
        }
        $output = $this->mastermodel->save_user_activities('Edit Sub Contractor Allocation',$postdata['subcontractor_allocation_id'], 'con_subcontractor_allocation');  //ss

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    function get_account_settings($field)
    {

        $this->db->select($field);
        $this->db->from('general_settings');
        $this->db->join('master', 'master.master_id=general_settings.general_settings_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $result = $this->db->get()->row();
        if ($result)
        {
            return $result->$field;
        } else
        {
            return "";
        }
    }

    function get_accountledger_by_head($id)
    {
        $this->db->select('ledger_id,ledger_name');
        $this->db->from('account_ledger');
        $this->db->join('account_group', 'account_group.account_group_id=account_ledger.account_group_id');
//        $this->db->join('account_head', 'account_head.id=account_group.group_under');
        $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->where('account_group.group_under', $id);
        $this->db->order_by('account_ledger.account_group_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }

    function search_subcontractor_payment()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('con_subcontractor_payment');
        $this->db->join('con_subcontractor_allocation', 'con_subcontractor_payment.subcontractor_allocation=con_subcontractor_allocation.subcontractor_allocation_id', 'left');
        $this->db->join('con_sub_contractor', 'con_subcontractor_payment.subcontractor=con_sub_contractor.con_sub_contractor_id', 'left');
        $this->db->join('con_project', 'con_subcontractor_payment.site=con_project.con_project_id', 'left');
        $this->db->join('master', 'master.master_id=con_subcontractor_payment.subcontractor_payment_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('subcontractor_payment_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    function get_subcontractor_payment_det($id)
    {
        $this->db->select('con_subcontractor_allocation.*')
                ->select('(con_subcontractor_allocation.estimation_amount-COALESCE(SUM(con_subcontractor_payment.payment_amount),"0")) as payable_amount', False);
//        $this->db->select('con_subcontractor_allocation.*,con_subcontractor_allocation.estimation_amount-COALESCE(SUM(con_subcontractor_payment.payment_amount),"0")) as payable_amount');
        $this->db->from('con_subcontractor_allocation');
        $this->db->join('con_subcontractor_payment', 'con_subcontractor_payment.subcontractor_allocation=con_subcontractor_allocation.subcontractor_allocation_id', 'left');

        $this->db->where('con_subcontractor_allocation.subcontractor_allocation_id', $id);
        $data = $this->db->get()->row();
        return $data;
    }

    public function insert_subcontractor_payment($postdata)
    {
        $this->db->trans_begin();
        $ledger_id = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'ledger_book_id' => $ledger_id,
            'voucher_no' => $postdata['subcontractor_allocation'],
            'voucher_date' => $this->mastermodel->convert_date_format($postdata['payment_date']),
        );
        $output = $this->db->insert('ledger_book', $tblValues);
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'subcontractor_payment_id' => $masterid,
            'subcontractor_allocation' => $postdata['subcontractor_allocation'],
            'subcontractor' => $postdata['subcontractor'],
            'payment_date' => $this->mastermodel->convert_date_format($postdata['payment_date']),
            'site' => $postdata['site'],
            'payment_amount' => $postdata['payment_amount'],
            'payment_mode' => $postdata['payment_mode'],
            'remarks' => $postdata['remarks'],
            'account' => $postdata['account'],
            'subcontractor_payment_ledger' => $ledger_id,
        );
        $output = $this->db->insert('con_subcontractor_payment', $tblValues);
        $ret = $this->accountingmodel->get_accountmaster_id('con_sub_contractor', 'con_sub_contractor_id', 'con_contractor_ledger', $postdata['subcontractor']);

        $set = $postdata['account'];
        $tblValues = array(
            'ledger_book_id' => $ledger_id,
            'account_ledger_id' => $ret,
            'debit' => $postdata['payment_amount'],
        );
        $output = $this->db->insert('ledger_book_details', $tblValues);
        $tblValues = array(
            'ledger_book_id' => $ledger_id,
            'account_ledger_id' => $set,
            'credit' => $postdata['payment_amount'],
        );
        $output = $this->db->insert('ledger_book_details', $tblValues);

        $output = $this->mastermodel->save_user_activities('Edit Sub Contractor Payment',$masterid, 'con_subcontractor_payment');  //ss

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = 'Error on adding record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = 'Record Added  successfully';
            return $data;
        }
    }

    public function update_subcontractor_payment($postdata)
    {
        $this->db->trans_begin();

        $tblValues = array(
            'voucher_no' => $postdata['subcontractor_allocation'],
            'voucher_date' => $this->mastermodel->convert_date_format($postdata['payment_date']),
        );
        $this->db->where('ledger_book_id', $postdata['subcontractor_payment_ledger']);
        $output = $this->db->update('ledger_book', $tblValues);

        $tblValues = array(
            'subcontractor_allocation' => $postdata['subcontractor_allocation'],
            'subcontractor' => $postdata['subcontractor'],
            'payment_date' => $this->mastermodel->convert_date_format($postdata['payment_date']),
            'site' => $postdata['site'],
            'payment_amount' => $postdata['payment_amount'],
            'payment_mode' => $postdata['payment_mode'],
            'remarks' => $postdata['remarks'],
            'account' => $postdata['account'],
        );
        $this->db->where('subcontractor_payment_id', $postdata['subcontractor_payment_id']);
        $output = $this->db->update('con_subcontractor_payment', $tblValues);
        $ret = $this->accountingmodel->get_accountmaster_id('con_sub_contractor', 'con_sub_contractor_id', 'con_contractor_ledger', $postdata['subcontractor']);

        $set = $postdata['account'];
        $tblValues = array(
            'account_ledger_id' => $ret,
            'debit' => $postdata['payment_amount'],
        );
        $this->db->where('ledger_book_id', $postdata['subcontractor_payment_ledger']);
        $output = $this->db->update('ledger_book_details', $tblValues);
        $tblValues = array(
            'account_ledger_id' => $set,
            'credit' => $postdata['payment_amount'],
        );
        $this->db->where('ledger_book_id', $postdata['subcontractor_payment_ledger']);
        $output = $this->db->update('ledger_book_details', $tblValues);

        $output = $this->mastermodel->save_user_activities('Edit Sub Contractor Payment',$postdata['subcontractor_payment_id'], 'con_subcontractor_payment');  //ss

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = 'Error on adding record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = 'Record Added  successfully';
            return $data;
        }
    }

    function search_tools_category()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('tools_category');
        $this->db->join('master', 'master.master_id=tools_category.tools_category_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('tools_category_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_tools_category($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'tools_category_id' => $masterid,
            'tools_category_name' => $postdata['tools_category_name']
        );
        $this->db->insert('tools_category', $tblValues);

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_tools_category($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'tools_category_name' => $postdata['tools_category_name']
        );
        $this->db->where('tools_category_id', $postdata['tools_category_id']);
        $this->db->update('tools_category', $tblValues);

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    function search_tools()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('tools');
        $this->db->join('master', 'master.master_id=tools.tools_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('tools_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_tools($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $tool_code = $this->mastermodel->get_ref('tools_code', 'tools', 'tools_code');
        foreach ($postdata['tools_vendor_id'] as $item)
        {
            $itemid = $this->mastermodel->insertmasterdata();
            $subValues = array(
                'tools_vendor_id' => $itemid,
                'tools_vendor_tool_id' => $masterid,
                'tools_vendor_name' => $item
            );
            $this->db->insert('tools_vendor', $subValues);
        }
        $tblValues = array(
            'tools_id' => $masterid,
            'tools_code' => $tool_code,
            'tools_name' => $postdata['tools_name'],
            'tools_category_id' => $postdata['tools_category_id'],
            'tools_description' => $postdata['tools_description']
        );
        $this->db->insert('tools', $tblValues);
        $output = $this->mastermodel->save_user_activities('Add Tools',$masterid, 'tools');  //ss

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_tools($postdata)
    {
        $data = array();
        $this->db->trans_begin();

        $this->db->where('tools_vendor_tool_id', $postdata['tools_id']);
        $this->db->delete('tools_vendor');

        foreach ($postdata['tools_vendor_id'] as $item)
        {
            $itemid = $this->mastermodel->insertmasterdata();
            $subValues = array(
                'tools_vendor_id' => $itemid,
                'tools_vendor_tool_id' => $postdata['tools_id'],
                'tools_vendor_name' => $item
            );
            $this->db->insert('tools_vendor', $subValues);
        }

        $tblValues = array(
            'tools_name' => $postdata['tools_name'],
            'tools_category_id' => $postdata['tools_category_id'],
            'tools_description' => $postdata['tools_description']
        );
        $this->db->where('tools_id', $postdata['tools_id']);
        $this->db->update('tools', $tblValues);
        $output = $this->mastermodel->save_user_activities('Edit Tools',$postdata['tools_id'], 'tools');  //ss

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    function set_manager_approval($po_management_id)
    {
        $tblValues = array(
            'po_manager_approval' => 1
        );
        $this->db->where('con_po_id', $po_management_id);
        $data = $this->db->update('con_po', $tblValues);
        if ($data == 1)
        {
            $output = $this->search_purchase_order();
            return $output;
        } else
        {
            return 0;
        }
    }

    function set_gm_approval($po_gm_id)
    {
        $tblValues = array(
            'po_gm_approval' => 1
        );
        $this->db->where('con_po_id', $po_gm_id);
        $data = $this->db->update('con_po', $tblValues);
        if ($data == 1)
        {
            $output = $this->search_purchase_order();

            return $output;
        } else
        {
            return 0;
        }
    }

    function search_tools_request()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('con_tool_request');
        $this->db->join('master', 'master.master_id=tool_request_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('tool_request_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_tools_request($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $tool_request_code = $this->mastermodel->get_ref('tool_request_code', 'con_tool_request', 'tool_request_code');
        $tblValues = array(
            'tool_request_id' => $masterid,
            'tool_request_code' => $tool_request_code,
            'tool_request_date' => $this->mastermodel->convert_date_format($postdata['tool_request_date']),
            'tool_request_project' => $postdata['tool_request_project'],
            'tool_request_employee' => $postdata['tool_request_employee'],
            'tool_request_remarks' => $postdata['tool_request_remarks']
        );
        $this->db->insert('con_tool_request', $tblValues);

        $i = 1;
        while (!empty($postdata['tool_id' . $i]))
        {
            $detailsid = $this->mastermodel->insertmasterdata();
            $Values = array(
                'tool_request_details_id' => $detailsid,
                'tool_request_id' => $masterid,
                'tool_id' => $postdata['tool_id' . $i],
                'qty' => $postdata['qty' . $i],
                'due_date' => $this->mastermodel->convert_date_format($postdata['due_date' . $i]),
                'return_date' => $this->mastermodel->convert_date_format($postdata['return_date' . $i]),
                'remarks' => $postdata['remarks' . $i]
            );
            $this->db->insert('con_tool_request_details', $Values);
            $i++;
        }
        $output = $this->mastermodel->save_user_activities('Add Tool Request',$masterid, 'con_tool_request');  //ss
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_tools_request($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'tool_request_date' => $this->mastermodel->convert_date_format($postdata['tool_request_date']),
            'tool_request_project' => $postdata['tool_request_project'],
            'tool_request_employee' => $postdata['tool_request_employee'],
            'tool_request_remarks' => $postdata['tool_request_remarks']
        );
        $this->db->where('con_tool_request.tool_request_id', $postdata['tool_request_id']);
        $this->db->update('con_tool_request', $tblValues);

        $this->db->where('con_tool_request_details.tool_request_id', $postdata['tool_request_id']);
        $this->db->delete('con_tool_request_details');
        $i = 1;
        while (!empty($postdata['tool_id' . $i]))
        {
            $detailsid = $this->mastermodel->insertmasterdata();
            $Values = array(
                'tool_request_details_id' => $detailsid,
                'tool_request_id' => $postdata['tool_request_id'],
                'tool_id' => $postdata['tool_id' . $i],
                'qty' => $postdata['qty' . $i],
                'due_date' => $this->mastermodel->convert_date_format($postdata['due_date' . $i]),
                'return_date' => $this->mastermodel->convert_date_format($postdata['return_date' . $i]),
                'remarks' => $postdata['remarks' . $i]
            );
            $this->db->insert('con_tool_request_details', $Values);
            $i++;
        }
        $output = $this->mastermodel->save_user_activities('Edit Tool Request',$postdata['tool_request_id'], 'con_tool_request');  //ss
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    function search_order_rented_tools()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('con_order_rented_tools');

        $this->db->join('vendor', 'vendor.vendor_id=con_order_rented_tools.vendor_id');
        $this->db->join('master', 'master.master_id=order_rented_tools_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('order_rented_tools_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    function insert_order_rented_tools($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $order_no = $this->mastermodel->get_ref('order_rented_tools', 'con_order_rented_tools', 'order_no');

        $tblValues = array(
            'order_rented_tools_id' => $masterid,
            'order_no' => $order_no,
            'order_date' => $this->mastermodel->convert_date_format($postdata['order_date']),
            'vendor_id' => $postdata['vendor_id'],
            'vendor_address' => $postdata['vendor_address']
        );
        $this->db->insert('con_order_rented_tools', $tblValues);
        
        for ($i = 0; $i < count($postdata['project_id']); $i++)
        {
            $projmasterid = $this->mastermodel->insertmasterdata();
            $tblValues = array(
                'order_rented_project_id' => $projmasterid,
                'order_rended_id' => $masterid,
                'project_id' => $postdata['project_id'][$i],
            );
            $output = $this->db->insert('con_order_rended_projects', $tblValues);
        }

        for ($i = 0; $i < count($postdata['request_id']); $i++)
        {
            $rqstmasterid = $this->mastermodel->insertmasterdata();
            $tblValues = array(
                'order_rended_request_id' => $rqstmasterid,
                'order_rended_id' => $masterid,
                'request_id' => $postdata['request_id'][$i],
            );
            $output = $this->db->insert('con_order_rended_request', $tblValues);
        }


        $x = 1;
        while (isset($postdata['q_tool_' . $x]))
        {

            $romasterid = $this->mastermodel->insertmasterdata();
            $tblValues = array(
                'con_order_rented_tools_id' => $romasterid,
                'order_id' => $masterid,
                'order_request_id' => $this->db->escape_str($postdata['q_tools_request_details_' . $x]),
                'rended_tool_id' => $this->db->escape_str($postdata['q_tool_' . $x]),
                'order_qty' => $postdata['q_ordered_qnty_' . $x],
                'expected_due_date' => $this->mastermodel->convert_date_format($postdata['expected_return_date_' . $x]),
                'notes' => $this->db->escape_str($postdata['notes_' . $x]),
            );
            $this->db->insert('con_order_rented_tools_details', $tblValues);
//            for request updation
            $this->db->set('request_completed_qty','request_completed_qty + '.$postdata['q_ordered_qnty_' . $x], false);
            $this->db->where('tool_request_details_id',$postdata['q_tools_request_details_' . $x]);
            $this->db->update('con_tool_request_details',$data);
            
            
            
            $x++;
        }
        $output = $this->mastermodel->save_user_activities('Add Order Rented Tools',$masterid, 'con_order_rented_tools');  //ss
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_order_rented_tools($postdata)
    {


        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'order_date' => $this->mastermodel->convert_date_format($postdata['order_date']),
        );

        $this->db->where('order_rented_tools_id', $postdata['order_rented_tools_id']);
        $this->db->update('con_order_rented_tools', $tblValues);


        $masterid = $postdata['order_rented_tools_id'];
        $i = 1;
        while (isset($postdata['q_tool_' . $i]))
        {

            if ($postdata['q_tool_' . $i] != '')
            {


                if ($postdata['status_' . $i] == "0")
                {

                    $po_details_id = $postdata['con_order_rented_tools_id_' . $i];


                    $tblValues_po_details_id = array(
                        'order_request_id' => $this->db->escape_str($postdata['q_tools_request_details_' . $i]),
                        'rended_tool_id' => $this->db->escape_str($postdata['q_tool_' . $i]),
                        'order_qty' => $postdata['q_ordered_qnty_' . $i],
                        'expected_due_date' => $this->mastermodel->convert_date_format($postdata['expected_return_date_' . $i]),
                        'notes' => $this->db->escape_str($postdata['notes_' . $i]),
                    );

                    $this->db->where('con_order_rented_tools_details.con_order_rented_tools_id', $po_details_id);
                    $this->db->update('con_order_rented_tools_details', $tblValues_po_details_id);
                } elseif ($postdata['status_' . $i] == "1")
                {
                    $romasterid = $this->mastermodel->insertmasterdata();
                    $tblValues = array(
                        'con_order_rented_tools_id' => $romasterid,
                        'order_id' => $masterid,
                        'order_request_id' => $this->db->escape_str($postdata['q_tools_request_details_' . $i]),
                        'rended_tool_id' => $this->db->escape_str($postdata['q_tool_' . $i]),
                        'order_qty' => $postdata['q_ordered_qnty_' . $i],
                        'expected_due_date' => $this->mastermodel->convert_date_format($postdata['expected_return_date_' . $i]),
                        'notes' => $this->db->escape_str($postdata['notes_' . $i]),
                    );
                    $this->db->insert('con_order_rented_tools_details', $tblValues);
                } else
                {

                    $this->db->where('con_order_rented_tools_id', $postdata['con_order_rented_tools_id_' . $i]);
                    $this->db->delete('con_order_rented_tools_details');
                }
            }
            $new_qty = ($postdata['q_ordered_qnty_' . $i] - $postdata['prev_qty' . $i]);
//            for request updation
            $this->db->set('request_completed_qty','request_completed_qty + '.$new_qty, false);
            $this->db->where('tool_request_details_id',$postdata['q_tools_request_details_' . $i]);
            $this->db->update('con_tool_request_details',$data);
            $i++;
        }
        $output = $this->mastermodel->save_user_activities('Edit Order Rented Tools',$masterid, 'con_order_rented_tools');  //ss

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    function get_search_tool($val)
    {

        $this->db->select('tools_id as id,tools_name,tools_code');
        $this->db->from('tools');
        $this->db->join('master', 'master.master_id=tools.tools_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->like('tools.tools_name', $val);
        $this->db->order_by('tools.tools_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }

    function order_rented_tools_details($id)
    {

        $this->db->select('*');
        $this->db->from('con_order_rented_tools_details');
        $this->db->join('con_tool_request_details', 'con_tool_request_details.tool_request_details_id=con_order_rented_tools_details.order_request_id', 'left');
        $this->db->where('con_order_rented_tools_details.order_id', $id);

        $this->db->order_by('con_order_rented_tools_details.con_order_rented_tools_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }

    function search_rented_tools_receipt()
    {
        $data = array();
        $this->db->select('con_rented_tool_receipt.*');
        $this->db->from('con_rented_tool_receipt');

//           $this->db->join('vendor', 'vendor.vendor_id=con_order_rented_tools.vendor_id');
        $this->db->join('master', 'master.master_id=rented_tool_receipt_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('rented_tool_receipt_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    function get_tool_order_by_vendor($id)
    {
        $this->db->select('con_order_rented_tools.*');
        $this->db->from('con_order_rented_tools');
        $this->db->where('con_order_rented_tools.vendor_id', $id);
        $this->db->join('con_order_rented_tools_details', 'con_order_rented_tools_details.order_id=con_order_rented_tools.order_rented_tools_id','INNER');
        $this->db->where('con_order_rented_tools_details.order_qty != ','con_order_rented_tools_details.order_completed_qty',false);
        $this->db->group_by('con_order_rented_tools.order_rented_tools_id', 'desc');
        $data = $this->db->get()->result();
        
        return $data;
    }

    function insert_rented_tool_receipt($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $receipt_code = $this->mastermodel->get_ref('rented_tool_receipt_code', 'con_rented_tool_receipt', 'rented_tool_receipt_code');

        $tblValues = array(
            'rented_tool_receipt_id' => $masterid,
            'rented_tool_receipt_code' => $receipt_code,
            'rented_tool_receipt_date' => $this->mastermodel->convert_date_format($postdata['rented_tool_receipt_date']),
            'rented_tool_receipt_vendor' => $postdata['rented_tool_receipt_vendor'],
            'rented_tool_receipt_remarks' => $postdata['rented_tool_receipt_remarks']
        );
        $this->db->insert('con_rented_tool_receipt', $tblValues);

        for ($i = 0; $i < count($postdata['order_tool_request_id']); $i++)
        {
            $order_id = $this->mastermodel->insertmasterdata();
            $tblValues = array(
                'con_rented_tool_receipt_order_id' => $order_id,
                'rented_tool_receipt_id' => $masterid,
                'order_tool_request_id' => $postdata['order_tool_request_id'][$i],
            );
            $output = $this->db->insert('con_rented_tool_receipt_order', $tblValues);
        }

        $x = 1;
        while (isset($postdata['q_tool_' . $x]))
        {
            
            $details_id = $this->mastermodel->insertmasterdata();
            $tblValues = array(
                'rented_tool_receipt_details_id' => $details_id,
                'rented_tool_receipt_id' => $masterid,
                'order_rented_tools_id' => $postdata['order_rented_tools_id_'. $x],
                'tool_id'=>$postdata['q_tool_' . $x],
                'qty_delivered'=>$postdata['qty_delivered_' . $x],
                'rent'=>$postdata['rent_' . $x],
                'godown_id'=>$postdata['godown_id_' . $x],
                'received_status'=>$postdata['received_status_' . $x],
                'received_by'=>$this->db->escape_str($postdata['received_by_' . $x]),
                'receipt_details_notes'=>$this->db->escape_str($postdata['notes_' . $x]),
            );
            $this->db->insert('con_rented_tool_receipt_details', $tblValues);
//            related to stock
            
            $stock = $this->check_rented_stock($postdata['godown_id_' . $x], $postdata['q_tool_' . $x]);
            
            if($stock->qty == 0)
            {
                $field_id = $this->mastermodel->insertmasterdata();
                $fieldvalues = array(
                    'stock_id' => $field_id,
                    'item_id' => $postdata['q_tool_' . $x],
                    'qty' => $postdata['qty_delivered_' . $x],
                    'godown_id' => $postdata['godown_id_' . $x]
                    );
                $this->db->insert('tool_stock', $fieldvalues);
            }
            else
            {   
                $new_qty = $postdata['qty_delivered_' . $x] + $stock->qty;
                $fieldvalues = array(
                    'qty' => $new_qty
                );
                $this->db->where('stock_id', $stock->stock_id);
                $this->db->update('tool_stock', $fieldvalues);
            }
//            related to stock
//            for request updation
            $this->db->set('order_completed_qty','order_completed_qty + '.$postdata['qty_delivered_' . $x], false);
            $this->db->where('con_order_rented_tools_id',$postdata['order_rented_tools_id_' . $x]);
            $this->db->update('con_order_rented_tools_details',$data);
            $x++;
        }
        $output = $this->mastermodel->save_user_activities('Add Order Rented Tool Reciept',$masterid, 'con_rented_tool_receipt');  //ss
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    function get_rented_tool_rcptDetails($id){
        $data = array();
        $this->db->select('*');
        $this->db->from('con_rented_tool_receipt_details');

        $this->db->join('con_order_rented_tools_details', 'con_order_rented_tools_id=order_rented_tools_id');
        $this->db->join('master', 'master.master_id=rented_tool_receipt_details_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->where('rented_tool_receipt_id', $id);
//        $this->db->order_by('rented_tool_receipt_id', 'desc');
        $data = $this->db->get()->result();
//        echo $this->db->last_query();
        return $data;
    }
    function update_rented_tool_receipt($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $postdata['rented_tool_receipt_id'];
        
        $tblValues = array(
            'rented_tool_receipt_id' => $masterid,
            'rented_tool_receipt_date' => $this->mastermodel->convert_date_format($postdata['rented_tool_receipt_date']),
            'rented_tool_receipt_vendor' => $postdata['rented_tool_receipt_vendor'],
            'rented_tool_receipt_remarks' => $postdata['rented_tool_receipt_remarks']
        );
        $this->db->where('rented_tool_receipt_id',$postdata['rented_tool_receipt_id']);
        $this->db->update('con_rented_tool_receipt', $tblValues);

        $this->db->where('rented_tool_receipt_id',$postdata['rented_tool_receipt_id']);
        $this->db->delete('con_rented_tool_receipt_details');
        $x = 1;
        while (isset($postdata['q_tool_' . $x]))
        {
            if($postdata['status'. $x] != 2)
            {
                $details_id = $this->mastermodel->insertmasterdata();
                $tblValues = array(
                    'rented_tool_receipt_details_id' => $details_id,
                    'rented_tool_receipt_id' => $masterid,
                    'order_rented_tools_id' => $postdata['order_rented_tools_id_'. $x],
                    'tool_id'=>$postdata['q_tool_' . $x],
                    'qty_delivered'=>$postdata['qty_delivered_' . $x],
                    'rent'=>$postdata['rent_' . $x],
                    'godown_id'=>$postdata['godown_id_' . $x],
                    'received_status'=>$postdata['received_status_' . $x],
                    'received_by'=>$this->db->escape_str($postdata['received_by_' . $x]),
                    'receipt_details_notes'=>$this->db->escape_str($postdata['notes_' . $x]),
                );
                $this->db->insert('con_rented_tool_receipt_details', $tblValues);
            }
//            ralted to stock
            
        $stock = $this->check_rented_stock($postdata['godown_id_' . $x], $postdata['q_tool_' . $x]);
        
        if($postdata['status'. $x] == 0)
        {
            $new_qty = ($stock->qty - $postdata['prev_qty' . $x]) + $postdata['qty_delivered_' . $x];
            $fieldvalues = array(
                'qty' => $new_qty
            );
            $this->db->where('stock_id', $stock->stock_id);
            $this->db->update('tool_stock', $fieldvalues);
        }
        else if($postdata['status'. $x] == 1)
        {   
            if($stock->qty == 0)
            {
                $field_id = $this->mastermodel->insertmasterdata();
                $fieldvalues = array(
                    'stock_id' => $field_id,
                    'item_id' => $postdata['q_tool_' . $x],
                    'qty' => $postdata['qty_delivered_' . $x],
                    'godown_id' => $postdata['godown_id_' . $x]
                    );
                $this->db->insert('tool_stock', $fieldvalues);
            }
            else
            {   
                $new_qty = $postdata['qty_delivered_' . $x] + $stock->qty;
                $fieldvalues = array(
                    'qty' => $new_qty
                );
                $this->db->where('stock_id', $stock->stock_id);
                $this->db->update('tool_stock', $fieldvalues);
            }
        }
        else if($postdata['status'. $x] == 2)
        {   
            $new_qty = $stock->qty - $postdata['qty_delivered_' . $x];
            $fieldvalues = array(
                'qty' => $new_qty
            );
            $this->db->where('stock_id', $stock->stock_id);
            $this->db->update('tool_stock', $fieldvalues);
        }
        
//            related to stock
        
//            for request updation
            $new_qty = ($postdata['qty_delivered_' . $x] - $postdata['prev_qty' . $x]);
            $this->db->set('order_completed_qty','order_completed_qty + '.$new_qty, false);
            $this->db->where('con_order_rented_tools_id',$postdata['order_rented_tools_id_' . $x]);
            $this->db->update('con_order_rented_tools_details',$data);
        
            $x++;
        }
        $output = $this->mastermodel->save_user_activities('Edit Order Rented Tool Reciept',$postdata['rented_tool_receipt_id'], 'con_rented_tool_receipt');  //ss
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    function load_petty_ledger()
    {
        $group_id = $this->accountingmodel->get_general_report_settings()->cash_settings;
        $this->db->select('ledger_id,ledger_name');
        $this->db->from('account_ledger');
        $this->db->join('account_group','account_group.account_group_id=account_ledger.account_group_id');
        $this->db->where('account_group.parent',$group_id);
        
        return $this->db->get()->result();
    }
    function load_expense()
    {
        $this->db->select('ledger_id,ledger_name');
        $this->db->from('account_ledger');
        $this->db->join('account_group','account_group.account_group_id=account_ledger.account_group_id');
        $this->db->where('account_group.group_under',3);
         $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        return $this->db->get()->result();
    }
     function search_rented_tools_allocation()
    {
        $data = array();
        $this->db->select('*');
            $this->db->from('con_rented_tool_allocation');
        $this->db->join('master', 'master.master_id=rented_tool_allocation_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('rented_tool_allocation_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    public function insert_rented_tools_allocation($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $code = $this->mastermodel->get_ref('rented_tool_allocation_code', 'con_rented_tool_allocation', 'rented_tool_allocation_code');
        $tblValues = array(
            'rented_tool_allocation_id' => $masterid,
            'rented_tool_allocation_code' => $code,
            'rented_tool_allocation_date' => $this->mastermodel->convert_date_format($postdata['rented_tool_allocation_date']),
            'rented_tool_allocation_project' => $postdata['rented_tool_allocation_project'],
            'rented_tool_allocation_employee' => $postdata['rented_tool_allocation_employee']
        );
        $this->db->insert('con_rented_tool_allocation', $tblValues);
        
        foreach($postdata['rented_tool_request_id'] as $item)
        {
            $sub1 = $this->mastermodel->insertmasterdata();
            $tblValues = array(
            'rented_tool_allocation_request_id' => $sub1,
            'rented_tool_allocation_id' => $masterid,
            'rented_tool_request_id' => $item
            );
        $this->db->insert('con_rented_tool_allocation_request', $tblValues);
        }
        
        $i = 1;
        while (!empty($postdata['tool_id' . $i]))
        {
            $detailsid = $this->mastermodel->insertmasterdata();
            $Values = array(
                'rented_tool_allocation_details_id' => $detailsid,
                'rented_tool_allocation_id' => $masterid,
                'tool_request_details_id' => $postdata['tool_request_details_id' . $i],
                'tool_id' => $postdata['tool_id' . $i],
                'from_godown' => $postdata['from_godown' . $i],
                'to_godown' => $postdata['to_godown' . $i],
                'quantity' => $postdata['quantity' . $i],
                'remarks' => $postdata['remarks' . $i]
            );
            $this->db->insert('con_rented_tool_allocation_details', $Values);
            
            $from_stock = $this->check_rented_stock($postdata['from_godown' . $i], $postdata['tool_id' . $i]);
            if(!empty($from_stock->qty))
            {
                $this->db->set('qty', 'qty-'.$postdata['quantity' . $i] ,FALSE);
                $this->db->where('stock_id' , $from_stock->stock_id);
                $this->db->update('tool_stock');
            }
            
            $to_stock = $this->check_rented_stock($postdata['to_godown' . $i], $postdata['tool_id' . $i]);
            if(!empty($to_stock->qty))
            {
                $this->db->set('qty', 'qty+'.$postdata['quantity' . $i] ,FALSE);
                $this->db->where('stock_id' , $to_stock->stock_id);
                $this->db->update('tool_stock');
            }
            else
            {
                $fieldsid = $this->mastermodel->insertmasterdata();
                $fields = array(
                    'stock_id' => $fieldsid,
                    'item_id' => $postdata['tool_id' . $i],
                    'qty' => $postdata['quantity' . $i],
                    'godown_id' => $postdata['to_godown' . $i],
                );
                $this->db->insert('tool_stock', $fields);
            }
            
            $i++;
        }
        $output = $this->mastermodel->save_user_activities('Add Order Rented Tool Allocation',$masterid, 'con_rented_tool_allocation');  //ss
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    public function update_rented_tools_allocation($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'rented_tool_allocation_date' => $this->mastermodel->convert_date_format($postdata['rented_tool_allocation_date']),
        );
        $this->db->where('con_rented_tool_allocation.rented_tool_allocation_id',$postdata['rented_tool_allocation_id']);
        $this->db->update('con_rented_tool_allocation', $tblValues);
        
        $this->db->where('con_rented_tool_allocation_details.rented_tool_allocation_id',$postdata['rented_tool_allocation_id']);
        $this->db->delete('con_rented_tool_allocation_details');
        $i = 1;
        
        while (!empty($postdata['tool_id' . $i]))
        {
            $detailsid = $this->mastermodel->insertmasterdata();
            $Values = array(
                'rented_tool_allocation_details_id' => $detailsid,
                'rented_tool_allocation_id' => $postdata['rented_tool_allocation_id'],
                'tool_request_details_id' => $postdata['tool_request_details_id' . $i],
                'tool_id' => $postdata['tool_id' . $i],
                'from_godown' => $postdata['from_godown' . $i],
                'to_godown' => $postdata['to_godown' . $i],
                'quantity' => $postdata['quantity' . $i],
                'remarks' => $postdata['remarks' . $i]
            );
            $this->db->insert('con_rented_tool_allocation_details', $Values);
            
            
        if($postdata['status'. $i] == 0)
            {
                $from_stock = $this->check_rented_stock($postdata['from_godown' . $i], $postdata['tool_id' . $i]);
                if(!empty($from_stock->qty))
                {
                    $new_qty = ($from_stock->qty + $postdata['prev_qty' . $i]) - $postdata['quantity' . $i];
                    $stock_values = array(
                    'qty'=>$new_qty
                    );
                    $this->db->where('stock_id', $from_stock->stock_id);
                    $this->db->update('tool_stock', $stock_values);
                }

                $to_stock = $this->check_rented_stock($postdata['to_godown' . $i], $postdata['tool_id' . $i]);
                if(!empty($to_stock->qty))
                {
                    $new_qty = ($to_stock->qty - $postdata['prev_qty' . $i]) + $postdata['quantity' . $i];
                    $stock_values = array(
                    'qty'=>$new_qty
                    );
                    $this->db->where('stock_id', $to_stock->stock_id);
                    $this->db->update('tool_stock', $stock_values);
                }
            } 
            else if($postdata['status'. $i] == 2)
            {
                $new_qty = $stock->qty + $postdata['quantity' . $i];
                $fieldvalues = array(
                    'qty' => $new_qty
                );
                $this->db->where('stock_id', $stock->stock_id);
                $this->db->update('tool_stock', $fieldvalues); 
            }
            
            $i++;
        }
        $output = $this->mastermodel->save_user_activities('Edit Order Rented Tool Allocation',$postdata['rented_tool_allocation_id'], 'con_rented_tool_allocation');  //ss
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    
    function get_opening_balance($id)
    {
        $data = 0;
        $this->db->select('SUM(ledger_book_details.debit) - SUM(ledger_book_details.credit) as Difference, opening_balance');
        $this->db->from('ledger_book_details');
        $this->db->where('ledger_book_details.account_ledger_id',$id);
        $this->db->join('account_ledger','account_ledger.ledger_id=ledger_book_details.account_ledger_id');
        $data = $this->db->get()->row();
        
        return $data->Difference+$data->opening_balance;
    }
    function get_tool_allocation_detailes($ids)
    { 
        $data = 0;
        $this->db->select('*');
        $this->db->from('con_tool_request_details');
        $this->db->where_in('con_tool_request_details.tool_request_id',$ids);
        $data = $this->db->get()->result();
        
        return $data;
    }
    function get_requestlist_alloc_tools1($arr)
    {
//         $arr = $_POST['id'];
        $this->db->select('*');
        $this->db->from('con_tool_request');
        $this->db->join('con_tool_request_details', 'con_tool_request_details.tool_request_id=con_tool_request.tool_request_id');
        $this->db->where('con_tool_request.tool_request_project' , $arr);
//        $this->db->where('item_request_from_site.item_request_from_site_id in', '(SELECT  `item_request_from_site`.`item_request_from_site_id` 
//                            FROM `item_request_from_site`
//                            INNER JOIN `item_request_details` ON `item_request_from_site`.`item_request_from_site_id` = `item_request_details`.`item_request_from_site`
//        
//                            WHERE `po_completed_qty` < `request_quantity`)', false);
        $this->db->order_by('con_tool_request.tool_request_id', 'desc');
        $this->db->group_by('con_tool_request.tool_request_id');
        $data = $this->db->get()->result();
        return $data;
    }
      public function insert_site_expense($postdata)
    {
        $this->db->trans_begin();
        $ledger_id = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'ledger_book_id' => $ledger_id,
            'voucher_no' => $postdata['site_expense_voucher_no'],
            'voucher_date' => $this->mastermodel->convert_date_format($postdata['site_expense_date']),
        );
        $output = $this->db->insert('ledger_book', $tblValues);

        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'site_expense_id' => $masterid,
            'site' => $postdata['site'],
            'site_expense_petty_cash' => $postdata['site_expense_petty_cash'],
             'site_expense_opening_balance' => $postdata['site_expense_opening_balance'],
              'site_expense_incharge' => $postdata['site_expense_incharge'],
            'site_expense_date' => $this->mastermodel->convert_date_format($postdata['site_expense_date']),
            'site_expense_voucher_no' => $postdata['site_expense_voucher_no'],
            'site_expense_ledger' => $ledger_id,
        );
        $output = $this->db->insert('con_site_expense', $tblValues);
        $ret = $postdata['site_expense_petty_cash'];
       $sitecostcenter = $this->accountingmodel->get_costcentremaster_id('con_project', 'con_project_id', 'ledger', $postdata['site']);
      $i = 1;
        while (isset($postdata['expense_account_' . $i]))
        {
       $set = $postdata['expense_account_' . $i];
      $tblValues = array(
            'ledger_book_id' => $ledger_id,
            'account_ledger_id' => $ret,
            'debit' => $postdata['amount_' . $i],
        );
        $output = $this->db->insert('ledger_book_details', $tblValues);
        $ddet_id = $this->db->insert_id();

        $credit = 0;
        $debit = $postdata['amount_' . $i];

        $tblValues = array(
            'ledger_book_details' => $ddet_id,
            'ref_ledger' => $sitecostcenter,
            'ref_amount' => $postdata['amount_' . $i],
            'credit' => $credit,
            'debit' => $debit,
        );
        $output = $this->db->insert('ledger_book_reference', $tblValues);
        $tblValues = array(
            'ledger_book_id' => $ledger_id,
            'account_ledger_id' => $set,
            'credit' =>$postdata['amount_' . $i],
        );
        $output = $this->db->insert('ledger_book_details', $tblValues);
        $cdet_id = $this->db->insert_id();

        $debit = 0;
        $credit = $postdata['amount_' . $i];

        $tblValues = array(
            'ledger_book_details' => $cdet_id,
            'ref_ledger' => $sitecostcenter,
            'ref_amount' => $postdata['amount_' . $i],
            'credit' => $credit,
            'debit' => $debit,
        );
        $output = $this->db->insert('ledger_book_reference', $tblValues);
        
         $submasterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
             'site_expense_details_id' => $submasterid,
            'site_expense_id' => $masterid,
            'site_expense_account' => $postdata['expense_account_' . $i],
              'site_expense_amount' => $postdata['amount_' . $i],
             'site_expense_narration' => $postdata['site_expense_narration_' . $i],
            
            
        );
        $output = $this->db->insert('con_site_expense_details', $tblValues);
        
       $i++; }
        $output = $this->mastermodel->save_user_activities('Add Site Expenses',$masterid, 'con_site_expense');  //ss
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = 'Error on adding record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = 'Record Added  successfully';
            return $data;
        }
    }
    
    
      public function update_site_expense($postdata)
    {
        $this->db->trans_begin();
        $tblValues = array(
            'voucher_no' => $postdata['site_expense_voucher_no'],
            'voucher_date' => $this->mastermodel->convert_date_format($postdata['site_expense_date']),
        );
        $this->db->where('ledger_book_id', $postdata['ledger_book_id']);
        $output = $this->db->update('ledger_book', $tblValues);
        $tblValues = array(
          'site' => $postdata['site'],
            'site_expense_petty_cash' => $postdata['site_expense_petty_cash'],
             'site_expense_opening_balance' => $postdata['site_expense_opening_balance'],
              'site_expense_incharge' => $postdata['site_expense_incharge'],
            'site_expense_date' => $this->mastermodel->convert_date_format($postdata['site_expense_date']),
            'site_expense_voucher_no' => $postdata['site_expense_voucher_no'],
            );
        $this->db->where('site_expense_id', $postdata['site_expense_id']);
        $output = $this->db->update('con_site_expense', $tblValues);
        $ledger_id = $postdata['ledger_book_id'];
        $pid = $this->db->query("select ledger_book_details_id from ledger_book_details where ledger_book_id='$ledger_id'order by ledger_book_details_id desc");
        $result = $pid->result();
        if (!empty($result))
        {
            foreach ($result as $value)
            {
                $pdetid = $value->ledger_book_details_id;
                $this->db->where('ledger_book_reference.ledger_book_details', $pdetid);
                $output = $this->db->delete('ledger_book_reference');
            }
        }


        $this->db->where('ledger_book_id', $postdata['ledger_book_id']);
        $this->db->delete('ledger_book_details');
        
         $this->db->where('site_expense_id', $postdata['site_expense_id']);
        $this->db->delete('con_site_expense_details');
         $sitecostcenter = $this->accountingmodel->get_costcentremaster_id('con_project', 'con_project_id', 'ledger', $postdata['site']);
     
        $ret = $postdata['site_expense_petty_cash'];
//        $set = $this->accountingmodel->get_account_settings('expense');
        $i = 1;
        while (isset($postdata['expense_account_' . $i]))
        {
       $set = $postdata['expense_account_' . $i];
       $tblValues = array(
            'ledger_book_id' => $postdata['ledger_book_id'],
            'account_ledger_id' => $ret,
            'debit' => $postdata['site_expense_amount_' . $i],
        );
        $output = $this->db->insert('ledger_book_details', $tblValues);
        $ddet_id = $this->db->insert_id();

        $credit = 0;
        $debit =$postdata['site_expense_amount_' . $i];

        $tblValues = array(
            'ledger_book_details' => $ddet_id,
            'ref_ledger' => $sitecostcenter,
            'ref_amount' => $postdata['site_expense_amount_' . $i],
            'credit' => $credit,
            'debit' => $debit,
        );
        $output = $this->db->insert('ledger_book_reference', $tblValues);
        $tblValues = array(
            'ledger_book_id' => $postdata['ledger_book_id'],
            'account_ledger_id' => $set,
            'credit' =>$postdata['site_expense_amount_' . $i]
        );
        $output = $this->db->insert('ledger_book_details', $tblValues);
        $cdet_id = $this->db->insert_id();

        $debit = 0;
        $credit = $postdata['site_expense_amount_' . $i];

        $tblValues = array(
            'ledger_book_details' => $cdet_id,
            'ref_ledger' => $sitecostcenter,
            'ref_amount' => $postdata['site_expense_amount_' . $i],
            'credit' => $credit,
            'debit' => $debit,
        );
        $output = $this->db->insert('ledger_book_reference', $tblValues);
     
        
         $submasterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
             'site_expense_details_id' => $submasterid,
            'site_expense_id' => $postdata['site_expense_id'],
            'site_expense_account' => $postdata['expense_account_' . $i],
              'site_expense_amount' => $postdata['site_expense_amount_' . $i],
             'site_expense_narration' => $postdata['site_expense_narration_' . $i],
            
            
        );
        $output = $this->db->insert('con_site_expense_details', $tblValues);
        
        
        
        $i++;  }
        $output = $this->mastermodel->save_user_activities('Edit Site Expenses',$postdata['site_expense_id'], 'con_site_expense');  //ss
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = 'Error on Updating record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = 'Record Updated successfully';
            return $data;
        }
    }
    function search_expense(){
        $data = array();
        $this->db->select('*');
        $this->db->from('con_site_expense');
        $this->db->join('master', 'master.master_id=site_expense_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('site_expense_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    function search_tool_allocation_employee()
    {
        $data = array();
        $this->db->select('tool_allocation_employee.*');
        $this->db->from('tool_allocation_employee');
        $this->db->join('master', 'master.master_id=tool_allocation_employee.allocation_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('tool_allocation_employee.allocation_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    function insert_tool_allocation_employee($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $code = $this->mastermodel->get_ref('allocation_code', 'tool_allocation_employee', 'allocation_code');
        
        $tblValues = array(
            'allocation_id' => $masterid,
            'allocation_code' => $code,
            'allocation_date' => $this->mastermodel->convert_date_format($postdata['allocation_date']),
            'project_id' => $postdata['project_id'],
            'in_charge' => $postdata['in_charge'],
            'employee_id' => $postdata['employee_id']
        );
        $this->db->insert('tool_allocation_employee', $tblValues);
        
        foreach($postdata['request_id'] as $item)
        {
            $sub1 = $this->mastermodel->insertmasterdata();
            $tblValues = array(
            'tool_request_id' => $sub1,
            'allocation_id' => $masterid,
            'request_id' => $item
            );
        $this->db->insert('tool_allocation_employee_request', $tblValues);
        }

        $i = 1;
        while (!empty($postdata['tool_id' . $i]))
        {
            $detailsid = $this->mastermodel->insertmasterdata();
            $Values = array(
                'tool_allocation_details_id' => $detailsid,
                'tool_allocation_id' => $masterid,
                'tool_request_details_id' => $postdata['tool_request_details_id' . $i],
                'tool_id' => $postdata['tool_id' . $i],
                'allocated_qty' => $postdata['allocated_qty' . $i],
                'expected_return_date' => $this->mastermodel->convert_date_format($postdata['expected_return_date' . $i]),
                'note' => $postdata['note' . $i]
            );
            $this->db->insert('tool_allocation_employee_details', $Values);
            $i++;
        }
        $output = $this->mastermodel->save_user_activities('Add Tool Allocation Employee',$masterid, 'tool_allocation_employee');  //ss
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    function update_tool_allocation_employee($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        
        $tblValues = array(
            'allocation_date' => $this->mastermodel->convert_date_format($postdata['allocation_date'])
        );
        $this->db->where('tool_allocation_employee.allocation_id', $postdata['allocation_id']);
        $this->db->update('tool_allocation_employee', $tblValues);
        
       $this->db->where('tool_allocation_employee_details.tool_allocation_id', $postdata['allocation_id']);
       $this->db->delete('tool_allocation_employee_details');
       
        $i = 1;
        while (!empty($postdata['tool_id' . $i]))
        {
            $detailsid = $this->mastermodel->insertmasterdata();
            $Values = array(
                'tool_allocation_details_id' => $detailsid,
                'tool_allocation_id' => $postdata['allocation_id'],
                'tool_request_details_id' => $postdata['tool_request_details_id' . $i],
                'tool_id' => $postdata['tool_id' . $i],
                'allocated_qty' => $postdata['allocated_qty' . $i],
                'expected_return_date' => $this->mastermodel->convert_date_format($postdata['expected_return_date' . $i]),
                'note' => $postdata['note' . $i]
            );
            $this->db->insert('tool_allocation_employee_details', $Values);
            $i++;
        }
        $output = $this->mastermodel->save_user_activities('Edit Tool Allocation Employee',$postdata['allocation_id'], 'tool_allocation_employee');  //ss
        
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    function get_allocated_tools($id)
    { 
        $this->db->select('tool_allocation_employee_details.*');
        $this->db->from('tool_allocation_employee_details');
        $this->db->join('tool_allocation_employee','tool_allocation_employee.allocation_id=tool_allocation_employee_details.tool_allocation_id');
        $this->db->where('tool_allocation_employee.project_id', $id['project_id']);
        $data = $this->db->get()->result();
        return $data;
    }
    function search_tool_return_employee()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('tool_return_employee');
        $this->db->join('master', 'master.master_id=tool_return_employee.return_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('tool_return_employee.return_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    function insert_tool_return_employee($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $code = $this->mastermodel->get_ref('return_code', 'tool_return_employee', 'return_code');
        
        $tblValues = array(
            'return_id' => $masterid,
            'return_code' => $code,
            'return_date' => $this->mastermodel->convert_date_format($postdata['return_date']),
            'return_project_id' => $postdata['return_project_id'],
            'in_charge' => $postdata['in_charge'],
            'return_employee' => $postdata['return_employee']
        );
        $this->db->insert('tool_return_employee', $tblValues);
        
        $i = 1;
        while (!empty($postdata['returned_tool_id' . $i]))
        {
            $detailsid = $this->mastermodel->insertmasterdata();
            $Values = array(
                'details_id' => $detailsid,
                'details_return_id' => $masterid,
                'details_allocation_details_id' => $postdata['details_allocation_details_id' . $i],
                'returned_tool_id' => $postdata['returned_tool_id' . $i],
                'returned_qty' => $postdata['returned_qty' . $i],
                'returned_date' => $this->mastermodel->convert_date_format($postdata['returned_date' . $i]),
                'returned_note' => $postdata['returned_note' . $i]
            );
            $this->db->insert('tool_return_employee_details', $Values);
            $i++;
        }
        $output = $this->mastermodel->save_user_activities('Add Tool Return Employee',$masterid, 'tool_return_employee');  //ss
        
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    function update_tool_return_employee($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        
        $tblValues = array(
            'return_date' => $this->mastermodel->convert_date_format($postdata['return_date'])
        );
        $this->db->where('return_id', $postdata['return_id']);
        $this->db->update('tool_return_employee', $tblValues);
        
        $this->db->where('details_return_id', $postdata['return_id']);
        $this->db->delete('tool_return_employee_details');
        $i = 1;
        while (!empty($postdata['returned_tool_id' . $i]))
        {
            $detailsid = $this->mastermodel->insertmasterdata();
            $Values = array(
                'details_id' => $detailsid,
                'details_return_id' => $postdata['return_id'],
                'details_allocation_details_id' => $postdata['details_allocation_details_id' . $i],
                'returned_tool_id' => $postdata['returned_tool_id' . $i],
                'returned_qty' => $postdata['returned_qty' . $i],
                'returned_date' => $this->mastermodel->convert_date_format($postdata['returned_date' . $i]),
                'returned_note' => $postdata['returned_note' . $i]
            );
            $this->db->insert('tool_return_employee_details', $Values);
            $i++;
        }
        $output = $this->mastermodel->save_user_activities('Edit Tool Return Employee',$postdata['return_id'], 'tool_return_employee');  //ss
        
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    function get_allocation_details($id)
    {
        $this->db->select('*');
        $this->db->from('con_rented_tool_allocation_details');
        $this->db->where('rented_tool_allocation_id', $id['id']);
        $data = $this->db->get()->result();
        return $data;
    }
    function search_tool_return_project()
    {
        $data = array();
        $this->db->select('tool_return_project.*');
        $this->db->from('tool_return_project');
        $this->db->join('master', 'master.master_id=tool_return_project.return_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('tool_return_project.return_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    function insert_tool_return_project($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $code = $this->mastermodel->get_ref('return_code', 'tool_return_employee', 'return_code');
        
        $tblValues = array(
            'return_id' => $masterid,
            'return_code' => $code,
            'return_date' => $this->mastermodel->convert_date_format($postdata['return_date']),
            'project_id' => $postdata['project_id'],
            'incharge' => $postdata['incharge'],
            'allocation_id' => $postdata['allocation_id']
        );
        $this->db->insert('tool_return_project', $tblValues);
        
        $i = 1;
        while (!empty($postdata['tool_id' . $i]))
        {
            $detailsid = $this->mastermodel->insertmasterdata();
            $Values = array(
                'return_id' => $detailsid,
                'return_project_id' => $masterid,
                'allocation_details_id' => $postdata['allocation_details_id' . $i],
                'tool_id' => $postdata['tool_id' . $i],
                'from_godown' => $postdata['from_godown' . $i],
                'to_godown' => $postdata['to_godown' . $i],
                'returned_qty' => $postdata['returned_qty' . $i],
                'note' => $postdata['note' . $i]
            );
            $this->db->insert('tool_return_project_details', $Values);
            
            
            $from_stock = $this->check_rented_stock($postdata['from_godown' . $i], $postdata['tool_id' . $i]);
            if(!empty($from_stock))
            {
                $this->db->set('qty', 'qty-'.$postdata['returned_qty' . $i] ,FALSE);
                $this->db->where('stock_id' , $from_stock->stock_id);
                $this->db->update('tool_stock');
            }
            
            $to_stock = $this->check_rented_stock($postdata['to_godown' . $i], $postdata['tool_id' . $i]);
            if(!empty($to_stock->qty))
            {
                $this->db->set('qty', 'qty+'.$postdata['returned_qty' . $i] ,FALSE);
                $this->db->where('stock_id' , $to_stock->stock_id);
                $this->db->update('tool_stock');
            }
            else
            {
                $fieldsid = $this->mastermodel->insertmasterdata();
                $fields = array(
                    'stock_id' => $fieldsid,
                    'item_id' => $postdata['tool_id' . $i],
                    'qty' => $postdata['returned_qty' . $i],
                    'godown_id' => $postdata['to_godown' . $i],
                );
                $this->db->insert('tool_stock', $fields);
            }
            $i++;
        }
        $output = $this->mastermodel->save_user_activities('Add Tool Return Project',$masterid, 'tool_return_project');  //ss
        
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    function update_tool_return_project($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        
        $tblValues = array(
            'return_date' => $this->mastermodel->convert_date_format($postdata['return_date'])
        );
        $this->db->where('tool_return_project.return_id', $postdata['return_id']);
        $this->db->update('tool_return_project', $tblValues);
        
        $this->db->where('tool_return_project_details.return_project_id', $postdata['return_id']);
        $this->db->delete('tool_return_project_details');
        
        $i = 1;
        while (!empty($postdata['tool_id' . $i]))
        {
            $detailsid = $this->mastermodel->insertmasterdata();
            $Values = array(
                'return_id' => $detailsid,
                'return_project_id' => $postdata['return_id'],
                'allocation_details_id' => $postdata['allocation_details_id' . $i],
                'from_godown' => $postdata['from_godown' . $i],
                'to_godown' => $postdata['to_godown' . $i],
                'tool_id' => $postdata['tool_id' . $i],
                'returned_qty' => $postdata['returned_qty' . $i],
                'note' => $postdata['note' . $i]
            );
            $this->db->insert('tool_return_project_details', $Values);
            $i++;
        }
        $output = $this->mastermodel->save_user_activities('Edit Tool Return Project',$postdata['return_id'], 'tool_return_project');  //ss
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    function get_allocated_tools_employee($id)
    {
        $this->db->select('tool_allocation_employee_details.*');
        $this->db->from('tool_allocation_employee_details');
        $this->db->join('tool_allocation_employee','tool_allocation_employee.allocation_id=tool_allocation_employee_details.tool_allocation_id');
        $this->db->where('tool_allocation_employee.project_id', $id['project_id']);
        $this->db->where('tool_allocation_employee.employee_id', $id['employee_id']);
        $data = $this->db->get()->result();
        return $data;
    }
    function get_rented_tool_stock($id)
    {
        $this->db->select('sum(qty) as total');
        $this->db->from('tool_stock');
        $this->db->join('master','master.master_id=tool_stock.stock_id');
        $data['stock'] = $this->db->get()->row();
        return $data;
    }
   
    function get_tool_allocation_emp_detailes($ids)
    { 
        $data = 0;
        $this->db->select('*');
        $this->db->from('con_tool_request_details');
        $this->db->where_in('con_tool_request_details.tool_request_id',$ids['id']);
        $data = $this->db->get()->result();
        
        return $data;
    }
    function check_rented_stock($godown_id, $item_id)
    {
        $this->db->select('stock_id, qty');
        $this->db->from('tool_stock');
        $this->db->where('godown_id', $godown_id);
        $this->db->where('item_id', $item_id);
        $data = $this->db->get()->row();
        ($data == null)? $data = array('qty'=> 0) : $data;
        return $data;
    }
    function search_tool_stock()
    {
        $data = array();
        $this->db->select('tool_stock.*');
        $this->db->from('tool_stock');
        $this->db->join('master', 'master.master_id=tool_stock.stock_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->where('tool_stock.qty >', 0);
        $this->db->order_by('stock_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
      function delete_purchase_id($id)
    {  
         $this->db->trans_begin();
      
            $pid = $this->db->query("select ledger_book_details_id from ledger_book_details where ledger_book_id='$id'order by ledger_book_details_id desc");
            $result = $pid->result();
            if (!empty($result))
            {
                foreach ($result as $value)
                {
                    $pdetid = $value->ledger_book_details_id;
                    $this->db->where('ledger_book_reference.ledger_book_details', $pdetid);
                    $output = $this->db->delete('ledger_book_reference');
                }
            }
            $this->db->where('ledger_book_details.ledger_book_id', $id);
            $output = $this->db->delete('ledger_book_details');
            $q = $this->db->query("select con_purchase_id from con_purchase where po_ledger='$id'order by po_ledger desc limit 1");
            $result = $q->row();
            if (!empty($result))
            {
                $jno = $result->con_purchase_id;
            }
            $pdet = $this->db->query("select po_details,quantity from con_purchase_details where con_purchase_id='$jno'order by con_purchase_details_id desc");
            $result = $pdet->result();
            if (!empty($result))
            {
                foreach ($result as $value)
                {
                    $pdetid = $value->po_details;

                    $prev_qnt = $value->quantity;

                    if (!empty($pdetid))
                    {
                        $output = $this->db->query("UPDATE con_po_details SET purchase_quantity = purchase_quantity -" . $prev_qnt . " WHERE con_po_details_id = " . $pdetid);
                    }
                }
            }
            $purchase_stock=$this->mastermodel->selected_data_by_id('con_purchase_details',array('item','godown_id','quantity'),'con_purchase_id',$jno);
            foreach ($purchase_stock as $value){
                $output = $this->db->query("UPDATE prop_item_stock SET prop_item_stock_qty = prop_item_stock_qty -" . $value->quantity . " WHERE prop_item_id = " . $value->item. " and prop_godown_id =".$value->godown_id);
                   
            }
            $this->db->where('con_purchase_details.con_purchase_id', $jno);
            $output = $this->db->delete('con_purchase_details');
            $this->db->where('con_purchase.con_purchase_id', $jno);
            $output = $this->db->delete('con_purchase');
            $this->db->where('ledger_book.ledger_book_id', $id);
            $output = $this->db->delete('ledger_book');
           

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = "Unable to delete Record..!";
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = "Data Deleted Successfully..!";
            return $data;
        }
    }
    function load_tool_return_vendor($postata)
    {
        $this->db->select('*');
        $this->db->from('con_rented_tool_receipt s1');
        $this->db->where('s1.rented_tool_receipt_id', $postata['receipt_id']);
        $this->db->join('con_rented_tool_receipt_details s2', 's1.rented_tool_receipt_id=s2.rented_tool_receipt_id AND s2.qty_returned <= s2.qty_delivered');
        $this->db->group_by('s2.tool_id');
        $data = $this->db->get()->result();
        
        return $data;
    }
    function load_remaining_vendor_tools($vendor_id, $tool_id)
    {
        $this->db->select('sum(con_rented_tool_receipt_details.qty_delivered) as receipt_qty');
        $this->db->from('con_rented_tool_receipt_details');
        $this->db->join('con_rented_tool_receipt', 'con_rented_tool_receipt_details.rented_tool_receipt_id=con_rented_tool_receipt.rented_tool_receipt_id');
        $this->db->where('con_rented_tool_receipt.rented_tool_receipt_vendor', $vendor_id);
        $this->db->where('con_rented_tool_receipt_details.tool_id', $tool_id);
        
        $data1 = $this->db->get()->row();
        
        $this->db->select('sum(tool_vendor_return_details.returned_qty) as returned_qty');
        $this->db->from('tool_vendor_return_details');
        $this->db->join('tool_vendor_return', 'tool_vendor_return.return_id=tool_vendor_return_details.tool_vendor_return_id');
        $this->db->where('tool_vendor_return.vendor_id', $vendor_id);
        $this->db->where('tool_vendor_return_details.tool_id', $tool_id);
        
        $data2 = $this->db->get()->row();
        $data = $data1->receipt_qty - $data2->returned_qty;
        
        return $data;
    }
    function search_tool_return_vendor()
    {
        $data = array();
        $this->db->select('tool_vendor_return.*');
        $this->db->from('tool_vendor_return');
        $this->db->join('master', 'master.master_id=tool_vendor_return.return_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('tool_vendor_return.return_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    function insert_tool_return_vendor($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $code = $this->mastermodel->get_ref('return_code', 'tool_vendor_return', 'return_code');
        
        $tblValues = array(
            'return_id' => $masterid,
            'return_code' => $code,
            'return_date' => $this->mastermodel->convert_date_format($postdata['return_date']),
            'vendor_id' => $postdata['vendor_id'],
            'purchase_id' => $postdata['purchase_id'],
            'remarks' => $postdata['remarks']
        );
        $this->db->insert('tool_vendor_return', $tblValues);
        
        $i = 1;
        while (!empty($postdata['tool_id' . $i]))
        {
            $detailsid = $this->mastermodel->insertmasterdata();
            $Values = array(
                'details_id' => $detailsid,
                'tool_vendor_return_id' => $masterid,
                'tool_id' => $postdata['tool_id' . $i],
                'godown_id' => $postdata['godown_id' . $i],
                'returned_qty' => $postdata['returned_qty' . $i],
                'receipt_id' => $postdata['receipt_id' . $i],
                'note' => $postdata['note' . $i]
            );
            $this->db->insert('tool_vendor_return_details', $Values);
//            receipt
            $this->db->set('qty_returned', 'qty_returned+'.$postdata['returned_qty' . $i], FALSE);
            $this->db->where('rented_tool_receipt_details_id', $postdata['receipt_id' . $i]);
            $this->db->update('con_rented_tool_receipt_details');
//            receipt
//            stock
            $stock = $this->check_rented_stock($postdata['godown_id' . $i], $postdata['tool_id' . $i]);
            $new_stock = $stock->qty - $postdata['returned_qty' . $i];
            $stock_values = array(
                'qty'=> $new_stock
            );
            
            $this->db->where('stock_id', $stock->stock_id);
            $this->db->update('tool_stock', $stock_values);
//            stock
            $i++;
        }
        $output = $this->mastermodel->save_user_activities('Add Tool Return Vendor',$masterid, 'tool_vendor_return');  //ss
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    function update_tool_return_vendor($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        
        $tblValues = array(
            'return_date' => $this->mastermodel->convert_date_format($postdata['return_date']),
            'remarks' => $postdata['remarks']
        );
        $this->db->where('return_id', $postdata['return_id']);
        $this->db->update('tool_vendor_return', $tblValues);
        
        $this->db->where('tool_vendor_return_id', $postdata['return_id']);
        $this->db->delete('tool_vendor_return_details');
        $i = 1;
        while (!empty($postdata['tool_id' . $i]))
        {
            $detailsid = $this->mastermodel->insertmasterdata();
            $Values = array(
                'details_id' => $detailsid,
                'tool_vendor_return_id' => $postdata['return_id'],
                'tool_id' => $postdata['tool_id' . $i],
                'godown_id' => $postdata['godown_id' . $i],
                'returned_qty' => $postdata['returned_qty' . $i],
                'receipt_id' => $postdata['receipt_id' . $i],
                'note' => $postdata['note' . $i]
            );
            $this->db->insert('tool_vendor_return_details', $Values);
//            receipt
            $rct_qty = $postdata['returned_qty' . $i] - $postdata['prev_qty' . $i];
            $this->db->set('qty_returned', 'qty_returned+'.$rct_qty, FALSE);
            $this->db->where('rented_tool_receipt_details_id', $postdata['receipt_id' . $i]);
            $this->db->update('con_rented_tool_receipt_details');
//            receipt
//            stock
            
            $stock = $this->check_rented_stock($postdata['godown_id' . $i], $postdata['tool_id' . $i]);
            
            if($postdata['status'. $i] == 0)
            {
                $new_qty = ($stock->qty - $postdata['prev_qty' . $i]) + $postdata['returned_qty' . $i];
                $stock_values = array(
                    'qty'=>$new_qty
                );
                $this->db->where('stock_id', $stock->stock_id);
                $this->db->update('tool_stock', $stock_values);
            }
            else if($postdata['status'. $i] == 1)
            {
                if($stock->qty == 0)
                {
                    $field_id = $this->mastermodel->insertmasterdata();
                    $fieldvalues = array(
                        'stock_id' => $field_id,
                        'item_id' => $postdata['tool_id' . $i],
                        'qty' => $postdata['returned_qty' . $i],
                        'godown_id' => $postdata['godown_id' . $i]
                        );
                    $this->db->insert('tool_stock', $fieldvalues);
                }
                else
                {   
                    $new_qty = $postdata['returned_qty' . $i] + $stock->qty;
                    $fieldvalues = array(
                        'qty' => $new_qty
                    );
                    $this->db->where('stock_id', $stock->stock_id);
                    $this->db->update('tool_stock', $fieldvalues);
                }
            }
            else if($postdata['status'. $i] == 2)
            {
                $new_qty = $stock->qty - $postdata['returned_qty' . $i];
                $fieldvalues = array(
                    'qty' => $new_qty
                );
                $this->db->where('stock_id', $stock->stock_id);
                $this->db->update('tool_stock', $fieldvalues); 
                }
//            stock
            $i++;
        }
        $output = $this->mastermodel->save_user_activities('Edit Tool Return Vendor',$postdata['return_id'], 'tool_vendor_return');  //ss
        
        
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    function get_remaing_rtn_qty($allocation_id, $tool_id)
    {
        $this->db->select(('SUM(returned_qty) AS qty'));
        $this->db->from('tool_return_employee_details');
        $this->db->where('returned_tool_id', $tool_id);
        $this->db->where('details_allocation_details_id', $allocation_id);
       // $this->db->get()->row();
        return $this->db->get()->row()->qty;
    }
    function get_remaing_rtn_qty_edit($allocation_id, $tool_id)
    {
        $this->db->select(('allocated_qty - SUM(tool_return_employee_details.returned_qty) AS qty'));
        $this->db->from('tool_return_employee_details');
        $this->db->where('returned_tool_id', $tool_id);
        $this->db->where('details_allocation_details_id', $allocation_id);
        $this->db->join('tool_allocation_employee_details','tool_allocation_employee_details.tool_allocation_details_id=tool_return_employee_details.details_allocation_details_id');
       // $this->db->get()->row();
        
        return $this->db->get()->row()->qty;
    }
       function get_accountledger_by_commodity($id)
    {
        $this->db->select('ledger_id,ledger_name');
        $this->db->from('account_ledger');
        $this->db->join('item_master', 'item_master.item_master_account=account_ledger.ledger_id');
        $this->db->join('master', 'master.master_id=account_ledger.ledger_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->where('item_master.item_master_id', $id);
        $data = $this->db->get()->row();
       
        return $data;
    }
    function get_stock_item($val)
    {
        $this->db->select('prop_item_stock.price,prop_item_stock.prop_item_stock_id,item_master.item_master_name,prop_item_stock.prop_godown_id,prop_item_stock.prop_item_stock_qty');
        $this->db->from('prop_item_stock');
        $this->db->join('item_master', 'item_master.item_master_id=prop_item_stock.prop_item_id');
        $this->db->join('master', 'master.master_id=item_master.item_master_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
//        $this->db->where_in('account_ledger.account_group_id', $id);
        $this->db->where('prop_item_stock.prop_item_id', $val);
        $this->db->order_by('prop_item_stock.stock_date', 'desc');
        $this->db->limit(1);
        $data = $this->db->get()->row();
        return $data;
    }
     function get_item($stock_id)
    {
      $data = array();
        $this->db->select('*');
        $this->db->from('prop_item_stock');
        $this->db->join('item_master','item_master.item_master_id=prop_item_stock.prop_item_id');
        $this->db->join('godown','godown.godown_id=prop_item_stock.prop_godown_id');
        $this->db->where('prop_item_stock.prop_item_stock_id',$stock_id);
        $this->db->order_by('prop_item_stock.prop_item_stock_id', 'desc');
        $data= $this->db->get()->result();
//        echo $this->db->last_query();die();
        return $data;  
    }
    function search_item_consumption(){
        $data = array();
        $this->db->select('con_item_consumption.*');
        $this->db->from('con_item_consumption');
        $this->db->join('master', 'master.master_id=con_item_consumption.con_item_consumption_id');
//        $this->db->join('con_item_consumption_details','con_item_consumption_details.consumption_id=con_item_consumption_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        
        $this->db->order_by('con_item_consumption_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    function insert_item_consumption($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $consumption_code = $this->mastermodel->get_ref('consumption_code', 'con_item_consumption', 'consumption_code');
        $tblValues = array(
            'con_item_consumption_id' => $masterid,
            'consumption_code' => $consumption_code,
            'consumption_date' => $this->mastermodel->convert_date_format($postdata['consumption_date']),
            'consumption_project_id' => $postdata['consumption_project_id'],
            'consumption_remarks' => $postdata['consumption_remarks'],
        );
        $this->db->insert('con_item_consumption', $tblValues);
        
        $i = 1;
        while (isset($postdata['consumption_details_item_id_' . $i]))
        {
            $stock_detailes = $this->mastermodel->get_data_srow('prop_item_stock',$postdata['consumption_details_item_id_'. $i],'prop_item_stock_id');
      
            
            $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty -' . $postdata['consumption_details_qty_' . $i], false);
            $this->db->where('prop_item_stock_id', $postdata['q_stock_item_' . $i]);
            $this->db->update('prop_item_stock');
            
            
            $sub_masterid = $this->mastermodel->insertmasterdata();
            $sub_tblValues = array(
                'con_item_consumption_details_id' => $sub_masterid,
                'consumption_id' => $masterid,
                'consumption_details_stock_id'=>$postdata['q_stock_item_' . $i],
                'consumption_details_item_id' => $postdata['consumption_details_item_id_' . $i],
                'consumption_details_godown_id' => $postdata['consumption_details_godown_id_' . $i],
                'consumption_details_qty' => $postdata['consumption_details_qty_' . $i],
                'consumption_details_remarks' => $postdata['consumption_details_remarks_' . $i],
                
            );
            $this->db->insert('con_item_consumption_details', $sub_tblValues);


            $i++;
        }
//        $output = $this->mastermodel->save_user_activities('Add C-Item Transfer',$masterid, 'con_item_transfer');  //ss
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    function update_item_consumption($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'consumption_date' => $this->mastermodel->convert_date_format($postdata['consumption_date']),
//            'consumption_project_id' => $postdata['consumption_project_id'],
            'consumption_remarks' => $postdata['consumption_remarks'],
        );
        $this->db->where('con_item_consumption_id', $postdata['con_item_consumption_id']);
        $this->db->update('con_item_consumption', $tblValues);
        
        $masterid = $postdata['con_item_consumption_id'];
        
        $this->db->where('consumption_id',$postdata['con_item_consumption_id']);
        $this->db->delete('con_item_consumption_details');
        $i = 1;
        while (isset($postdata['consumption_details_item_id_' . $i]))
        {
             if ($postdata['consumption_details_item_id_' . $i] != ''){ 
                 
                 if(!empty($postdata['previus_qty_'. $i])){
                    
                    
                $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty +' . $postdata['previus_qty_'. $i], false);
                $this->db->where('prop_item_stock_id', $postdata['q_stock_item_' . $i]);
                $this->db->update('prop_item_stock');
                
                }
                if ($postdata['status_' . $i] == 1  )
                {
                $sub_masterid = $this->mastermodel->insertmasterdata();
                $sub_tblValues = array(
                    'con_item_consumption_details_id' => $sub_masterid,
                    'consumption_id' => $postdata['con_item_consumption_id'],
                    'consumption_details_stock_id'=>$postdata['q_stock_item_' . $i],
                    'consumption_details_item_id' => $postdata['consumption_details_item_id_' . $i],
                    'consumption_details_godown_id' => $postdata['consumption_details_godown_id_' . $i],
                    'consumption_details_qty' => $postdata['consumption_details_qty_' . $i],
                    'consumption_details_remarks' => $postdata['consumption_details_remarks_' . $i],

                );
                $this->db->insert('con_item_consumption_details', $sub_tblValues);
                
                $this->db->set('prop_item_stock_qty', 'prop_item_stock_qty -' . $postdata['consumption_details_qty_' . $i], false);
                $this->db->where('prop_item_stock_id', $postdata['q_stock_item_' . $i]);
                $this->db->update('prop_item_stock');
                }
                $i++;
            }
        }
        
       
//        $output = $this->mastermodel->save_user_activities('Add C-Item Transfer',$masterid, 'con_item_transfer');  //ss
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
}
 

?>
