<?php


if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Constructionreportmodel extends CI_Model
{

    function __construct()
    {
        // Call the Model constructor
        parent::__construct();
    }

    function search_report()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('report');
        $this->db->where('report_module_id', $_SESSION['current_menu']);
        $this->db->order_by('report_sort', 'asc');
        $data['results'] = $this->db->get();
        return $data;
    }
    function purchase_order_report($postdata)
    {
        $this->db->select('*');
        $this->db->from('con_po');
        $this->db->order_by('con_po.con_po_id', 'desc');
        if ($postdata['con_vendor'] != '0')
        {
            $this->db->where('con_po.con_po_vendor_id', $postdata['con_vendor']);
        }
        if ($postdata['con_po_id'] != '0')
        {
            $this->db->where('con_po.con_po_id', $postdata['con_po_id']);
        }
        if ($postdata['date_from'] != '')
        {
            $this->db->where('con_po_date >=', $this->mastermodel->convert_date_format($postdata['date_from']));
        }
        if ($postdata['date_to'] != '')
        {
            $this->db->where('con_po_date <=', $this->mastermodel->convert_date_format($postdata['date_to']));
        }

        $res = $this->db->get();
        return $res->result();
    }
    function get_po_details($id)
    {

        $this->db->select('*');
        $this->db->from('con_po_details');
        $this->db->join('item_master', 'item_master.item_master_id=con_po_details.con_po_item');
        $this->db->where('con_po_details.con_po_details_po_id', $id);
        $this->db->order_by('con_po_details.con_po_details_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }
    function load_quotation_report($postdata)
    {
        $this->db->select('*');
        $this->db->from('con_quotation');  
        $this->db->where('con_quotation_date >=',$this->mastermodel->convert_date_format($postdata['from_date']));
        $this->db->where('con_quotation_date <=',$this->mastermodel->convert_date_format($postdata['to_date']));
        if(!empty($postdata['customer_id']))
        {
            $this->db->where('con_quotation_customer',$postdata['customer_id']);
        }
        if(!empty($postdata['quotation_id']))
        {
            $this->db->where('con_quotation_id',$postdata['quotation_id']);
        }
        $this->db->order_by('con_quotation_id', 'asc');
        $data = $this->db->get()->result();
        return $data;
    }
    function load_budgeting_report($postdata)
    {
        $this->db->select('*');
        $this->db->from('con_budgeting');  
        $this->db->where('con_budgeting_date >=',$this->mastermodel->convert_date_format($postdata['from_date']));
        $this->db->where('con_budgeting_date <=',$this->mastermodel->convert_date_format($postdata['to_date']));
        if(!empty($postdata['project_id']))
        {
            $this->db->where('con_budgeting_project_id',$postdata['project_id']);
        }
        $this->db->order_by('con_budgeting_id', 'asc');
        $data = $this->db->get()->result();
        return $data;
    }
    function load_Item_retun_report($postdata)
    { 
        $this->db->select('*');
        $this->db->from('con_item_return'); 
        $this->db->where('con_item_return_date >=',$this->mastermodel->convert_date_format($postdata['from_date']));
        $this->db->where('con_item_return_date <=',$this->mastermodel->convert_date_format($postdata['to_date'])); 
        if(!empty($postdata['project_id']))
        {
            $this->db->where('con_item_return_project',$postdata['project_id']);
        }
        $this->db->order_by('con_item_return_id', 'asc');
        $data = $this->db->get()->result();
        return $data;
    }
    function load_workorder_report($postdata)
    { 
        $this->db->select('*');
        $this->db->from('con_work_order'); 
        $this->db->where('con_work_order_date >=',$this->mastermodel->convert_date_format($postdata['from_date']));
        $this->db->where('con_work_order_date <=',$this->mastermodel->convert_date_format($postdata['to_date'])); 
        
        if(!empty($postdata['work_order_id']))
        {
            $this->db->where('con_work_order_id',$postdata['work_order_id']);
        }
        if(!empty($postdata['quotation_id']))
        {
            $this->db->where('con_work_order_quotation_id',$postdata['quotation_id']);
        }
        if(!empty($postdata['customer_id']))
        {
            $this->db->where('con_work_order_customer_id',$postdata['customer_id']);
        }
        $this->db->order_by('con_work_order_id', 'asc');
        $data = $this->db->get()->result();
        return $data;
    }
    function load_purchase_report($postdata)
    { 
        $this->db->select('*');
        $this->db->from('con_purchase'); 
        $this->db->where('po_date >=',$this->mastermodel->convert_date_format($postdata['from_date']));
        $this->db->where('po_date <=',$this->mastermodel->convert_date_format($postdata['to_date'])); 
        
        if(!empty($postdata['vendor_id']))
        {
            $this->db->where('vendor',$postdata['vendor_id']);
        }
        $this->db->order_by('con_purchase_id', 'asc');
        $data = $this->db->get()->result();
        return $data;
    }
     function load_project_allocation_report($postdata)
    { 
         $this->db->select('*');
        $this->db->from('con_item_transfer');
        $this->db->join('con_project', 'con_item_transfer.con_item_transfer_project=con_project.con_project_id', 'left');
        $this->db->order_by('con_item_transfer.con_item_transfer_id', 'desc');
        if ($postdata['project_id'] != '0')
        {
            $this->db->where('con_item_transfer.con_item_transfer_project', $postdata['project_id']);
        }
        if ($postdata['from_date'] != '')
        {
            $this->db->where('con_item_transfer_date >=', $this->mastermodel->convert_date_format($postdata['from_date']));
        }
        if ($postdata['to_date'] != '')
        {
            $this->db->where('con_item_transfer_date <=', $this->mastermodel->convert_date_format($postdata['to_date']));
        }
     
        $data = $this->db->get()->result();
        return $data; 
         
     }
      function get_item_transfer_details_report($id)
    {
        $this->db->select('*,godown_from.godown_name as godown_from_name ,godown_to.godown_name as godown_to_name');
        $this->db->from('con_item_transfer_details');
        $this->db->join('item_master', 'item_master.item_master_id=con_item_transfer_details.item_master_id');
          $this->db->join('godown as godown_from', 'godown_from.godown_id=con_item_transfer_details.con_from_godown');
          $this->db->join('godown as godown_to', 'godown_to.godown_id=con_item_transfer_details.con_to_godown');
        $this->db->where('con_item_transfer_details.con_item_transfer_id', $id);
        $this->db->order_by('con_item_transfer_details.con_item_transfer_details_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }
    function get_itemStock_report($postdata)
    {     
        $data = array();
        $this->db->select('*');
        $this->db->from('prop_item_stock');
        $this->db->join('item_master','item_master.item_master_id=prop_item_stock.prop_item_id');
        $this->db->join('godown','godown.godown_id=prop_item_stock.prop_godown_id');
        
        $this->db->join('master', 'master.master_id=prop_item_stock.prop_item_stock_id');
        
        if(!empty($postdata['item_master_id'])){
            $this->db->where('prop_item_stock.prop_item_id',$postdata['item_master_id']);
        }
        if(!empty($postdata['godown_id'])){
            $this->db->where('prop_item_stock.prop_godown_id',$postdata['godown_id']);
        }
        $this->db->where('master.project_id',$_SESSION['project_id']);
        
        $this->db->order_by('prop_item_stock.prop_item_stock_id', 'desc');
        $data = $this->db->get()->result();
        return $data;  
    }
    function load_view_wise_rented_tool_report($postdata)
    {     
        $this->db->select('*');
        $this->db->from('tool_vendor_return');
        $this->db->join('con_rented_tool_receipt', 'con_rented_tool_receipt.rented_tool_receipt_id=tool_vendor_return.purchase_id', 'right');
        if ($postdata['from_date'] != '')
        {
            $this->db->where('con_rented_tool_receipt.rented_tool_receipt_date >=', $this->mastermodel->convert_date_format($postdata['from_date']));
        }
        if ($postdata['to_date'] != '')
        {
            $this->db->where('con_rented_tool_receipt.rented_tool_receipt_date <=', $this->mastermodel->convert_date_format($postdata['to_date']));
        }
        if ($postdata['vendor_id'] != '')
        {
            $this->db->where('con_rented_tool_receipt.rented_tool_receipt_vendor <=', $postdata['vendor_id']);
        }
        
        if ($postdata['tools_id'] != '')
        {
            $this->db->join('con_rented_tool_receipt_details', 'con_rented_tool_receipt.rented_tool_receipt_id=con_rented_tool_receipt_details.rented_tool_receipt_id AND con_rented_tool_receipt_details.tool_id = '.$postdata['tools_id']);
        }else{
            $this->db->join('con_rented_tool_receipt_details', 'con_rented_tool_receipt.rented_tool_receipt_id=con_rented_tool_receipt_details.rented_tool_receipt_id');
        }
        $this->db->order_by("tool_vendor_return.purchase_id", "DESC"); 

        $data = $this->db->get()->result();
        return $data; 

     }
     function get_tool_dual($return_id, $tool_id)
     {
         $this->db->select('returned_qty');
         $this->db->from('tool_vendor_return_details');
         $this->db->where('tool_vendor_return_id', $return_id);
         $this->db->where('tool_id', $tool_id);
         $data = $this->db->get()->row()->returned_qty;
         return $data;
     }
    function view_vendorWise_orderwice_report($postdata)
    {        
        $this->db->select('order_rented_tools_id,order_no,con_order_rented_tools_details.rended_tool_id,con_order_rented_tools_details.order_qty,con_order_rented_tools_details.expected_due_date');
        $this->db->from('con_order_rented_tools');
        $this->db->join('con_order_rented_tools_details', 'con_order_rented_tools_details.order_id=con_order_rented_tools.order_rented_tools_id');
        if ($postdata['from_date'] != '')
        {
            $this->db->where('con_order_rented_tools.order_date >=', $this->mastermodel->convert_date_format($postdata['from_date']));
        }
        if ($postdata['to_date'] != '')
        {
            $this->db->where('con_order_rented_tools.order_date <=', $this->mastermodel->convert_date_format($postdata['to_date']));
        }
        if ($postdata['vendor_id'] != '')
        {
            $this->db->where('con_order_rented_tools.vendor_id =', $postdata['vendor_id']);
        }
        if ($postdata['order_id'] != '')
        {
            $this->db->where('con_order_rented_tools.order_rented_tools_id =', $postdata['order_id']);
        }
        
        $this->db->order_by("con_order_rented_tools.order_rented_tools_id", "DESC"); 

        $data = $this->db->get()->result();
        
        
        foreach($data as $key => $item)
        {
            $data[$key]->span = 0;
            foreach($data as $item1)
            {
                ($item->order_rented_tools_id != $item1->order_rented_tools_id) ? : $data[$key]->span++;
            }
            
            $this->db->select('con_rented_tool_receipt.rented_tool_receipt_date,con_rented_tool_receipt_details.qty_delivered');
            $this->db->from('con_rented_tool_receipt');
            $this->db->join('con_rented_tool_receipt_order', 'con_rented_tool_receipt.rented_tool_receipt_id=con_rented_tool_receipt_order.rented_tool_receipt_id');
            $this->db->where('con_rented_tool_receipt_order.order_tool_request_id', $item->order_rented_tools_id);
            $this->db->join('con_rented_tool_receipt_details', 'con_rented_tool_receipt.rented_tool_receipt_id=con_rented_tool_receipt_details.rented_tool_receipt_id');
            $this->db->where('con_rented_tool_receipt_details.tool_id', $item->rended_tool_id);
            $data[$key]->rcpt = $this->db->get()->result();
        }
        
        return $data; 

     }
}
