<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Hrmodel extends CI_Model {

    function __construct() {
        // Call the Model constructor
        parent::__construct();
    }
    
    function search_department()
    { 
        $data = array();
        $this->db->select('*');
        $this->db->from('hr_department');
        $this->db->join('master', 'master.master_id=hr_department.hr_department_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('hr_department_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    public function insert_department($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
       
        $tblValues = array(
            'hr_department_id' => $masterid,
            'hr_department_name' => $postdata['hr_department_name'],
            );
        $this->db->insert('hr_department', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
      public function update_department($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'hr_department_name' => $postdata['hr_department_name'],
            );
        $this->db->where('hr_department_id',$postdata['hr_department_id']);
        $this->db->update('hr_department', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    function search_designation()
    { 
        $data = array();
        $this->db->select('*');
        $this->db->from('hr_designation');
        $this->db->join('master', 'master.master_id=hr_designation.hr_designation_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('hr_designation_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    public function insert_designation($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
       
        $tblValues = array(
            'hr_designation_id' => $masterid,
            'hr_designation_name' => $postdata['hr_designation_name'],
            );
        $this->db->insert('hr_designation', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
      public function update_designation($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'hr_designation_name' => $postdata['hr_designation_name'],
            );
        $this->db->where('hr_designation_id',$postdata['hr_designation_id']);
        $this->db->update('hr_designation', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    function search_division()
    { 
        $data = array();
        $this->db->select('*');
        $this->db->from('hr_division');
         $this->db->join('master', 'master.master_id=hr_division.hr_division_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('hr_division_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    public function insert_division($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
       
        $tblValues = array(
            'hr_division_id' => $masterid,
            'hr_division_name' => $postdata['hr_division_name'],
            );
        $this->db->insert('hr_division', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
      public function update_division($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'hr_division_name' => $postdata['hr_division_name'],
            );
        $this->db->where('hr_division_id',$postdata['hr_division_id']);
        $this->db->update('hr_division', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    function search_visa_type()
    { 
        $data = array();
        $this->db->select('*');
        $this->db->from('hr_visa_type');
        $this->db->join('master', 'master.master_id=hr_visa_type.hr_visa_type_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('hr_visa_type_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    public function insert_visa_type($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
       
        $tblValues = array(
            'hr_visa_type_id' => $masterid,
            'hr_visa_type_name' => $postdata['hr_visa_type_name'],
            );
        $this->db->insert('hr_visa_type', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
      public function update_visa_type($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'hr_visa_type_name' => $postdata['hr_visa_type_name'],
            );
        $this->db->where('hr_visa_type_id',$postdata['hr_visa_type_id']);
        $this->db->update('hr_visa_type', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    public function search_employees()
    {
        $profile_settings = $this->mastermodel->get_profile_settings();
        $data = array();
        $this->db->select('*');
        $this->db->from('hr_employees');
        $this->db->join('master', 'master.master_id=hr_employees.hr_employees_id');
        $this->db->join('user', 'user.employee_id=hr_employees.hr_employees_id');
        //  $user_branch = $_SESSION['master_branch'];
        //      $query = "(";         
        //      $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";      
        //      $query.=")";     
        //      $this->db->where($query);
              if ($profile_settings->agency_profile_id == $_SESSION['profile_id']) {
$user_branch = $_SESSION['master_branch'];
             $query = "(";    
             $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";    
             $query.=")";     
              if($_SESSION['master_branch']!=4906){
             $this->db->where($query);
             }
            $allowed_branches=$this->mastermodel->get_single_field_value('user','sub_branch_id','user_id',$_SESSION['user_id']);
 $query1 = "(";    
             $query1.= "FIND_IN_SET(`sub_branch_id`,'" . $allowed_branches . "') != 0";    
             $query1.=")";     
              if($_SESSION['master_branch']!=4906){
             $this->db->where($query1);
             }
        }else{
            $user_branch = $_SESSION['master_branch'];
             $query = "(";    
             $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";    
             $query.=")";     
              if($_SESSION['master_branch']!=4906){
             $this->db->where($query);
             }
        }
    //   if ($profile_settings->agency_profile_id == $_SESSION['profile_id']) {
    //       $this->db->where('user.agency_id', $_SESSION['agency_id']);
    //   }else{
    //           $this->mastermodel->user_access();
    //   }
        $this->db->where('master.project_id',$_SESSION['project_id']);
          
            
        $this->db->order_by('hr_employees_id', 'desc');
        $data['results'] = $this->db->get();
         // echo $this->db->last_query();;
        return $data;
    }
    public function insert_employees($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        
          $profile_settings = $this->mastermodel->get_profile_settings();
          $role_permission = $this->mastermodel->get_single_field_value('user_profile', 'profile_modules', 'profile_id', $profile_settings->employeer_profile_id);
       $modules_permission = $this->mastermodel->get_single_field_value('user_profile', 'profile_modules_permission', 'profile_id', $profile_settings->employeer_profile_id);
         $username=trim( $postdata['hr_employees_name'] );
       
       $user_id = $this->mastermodel->insertmasterdata();
       $masterid = $this->mastermodel->insertmasterdata();
       $tblValues = array(
            'user_id' => $user_id,
            'user_name' => $username,
            'phone' => $postdata['hr_employees_contact_no'],
            'email' => $postdata['hr_employees_email'],
            'password' => md5($postdata['hr_employees_name']),
            'profile_id' => $postdata['profile_id'],
            'agency_id' =>  ($postdata['branch_agency']=="branch")?0:$postdata['agency_id'],
            'sub_branch_id' => ($postdata['branch_agency']=="branch")?$postdata['regional_branch']:0,
            'user_modules' => $role_permission,
            'modules_permission' => $modules_permission,
//            'home_page' => $postdata['role_home_page'],
            'manager_approve' => 0,
            'gm_approve' => 0,
            'employee_id' => $masterid,
                  'branch_id' => $_SESSION['master_branch']
        );
        $this->db->insert('user', $tblValues);
        
        $set = $this->accountingmodel->get_account_settings('employee');
        $ledger_id = $this->mastermodel->insertmasterdata();
          $tblValues = array(
                'ledger_id' => $ledger_id,
//            'group_id' => '45',
                'group_id' => $set,
                'ledger_name' => $postdata['hr_employees_name'],
                'mailing_name' => $postdata['hr_employees_name'],
                'address' => $postdata['hr_employees_address'],
                'phone' => $postdata['hr_employees_contact_no'],
                'mobile' => $postdata['hr_employees_contact_no'],
                'email' => $postdata['hr_employees_email'],
                
            );
            $output = $this->db->insert('cost_centre_ledger', $tblValues);
        $tblValues = array(
            'hr_employees_id' => $masterid,
            'hr_employees_code' => $this->mastermodel->get_ref('hr_employees_code', 'hr_employees', 'hr_employees_code'),
            'hr_employees_name' => $postdata['hr_employees_name'],
            'hr_employees_department_id' => $postdata['hr_employees_department_id'],
            'hr_employees_designation_id' => $postdata['hr_employees_designation_id'],
            'hr_employees_email' => $postdata['hr_employees_email'],
            'hr_employees_address' => $postdata['hr_employees_address'],
            'hr_employees_gender' => $postdata['hr_employees_gender'],
            'hr_employees_DOB' => $this->mastermodel->convert_date_format($postdata['hr_employees_DOB']),
            'hr_employees_faher_name' => $postdata['hr_employees_faher_name'],
            'hr_employees_mother_name' => $postdata['hr_employees_mother_name'],
            'hr_employees_division_id' => $postdata['hr_employees_division_id'],
            'hr_employees_joining_date' => $this->mastermodel->convert_date_format($postdata['hr_employees_joining_date']),
            'hr_employees_blood_group' => $postdata['hr_employees_blood_group'],
            'hr_employees_contact_no' => $postdata['hr_employees_contact_no'],
            'hr_employees_passport_no' => $postdata['hr_employees_passport_no'],
            'hr_employees_passport_exp_date' => $this->mastermodel->convert_date_format($postdata['hr_employees_passport_exp_date']),
            'hr_employees_visa_type_id' => $postdata['hr_employees_visa_type_id'],
            'hr_employees_visa_exp_date' => $this->mastermodel->convert_date_format($postdata['hr_employees_visa_exp_date']),
            'hr_employees_visa_no' => $postdata['hr_employees_visa_no'],
            'hr_employees_labour_card_issue_date' => $this->mastermodel->convert_date_format($postdata['hr_employees_labour_card_issue_date']),
            'hr_employees_labour_card_no' => $postdata['hr_employees_labour_card_no'],
            'hr_employees_exp_date' => $this->mastermodel->convert_date_format($postdata['hr_employees_exp_date']),
            'hr_employees_device_no' => $postdata['hr_employees_device_no'],
             'device_id' => $postdata['hr_employees_device_no'],
            'hr_employees_spouse_name' => $postdata['hr_employees_spouse_name'],
            'hr_employees_bank_name' => $postdata['hr_employees_bank_name'],
            'hr_employees_bank_branch' => $postdata['hr_employees_bank_branch'],
            'hr_employees_residence' => $postdata['hr_employees_residence'],
            'hr_employees_bank_account_no' => $postdata['hr_employees_bank_account_no'],
             'hr_employees_branch' => $_SESSION['master_branch'],
             'hr_employees_grade_id' => $postdata['hr_employees_grade_id'],
            'hr_employee_ledger' => $ledger_id,
            'user_id'=>$user_id
            );
        
        
        $this->db->insert('hr_employees', $tblValues);
        
        $i=0;
        while(!empty($_FILES['hr_employees_file_name'.++$i]))
        {   
            $upload_data = $this->mastermodel->upload_image('hr_employees_file_name'.$i);
            if (!empty($upload_data['file_name'])) {
                $tblValues['hr_employees_file_name'] = $upload_data['file_name'];
                $files_id = $this->mastermodel->insertmasterdata();
                $filesValues = array(
                    'hr_employees_file_details_id' => $files_id,
                    'employees_id' => $masterid,
                    'hr_employees_file_name' => $upload_data['file_name']
                );
                $this->db->insert('hr_employees_file_details', $filesValues);
            }
        }
        $output = $this->mastermodel->save_user_activities('Add Employees',$masterid, 'hr_employees');  //ss
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
      public function update_employees($postdata)
    {
        $data = array();
        $this->db->trans_begin();
         $set = $this->accountingmodel->get_account_settings('employee');
          $this->mastermodel->update_master_branch($postdata['hr_employee_ledger']);   
          $tblValues = array(
                'ledger_name' => $postdata['hr_employees_name'],
                'mailing_name' => $postdata['hr_employees_name'],
                'address' => $postdata['hr_employees_address'],
                'phone' => $postdata['hr_employees_contact_no'],
                'mobile' => $postdata['hr_employees_contact_no'],
                'email' => $postdata['hr_employees_email'],
            );
         $this->db->where('ledger_id', $postdata['hr_employee_ledger']);
        $output = $this->db->update('cost_centre_ledger', $tblValues);
        
        $tblValues_user = array(
                 'user_name'=>$postdata['hr_employees_name'],
                  'email' => $postdata['hr_employees_email'],
                'phone' => $postdata['hr_employees_contact_no'],
                'branch_id' => $_SESSION['master_branch'],
                'agency_id' =>  ($postdata['branch_agency']=="branch")?0:$postdata['agency_id'],
                'sub_branch_id' => ($postdata['branch_agency']=="branch")?$postdata['regional_branch']:0,
            );
         $this->db->where('employee_id', $postdata['hr_employees_id']);
      $this->db->update('user', $tblValues_user);
        $this->mastermodel->update_master_branch($postdata['hr_employees_id']);  
        $tblValues = array(
            'hr_employees_name' => $postdata['hr_employees_name'],
            'hr_employees_department_id' => $postdata['hr_employees_department_id'],
            'hr_employees_designation_id' => $postdata['hr_employees_designation_id'],
            'hr_employees_email' => $postdata['hr_employees_email'],
            'hr_employees_address' => $postdata['hr_employees_address'],
            'hr_employees_gender' => $postdata['hr_employees_gender'],
            'hr_employees_DOB' => $this->mastermodel->convert_date_format($postdata['hr_employees_DOB']),
            'hr_employees_faher_name' => $postdata['hr_employees_faher_name'],
            'hr_employees_mother_name' => $postdata['hr_employees_mother_name'],
            'hr_employees_division_id' => $postdata['hr_employees_division_id'],
            'hr_employees_joining_date' => $this->mastermodel->convert_date_format($postdata['hr_employees_joining_date']),
            'hr_employees_blood_group' => $postdata['hr_employees_blood_group'],
            'hr_employees_contact_no' => $postdata['hr_employees_contact_no'],
            'hr_employees_passport_no' => $postdata['hr_employees_passport_no'],
            'hr_employees_passport_exp_date' => $this->mastermodel->convert_date_format($postdata['hr_employees_passport_exp_date']),
            'hr_employees_visa_type_id' => $postdata['hr_employees_visa_type_id'],
            'hr_employees_visa_exp_date' => $this->mastermodel->convert_date_format($postdata['hr_employees_visa_exp_date']),
            'hr_employees_visa_no' => $postdata['hr_employees_visa_no'],
            'hr_employees_labour_card_issue_date' => $this->mastermodel->convert_date_format($postdata['hr_employees_labour_card_issue_date']),
            'hr_employees_labour_card_no' => $postdata['hr_employees_labour_card_no'],
            'hr_employees_exp_date' => $this->mastermodel->convert_date_format($postdata['hr_employees_exp_date']),
            'hr_employees_device_no' => $postdata['hr_employees_device_no'],
             'device_id' => $postdata['hr_employees_device_no'],
            'hr_employees_spouse_name' => $postdata['hr_employees_spouse_name'],
            'hr_employees_bank_name' => $postdata['hr_employees_bank_name'],
            'hr_employees_bank_branch' => $postdata['hr_employees_bank_branch'],
             'hr_employees_residence' => $postdata['hr_employees_residence'],
            'hr_employees_bank_account_no' => $postdata['hr_employees_bank_account_no'],
             'hr_employees_branch' => $_SESSION['master_branch'],
             'hr_employees_grade_id' => $postdata['hr_employees_grade_id'],
            );
        $this->db->where('hr_employees_id',$postdata['hr_employees_id']);
        $this->db->update('hr_employees', $tblValues);
        
        $this->db->where('hr_employees_file_details.employees_id', $postdata['hr_employees_id']);
        $this->db->delete('hr_employees_file_details');
        $i=0;
        while(!empty($_FILES['hr_employees_file_name'.++$i]) || !empty($postdata['prev_hr_employees_file_name'.$i]))
        {   
            $upload_data = $this->mastermodel->upload_image('hr_employees_file_name'.$i);
            if (!empty($upload_data['file_name'])) {
                $file_name = $upload_data['file_name'];
            }else{
                $file_name = $postdata['prev_hr_employees_file_name'.$i];
            }
            $files_id = $this->mastermodel->insertmasterdata();
            $filesValues = array(
                'hr_employees_file_details_id' => $files_id,
                'employees_id' => $postdata['hr_employees_id'],
                'hr_employees_file_name' => $file_name
            );
            $this->db->insert('hr_employees_file_details', $filesValues);
        }        
        $output = $this->mastermodel->save_user_activities('Edit Employees',$postdata['hr_employees_id'], 'hr_employees');  //ss
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
      public function search_shift_details()
    {
        
        $data = array();
        $this->db->select('*');
        $this->db->from('hr_shift_details');
        $this->db->join('master', 'master.master_id=hr_shift_details.hr_shift_details_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
         $user_branch = $_SESSION['user_branch'];
             $query = "(";     
             $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";    
             $query.=")";     
             $this->db->where($query);
        $this->db->order_by('hr_shift_details_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
     public function insert_shift_details($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
       
        $tblValues = array(
            'hr_shift_details_id' => $masterid,
            'hr_shift_name' => $postdata['hr_shift_name'],
            'hr_shift_start_time' => $postdata['hr_shift_start_time'],
            'hr_shift_end_time' => $postdata['hr_shift_end_time'],
            'hr_shift_grace_time' => $postdata['hr_shift_grace_time'],
            'hr_shift_lunch_break' => $postdata['hr_shift_lunch_break'],
            'hr_shift_break_start' => $postdata['hr_shift_break_start'],
            'hr_shift_break_end' => $postdata['hr_shift_break_end'],
            'hr_shift_branch' => $_SESSION['master_branch'],
            
            );
        $this->db->insert('hr_shift_details', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    public function update_shift_details($postdata)
    {  
        $data = array();
        $this->db->trans_begin();
         $this->mastermodel->update_master_branch($postdata['hr_shift_details_id']);   
        $tblValues = array(
            'hr_shift_name' => $postdata['hr_shift_name'],
            'hr_shift_start_time' => $postdata['hr_shift_start_time'],
            'hr_shift_end_time' => $postdata['hr_shift_end_time'],
            'hr_shift_grace_time' => $postdata['hr_shift_grace_time'],
            'hr_shift_lunch_break' => $postdata['hr_shift_lunch_break'],
            'hr_shift_break_start' => $postdata['hr_shift_break_start'],
            'hr_shift_break_end' => $postdata['hr_shift_break_end'],
            'hr_shift_branch' => $_SESSION['master_branch'],
            );
        $this->db->where('hr_shift_details_id',$postdata['hr_shift_details_id']);
        $this->db->update('hr_shift_details', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    public function search_hr_holyday()
    {
        
        $data = array();
        $this->db->select('*');
        $this->db->from('hr_holyday');
         $this->db->join('master', 'master.master_id=hr_holyday.hr_holyday_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
         $user_branch = $_SESSION['user_branch'];
             $query = "(";     
             $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";    
             $query.=")";     
             $this->db->where($query);
      
        $this->db->order_by('hr_holyday_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    public function insert_hr_holyday($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
       
        $tblValues = array(
            'hr_holyday_id' => $masterid,
            'hr_holyday_name' => $postdata['hr_holyday_name'],
            'hr_holyday_from_date' => $this->mastermodel->convert_date_format($postdata['hr_holyday_from_date']),
            'hr_holyday_to_date' => $this->mastermodel->convert_date_format($postdata['hr_holyday_to_date']),
            'hr_holyday_description' => $postdata['hr_holyday_description'],
            'hr_holiday_branch' =>$_SESSION['master_branch']
            );
        $this->db->insert('hr_holyday', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
      public function update_hr_holyday($postdata)
    {
        $data = array();
        $this->db->trans_begin();
            $this->mastermodel->update_master_branch($postdata['hr_holyday_id']);   
        $tblValues = array(
            'hr_holyday_id' => $postdata['hr_holyday_id'],
            'hr_holyday_name' => $postdata['hr_holyday_name'],
            'hr_holyday_from_date' => $this->mastermodel->convert_date_format($postdata['hr_holyday_from_date']),
            'hr_holyday_to_date' => $this->mastermodel->convert_date_format($postdata['hr_holyday_to_date']),
            'hr_holyday_description' => $postdata['hr_holyday_description'],
            'hr_holiday_branch' => $_SESSION['master_branch']
            );
        $this->db->where('hr_holyday_id',$postdata['hr_holyday_id']);
        $this->db->update('hr_holyday', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    public function search_hr_leave_type()
    {
           
        $data = array();
        $this->db->select('*');
        $this->db->from('hr_leave_type');
        $this->db->join('master', 'master.master_id=hr_leave_type.hr_leave_type_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        
        $this->db->order_by('hr_leave_type_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    public function insert_hr_leave_type($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
       
        $tblValues = array(
            'hr_leave_type_id' => $masterid,
            'hr_leave_type_name' => $postdata['hr_leave_type_name'],
            'hr_leave_type_description' => $postdata['hr_leave_type_description'],
            'hr_leave_type_branch' => $_SESSION['master_branch']
            );
        $this->db->insert('hr_leave_type', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
      public function update_hr_leave_type($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'hr_leave_type_name' => $postdata['hr_leave_type_name'],
            'hr_leave_type_description' => $postdata['hr_leave_type_description'],
            'hr_leave_type_branch' =>$_SESSION['master_branch']
            );
        $this->db->where('hr_leave_type_id',$postdata['hr_leave_type_id']);
        $this->db->update('hr_leave_type', $tblValues);
         $this->mastermodel->update_master_branch($postdata['hr_leave_type_id']);   
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    public function search_hr_week_off()
    {
       
        $data = array();
        $this->db->select('*');
        $this->db->from('hr_week_off');
        $this->db->join('master', 'master.master_id=hr_week_off.hr_week_off_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
          $user_branch = $_SESSION['user_branch'];
             $query = "(";            $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";         $query.=")";         $this->db->where($query);
      
        $this->db->order_by('hr_week_off_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    public function insert_hr_week_off($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
       
        $tblValues = array(
            'hr_week_off_id' => $masterid,
            'hr_week_off_sunday' => $postdata['day']['0'],
            'hr_week_off_monday' => $postdata['day']['1'],
            'hr_week_off_tuesday' => $postdata['day']['2'],
            'hr_week_off_wednesday' => $postdata['day']['3'],
            'hr_week_off_thursday' => $postdata['day']['4'],
            'hr_week_off_friday' => $postdata['day']['5'],
            'hr_week_off_saturday' => $postdata['day']['6'],
            'hr_week_off_branch' => $_SESSION['master_branch']
            );
        $this->db->insert('hr_week_off', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
      public function update_hr_week_off($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'hr_week_off_sunday' => $postdata['day']['0'],
            'hr_week_off_monday' => $postdata['day']['1'],
            'hr_week_off_tuesday' => $postdata['day']['2'],
            'hr_week_off_wednesday' => $postdata['day']['3'],
            'hr_week_off_thursday' => $postdata['day']['4'],
            'hr_week_off_friday' => $postdata['day']['5'],
            'hr_week_off_saturday' => $postdata['day']['6'],
            'hr_week_off_branch' => $_SESSION['master_branch']
            );
        $this->db->where('hr_week_off_id',$postdata['hr_week_off_id']);
        $this->db->update('hr_week_off', $tblValues);
         $this->mastermodel->update_master_branch($postdata['hr_week_off_id']);   
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    public function search_leave_application()
    {
        
        $data = array();
        $this->db->select('*');
        $this->db->from('hr_leave_application');
        $this->db->join('master', 'master.master_id=hr_leave_application.hr_leave_application_id');
           $user_branch = $_SESSION['user_branch'];
             $query = "(";        
             
             $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";   
             $query.=")";    
             $this->db->where($query);
       if ($_SESSION['administrator_privilage'] == 'no') {
            $this->db->where('hr_leave_application_employee', $_SESSION['employee_id']);
        }
           
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('hr_leave_application_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    public function insert_leave_application($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
       $to =array();
        $tblValues = array(
            'hr_leave_application_id' => $masterid,
            'hr_leave_application_employee' => $postdata['hr_leave_application_employee'],
            'hr_leave_application_type_id' => $postdata['hr_leave_application_type_id'],
            'hr_leave_application_from_date' => $this->mastermodel->convert_date_format($postdata['hr_leave_application_from_date']),
            'hr_leave_application_days' => $postdata['hr_leave_application_days'],
            'hr_leave_application_to_date' => $this->mastermodel->convert_date_format($postdata['hr_leave_application_to_date']),
            'hr_leave_application_description' => $postdata['hr_leave_application_description'],
             'days' => $postdata['day']
            );
        $this->db->insert('hr_leave_application', $tblValues);
        $output = $this->mastermodel->save_user_activities('Add Leave Application',$masterid, 'hr_leave_application');  //ss
       $gm_approvel =  $this->mastermodel->select_data_by_id("user","gm_approve",1);
       foreach($gm_approvel as $gm_approvel){
           array_push($to,$gm_approvel->email);
         
       }
       
        $email['to']= $to;
             $email['subject']='Leave Request';
                $email['message']= '<pre style="font-family: arial,sans-serif;font-size: 100%;color: #222;">'
                        . '</br>Employee Name :'.$this->mastermodel->get_single_field_value("hr_employees", "hr_employees_name", "hr_employees_id", $postdata["hr_leave_application_employee"]).'<pre>'
                        . '<pre style="font-family: arial,sans-serif;font-size: 100%;color: #222;">Leave Type :'.$this->mastermodel->get_single_field_value("hr_leave_type", "hr_leave_type_name", "hr_leave_type_id", $postdata["hr_leave_application_type_id"]).'<pre>'
                        . '<pre style="font-family: arial,sans-serif;font-size: 100%;color: #222;">From : '.$postdata["hr_leave_application_from_date"].'           To :'.$postdata["hr_leave_application_to_date"].'<pre>'
                        . '<pre style="font-family: arial,sans-serif;font-size: 100%;color: #222;">No Of Days :'.$postdata["hr_leave_application_days"].'<pre>'
                        . '<pre style="font-family: arial,sans-serif;font-size: 100%;color: #222;">Description : '.$postdata["hr_leave_application_description"].'<pre>';
           
                $status = $this->send_email_task($email);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
      public function update_leave_application($postdata)
    {
        $data = array();
         $this->mastermodel->update_master_branch($postdata['hr_leave_application_id']); 
        $this->db->trans_begin();
        $tblValues = array(
            'hr_leave_application_employee' => $postdata['hr_leave_application_employee'],
            'hr_leave_application_type_id' => $postdata['hr_leave_application_type_id'],
            'hr_leave_application_from_date' => $this->mastermodel->convert_date_format($postdata['hr_leave_application_from_date']),
            'hr_leave_application_days' => $postdata['hr_leave_application_days'],
            'hr_leave_application_to_date' => $this->mastermodel->convert_date_format($postdata['hr_leave_application_to_date']),
            'hr_leave_application_description' => $postdata['hr_leave_application_description']
            );
        $this->db->where('hr_leave_application_id',$postdata['hr_leave_application_id']);
        $this->db->update('hr_leave_application', $tblValues);
        $output = $this->mastermodel->save_user_activities('Edit Leave Application',$postdata['hr_leave_application_id'], 'hr_leave_application');  //ss
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
     public function search_special_allowance()
    {
        
        $data = array();
        $this->db->select('*');
        $this->db->from('hr_special_allowance');
        $this->db->join('master', 'master.master_id=hr_special_allowance.hr_allowance_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('hr_allowance_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    function insert_special_allowance($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
       
        $tblValues = array(
            'hr_allowance_id' => $masterid,
            'hr_allowance_name' => $postdata['hr_allowance_name'],
          
            'hr_allowance_mode' => $postdata['hr_allowance_mode'], 
            'hr_allowance_salary' => $postdata['hr_allowance_salary'], 
            
            );
        $this->db->insert('hr_special_allowance', $tblValues);
        $output = $this->mastermodel->save_user_activities('Add Special Allowance',$masterid, 'hr_special_allowance');  //ss
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    public function update_special_allowance($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'hr_allowance_name' => $postdata['hr_allowance_name'],
          
            'hr_allowance_mode' => $postdata['hr_allowance_mode'], 
            'hr_allowance_salary' => $postdata['hr_allowance_salary'], 
            );
        
        $this->db->where('hr_allowance_id', $postdata['hr_allowance_id']);
        $this->db->update('hr_special_allowance', $tblValues);
        $output = $this->mastermodel->save_user_activities('Edit Special Allowance',$postdata['hr_allowance_id'], 'hr_special_allowance');  //ss
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    public function search_allowance_deduction()
    {
        
        $data = array();
        $this->db->select('*');
        $this->db->from('hr_allowdeduc');
        $this->db->join('master', 'master.master_id=hr_allowdeduc.hr_allowdeduc_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('hr_allowdeduc_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
     public function insert_allowance_deduction($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
       
        $tblValues = array(
            'hr_allowdeduc_id' => $masterid,
            'hr_allowdeduc_name' => $postdata['hr_allowdeduc_name'],
            'hr_allowdeduc_type' => $postdata['hr_allowdeduc_type'],
            'hr_allowdeduc_mode' => $postdata['hr_allowdeduc_mode'], 
            'hr_allowdeduc_salary' => $postdata['hr_allowdeduc_salary'], 
            
            );
        $this->db->insert('hr_allowdeduc', $tblValues);
        $output = $this->mastermodel->save_user_activities('Add Allowance And Deduction',$masterid, 'hr_allowdeduc');  //ss
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
     public function update_allowance_deduction($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'hr_allowdeduc_name' => $postdata['hr_allowdeduc_name'],
            'hr_allowdeduc_type' => $postdata['hr_allowdeduc_type'],
            'hr_allowdeduc_mode' => $postdata['hr_allowdeduc_mode'], 
              'hr_allowdeduc_salary' => $postdata['hr_allowdeduc_salary'], 
            );
        
        $this->db->where('hr_allowdeduc_id', $postdata['hr_allowdeduc_id']);
        $this->db->update('hr_allowdeduc', $tblValues);
        $output = $this->mastermodel->save_user_activities('Edit Allowance And Deduction',$postdata['hr_allowdeduc_id'], 'hr_allowdeduc');  //ss
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    public function search_assign_shift()
    {
        
        $data = array();
        $this->db->select('*');
        $this->db->from('hr_assign_shift');
        $this->db->join('master', 'master.master_id=hr_assign_shift.hr_assign_shift_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
         $user_branch = $_SESSION['user_branch'];
             $query = "(";          
             $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";  
             $query.=")";     
             $this->db->where($query);
      
        $this->db->order_by('hr_assign_shift_id', 'desc');
        $data['results'] = $this->db->get();

        return $data;
    }
    public function insert_assign_shift($postdata)
    {
        $data = array();
        $this->db->trans_begin();
         foreach($postdata['hr_assign_shift_employee'] as $item)
        {
            $masterid = $this->mastermodel->insertmasterdata();
       
        $tblValues = array(
            'hr_assign_shift_id' => $masterid,
//            'hr_assign_shift_shift_id' => $postdata['hr_assign_shift_shift_id'],
            'hr_assign_shift_employee' => $item,
//            'hr_assign_shift_start_date' => $this->mastermodel->convert_date_format($postdata['hr_assign_shift_start_date'])
            );
        $this->db->insert('hr_assign_shift', $tblValues);
        $i=1;
        while(!empty($postdata['hr_assign_shift_shift_id_'.$i])){
            $subid = $this->mastermodel->insertmasterdata();
            $subtbls=array(
                    'assign_shift_details_id' => $subid,
                    'assign_shift_id' => $masterid,
                    'shift_id'=>$postdata['hr_assign_shift_shift_id_'.$i],
                    'shift_date'=>$this->mastermodel->convert_date_format($postdata['hr_assign_shift_start_date_'.$i]),
            );
             $this->db->insert('hr_assign_shift_details', $subtbls);
           $i++; 
        }
        $output = $this->mastermodel->save_user_activities('Add Assign Shift',$masterid, 'hr_assign_shift');  //ss
         }
       
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
      public function update_assign_shift($postdata)
    {
        $data = array();
        $this->db->trans_begin();
         $this->mastermodel->update_master_branch($postdata['hr_assign_shift_id']);   
       
            $tblValues = array(
            'hr_assign_shift_shift_id' => $postdata['hr_assign_shift_shift_id'],
            'hr_assign_shift_employee' => $postdata['hr_assign_shift_employee'],
//            'hr_assign_shift_start_date' => $this->mastermodel->convert_date_format($postdata['hr_assign_shift_start_date'])
            );
        $this->db->where('hr_assign_shift_id',$postdata['hr_assign_shift_id']);
        $this->db->update('hr_assign_shift', $tblValues);
        
        $this->db->where('assign_shift_id',$postdata['hr_assign_shift_id']);
        $this->db->delete('hr_assign_shift_details');
        $i=1;
        while(!empty($postdata['hr_assign_shift_shift_id_'.$i])){
            $subid = $this->mastermodel->insertmasterdata();
            $subtbls=array(
                    'assign_shift_details_id' => $subid,
                    'assign_shift_id' => $postdata['hr_assign_shift_id'],
                    'shift_id'=>$postdata['hr_assign_shift_shift_id_'.$i],
                    'shift_date'=>$this->mastermodel->convert_date_format($postdata['hr_assign_shift_start_date_'.$i]),
            );
             $this->db->insert('hr_assign_shift_details', $subtbls);
           $i++; 
        } 
        
        
        $output = $this->mastermodel->save_user_activities('edit Assign Shift',$postdata['hr_assign_shift_id'], 'hr_assign_shift');  //ss
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    public function search_leave_allocation()
    {
        
        $data = array();
        $this->db->select('*');
        $this->db->from('hr_leave_allocation');
         $this->db->join('master', 'master.master_id=hr_leave_allocation.hr_leave_allocation_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
            $user_branch = $_SESSION['user_branch'];
             $query = "(";          
             $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";  
             $query.=")";     
             $this->db->where($query);
        $this->db->order_by('hr_leave_allocation_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    public function insert_leave_allocation($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
       
        $tblValues = array(
            'hr_leave_allocation_id' => $masterid,
            'hr_leave_allocation_designation' => $postdata['hr_leave_allocation_designation'],
            'hr_leave_allocation_from_date' => $this->mastermodel->convert_date_format($postdata['hr_leave_allocation_from_date']),
            'hr_leave_allocation_to_date' => $this->mastermodel->convert_date_format($postdata['hr_leave_allocation_to_date'])
            );
        $this->db->insert('hr_leave_allocation', $tblValues);
        $i=1;
        while(isset($postdata['leave_type_id' .$i]) && !empty($postdata['leave_type_id' .$i]))
        {
            if($postdata['check' .$i] == 1)
            {   $masterid1 = $this->mastermodel->insertmasterdata();
                $subValues = array(
                    'hr_leave_allocation_details_id' => $masterid1,
                    'hr_leave_allocation_id' => $masterid,
                    'hr_leave_type_id' => $postdata['leave_type_id' .$i],
                    'hr_leave_allocation_details_total_days' => $postdata['hr_leave_allocation_details_total_days' .$i]
                );
                $this->db->insert('hr_leave_allocation_details', $subValues);
            }
            $i++;
        }
        $output = $this->mastermodel->save_user_activities('Add Leave Allocation',$masterid, 'hr_leave_allocation');  //ss
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
      public function update_leave_allocation($postdata)
    {
        $data = array();
        $this->db->trans_begin();
         $this->mastermodel->update_master_branch($postdata['hr_leave_allocation_id']);   
        $tblValues = array(
            'hr_leave_allocation_designation' => $postdata['hr_leave_allocation_designation'],
            'hr_leave_allocation_from_date' => $this->mastermodel->convert_date_format($postdata['hr_leave_allocation_from_date']),
            'hr_leave_allocation_to_date' => $this->mastermodel->convert_date_format($postdata['hr_leave_allocation_to_date'])
            );
        $this->db->where('hr_leave_allocation.hr_leave_allocation_id',$postdata['hr_leave_allocation_id']);
        $this->db->update('hr_leave_allocation', $tblValues);
        $i=1;
        $this->db->where('hr_leave_allocation_id',$postdata['hr_leave_allocation_id']);
        $this->db->delete('hr_leave_allocation_details');
        while(isset($postdata['leave_type_id' .$i]) && !empty($postdata['leave_type_id' .$i]))
        {
            if($postdata['check' .$i] == 1)
            {   $masterid1 = $this->mastermodel->insertmasterdata();
                $subValues = array(
                    'hr_leave_allocation_details_id' => $masterid1,
                    'hr_leave_allocation_id' => $postdata['hr_leave_allocation_id'],
                    'hr_leave_type_id' => $postdata['leave_type_id' .$i],
                    'hr_leave_allocation_details_total_days' => $postdata['hr_leave_allocation_details_total_days' .$i]
                );
                $this->db->insert('hr_leave_allocation_details', $subValues);
            }
            $i++;
        }
        $output = $this->mastermodel->save_user_activities('Edit Leave Allocation',$postdata['hr_leave_allocation_id'], 'hr_leave_allocation');  //ss
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    
     public function search_attendance()
    {
        
        $data = array();
        $this->db->select('*');
        $this->db->from('hr_attendance');
        $this->db->join('master', 'master.master_id=hr_attendance.hr_attendance_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $user_branch = $_SESSION['user_branch'];
             $query = "(";          
             $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";  
             $query.=")";     
             $this->db->where($query);
        $this->db->order_by('hr_attendance_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    public function insert_attendance($postdata)
 {
        
        $data = array();
        $this->db->trans_begin();
        if ($postdata['punching_time'] == 'common') {

            if (isset($postdata['commonselected']) && !empty($postdata['commonselected'])) {
               
                for ($i = 0; $i < count($postdata['commonselected']); $i++) {
                    $j = 1;
                    $n = $postdata['commonselected'][$i];
                    
                    while (isset($postdata['intime' . $j]) && !empty($postdata['intime' . $j])) {
                        $masterid = $this->mastermodel->insertmasterdata();
                        $tblValues = array(
                            'hr_attendance_id' => $masterid,
                            'hr_department_id' => $postdata['employee_department_id'],
                            'hr_attendance_date' => $this->mastermodel->convert_date_format($postdata['hr_attendance_date']),
                            'hr_attendance_emp_id' => $postdata['employee'][$n-1],
                            'hr_attendance_start_time' => $postdata['intime' . $j],
                            'hr_attendance_end_time' => $postdata['outtime' . $j],
                            'hr_attendance_remarks' => $postdata['remarks'][$n-1],
                        );

                       $this->db->insert('hr_attendance', $tblValues);
                      
                        $j++;
                    }
                     
                }
            }
        }
        if ($postdata['punching_time'] == 'different') {

            for ($n = 0; $n < count($postdata['employee']); $n++) {


                $i = $n + 1;
                $employee = $postdata['employee'][$n];
                $selected = $postdata['differentselected'][$employee];
                if (isset($selected) && !empty($selected)) {
                    $j = 1;
                    while (isset($postdata['intime' . $i . '_' . $j]) && !empty($postdata['intime' . $i . '_' . $j])) {
                        $masterid = $this->mastermodel->insertmasterdata();
                        $tblValues = array(
                            'hr_attendance_id' => $masterid,
                            'hr_department_id' => $postdata['employee_department_id'],
                            'hr_attendance_date' => $this->mastermodel->convert_date_format($postdata['hr_attendance_date']),
                            'hr_attendance_emp_id' => $postdata['employee'][$n],
                            'hr_attendance_start_time' => $postdata['intime' . $i . '_' . $j],
                            'hr_attendance_end_time' => $postdata['outtime' . $i . '_' . $j],
                            'hr_attendance_remarks' => $postdata['remarks' . $i],
                        );

                        $this->db->insert('hr_attendance', $tblValues);

                        $j++;
                    }
                }
            }
        }
            if ($postdata['punching_time'] == 'monthly') {

            if (isset($postdata['commonselected']) && !empty($postdata['commonselected'])) {
               
                for ($i = 0; $i < count($postdata['commonselected']); $i++) {
                    $j = 1;
                    $n = $postdata['commonselected'][$i];
                    
                    while (isset($postdata['intime' . $j]) && !empty($postdata['intime' . $j])) {
                        $title =   $this->dateRange( $this->mastermodel->convert_date_format($postdata['hr_attendance_date']),  $this->mastermodel->convert_date_format($postdata['hr_attendance_todate']), "+1 day");
           
                        foreach ($title as $value)
{
                             $branch_id = $this->mastermodel->get_single_field_value('hr_employees', 'hr_employees_branch', 'hr_employees_id',$postdata['employee'][$n-1]);
     
                               $hldday = $this->get_holiday_check($value,$branch_id);
                 $weekoff = $this->get_weekoff($value,$branch_id);
                    $allowed_leave = $this->get_allowed_leave($value,$employee_id);
                 
                              if ($hldday > 0 || $weekoff == 1 || $allowed_leave > 0)
                {
                
                                  
                              }
                              else{
                        $masterid = $this->mastermodel->insertmasterdata();
                        $tblValues = array(
                            'hr_attendance_id' => $masterid,
                            'hr_department_id' => $postdata['employee_department_id'],
                            'hr_attendance_date' => $value,
                            'hr_attendance_emp_id' => $postdata['employee'][$n-1],
                            'hr_attendance_start_time' => $postdata['intime' . $j],
                            'hr_attendance_end_time' => $postdata['outtime' . $j],
                            'hr_attendance_remarks' => $postdata['remarks'][$n-1],
                        );

                       $this->db->insert('hr_attendance', $tblValues);
}

                              }
                        $j++;
                    }
                     
                }
            }
        }
        
        $output = $this->mastermodel->save_user_activities('Add Attendance',$masterid, 'hr_attendance');  //ss        

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_attendance($postdata)
    {
        $data = array();
        $this->db->trans_begin();
     
         $this->mastermodel->update_master_branch($postdata['hr_attendance_id']);   
        $tblValues = array(
             'hr_attendance_date' => $this->mastermodel->convert_date_format($postdata['hr_attendance_date']),
                      
                            'hr_attendance_start_time' => $postdata['hr_attendance_start_time'],
                            'hr_attendance_end_time' =>$postdata['hr_attendance_end_time'],
                            'hr_attendance_remarks' => $postdata['hr_attendance_remarks'],
            );
        $this->db->where('hr_attendance_id',$postdata['hr_attendance_id']);
        $this->db->update('hr_attendance', $tblValues);
        $output = $this->mastermodel->save_user_activities('Edit Attendance',$postdata['hr_attendance_id'], 'hr_attendance');  //ss   
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
     public function search_grade()
    {
        
        $data = array();
        $this->db->select('*');
        $this->db->from('hr_grade');
        $this->db->join('master', 'master.master_id=hr_grade.hr_grade_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('hr_grade_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    public function insert_grade($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'hr_grade_id' => $masterid,
            'hr_grade_name' => $postdata['hr_grade_name']
        );
        $this->db->insert('hr_grade', $tblValues);
        
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
      public function update_grade($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'hr_grade_name' => $postdata['hr_grade_name']
        );
        $this->db->where('hr_grade_id',$postdata['hr_grade_id']);
        $this->db->update('hr_grade', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
      public function leave_approval($leavid)
    {
        $tblValues = array(
            'hr_leave_application_approve' => 1,
        );
        $this->db->where('hr_leave_application_id', $leavid);
        $output = $this->db->update('hr_leave_application', $tblValues);
    }
     public function leav_approval_test($postdata)
    {
        $to = array();
        $tblValues = array(
            'hr_leave_application_from_date'=>$this->mastermodel->convert_date_format($postdata['hr_leave_application_from_date']),
            'hr_leave_application_to_date'=>$this->mastermodel->convert_date_format($postdata['hr_leave_application_to_date']),
            'hr_leave_application_from_date_old'=>$this->mastermodel->convert_date_format($postdata['hr_leave_application_from_date_old']),
            'hr_leave_application_to_date_old'=>$this->mastermodel->convert_date_format($postdata['hr_leave_application_to_date_old']),
            'hr_leave_application_days'=>$postdata['hr_leave_application_days'],
            'hr_leave_application_days_old'=>$postdata['hr_leave_application_days_old'],
            'hr_leave_application_description_change'=>$postdata['hr_leave_application_description_change'],
            'hr_leave_application_approve' => 1,
        );
        $this->db->where('hr_leave_application_id', $postdata['hr_leave_application_id']);
        $output = $this->db->update('hr_leave_application', $tblValues);;
        $gm_approvel =  $this->mastermodel->select_data_by_id("user","manager_approve",1);
      
       foreach($gm_approvel as $gm_approvel){
           array_push($to,$gm_approvel->email);
         
       }
        $email['to']= $to;
             $email['subject']='Leave Request';
                $email['message']= '<pre style="font-family: arial,sans-serif;font-size: 100%;color: #222;">'
                        . '</br>Employee Name :'.$this->mastermodel->get_single_field_value("hr_employees", "hr_employees_name", "hr_employees_id", $postdata["hr_leave_application_employee"]).'<pre>'
                        . '<pre style="font-family: arial,sans-serif;font-size: 100%;color: #222;">Leave Type :'.$this->mastermodel->get_single_field_value("hr_leave_type", "hr_leave_type_name", "hr_leave_type_id", $postdata["hr_leave_application_type_id"]).'<pre>'
                        . '<pre style="font-family: arial,sans-serif;font-size: 100%;color: #222;">From : '.$postdata["hr_leave_application_from_date"].'           To :'.$postdata["hr_leave_application_to_date"].'<pre>'
                        . '<pre style="font-family: arial,sans-serif;font-size: 100%;color: #222;">No Of Days :'.$postdata["hr_leave_application_days"].'<pre>'
                        . '<pre style="font-family: arial,sans-serif;font-size: 100%;color: #222;">Description : '.$postdata["hr_leave_application_description_change"].'<pre>'
                          . '<pre style="font-family: arial,sans-serif;font-size: 100%;color: #222;">GM Approved <pre>';
             
                $status = $this->send_email_task($email);
    }
      public function leav_reject($postdata)
    {
        
        $tblValues = array(
            
            'hr_leave_reject_reason'=>$postdata['hr_leave_reject_reason'],
            'leav_reject' => 1,
            'reject_user_id'=>$_SESSION['user_id']
        );
        $this->db->where('hr_leave_application_id', $postdata['hr_leave_application_id']);
        $output = $this->db->update('hr_leave_application', $tblValues);
           $email['to']= $postdata['employee_email'];
             $email['subject']='Leave Reject';
                $email['message']= '<pre style="font-family: arial,sans-serif;font-size: 100%;color: #222;">'
                       
                        . '<pre style="font-family: arial,sans-serif;font-size: 100%;color: #222;">From : '.$postdata["hr_leave_application_from_date"].'           To :'.$postdata["hr_leave_application_to_date"].'<pre>'
                        . '<pre style="font-family: arial,sans-serif;font-size: 100%;color: #222;">No Of Days :'.$postdata["hr_leave_application_days"].'<pre>'
                        . '<pre style="font-family: arial,sans-serif;font-size: 100%;color: #222;">Reject Reason : '.$postdata['hr_leave_reject_reason'].'<pre>';
                        
             
                $status = $this->send_email_task($email);
    }
    
    public function leave_approval_higher($leavid)
    {
       $tblValues = array(
           'hr_leave_application_higher' => 1,
       );
       $this->db->where('hr_leave_application_id', $leavid);
       $output = $this->db->update('hr_leave_application', $tblValues);
          $data =  $this->mastermodel->get_data_srow('hr_leave_application',$leavid,'hr_leave_application_id');
      
       
        $email['to']= $this->mastermodel->get_single_field_value("hr_employees", "hr_employees_email", "hr_employees_id",$data->hr_leave_application_employee);
             $email['subject']='Leave Approved';
                $email['message']= '<pre style="font-family: arial,sans-serif;font-size: 100%;color: #222;">'
                        .'I am pleased to inform you that your leaves are sanctioned from '.$data->hr_leave_application_from_date.' to '.$data->hr_leave_application_to_date.' as requested by you. '
                    ;
                 
                $status = $this->send_email_task($email);
    }
      public function salary_approval($id)
    {
       $tblValues = array(
           'hr_employee_salary_approve' => 1,
           'hr_employee_salary_pay_date'=>date("Y-m-d")
       );
       $this->db->where('hr_employee_salary_slip_id', $id);
       $output = $this->db->update('hr_employee_salary_slip', $tblValues);
    }
    public function claim_approval_higher($claim_id)
    {
       $tblValues = array(
           'claim_approve' => 1,
       );
       $this->db->where('hr_claim_allowance_id', $claim_id);
       $output = $this->db->update('hr_claim_allowance', $tblValues);
    }
     public function claim_release($claim_id)
    {
       $tblValues = array(
           'claim_fund_released' => 1,
       );
       $this->db->where('hr_claim_allowance_id', $claim_id);
       $output = $this->db->update('hr_claim_allowance', $tblValues);
    }
     public function search_employee_pay_structure(){
        $data = array();
        $this->db->select('*');
        $this->db->from('hr_employee_salary');
         $this->db->join('master', 'master.master_id=hr_employee_salary.hr_employee_salary_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
          $user_branch = $_SESSION['user_branch'];
             $query = "(";     
             $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";    
             $query.=")";   
        $this->db->order_by('hr_employee_salary_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    
     public function search_punch(){
        $data = array();
        $this->db->select('hr_employees_name,hr_attendance_date,hr_attendance_start_time,hr_attendance_end_time,hr_attendance_emp_id');
        $this->db->from('hr_attendance');
        $this->db->join('master', 'master.master_id=hr_attendance.hr_attendance_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
      
           $this->db->join('hr_employees','hr_employees.hr_employees_id = hr_attendance.hr_attendance_emp_id','left');
        $this->db->order_by('hr_attendance_id', 'asc');
        $data['results'] = $this->db->get();
        return $data;
    }
    
    public function insert_pay_structure($postdata){
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        if (isset($postdata['hr_employee_salary_return_ticket']))
        {
            $return_ticket = 'yes';
        } else
        {
            $return_ticket = 'no';
        }
        if(isset($postdata['overtime_check'])){
            $isovertime='1';
           $overtime_amount = $postdata['overtime_amount'] ;
        }
        else{
            $isovertime='0';
            $overtime_amount ='0';
        }
        $tblValues = array(
            'hr_employee_salary_id' => $masterid,
            'hr_employee_salary_employee_id' => $postdata['hr_employee_salary_employee_id'],
            'hr_employee_salary_wef_date' => $this->mastermodel->convert_date_format($postdata['hr_employee_salary_wef_date']),
            'hr_employee_salary_basic_salary' => $postdata['hr_employee_salary_basic_salary'],
            'hr_employee_salary_from_ticket' => $postdata['hr_employee_salary_from_ticket'],
            'hr_employee_salary_to_ticket' => $postdata['hr_employee_salary_to_ticket'],
            'hr_employee_salary_return_ticket' => $return_ticket,
            'hr_employee_salary_no_tickets' => $postdata['hr_employee_salary_no_tickets'],
            'hr_employee_salary_payment_method' => $postdata['hr_employee_salary_payment_method'],
            'hr_employee_salary_isovertime' => $isovertime,
             'hr_employee_salary_overtime_amount' => $overtime_amount,
             'hr_employee_salary_holiday_payment' => $postdata['holiday_payment'],
                         'hr_employee_salary_gross_salary' => $postdata['grosssalary'],
             'hr_employee_salary_deduction' => $postdata['deduction'],
             'hr_employee_salary_allowance' => $postdata['allowance'],
             'hr_employee_salary_netsalary' => $postdata['netsalary'],

            
            );

        $output = $this->db->insert('hr_employee_salary', $tblValues);
        $i = 1;
        while (isset($postdata['amount' . $i]))
        {
            $sub_masterid = $this->mastermodel->insertmasterdata();
            $tblValues = array(
                'hr_employee_salary_allowdeduc_id' => $sub_masterid,
                'hr_employee_salary_id' => $masterid,
                'hr_employee_salary_allowdeduc_allowdeduc_id' => $postdata['allowdeduc_id_' . $i],
                'hr_employee_salary_allowdeduc_amount' => $postdata['amount' . $i],
                 'hr_employee_salary_allowdeduc_amount_emp' => $postdata['amount_emp' . $i]
                    
                    
                    );
            
            $output = $this->db->insert('hr_employee_salary_allowdeduc', $tblValues);
            $i++;
        }
         $x = 1;
        while (isset($postdata['specialallow_amount' . $x]))
        {
            $sub_spcl_masterid = $this->mastermodel->insertmasterdata();
            $tblValues = array(
                'hr_employee_salary_spcl_alwnc_id' => $sub_spcl_masterid,
                'hr_employee_salary_id' => $masterid,
                'hr_employee_spcl_alwnc_id' => $postdata['special_allowance_id' . $x],
                'hr_employee_salary_spcl_alwnc_amount' => $postdata['specialallow_amount' . $x],
                'hr_employee_salary_special_allowance_total' => $postdata['special_allowance_total' . $x],
               
                    
                    
                    );
            
            $output = $this->db->insert('hr_employee_salary_spcl_allowance', $tblValues);
            $x++;
        }
        $j = 1;
        while (isset($postdata['hr_employee_salary_medical_type' . $j]))
        {
             $medical_id = $this->mastermodel->insertmasterdata();
//            if ($postdata['hr_employee_salary_medical_type' . $i] != "")
//            {
                $tblValues = array(
                    'hr_employee_salary_medical_id' => $medical_id,
                    'hr_employee_salary_id' => $masterid,
                    'hr_employee_salary_medical_type' => $postdata['hr_employee_salary_medical_type' . $j],
                    'hr_employee_salary_medical_company' => $postdata['hr_employee_salary_medical_company' . $j],
                    'hr_employee_salary_medical_policy' => $postdata['hr_employee_salary_medical_policy' . $j],
                    'hr_employee_salary_medical_plan' => $postdata['hr_employee_salary_medical_plan' . $j],
                    'hr_employee_salary_medical_sum' => $postdata['hr_employee_salary_medical_sum' . $j]);
                $output = $this->db->insert('hr_employee_salary_medical', $tblValues);
//            }
            $j++;
        }
        
//         $k = 1;
//        while (isset($postdata['hr_employee_overtime_type' . $k]))
//        {
//            $overtime_id = $this->mastermodel->insertmasterdata();
//            $tblValues = array(
//                'hr_employee_overtime_id' => $overtime_id,
//                'hr_employee_overtime_salary_id' => $masterid,
//                'hr_employee_overtime_type' => $postdata['hr_employee_overtime_type' . $k],
//                'hr_employee_overtime_value' => $postdata['hr_employee_overtime_value' . $k]);
//            $output = $this->db->insert('hr_employee_overtime', $tblValues);
//            $k++;
//        }
        $output = $this->mastermodel->save_user_activities('Add Employee Salary',$masterid, 'hr_employee_salary');  //ss
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = 'Error on adding record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = 'Record Added  successfully';
            return $data;
        }
    }
    public function update_pay_structure($postdata){
        $this->db->trans_begin();

        if (isset($postdata['hr_employee_salary_return_ticket']))
        {
            $return_ticket = 'yes';
        } else
        {
            $return_ticket = 'no';
        }
          if(isset($postdata['overtime_check'])){
            $isovertime='1';
           $overtime_amount = $postdata['overtime_amount'] ;
        }
        else{
            $isovertime='0';
            $overtime_amount ='0';
        }
          $this->mastermodel->update_master_branch($postdata['hr_employee_salary_id']);   
        $tblValues = array(
            'hr_employee_salary_employee_id' => $postdata['hr_employee_salary_employee_id'],
            'hr_employee_salary_wef_date' => $this->mastermodel->convert_date_format($postdata['hr_employee_salary_wef_date']),
            'hr_employee_salary_basic_salary' => $postdata['hr_employee_salary_basic_salary'],
            'hr_employee_salary_from_ticket' => $postdata['hr_employee_salary_from_ticket'],
            'hr_employee_salary_to_ticket' => $postdata['hr_employee_salary_to_ticket'],
            'hr_employee_salary_return_ticket' => $return_ticket,
            'hr_employee_salary_no_tickets' => $postdata['hr_employee_salary_no_tickets'],
            'hr_employee_salary_payment_method' => $postdata['hr_employee_salary_payment_method'],
            'hr_employee_salary_isovertime' => $isovertime,
               'hr_employee_salary_overtime_amount' => $overtime_amount,
             'hr_employee_salary_holiday_payment' => $postdata['holiday_payment'],
              'hr_employee_salary_gross_salary' => $postdata['grosssalary'],
               'hr_employee_salary_deduction' => $postdata['deduction'],
             'hr_employee_salary_allowance' => $postdata['allowance'],
             'hr_employee_salary_netsalary' => $postdata['netsalary'],
            );
        $this->db->where('hr_employee_salary_id', $postdata['hr_employee_salary_id']);
        $output = $this->db->update('hr_employee_salary', $tblValues);
        
        $this->db->where('hr_employee_salary_id', $postdata['hr_employee_salary_id']);
        $this->db->delete('hr_employee_salary_allowdeduc');
        $masterid = $postdata['employee_salary_id'];
         $i = 1;
        while (isset($postdata['amount' . $i]))
        {
             $sub_masterid = $this->mastermodel->insertmasterdata();
            $tblValues = array(
                'hr_employee_salary_allowdeduc_id' => $sub_masterid,
                'hr_employee_salary_id' => $postdata['hr_employee_salary_id'],
                'hr_employee_salary_allowdeduc_allowdeduc_id' => $postdata['allowdeduc_id_' . $i],
                'hr_employee_salary_allowdeduc_amount' => $postdata['amount' . $i],
                   'hr_employee_salary_allowdeduc_amount_emp' => $postdata['amount_emp' . $i]
                    
                    );
            $output = $this->db->insert('hr_employee_salary_allowdeduc', $tblValues);
            $i++;
        }
         $this->db->where('hr_employee_salary_id', $postdata['hr_employee_salary_id']);
        $this->db->delete('hr_employee_salary_spcl_allowance');
        $masterid = $postdata['employee_salary_id'];
         $x = 1;
          while (isset($postdata['specialallow_amount' . $x]))
        {
            $sub_spcl_masterid = $this->mastermodel->insertmasterdata();
            $tblValues = array(
                'hr_employee_salary_spcl_alwnc_id' => $sub_spcl_masterid,
                'hr_employee_salary_id' => $postdata['hr_employee_salary_id'],
                'hr_employee_spcl_alwnc_id' => $postdata['special_allowance_id' . $x],
                'hr_employee_salary_spcl_alwnc_amount' => $postdata['specialallow_amount' . $x],
                'hr_employee_salary_special_allowance_total' => $postdata['special_allowance_total' . $x],
               
                    
                    
                    );
            
            $output = $this->db->insert('hr_employee_salary_spcl_allowance', $tblValues);
            $x++;
        }
     
        
        $this->db->where('hr_employee_salary_id', $postdata['hr_employee_salary_id']);
        $this->db->delete('hr_employee_salary_medical');
        $j = 1;
        while (isset($postdata['hr_employee_salary_medical_type' . $j]))
        {
             $medical_id = $this->mastermodel->insertmasterdata();
//            if ($postdata['hr_employee_salary_medical_type' . $i] != "")
//            {
                $tblValues = array(
                    'hr_employee_salary_medical_id' => $medical_id,
                    'hr_employee_salary_id' => $postdata['hr_employee_salary_id'],
                    'hr_employee_salary_medical_type' => $postdata['hr_employee_salary_medical_type' . $j],
                    'hr_employee_salary_medical_company' => $postdata['hr_employee_salary_medical_company' . $j],
                    'hr_employee_salary_medical_policy' => $postdata['hr_employee_salary_medical_policy' . $j],
                    'hr_employee_salary_medical_plan' => $postdata['hr_employee_salary_medical_plan' . $j],
                    'hr_employee_salary_medical_sum' => $postdata['hr_employee_salary_medical_sum' . $j]);
                $output = $this->db->insert('hr_employee_salary_medical', $tblValues);
//            }
            $j++;
        }
        
        $this->db->where('hr_employee_overtime_salary_id', $postdata['hr_employee_salary_id']);
        $this->db->delete('hr_employee_overtime');
        $k = 1;
        while (isset($postdata['hr_employee_overtime_type' . $k]))
        {
            $overtime_id = $this->mastermodel->insertmasterdata();
            $tblValues = array(
                'hr_employee_overtime_id' => $overtime_id,
                'hr_employee_overtime_salary_id' => $postdata['hr_employee_salary_id'],
                'hr_employee_overtime_type' => $postdata['hr_employee_overtime_type' . $k],
                'hr_employee_overtime_value' => $postdata['hr_employee_overtime_value' . $k]);
            $output = $this->db->insert('hr_employee_overtime', $tblValues);
            $k++;
        }
//        $output = $this->mastermodel->save_user_activities('Update Pay Structure', $postdata['employee_salary_id'], 'employee_salary_allowdeduc');  //ss

        $output = $this->mastermodel->save_user_activities('Edit Employee Salary',$postdata['hr_employee_salary_id'], 'hr_employee_salary');  //ss
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = 'Error on Updating record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = 'Record Updated  successfully';
            return $data;
        }
    }
     public function hold_passport($postdata)
    {
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'hr_employee_passport_id' => $masterid,
            'hr_employee_passport_employee_id' => $postdata['employee_id'],
            'hr_employee_passport_date' => $this->mastermodel->convert_date_format($postdata['date']),
            'hr_employee_passport_hold' => $postdata['hold'],
            'hr_employee_passport_reason' => $postdata['reason'],
        );
        $output = $this->db->insert('hr_employee_passport', $tblValues);


        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = 'Error on adding record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = 'Record Added  successfully';
            return $data;
        }
    }  
     public function save_rejoin_data($postdata)
    {
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'hr_employee_rejoin_id' => $masterid,
            'hr_employee_employee_id' => $postdata['hr_employee_employee_id'],
            'hr_employee_date' => $this->mastermodel->convert_date_format($postdata['hr_employee_date']),
            'hr_employee_reason' => $postdata['hr_employee_reason']
        );
        $output = $this->db->insert('hr_employee_rejoin', $tblValues);


        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = 'Error on adding record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = 'Record Added  successfully';
            return $data;
        }
    }
    function get_passport_holding_by_employee($id)
    {
        $this->db->select('*');
        $this->db->from('hr_employee_passport');
         $this->db->join('master', 'master.master_id=hr_employee_passport.hr_employee_passport_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->where('hr_employee_passport.hr_employee_passport_employee_id', $id);
        $this->db->order_by('hr_employee_passport_date', 'desc');
        $this->db->order_by('hr_employee_passport_id', 'desc');
        $this->db->limit(15,0);
        $data = $this->db->get()->result();
        return $data;
    }
    function get_rejoin_by_employee($id)
    {
        $this->db->select('*');
        $this->db->from('hr_employee_rejoin');
        $this->db->join('master', 'master.master_id=hr_employee_rejoin.hr_employee_rejoin_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->where('hr_employee_rejoin.hr_employee_employee_id', $id);
        $this->db->order_by('hr_employee_date', 'desc');
        $this->db->order_by('hr_employee_rejoin_id', 'desc');
        $this->db->limit(15,0);
        $data = $this->db->get()->result();
        return $data;
    }
      function getemployeelist()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('hr_employees');
         $this->db->join('master', 'master.master_id=hr_employees.hr_employees_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->join('hr_department', 'hr_department.hr_department_id=hr_employees.hr_employees_department_id');
        $this->db->join('hr_designation', 'hr_designation.hr_designation_id=hr_employees.hr_employees_designation_id');
        $this->db->order_by('hr_employees_visa_exp_date', 'asc');
        $Q = $this->db->get();
        if ($Q->num_rows() > 0)
        {
            foreach ($Q->result_array() as $row)
            {
                $data[] = $row;
            }
        }
        $Q->free_result();
        return $data;
    }
      function count_data_salary($table, $id, $date)
    {
        $date = $this->mastermodel->convert_date_format($date);
    
        $query = "select hr_employee_salary_id from $table where hr_employee_salary_employee_id = '$id' and hr_employee_salary_wef_date <= '$date' order by hr_employee_salary_wef_date DESC limit 1";
        $res = mysql_query($query);
        $num = mysql_num_rows($res);
        $data['num'] = $num;
        return $num;
    }
    function check_salary_month($id, $date)
    {
        $date = $this->mastermodel->convert_date_format($date);
        $this->db->select('hr_employee_salary_slip_id');
        $this->db->from('hr_employee_salary_slip');
        $this->db->where('hr_employee_salary_employee_id', $id);
        $where = "month(hr_employee_salary_salary_date)=month('$date') and year(hr_employee_salary_salary_date)=year('$date')";
        $this->db->where($where, NULL, FALSE);
        return $this->db->count_all_results();
    }
//     function get_employee_salary_id($employee_id, $date)
//    {
//        $data = array();
//
//        $date = $this->mastermodel->convert_date_format($date);
//        
//        $sql = "SELECT tt.*
//                FROM hr_employee_salary tt
//                INNER JOIN
//                (SELECT hr_employee_salary_employee_id, MAX(hr_employee_salary_wef_date) AS wefdate
//                FROM hr_employee_salary
//                GROUP BY hr_employee_salary_employee_id) groupedtt ON tt.hr_employee_salary_employee_id = groupedtt.hr_employee_salary_employee_id AND tt.hr_employee_salary_wef_date = groupedtt.wefdate
//                where tt.hr_employee_salary_employee_id = '$employee_id' AND wefdate <= '$date'";
//        $Q = $this->db->query($sql);
//        $result = $Q->row();
//
//        if (!empty($result))
//            return $result->hr_employee_salary_id;
//        else
//            return '';
//    }
     function getunpaidemployees($month, $year)
    {
        $data = array();
           $user_branch = $_SESSION['master_branch'];
        $this->db->where("hr_employees.hr_employees_id NOT IN (SELECT `hr_employee_salary_employee_id` FROM `hr_employee_salary_slip` where month(hr_employee_salary_salary_date)='$month' and year(hr_employee_salary_salary_date)='$year') ", NULL, FALSE);
       $this->db->from('hr_employees');
          $this->db->join('master', 'master.master_id=hr_employees.hr_employees_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
             $query = "(";    
         $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";       
         $query.=")";      
         $this->db->where($query);
        $Q = $this->db->get();
        if ($Q->num_rows() > 0)
        {
            foreach ($Q->result_array() as $row)
            {
                $data[] = $row;
            }
        }
        $Q->free_result();
        return $data;
    }
     function get_employee_salary_data($table, $id, $date)
    {
        $date = $this->mastermodel->convert_date_format($date);
        $data = array();
        $sql = "select * from $table where hr_employee_salary_employee_id = '$id' and hr_employee_salary_wef_date <= '$date' order by hr_employee_salary_wef_date DESC limit 1";
        $Q = $this->db->query($sql);
        $row = $Q->row();
        return $row;
    }

     function insert_multiple_salary_payment($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $salary_date = $this->mastermodel->convert_date_format($postdata['salary_date']);
        $pay_date = date('Y-m-d');
        
    
        if (isset($postdata['salempdet']))
        {

            for ($i = 0; $i < sizeof($postdata['salempdet']); $i++)
            {
                if (isset($postdata['salempdet'][$i]))
                {
                    $masterid = $this->mastermodel->insertmasterdata();
                    $employee_id = $postdata['salempdet'][$i];
                    $salary_payment = $this->get_employee_salary_data('hr_employee_salary', $employee_id, $postdata['salary_date']);
                       
                        
                        $postdata['overtime_amount'] = $salary_payment->hr_employee_salary_overtime_amount;
                            $postdata['holiday_payment'] = $salary_payment->hr_employee_salary_holiday_payment;
                    $base_salary = $salary_payment->hr_employee_salary_basic_salary;
                    $gross_salary = $salary_payment->hr_employee_salary_gross_salary;
                    $employee_salary_id = $salary_payment->hr_employee_salary_id;
                    $allowdeduc_details = $this->mastermodel->get_data('hr_employee_salary_allowdeduc', $employee_salary_id, 'hr_employee_salary_id');
                    $tblValues = array('hr_employee_salary_slip_id' => $masterid,
                        'hr_employee_salary_employee_id' => $employee_id,
                        'hr_employee_salary_salary_date' => $salary_date,
                        'hr_employee_salary_pay_date' => $pay_date,
                        'hr_employee_salary_basic_salary' => $base_salary,
                          'hr_employee_salary_gross_salary' => $gross_salary,
                        'hr_employee_salary_payment_method' => $salary_payment->hr_employee_salary_payment_method,
//                          'hr_employee_salary_commission_amount' => $postdata['commission'],
//            'hr_employee_salary_payment_method' => $postdata['employee_sal_payment_mode'],
                    );
                    $this->db->insert('hr_employee_salary_slip', $tblValues);

                    $allowance = 0;
                    $deduction = 0;
                    foreach ($allowdeduc_details as $list)
                    {
                        $tblValues = array(
                            'hr_employee_salary_slip_id' => $masterid,
                            'hr_allowdeduc_id' => $list['hr_employee_salary_allowdeduc_allowdeduc_id'],
                            'hr_employee_salary_slip_allowdeduc_amount' => $list['hr_employee_salary_allowdeduc_amount']);
                        $res = $this->db->insert('hr_employee_salary_slip_allowdeduc', $tblValues);
                        $allowdeductype = $this->mastermodel->get_data_srow('hr_allowdeduc', $list['hr_employee_salary_allowdeduc_allowdeduc_id'], 'hr_allowdeduc_id');
                        if ($allowdeductype->hr_allowdeduc_type == "Allowance")
                        {  //allowance
                            if ($allowdeductype->hr_allowdeduc_mode == "Direct")
                            {
                                $sf = 1;
                                $amount = $list['hr_employee_salary_allowdeduc_amount'] * $sf;
                                $asubtotal = $amount;
                            } else
                            {
                                $sf = 0.01;
                                $amount = $list['hr_employee_salary_allowdeduc_amount'] * $sf;
                                $asubtotal = $gross_salary * $amount;
                            }
                            $allowance+=$asubtotal;
                        } else
                        {
                            if ($allowdeductype->hr_allowdeduc_mode == "Direct")
                            {
                                $sf = 1;
                                $amount = $list['hr_employee_salary_allowdeduc_amount'] * $sf;
                                $dsubtotal = $amount;
                            } else
                            {

                                $sf = 0.01;
                                $amount = $list['hr_employee_salary_allowdeduc_amount'] * $sf;
                                $dsubtotal = $gross_salary * $amount;
                            }
                            $deduction+=$dsubtotal;
                        }
                    }
                    
                       $frmdate = date('Y-m-d', strtotime($salary_date . ' -1 months'));
         $todate = date('Y-m-d', strtotime($salary_date . ' -1 day'));
           
        if(!empty( $postdata['overtime_amount']) && $postdata['overtime_amount'] != 0){
           $overtime = $this->overtime($frmdate, $todate, $employee_id);
                  if($overtime < 0){
     $overtime = 0; 
  }
          $overtime_amount = $overtime * $postdata['overtime_amount'];
        }
          if(!empty( $postdata['holiday_payment']) && $postdata['holiday_payment'] != 0){
           $holiday = $this->holiday($frmdate, $todate, $employee_id);
          
          $holiday_amount = $holiday * $postdata['holiday_payment'];
        }
        $extra_amount = $overtime_amount + $holiday_amount;
//         $totalworked = $this->totalworked($frmdate, $todate, $employee_id);
         
              $daysworked = $this->daysworked($frmdate, $todate, $employee_id);
//         $total_assign_work = $this->total_assign_work($frmdate, $todate, $employee_id);
         $totalholidays = $this->totalholidays($frmdate, $todate, $employee_id);
         $totalmin = $this->totalmin($frmdate, $todate, $employee_id);
       
         $totalholidays *= $totalmin; 
  
  
     $allowed_leave = $this->allowed_leave($frmdate, $todate, $employee_id);
    
     $allowed_leave *=$totalmin;
   
      $real = $daysworked + $totalholidays + $allowed_leave;
   $total = $this->days_month($frmdate, $todate, $employee_id);
   $total *=$totalmin;
  $to_be_worked = $total -($totalholidays + $allowed_leave);
   if($real > $total){
      $real =  $total;
   }
       $totalsal = ($gross_salary /$total)*$real;
       $netpayment = $totalsal  + $extra_amount - $deduction;
               
                    
                    

                    $tblValues = array('hr_employee_salary_allowance_amount' => $allowance, 
                        'hr_employee_salary_deduction_amount' => $deduction,
//                        'hr_employee_salary_net_payment' => $netpayment,
//                        'hr_employee_salary_paid_amount' => $netpayment,
                            
                         'hr_employee_salary_net_payment' => $netpayment,
          
            'hr_employee_salary_paid_amount' => $netpayment,
            
              'hr_employee_salary_holiday_payment' => $holiday_amount,
            'hr_employee_salary_overtime_amount' => $overtime_amount,
                                'hr_employee_salary_overtime_minutes' => $overtime,
                'hr_employee_salary_holiday_minutes' => $holiday,
               'hr_employee_salary_overtime_amount_permin' =>$postdata['overtime_amount'],
                'hr_employee_salary_holiday_amount_permin' => $postdata['holiday_payment'],
              'hr_employee_salary_allowedholidays_min' => $totalholidays,
                'hr_employee_salary_allowed_leave_min' => $allowed_leave,
             'hr_employee_salary_orginal_daysworked' => $daysworked,
                'hr_employee_salary_daysworked' => $daysworked,
                 'hr_employee_salary_total_minutes' => $total,
            'hr_employee_salary_daystobeworked' => $to_be_worked,  
                            
                            
                            
                            );
                    $this->db->where('hr_employee_salary_slip_id', $masterid);
                    $res = $this->db->update('hr_employee_salary_slip', $tblValues);
                }
            }
            $data['resfunction'] = 'search_salary_payment';
            $output = $this->mastermodel->save_user_activities('Add multiple salary payment',$masterid, 'hr_employee_salary_slip');  //ss
            if ($this->db->trans_status() === FALSE)
            {
                $this->db->trans_rollback();
                $data['res'] = 0;
                $data['msg'] = 'Error On Adding Record';
                return $data;
            } else
            {
                $this->db->trans_commit();
                $data['res'] = 1;
                $data['msg'] = 'Salary processed succesfully';
                return $data;
            }
        } else
        {
            $data['resfunction'] = 'search_salary_payment';
            $this->db->trans_rollback();
            $data['res'] = 1;
            $data['msg'] = 'No employee selected';
            return $data;
        }
    }
     function dateRange($first, $last, $step = '+1 month', $format = 'Y-m-d')
        {
            $dates = array();
            $current = strtotime($first);
            $last = strtotime($last);

            while ($current <= $last)
            {
                $dates[] = date($format, $current);
                $current = strtotime($step, $current);
            }
            return $dates;
        }
          function get_holiday_check($date,$branch_id)
    {
        $this->db->from('hr_holyday');
          $this->db->join('master', 'master.master_id=hr_holyday.hr_holyday_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->where('hr_holyday_from_date <=', $date);
          $this->db->where('hr_holyday_to_date >=', $date);
            $this->db->where('hr_holiday_branch', $branch_id);
        $count = $this->db->count_all_results();
        return $count;
    }
    
         function get_weekoff($date,$branch_id)
    {
               
            
             $dw = date('w',strtotime($date));
          
           
              $hr_week_off = $this->mastermodel->get_data_srow('hr_week_off',$branch_id,'hr_week_off_branch');
           
               if($dw == 0){
             if($hr_week_off->hr_week_off_sunday == 1){
                
                      return 1;
                  }
                  else{
                       return 0;
                  }
              }
                 if($dw == 1){
             if($hr_week_off->hr_week_off_monday == 1){
                  
                
                      return 1;
                  }
                  else{
                       return 0;
                  }
              }
               if($dw == 2){
              if($hr_week_off->hr_week_off_tuesday == 1){
                  
                  
                      return 1;
                  }
                  else{
                       return 0;
                  }
              }
                if($dw == 3){
           if($hr_week_off->hr_week_off_wednesday == 1){
                 
                      return 1;
                  }
                  else{
                       return 0;
                  }
              }
                if($dw == 4){
              if($hr_week_off->hr_week_off_thursday == 1){
                 
                      return 1;
                  }
                  else{
                       return 0;
                  }
              }
                if($dw == 5){
              if($hr_week_off->hr_week_off_friday == 1){
                 
                      return 1;
                  }
                  else{
                       return 0;
                  } 
              }
                if($dw == 6){
              if($hr_week_off->hr_week_off_saturday == 1){
                 
                      return 1;
                  }
                  else{
                       return 0;
                  }
              }
        
    }
          function  overtime($frmdate,$todate,$employee_id)
    {
             $title =   $this->dateRange($frmdate, $todate, "+1 day");
              $i = 1;
              $ttovertime= 0;
               $ttlateminutes= 0;

foreach ($title as $value)
{
    $branch_id = $this->mastermodel->get_single_field_value('hr_employees', 'hr_employees_branch', 'hr_employees_id',$employee_id);
                      
           $hldday = $this->get_holiday_check($value,$branch_id);
        $weekoff = $this->get_weekoff($value,$branch_id);
      
            if ($hldday > 0 || $weekoff == 1)
                {
                
                }
                else{ 
                $attendance = $this->hrreportmodel->get_attendance_check($employee_id, $value);
                $overtime_status = 0;

                if ($attendance > 0)
                {
                    
                    $wrk = $this->hrreportmodel->get_working_hours($employee_id, $value);
  
                     if (!empty($wrk))
                    {
                        $totalMinutes = $wrk->elapsed_min;
                        $totalMinutess = $wrk->elapsed_min;
                        $hours = intval($totalMinutes / 60);
                        $minutes = $totalMinutes - ($hours * 60);
                        $status = $hours . ':' . $minutes;
                        $shift = $this->hrreportmodel->employee_shifthours($employee_id, $value);
                        
                        if (!empty($shift))
                        {
                            $shifttotalMinutes = 0;
                            $shiftstarttime = $value . ' ' . $shift->hr_shift_start_time;
                            $shiftendtime = $value . ' ' . $shift->hr_shift_end_time;
                          
                            $shifttotalMinutes = strtotime($shiftendtime) - strtotime($shiftstarttime);
                    
                            $shifttotalMinutes = intval($shifttotalMinutes / 60);
                         
                            $overtime = $totalMinutess - $shifttotalMinutes;
                            
                       
//                            if ($overtime > 30)
//                            {
                                $ttovertime += $overtime;
                                $overtimehours = intval($overtime / 60);
                                $overtimeminutes = $overtime - ($overtimehours * 60);
                                $overtime_status = $overtimehours . ':' . $overtimeminutes;
                           
                             
                                
                                
//                                }
                            }
                        }
                    } 
                   
                
}}
                  
                      return $ttovertime;
    }
    
    
      function totalworked($frmdate,$todate,$employee_id)
    {
             $title =   $this->dateRange($frmdate, $todate, "+1 day");
              $i = 1;
              $ttovertime= 0;
               $ttlateminutes= 0;
             
foreach ($title as $value)
{
    $branch_id = $this->mastermodel->get_single_field_value('hr_employees', 'hr_employees_branch', 'hr_employees_id',$employee_id);
               
           $hldday = $this->get_holiday_check($value,$branch_id);
        $weekoff = $this->get_weekoff($value,$branch_id);
    
            if ($hldday > 0 || $weekoff == 1)
                {
                
                }
                else{ 
                  
                $attendance = $this->hrreportmodel->get_attendance_check($employee_id, $value);
                $overtime_status = 0;
 
                if ($attendance > 0)
                {
                    
                    $wrk = $this->hrreportmodel->get_working_hours($employee_id, $value);
 
                     if (!empty($wrk))
                    {
                        $totalMinutes = $wrk->elapsed_min;
                        $totalMinutess = $wrk->elapsed_min;
                        $hours = intval($totalMinutes / 60);
                        $minutes = $totalMinutes - ($hours * 60);
                        $status = $hours . ':' . $minutes;
                        $shift = $this->hrreportmodel->employee_shifthours($employee_id, $value);
                        
                        if (!empty($shift))
                        {
                            $shifttotalMinutes = 0;
                            $shiftstarttime = $value . ' ' . $shift->hr_shift_start_time;
                            $shiftendtime = $value . ' ' . $shift->hr_shift_end_time;
                          
                            $shifttotalMinutes = strtotime($shiftendtime) - strtotime($shiftstarttime);
                    
                            $shifttotalMinutes = intval($shifttotalMinutes / 60);
                         
                            $overtime = $totalMinutess - $shifttotalMinutes;
                              
                                $ttovertime += $overtime;
                                
                              
                                $overtimehours = intval($overtime / 60);
                                $overtimeminutes = $overtime - ($overtimehours * 60);
                                $overtime_status = $overtimehours . ':' . $overtimeminutes;
                           
                             
                                
                                
                                
                            }
                        }
                    } 
                   
                
}}
                  
                      return $ttovertime;
    }
      function daysworked($frmdate,$todate,$employee_id)
    {
             $title =   $this->dateRange($frmdate, $todate, "+1 day");
              $i = 1;
              $ttovertime= 0;
               $ttlateminutes= 0;
             $n =0;
foreach ($title as $value)
{
    $branch_id = $this->mastermodel->get_single_field_value('hr_employees', 'hr_employees_branch', 'hr_employees_id',$employee_id);
               
           $hldday = $this->get_holiday_check($value,$branch_id);
        $weekoff = $this->get_weekoff($value,$branch_id);
    
            if ($hldday > 0 || $weekoff == 1)
                {
                
                }
                else{ 
                  
                $attendance = $this->hrreportmodel->get_attendance_check($employee_id, $value);
                $overtime_status = 0;
 
                if ($attendance > 0)
                {
                    
                    $wrk = $this->hrreportmodel->get_working_hours($employee_id, $value);
 
                     if (!empty($wrk))
                    {
                        $totalMinutes = $wrk->elapsed_min;
                        $totalMinutess = $wrk->elapsed_min;
                        $hours = intval($totalMinutes / 60);
                        $minutes = $totalMinutes - ($hours * 60);
                        $status = $hours . ':' . $minutes;
                        $shift = $this->hrreportmodel->employee_shifthours($employee_id, $value);
                     
                        if (!empty($shift))
                        {
                            
                             $shifttotalMinutes = 0;
                            $shiftstarttime = $value . ' ' . $shift->hr_shift_start_time;
                            $shiftendtime = $value . ' ' . $shift->hr_shift_end_time;
                           
                            $shifttotalMinutes = strtotime($shiftendtime) - strtotime($shiftstarttime);
                    
                            $shifttotalMinutes = intval($shifttotalMinutes / 60);
                         
                            $overtime += $totalMinutess ;
                               
                           $n++;
                           
                             
                                
                                
                                
                            }
                        }
                    } 
                   
                
}}
                  
                      return $overtime;
    }
     function totalmin($frmdate,$todate,$employee_id)
    {
             $title =   $this->dateRange($frmdate, $todate, "+1 day");
              $i = 1;
              $ttovertime= 0;
               $ttlateminutes= 0;
             $n =0;
foreach ($title as $value)
{
    $branch_id = $this->mastermodel->get_single_field_value('hr_employees', 'hr_employees_branch', 'hr_employees_id',$employee_id);
               
           $hldday = $this->get_holiday_check($value,$branch_id);
        $weekoff = $this->get_weekoff($value,$branch_id);
    
            if ($hldday > 0 || $weekoff == 1)
                {
                
                }
                else{ 
                  
                $attendance = $this->hrreportmodel->get_attendance_check($employee_id, $value);
                $overtime_status = 0;
 
                if ($attendance > 0)
                {
                    
                    $wrk = $this->hrreportmodel->get_working_hours($employee_id, $value);
 
                     if (!empty($wrk))
                    {
                        $totalMinutes = $wrk->elapsed_min;
                        $totalMinutess = $wrk->elapsed_min;
                        $hours = intval($totalMinutes / 60);
                        $minutes = $totalMinutes - ($hours * 60);
                        $status = $hours . ':' . $minutes;
                        $shift = $this->hrreportmodel->employee_shifthours($employee_id, $value);
                     
                        if (!empty($shift))
                        {
                            
                             $shifttotalMinutes = 0;
                            $shiftstarttime = $value . ' ' . $shift->hr_shift_start_time;
                            $shiftendtime = $value . ' ' . $shift->hr_shift_end_time;
                           
                            $shifttotalMinutes = strtotime($shiftendtime) - strtotime($shiftstarttime);
                    
                            $shifttotalMinutes = intval($shifttotalMinutes / 60);
                         
                       
                               
                           $n++;
                           
                             
                                
                                
                                
                            }
                        }
                    } 
                   
                
}}
                  
                      return $shifttotalMinutes;
    }
      function total_assign_work($frmdate,$todate,$employee_id)
    {
             $title =   $this->dateRange($frmdate, $todate, "+1 day");
              $i = 1;
              $ttovertime= 0;
               $ttlateminutes= 0;
             $n = 0;
foreach ($title as $value)
{
    $branch_id = $this->mastermodel->get_single_field_value('hr_employees', 'hr_employees_branch', 'hr_employees_id',$employee_id);
               
           $hldday = $this->get_holiday_check($value,$branch_id);
        $weekoff = $this->get_weekoff($value,$branch_id);
    
            if ($hldday > 0 || $weekoff == 1)
                {
                
                }
                else{ 
                  
               
                    
                  
                   
                        $shift = $this->hrreportmodel->employee_shifthours($employee_id, $value);
                        
                        if (!empty($shift))
                        {
                             $shifttotalMinutes = 0;
                            $shiftstarttime = $value . ' ' . $shift->hr_shift_start_time;
                            $shiftendtime = $value . ' ' . $shift->hr_shift_end_time;
                          
                            $shifttotalMinutes = strtotime($shiftendtime) - strtotime($shiftstarttime);
                    
                            $shifttotalMinutes = intval($shifttotalMinutes / 60);
                         
                            $overtime = $shifttotalMinutes;
                              
                                $ttovertime += $overtime;
                                
                           $n++;
                             
                                
                                
                                
                            
                        }
                    
                   
                
}}
                  
                      return $ttovertime;
    }
    
        function totalholidays($frmdate,$todate,$employee_id)
    {
             $title =   $this->dateRange($frmdate, $todate, "+1 day");
              $i = 1;
              $ttovertime= 0;
               $ttlateminutes= 0;
             $n = 0;
foreach ($title as $value)
{
    $branch_id = $this->mastermodel->get_single_field_value('hr_employees', 'hr_employees_branch', 'hr_employees_id',$employee_id);
               
           $hldday = $this->get_holiday_check($value,$branch_id);
        $weekoff = $this->get_weekoff($value,$branch_id);
    
            if ($hldday > 0 )
                {
              
                $n++;
                }
                if ($weekoff == 1)
                {
               
                $n++;
                } 
            
                  
                    
    }
      return $n;
    }
           function get_allowed_leave($date,$emp_id)
    {
        $this->db->from('hr_leave_application');
          $this->db->join('master', 'master.master_id=hr_leave_application.hr_leave_application_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->where('hr_leave_application_from_date <=', $date);
          $this->db->where('hr_leave_application_to_date >=', $date);
            $this->db->where('hr_leave_application_approve', 1);
              $this->db->where('hr_leave_application_employee', $emp_id);
             $this->db->where('hr_leave_application_higher', 1);
        $count = $this->db->count_all_results();
        return $count;
    }
             function get_allowed_leave_data($date,$emp_id)
    {
                   $this->db->select('hr_leave_application.days');
        $this->db->from('hr_leave_application');
          $this->db->join('master', 'master.master_id=hr_leave_application.hr_leave_application_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->where('hr_leave_application_from_date <=', $date);
          $this->db->where('hr_leave_application_to_date >=', $date);
            $this->db->where('hr_leave_application_approve', 1);
              $this->db->where('hr_leave_application_employee', $emp_id);
             $this->db->where('hr_leave_application_higher', 1);
        $count = $this->db->get()->row();
        return $count;
    }
     function allowed_leave($frmdate,$todate,$employee_id)
    {
             $title =   $this->dateRange($frmdate, $todate, "+1 day");
              $i = 1;
              $ttovertime= 0;
               $ttlateminutes= 0;
             $n = 0;
           
foreach ($title as $value)
{
    $branch_id = $this->mastermodel->get_single_field_value('hr_employees', 'hr_employees_branch', 'hr_employees_id',$employee_id);
               
           $hldday = $this->get_holiday_check($value,$branch_id);
        $weekoff = $this->get_weekoff($value,$branch_id);
    
               if ($hldday > 0 || $weekoff == 1)
                {
                
                }
                else{ 
                   
                 $allowed_leave = $this->get_allowed_leave($value,$employee_id);
                  if ($allowed_leave > 0 )
                {
                     $allowed_leave_data = $this->get_allowed_leave_data($value,$employee_id);
                   
                     if($allowed_leave_data->days =="full_day"){
                         $n = $n+1;
                     }
                     elseif($allowed_leave_data->days =="half_day"){
                         $n = $n+0.5;
                     }
              
                  }
                }
            
                  
                    
    }
      return $n;
    }
     function days_month($frmdate,$todate,$employee_id)
    {
             $title =   $this->dateRange($frmdate, $todate, "+1 day");
              $i = 1;
              $ttovertime= 0;
               $ttlateminutes= 0;
             $n = 0;
foreach ($title as $value)
{
 
                $n++;
    
            
                  
                    
    }
      return $n;
    }
    
       function total_empworked($frmdate,$todate,$employee_id)
    {
             $title =   $this->dateRange($frmdate, $todate, "+1 day");
              $i = 1;
              $ttovertime= 0;
               $ttlateminutes= 0;

foreach ($title as $value)
{
    $branch_id = $this->mastermodel->get_single_field_value('hr_employees', 'hr_employees_branch', 'hr_employees_id',$employee_id);
     
           $hldday = $this->get_holiday_check($value,$branch_id);
        $weekoff = $this->get_weekoff($value,$branch_id);
      
            if ($hldday > 0 || $weekoff == 1)
                {
                
                }
                else{ 
                $attendance = $this->hrreportmodel->get_attendance_check($employee_id, $value);
                $overtime_status = 0;

                if ($attendance > 0)
                {
                    
                    $wrk = $this->hrreportmodel->get_working_hours($employee_id, $value);
                   
                     if (!empty($wrk))
                    {
                        $totalMinutes = $wrk->elapsed_min;
                        $totalMinutess = $wrk->elapsed_min;
                           
                        $ttlateminutes += $totalMinutess;
                        }
                    } 
                   
                
}}
                  
                      return $ttlateminutes;
    }
    
       function total_empworked_notflex($frmdate,$todate,$employee_id)
    {
             $title =   $this->dateRange($frmdate, $todate, "+1 day");
              $i = 1;
              $ttovertime= 0;
               $ttlateminutes= 0;

foreach ($title as $value)
{
      $branch_id = $this->mastermodel->get_single_field_value('hr_employees', 'hr_employees_branch', 'hr_employees_id',$employee_id);
     
           $hldday = $this->get_holiday_check($value,$branch_id);
        $weekoff = $this->get_weekoff($value,$branch_id);
      
            if ($hldday > 0 || $weekoff == 1)
                {
                
                }
                else{ 
                $attendance = $this->hrreportmodel->get_attendance_check($employee_id, $value);
                $overtime_status = 0;

                if ($attendance > 0)
                {
                    
                    $wrk = $this->hrreportmodel->get_working_hours($employee_id, $value);
                   
                     if (!empty($wrk))
                    {
                        $starttime = "";
                        $endtime = "";
                        
                          $shift = $this->hrreportmodel->employee_shifthours($employee_id, $value);
                        
                        if (!empty($shift))
                        {
                            $shifttotalMinutes = 0;
                            $shiftstarttime = $value . ' ' . $shift->hr_shift_start_time;
                            $shiftendtime = $value . ' ' . $shift->hr_shift_end_time;
                          
                          if($shift->hr_shift_start_time <= $wrk->hr_attendance_start_time){
                              $starttime = $wrk->hr_attendance_start_time;
                          }
                          else{
                              $starttime = $shift->hr_shift_start_time; 
                          }
                          
                          
                          if($shift->hr_shift_end_time >= $wrk->hr_attendance_end_time){
                              $endtime = $wrk->hr_attendance_end_time;
                          }
                          else{
                               $endtime = $shift->hr_shift_end_time;
                          }
                          
                            $starttime = $value . ' ' .$starttime;
                            $endtime = $value . ' ' . $endtime;
                       $diiff = strtotime($endtime) - strtotime($starttime);
                    
                            $Minutes = intval($diiff / 60);
                          $ttlateminutes += $Minutes;
                            }
                     
                        }
                    } 
                   
                
}}
                  
                      return $ttlateminutes;
    }
    
      function total_shift($frmdate,$todate,$employee_id)
    {
             $title =   $this->dateRange($frmdate, $todate, "+1 day");
              $i = 1;
              $ttovertime= 0;
               $ttlshift= 0;

foreach ($title as $value)
{
   
     $branch_id = $this->mastermodel->get_single_field_value('hr_employees', 'hr_employees_branch', 'hr_employees_id',$employee_id);
     
           $hldday = $this->get_holiday_check($value,$branch_id);
        $weekoff = $this->get_weekoff($value,$branch_id);
      
            if ($hldday > 0 || $weekoff == 1)
                {
                
                }
                else{ 
                        $shift = $this->hrreportmodel->employee_shifthours($employee_id, $value);
                     
                        if (!empty($shift))
                        {
                            $shifttotalMinutes = 0;
                            $shiftstarttime = $value . ' ' . $shift->hr_shift_start_time;
                            $shiftendtime = $value . ' ' . $shift->hr_shift_end_time;
                          
                            $shifttotalMinutes = strtotime($shiftendtime) - strtotime($shiftstarttime);
                           
                            $shifttotalMinutes = intval($shifttotalMinutes / 60);
                        
                            $ttlshift += $shifttotalMinutes;
                           
                       
                          
                            }
                        }
                    } 
                   
                
                  
                      return $ttlshift;
    }
          function holiday($frmdate,$todate,$employee_id)
    {
             $title =   $this->dateRange($frmdate, $todate, "+1 day");
              $i = 1;
              $ttovertime= 0;
              $holiday_overtime = 0;
               $ttlateminutes= 0;

foreach ($title as $value)
{
    $branch_id = $this->mastermodel->get_single_field_value('hr_employees', 'hr_employees_branch', 'hr_employees_id',$employee_id);
     
                $hldday = $this->get_holiday_check($value,$branch_id);
                 $weekoff = $this->get_weekoff($value,$branch_id);
                 
                
                 if ($hldday > 0 || $weekoff == 1)
                {
                
                
                $attendance = $this->hrreportmodel->get_attendance_check($employee_id, $value);
                $overtime_status = 0;

                if ($attendance > 0)
                {
                      
                    $wrk = $this->hrreportmodel->get_working_hours($employee_id, $value);
                  
                     if (!empty($wrk))
                    {
                        $totalMinutes = $wrk->elapsed_min;
                        $totalMinutess = $wrk->elapsed_min;
                        $hours = intval($totalMinutes / 60);
                        $minutes = $totalMinutes - ($hours * 60);
                        $status = $hours . ':' . $minutes;
                        $shift = $this->hrreportmodel->employee_shifthours($employee_id, $value);
                         
                        if (!empty($shift))
                        {
                            $shifttotalMinutes = 0;
                            $shiftstarttime = $value . ' ' . $shift->hr_shift_start_time;
                            $shiftendtime = $value . ' ' . $shift->hr_shift_end_time;
                          
                            $shifttotalMinutes = strtotime($shiftendtime) - strtotime($shiftstarttime);
                    
                            $shifttotalMinutes = intval($shifttotalMinutes / 60);
                         
                            $overtime = $totalMinutess - $shifttotalMinutes;
//                            if ($overtime > 30)
//                            {
                             
                               $holiday_overtime = $holiday_overtime + $totalMinutess;
//                             
//                                $overtimehours = intval($overtime / 60);
//                                $overtimeminutes = $overtime - ($overtimehours * 60);
//                                $overtime_status = $overtimehours . ':' . $overtimeminutes;
                           
                           
                                
                                
//                                }
                            }
                        }
                    } 
                   
                } 
        }
      
      
                      return $holiday_overtime;
    }  
     function insert_single_salary_payment($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $data['resfunction'] = 'search_salary_payment';
        $masterid = $this->mastermodel->insertmasterdata();
        $salary_date = $this->mastermodel->convert_date_format($postdata['salary_date']);
        $pay_date = date('Y-m-d');
        $frmdate = date('Y-m-d', strtotime($salary_date . ' -1 months'));
         $todate = date('Y-m-d', strtotime($salary_date . ' -1 day'));
           $total_shift = $this->total_shift($frmdate, $todate, $postdata['employee_id']);
       
           if($_SESSION['policy'] == "flexible"){
           $total_empworked = $this->total_empworked($frmdate, $todate, $postdata['employee_id']);
           }
           elseif ($_SESSION['policy'] == "not_flexible") {
           
     
           $total_empworked = $this->total_empworked_notflex($frmdate, $todate, $postdata['employee_id']);

           }
           if($total_empworked >= $total_shift){
               $attendence = $total_shift;
           }
           else{
               $attendence = $total_empworked;
               
           }
           
            
           $perminute_salary = $postdata['basic_salary']/$total_shift;
           $total_salary = $perminute_salary * $attendence;
        if(!empty( $postdata['overtime_amount']) && $postdata['overtime_amount'] != 0){
           $overtime = $this->overtime($frmdate, $todate, $postdata['employee_id']);
             if($overtime < 0){
     $overtime = 0; 
  }
          $overtime_amount = $overtime * $postdata['overtime_amount'];
        }
        else{
            $overtime_amount = 0;
        }
          if(!empty( $postdata['holiday_payment']) && $postdata['holiday_payment'] != 0){
           $holiday = $this->holiday($frmdate, $todate, $postdata['employee_id']);
          
          $holiday_amount = $holiday * $postdata['holiday_payment'];
        }
        else{
            $holiday_amount = 0;
        }
        $extra_amount = $postdata['extraamount'];
   //         $totalworked = $this->totalworked($frmdate, $todate, $employee_id);
         
              $daysworked = $postdata['extraamount'];
//         $total_assign_work = $this->total_assign_work($frmdate, $todate, $employee_id);
         $totalholidays =$postdata['totalholidays'];
          $totalmin = $this->totalmin($frmdate, $todate, $employee_id);
//       
//         $totalholidays *= $totalmin; 
  
  
     $allowed_leave = $postdata['allowed_leave'];
  
//     $allowed_leave *=$totalmin;
  
      $real = $postdata['real'];
   $total = $this->days_month($frmdate, $todate, $postdata['employee_id']);
   $total *=$totalmin;
   if($real > $total){
      $real =  $total;
   }
       $totalsal = ($postdata['grosssalary'] /$total)*$real;
 
//        $netpayment = $total_salary + $allowance + $extra_amount - $deduction;
               
              $total_salary = $totalsal;

        $netpayment = $postdata['netsalary'];
        $tblValues = array(
            'hr_employee_salary_slip_id' => $masterid,
            'hr_employee_salary_employee_id' => $postdata['employee_id'],
            'hr_employee_salary_salary_date' => $salary_date,
            'hr_employee_salary_pay_date' => $pay_date,
            'hr_employee_salary_basic_salary' => $postdata['basic_salary'],
              'hr_employee_salary_gross_salary' => $postdata['grosssalary'],
            'hr_employee_salary_allowance_amount' => $postdata['allowance'],
            'hr_employee_salary_deduction_amount' => $postdata['deduction'],
            'hr_employee_salary_net_payment' => $netpayment,
//            'hr_employee_salary_commission_amount' => $postdata['commission'],
            'hr_employee_salary_payment_method' => $postdata['employee_sal_payment_mode'],
            'hr_employee_salary_paid_amount' => $netpayment,
            
              'hr_employee_salary_holiday_payment' => $postdata['holiday_payment'],
            'hr_employee_salary_overtime_amount' => $postdata['overtime_amount'],
            
                'hr_employee_salary_overtime_minutes' => $postdata['totalovertime'],
                'hr_employee_salary_holiday_minutes' => $postdata['totalholiday'],
               'hr_employee_salary_overtime_amount_permin' => $postdata['overtime_amount'],
                'hr_employee_salary_holiday_amount_permin' => $postdata['holiday_payment'],
              'hr_employee_salary_allowedholidays_min' => $postdata['allowedholidays'],
                'hr_employee_salary_allowed_leave_min' => $postdata['allowed_leave'],
             'hr_employee_salary_orginal_daysworked' => $postdata['orginal_daysworked'],
                'hr_employee_salary_daysworked' => $postdata['daysworked'],
                 'hr_employee_salary_total_minutes' => $postdata['total_minutes'],
            'hr_employee_salary_daystobeworked' => $postdata['to_be_worked'],
        );
        $this->db->insert('hr_employee_salary_slip', $tblValues);


        $i = 1;
        while (isset($postdata['amount_' . $i]))
        {
            $tblValues = array(
                'hr_employee_salary_slip_id' => $masterid,
                'hr_allowdeduc_id' => $postdata['allowdeduc_id_' . $i],
                'hr_employee_salary_slip_allowdeduc_amount' => $postdata['amount_' . $i]);
            $this->db->insert('hr_employee_salary_slip_allowdeduc', $tblValues);
            $i++;
        }

        $output = $this->mastermodel->save_user_activities('Add single salary payment',$masterid, 'hr_employee_salary_slip');  //ss
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Employee Salary Processed successfully';
            return $data;
        }
    }
      function search_salary_payment($pagenum)
    {
        $data = array();
        $data['results'] = '';
        return $data;
    }
      public function employee_service($employee_id)
    {
          $date = new DateTime("now");

        $curr_date = $date->format('Y-m-d ');
        $query = $this->db->query("select DATEDIFF('$curr_date',hr_employees_joining_date) as service,hr_employees_joining_date as joining_date  from hr_employees where hr_employees_id= $employee_id");

        $data = $query->row();
        return $data;
    }
    function gratuity_check($id)
    {

        $this->db->from('hr_gratuity');
        $this->db->where('hr_gratuity.hr_gratuity_employee', $id);
        $count = $this->db->count_all_results();
        return $count;
    }
       function gratuity_check_by_employee($id, $date)
    {
        $this->db->select('hr_gratuity_pay_date');
        $this->db->from('hr_gratuity');
       $this->db->where('hr_gratuity.hr_gratuity_employee', $id);
        $this->db->join('master', 'master.master_id=hr_gratuity.hr_gratuity_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
//        $this->db->where(array('hr_gratuity_amount-hr_gratuity_paid_amount', 0));
        $this->db->where('(select (gratuity.hr_gratuity_amount-gratuity.hr_gratuity_paid_amount) as amount from hr_gratuity gratuity where hr_gratuity_employee ='.$id.' )=', 0,false);
        $this->db->order_by('hr_gratuity_id', 'desc');
        $this->db->limit('1');
        $data = $this->db->get()->row();
        return $data;
    }
      function get_pay_structure_by_employee($id)
    {
        $this->db->select('*');
        $this->db->from('hr_employee_salary');
        $this->db->join('master', 'master.master_id=hr_employee_salary.hr_employee_salary_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->where('hr_employee_salary.hr_employee_salary_employee_id', $id);
        $data = $this->db->get()->row();
   
        return $data;
    }
    function get_netpay_by_salaryid($id)
    {
        $this->db->select(array('(sum(if(hr_allowdeduc_type="Allowance",hr_employee_salary_allowdeduc.hr_employee_salary_allowdeduc_amount,0))-sum(if(hr_allowdeduc_type="Deduction",hr_employee_salary_allowdeduc.hr_employee_salary_allowdeduc_amount,0))) as netpay'));
        $this->db->from('hr_employee_salary_allowdeduc');
        $this->db->join('hr_allowdeduc', 'hr_allowdeduc.hr_allowdeduc_id=hr_employee_salary_allowdeduc.hr_employee_salary_allowdeduc_allowdeduc_id');
        $this->db->join('master', 'master.master_id=hr_employee_salary_allowdeduc.hr_employee_salary_allowdeduc_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->where('hr_employee_salary_allowdeduc.hr_employee_salary_id', $id);
        $data = $this->db->get()->row();
        return $data;
    }
      function gratuity_pending_by_employee($id)
    {
        $this->db->select('(hr_gratuity_amount-hr_gratuity_paid_amount) as pending_amount,hr_gratuity_amount');
        $this->db->from('hr_gratuity');
        $this->db->join('master', 'master.master_id=hr_gratuity.hr_gratuity_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->where('hr_gratuity.hr_gratuity_employee', $id);
        $this->db->order_by('hr_gratuity_id', 'desc');
        $this->db->limit('1');
        $data = $this->db->get()->row();
        return $data;
    }
     public function save_gratuity($postdata)
    {
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'hr_gratuity_id' => $masterid,
            'hr_gratuity_employee' => $postdata['employee'],
            'hr_gratuity_netpay' => $postdata['netpay'],
             'hr_gratuity_basic_salary' => $postdata['basic_salary'],
            'hr_gratuity_pay_date' => $this->mastermodel->convert_date_format($postdata['pay_date']),
            'hr_gratuity_amount' => $postdata['gratuity_amount'],
            'hr_gratuity_paid_amount' => $postdata['paid_amount'],
        );
        $output = $this->db->insert('hr_gratuity', $tblValues);
        $i = 1;

        while (isset($postdata['year_' . $i]))
        {
            if ($postdata['year_' . $i] != "")
            {
                 $submasterid = $this->mastermodel->insertmasterdata();
                $tblValues = array(
                     'hr_gratuity_details_id' => $submasterid,
                    'hr_gratuity_details_gratuity' => $masterid,
                    'hr_gratuity_details_year' => $postdata['year_' . $i],
                    'hr_gratuity_details_amount' => $postdata['amount_' . $i],
                );
                $output = $this->db->insert('hr_gratuity_details', $tblValues);
            }
            $i++;
        }

//        $output = $this->mastermodel->save_user_activities('Add Gratuity', $masterid, 'gratuity');  //ss

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = 'Error on adding record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = 'Record Added  successfully';
            return $data;
        }
    }
    function get_employee_det($id)
    {
        $this->db->select('*');
        $this->db->from('hr_employees');
         $this->db->join('master', 'master.master_id=hr_employees.hr_employees_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
         $master_branch = $_SESSION['master_branch'];
             $query = "(";         
             $query.= "FIND_IN_SET(`master_branch_id`,'" . $master_branch . "') != 0";      
             $query.=")";     
             $this->db->where($query);
        $this->db->where('hr_employees.hr_employees_department_id', $id);
        $this->db->order_by('hr_employees_id', 'desc');
      
        $data = $this->db->get()->result();
        return $data;
    }
      function get_branchwise($table, $field, $id = "",$primary_field ="", $branchfield = "", $branch_id = '')
    {
        $data = array();
        $this->db->select('*');
         if ($id!='')
        {
        $this->db->where($field, $id);
        }
          if ($branch_id!='')
        {
        $this->db->where($branchfield, $branch_id);
        }
      if (!empty($primary_field))
        {
            $this->db->join('master', "master.master_id=$table.$primary_field");
        }
        $Q = $this->db->get($table);

        $data = $Q->result();
        return $data;
    }
  
    function search_salary_payed()
    { 
        $data = array();
        $this->db->select('hr_employee_salary_slip.*, hr_employees.hr_employees_name');
        $this->db->from('hr_employee_salary_slip');
        $this->db->join('master', 'master.master_id=hr_employee_salary_slip.hr_employee_salary_slip_id');
//        $this->db->join('hr_employee_salary_slip_allowdeduc', 'hr_employee_salary_slip_allowdeduc.hr_employee_salary_slip_id=hr_employee_salary_slip.hr_employee_salary_slip_id');
        $this->db->join('hr_employees', 'hr_employees.hr_employees_id=hr_employee_salary_employee_id    ');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $user_branch = $_SESSION['user_branch'];
             $query = "(";         
             $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";      
             $query.=")";     
             $this->db->where($query);
         $this->mastermodel->user_access();
        $this->db->order_by('hr_employee_salary_slip.hr_employee_salary_slip_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
    function get_allwnce_deduc_dtls($salary_slip_allowdeduc_id,$type)
    { 
        $data = array();
        $this->db->select('*');
        $this->db->from('hr_employee_salary_slip_allowdeduc');
        
        $this->db->join('hr_allowdeduc', 'hr_allowdeduc.hr_allowdeduc_id=hr_employee_salary_slip_allowdeduc.hr_allowdeduc_id');
       
        $this->db->where('hr_employee_salary_slip_allowdeduc.hr_employee_salary_slip_id',$salary_slip_allowdeduc_id);
        $this->db->where('hr_allowdeduc.hr_allowdeduc_type',$type);
        
//        $this->db->order_by('hr_employee_salary_slip.hr_employee_salary_slip_id', 'desc');
        $data = $this->db->get()->result();

        return $data;
    }
    function search_claim_allowance()
    {
         $data = array();
        $this->db->select('*');
        $this->db->from('hr_claim_allowance');
        $this->db->join('master', 'master.master_id=hr_claim_allowance.hr_claim_allowance_id');
//        $this->db->join('hr_employee_salary_slip_allowdeduc', 'hr_employee_salary_slip_allowdeduc.hr_employee_salary_slip_id=hr_employee_salary_slip.hr_employee_salary_slip_id');
        $this->db->join('hr_employees', 'hr_employees.hr_employees_id=hr_claim_allowance.hr_claim_employee_id');
          $this->db->join('hr_special_allowance', 'hr_special_allowance.hr_allowance_id=hr_claim_allowance.hr_claim_spcl_alwnc_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
         $user_branch = $_SESSION['user_branch'];
             $query = "(";         
             $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";      
             $query.=")";     
             $this->db->where($query);
        $this->db->order_by('hr_claim_allowance.hr_claim_allowance_id', 'desc');
          $this->mastermodel->user_access();
        $data['results'] = $this->db->get();
        return $data;
    }
    function get_employee_details($employee_id)
    {
      $data = array();
        $this->db->select('*');
        $this->db->from('hr_employees');
        
        $this->db->join('hr_department', 'hr_department.hr_department_id=hr_employees.hr_employees_department_id');
        $this->db->join('hr_designation', 'hr_designation.hr_designation_id=hr_employees.hr_employees_designation_id');
    
        $this->db->where('hr_employees.hr_employees_id',$employee_id);

        $Q = $this->db->get();

       
        if ($isarray)
            $row = $Q->row_array();
        else
            $row = $Q->row();
        return $row;
    }
    function get_claim_amount($postdata)
    {
       $data = array();

        
       $hr_employee_salary_id = $this->get_employee_salary_id($postdata['employee_id'],$postdata['date']);
       
        $this->db->select('hr_employee_salary_special_allowance_total,max(hr_employee_salary.hr_employee_salary_wef_date) as date');
         $this->db->from('hr_employee_salary_spcl_allowance');
        
        $this->db->join('hr_employee_salary', 'hr_employee_salary.hr_employee_salary_id=hr_employee_salary_spcl_allowance.hr_employee_salary_id');
      
        $this->db->where('hr_employee_salary_spcl_allowance.hr_employee_spcl_alwnc_id',$postdata['allowance_id']);
        $this->db->where('hr_employee_salary_spcl_allowance.hr_employee_salary_id',$hr_employee_salary_id);
        
        $data = $this->db->get()->row();
    
        return $data;
    }
     function get_employee_salary_id($employee_id, $date)
    {
        $data = array();

        $date = $this->mastermodel->convert_date_format($date);
        
        $sql = "SELECT tt.*,groupedtt.*
                FROM hr_employee_salary tt
                INNER JOIN
                (SELECT hr_employee_salary_employee_id, MAX(hr_employee_salary_wef_date) AS wefdate
                FROM hr_employee_salary
                where hr_employee_salary_wef_date <= '$date'
                GROUP BY hr_employee_salary_employee_id) groupedtt ON tt.hr_employee_salary_employee_id = groupedtt.hr_employee_salary_employee_id AND tt.hr_employee_salary_wef_date = groupedtt.wefdate
                where tt.hr_employee_salary_employee_id = '$employee_id' ";
        $Q = $this->db->query($sql);
        $result = $Q->row();
     
        if (!empty($result))
            return $result->hr_employee_salary_id;
        else
            return '';
    }
    
      public function insert_claim_allowance($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
         $b='image';
                $a='detail_images';
        $files = $_FILES;
        $cpt = count($_FILES[$a]['name']); 
        $cpt = count($files);
                    for($i=1; $i<=$cpt; $i++)
                    {
                        $_FILES[$a]['name']= $files[$a]['name'][$i];
                        $_FILES[$a]['type']= $files[$a]['type'][$i];
                        $_FILES[$a]['tmp_name']= $files[$a]['tmp_name'][$i];
                        $_FILES[$a]['error']= $files[$a]['error'][$i];
                        $_FILES[$a]['size']= $files[$a]['size'][$i];
                        $uploadPath = './assets/uploads/';
                        $config['upload_path'] = $uploadPath;
                           $config['max_size']             = 1024*20;
                        $config['allowed_types'] = 'gif|jpg|png|jpeg|xlsx|xls|pdf|csv|doc|docx|odt|txt';
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
               
                if($this->upload->do_upload($a.$i)){
                $fileData = $this->upload->data();
                $uploadData[$i]['file_name'] = $fileData['file_name'];
                $im[$i]=$uploadData[$i]['file_name'];
                }
                }
                 for($i=1;$i<=count($im);$i++){
              $detail_images_id= $this->mastermodel->insertmasterdata();
            $tbl1Values = array(
                'documeent_id' => $detail_images_id,
                'hr_claim_allowance_id' => $masterid,
                'claim_documnt_name' =>$im[$i],
             );
            $this->db->insert('hr_claim_allowance_documents', $tbl1Values);
            }
        $tblValues = array(
            'hr_claim_allowance_id' => $masterid,
            'hr_claim_spcl_alwnc_id' => $postdata['hr_claim_spcl_alwnc_id'],
             'hr_claim_employee_id' => $postdata['hr_claim_employee_id'],
            'hr_claim_eligible_amount' => $postdata['hr_claim_eligible_amount'],
            'hr_claim_period' => $postdata['hr_claim_period'],
            'hr_claim_remarks' => $postdata['hr_claim_remarks'],
            'hr_claim_amount' => $postdata['hr_claim_amount'],
            'hr_claim_reason' => $postdata['hr_claim_reason'],
            'claim_request_date' => $this->mastermodel->convert_date_format($postdata['claim_request_date']),
            );
        $this->db->insert('hr_claim_allowance', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
     function del_ppty_image($id)
    {    
       $this->db->trans_begin();
        $this->db->where('documeent_id', $id);
        $output = $this->db->delete('hr_claim_allowance_documents');

        $this->db->where('documeent_id', $id);
        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = "Unable to delete Record..!";
            return $data;
        } else {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = "Data Deleted Successfully..!";
            return $data;
        }
    }
     public function update_claim_allowance($postdata)
    {
        $data = array();
        $this->db->trans_begin();
         $a='detail_images';
         $files = $_FILES;
         $cpt = count($_FILES[$a]['name']); 
         $cpt = count($files);
                    for($i=1; $i<=$cpt; $i++)
                    {
                        $_FILES[$a]['name']= $files[$a]['name'][$i];
                        $_FILES[$a]['type']= $files[$a]['type'][$i];
                        $_FILES[$a]['tmp_name']= $files[$a]['tmp_name'][$i];
                        $_FILES[$a]['error']= $files[$a]['error'][$i];
                        $_FILES[$a]['size']= $files[$a]['size'][$i];
                        $uploadPath = './assets/uploads/';
                        $config['upload_path'] = $uploadPath;
                        $config['allowed_types'] = 'gif|jpg|png|jpeg|xlsx|xls|pdf|csv|doc|docx|odt|txt';
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
               
                if($this->upload->do_upload($a.$i)){
                $fileData = $this->upload->data();
                $uploadData[$i]['file_name'] = $fileData['file_name'];
                $im[$i]=$uploadData[$i]['file_name'];
                }
                }
        
      
        for($i=1;$i<=count($im);$i++){
              $detail_images_id= $this->mastermodel->insertmasterdata();
            $tbl1Values = array(
                'documeent_id' => $detail_images_id,
                'hr_claim_allowance_id' => $postdata['hr_claim_allowance_id'],
                'claim_documnt_name' =>$im[$i],
             );
            $this->db->insert('hr_claim_allowance_documents', $tbl1Values);
            }
       
                     $this->mastermodel->update_master_branch($postdata['hr_attendance_id']);   
        $cpt = count($_FILES[$a]['name']); 
        $tblValues = array(
            'hr_claim_period' => $postdata['hr_claim_period'],
            'hr_claim_remarks' => $postdata['hr_claim_remarks'],
            'hr_claim_amount' => $postdata['hr_claim_amount'],
            'hr_claim_reason' => $postdata['hr_claim_reason'],
            'claim_request_date' => $this->mastermodel->convert_date_format($postdata['claim_request_date']),
            );
        $this->db->where('hr_claim_allowance_id',$postdata['hr_claim_allowance_id']);
        $this->db->update('hr_claim_allowance', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    function search_circular(){
          $data = array();
        $this->db->select('*');
        $this->db->from('hr_circular');
        $this->db->join('user', 'user.user_id=hr_circular.hr_circular_userid');
        $this->db->join('master', 'master.master_id=hr_circular.hr_circular_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
         $user_branch = $_SESSION['user_branch'];
             $query = "(";         
             $query.= "FIND_IN_SET(`master_branch_id`,'" . $user_branch . "') != 0";      
             $query.=")";     
             $this->db->where($query);
        $this->db->order_by('hr_circular.hr_circular_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
     public function insert_circular($postdata)
    {       
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'hr_circular_id' => $masterid,
            'hr_circular_date' => $this->mastermodel->convert_date_format($postdata['hr_circular_date']),
            'hr_circular_userid' => $postdata['hr_circular_userid'],
            'hr_circular_emplyeeid' => $postdata['hr_circular_emplyeeid'],
            'hr_circular_remarks' => $postdata['hr_circular_remarks'],
            'hr_circular_content' => $postdata['hr_circular_content'],
             'hr_circular_type' => $postdata['hr_circular_type'],
            );
        $this->db->insert('hr_circular', $tblValues);
         $i = 1;
          
while(isset($postdata['hr_employee_id' . $i]))
{
        
 if(isset($postdata['circular_send_employe_id'.$i]))
 {
    $sub_masterid = $this->mastermodel->insertmasterdata();
                $tblValues = array(
            'hr_circular_details_id' => $sub_masterid,
            'hr_circular_id' => $masterid,
            'hr_employee_id' => $postdata['hr_employee_id' . $i], 
            );        
           $this->db->insert('hr_circular_details', $tblValues);
            $email['to']= $postdata['hr_employees_email' . $i];
             $email['subject']=$postdata['hr_circular_content_name'];
                $email['message']= '<pre style="font-family: arial,sans-serif;font-size: 100%;color: #222;">'.$postdata['hr_circular_content'].'<pre>';
           
                $status = $this->send_email_task($email);
               
 } 
      $i++;     
        }

         
        
      
      


        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
     function send_email_task($email)
   {         
        $sender = $this->get_sender_details();
       
        $config['protocol'] = 'smtp';
        $config['smtp_host'] = $sender->smtp_server;
        $config['smtp_port'] = $sender->smtp_port;
        $config['smtp_user'] = $sender->email_id;
        $config['smtp_pass'] = $sender->email_password;
        $from = $this->mastermodel->get_single_field_value('user','email','user_id',$_SESSION['user_id']);
      
         $config['smtp_crypto'] = "ssl";
        $config['mailtype'] = 'html';
        $config['charset'] = 'iso-8859-1';
        $this->load->library('email', $config);
        $this->email->set_newline("\r\n");
        $this->email->from($from,$sender->email_name);
        $this->email->to($email['to']);
      // $this->email->cc($email['cc']);
       
        $this->email->subject($email['subject']);
        
        $this->email->message($email['message']);
         if(!empty($email['attachment']))
        {
            $this->email->attach($email['attachment']);
        }
        
        return $this->email->send();
   }
   function get_sender_details()
    {
        $this->db->select('*');
        $this->db->from('email_settings');
        $this->db->where('email_settings_id',1);
        return $this->db->get()->row();
    }
    function search_circular_type()
    {
         $data = array();
        $this->db->select('*');
        $this->db->from('hr_circular_type');
        $this->db->join('master', 'master.master_id=hr_circular_type.hr_circular_type_id');
        $this->db->where('master.project_id',$_SESSION['project_id']);
        $this->db->order_by('hr_circular_type.hr_circular_type_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
  
               public function insert_circular_type($postdata)
    {       
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'hr_circular_type_id' => $masterid,
            'hr_circular_type_name' => $postdata['hr_circular_type_name'],
            'hr_circular_type_content' => $postdata['hr_circular_type_content'],
            );
        $this->db->insert('hr_circular_type', $tblValues);
        
         
        
      
      


        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
       public function update_circular_type($postdata)
    {
        $data = array();
        $this->db->trans_begin();
          $this->mastermodel->update_master_branch($postdata['hr_circular_type_id']);   
        $tblValues = array(
             'hr_circular_type_name' => $postdata['hr_circular_type_name'],
            'hr_circular_type_content' => $postdata['hr_circular_type_content'],
        );
        $this->db->where('hr_circular_type_id',$postdata['hr_circular_type_id']);
        $this->db->update('hr_circular_type', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    function get_circular_details($id){
          $data = array();
        $this->db->select('*');
        $this->db->from('hr_circular_details');
        
        $this->db->join('hr_employees', 'hr_employees.hr_employees_id=hr_circular_details.hr_employee_id');
       
        $this->db->where('hr_circular_details.hr_circular_id',$id);
    

        $data = $this->db->get()->result();

        return $data;
        
    }
    
    
      function get_total_leave_taken($value)
    {
        $f=date('Y-01-01');
                $t=date('Y-12-31');

        $data = $this->db->query("select SUM(hr_leave_application_days) as days_cpount from `hr_leave_application` where hr_leave_application_employee ='" . $value['hr_leave_application_employee']."' and  hr_leave_application_type_id ='" . $value['id']."' and hr_leave_application_from_date > '" .$f."' and  hr_leave_application_to_date < '" .$t."'");
        $result = $data->row();
        
              // echo $this->db->last_query();;

        if ($result->days_cpount)
        {
            return $result->days_cpount;
        }
        else
        {
            return 0;
        }
    }
}

    
