<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Posmodel extends CI_Model
{

    function __construct()
    {
        // Call the Model constructor
        parent::__construct();
    }

    public function search_category()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('pos_item_category');
        $this->db->join('master', 'master.master_id=pos_item_category.item_category_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('item_category_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_category($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $item_category_parent = 0;
        $masterid = $this->mastermodel->insertmasterdata();
        if (isset($postdata['item_category_parent']))
        {
            $item_category_parent = $postdata['item_category_parent'];
        }
        $tblValues = array(
            'item_category_id' => $masterid,
            'item_category_name' => $postdata['item_category_name'],
            'item_category_parent' => $item_category_parent,
            'narration' => $postdata['narration'],
        );
        $this->db->insert('pos_item_category', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_category($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $item_category_parent = 0;
        if (isset($postdata['item_category_parent']))
        {
            $item_category_parent = $postdata['item_category_parent'];
        }
        $tblValues = array(
            'item_category_name' => $postdata['item_category_name'],
            'item_category_parent' => $item_category_parent,
            'narration' => $postdata['narration'],
        );
        $this->db->where('item_category_id', $postdata['item_category_id']);
        $this->db->update('pos_item_category', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    public function search_type()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('item_type');
        $this->db->join('master', 'master.master_id=item_type.item_type_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('item_type_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_type($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();

        $tblValues = array(
            'item_type_id' => $masterid,
            'item_type_name' => $postdata['item_type_name'],
        );
        $this->db->insert('item_type', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_type($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'item_type_name' => $postdata['item_type_name'],
        );
        $this->db->where('item_type_id', $postdata['item_type_id']);
        $this->db->update('item_type', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    function search_vendor()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('vendor');
        $this->db->join('master', 'master.master_id=vendor_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('vendor_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_vendor($postdata)
    {
        $data = array();
        $this->db->trans_begin();

        $vendor_code = $this->mastermodel->get_ref('vendor_code', 'vendor', 'vendor_code');

        $set = $this->accountingmodel->get_account_settings('vendor');
        $ledger_id = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'ledger_id' => $ledger_id,
            'account_group_id' => $set,
            'ledger_name' => $postdata['vendor_name'],
            'mailing_name' => $postdata['vendor_name'],
            'address' => $postdata['vendor_address'],
            'phone' => $postdata['vendor_mobile'],
            'email' => $postdata['vendor_email'],
        );
        $output = $this->db->insert('account_ledger', $tblValues);
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'vendor_id' => $masterid,
            'vendor_code' => $vendor_code,
            'vendor_name' => $postdata['vendor_name'],
            'vendor_address' => $postdata['vendor_address'],
            'vendor_contact_person' => $postdata['vendor_contact_person'],
            'vendor_mobile' => $postdata['vendor_mobile'],
            'vendor_phone' => $postdata['vendor_phone'],
            'vendor_fax' => $postdata['vendor_fax'],
            'vendor_ledger' => $ledger_id,
            'vendor_email' => $postdata['vendor_email'],
            'vendor_sec_email' => $postdata['vendor_sec_email'],
            'vendor_skype_id' => $postdata['vendor_skype_id'],
            'vendor_website' => $postdata['vendor_website'],
            'vendor_credit_period' => $postdata['vendor_credit_period'],
            'vendor_credit_limit' => $postdata['vendor_credit_limit'],
            'vendor_account' => $postdata['vendor_account'],
            'vendor_bank_name' => $postdata['vendor_bank_name'],
            'vendor_bank_branch' => $postdata['vendor_bank_branch'],
            'vendor_ifsc_code' => $postdata['vendor_ifsc_code'],
            'vendor_remarks' => $postdata['vendor_remarks'],
            'vendor_lat' => $postdata['latclicked'],
            'vendor_long' => $postdata['longclicked'],
            'vendor_location' => $postdata['address'],
            'vendor_payment_term' => $postdata['vendor_payment_term']
        );
        $this->db->insert('vendor', $tblValues);
        $i = 1;
        while (!empty($postdata['vendor_contacts_name' . $i]))
        {
            $vendor_contacts_id = $this->mastermodel->insertmasterdata();
            $tblValues_sub_document = array(
                'vendor_contacts_id' => $vendor_contacts_id,
                'vendor_contacts_vendor_id' => $masterid,
                'vendor_contacts_name' => $postdata['vendor_contacts_name' . $i],
                'vendor_contacts_designation' => $postdata['vendor_contacts_designation' . $i],
                'vendor_contacts_mobile' => $postdata['vendor_contacts_mobile' . $i],
                'vendor_contacts_phone' => $postdata['vendor_contacts_phone' . $i],
                'vendor_contacts_email' => $postdata['vendor_contacts_email' . $i],
            );
            $i++;
            $output = $this->db->insert('vendor_contacts', $tblValues_sub_document);
        }
        $output = $this->mastermodel->save_user_activities('Add Vendor',$masterid, 'vendor');
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_vendor($postdata)
    {
        $data = array();
        $this->db->trans_begin();

        $set = $this->accountingmodel->get_account_settings('vendor');
        $tblValues = array(
            'account_group_id' => $set,
            'ledger_name' => $postdata['vendor_name'],
            'mailing_name' => $postdata['vendor_name'],
            'address' => $postdata['vendor_address'],
            'phone' => $postdata['vendor_mobile'],
            'email' => $postdata['vendor_email'],
        );
        $this->db->where('ledger_id', $postdata['ledger_id']);
        $output = $this->db->update('account_ledger', $tblValues);
        $tblValues = array(
            'vendor_name' => $postdata['vendor_name'],
            'vendor_address' => $postdata['vendor_address'],
            'vendor_contact_person' => $postdata['vendor_contact_person'],
            'vendor_mobile' => $postdata['vendor_mobile'],
            'vendor_phone' => $postdata['vendor_phone'],
            'vendor_fax' => $postdata['vendor_fax'],
            'vendor_ledger' => $ledger_id,
            'vendor_email' => $postdata['vendor_email'],
            'vendor_sec_email' => $postdata['vendor_sec_email'],
            'vendor_skype_id' => $postdata['vendor_skype_id'],
            'vendor_website' => $postdata['vendor_website'],
            'vendor_credit_period' => $postdata['vendor_credit_period'],
            'vendor_credit_limit' => $postdata['vendor_credit_limit'],
            'vendor_account' => $postdata['vendor_account'],
            'vendor_bank_name' => $postdata['vendor_bank_name'],
            'vendor_bank_branch' => $postdata['vendor_bank_branch'],
            'vendor_ifsc_code' => $postdata['vendor_ifsc_code'],
            'vendor_remarks' => $postdata['vendor_remarks'],
            'vendor_lat' => $postdata['latclicked'],
            'vendor_long' => $postdata['longclicked'],
            'vendor_location' => $postdata['address'],
            'vendor_payment_term' => $postdata['vendor_payment_term']
        );
        $this->db->where('vendor_id', $postdata['vendor_id']);
        $this->db->update('vendor', $tblValues);

        $this->db->where('vendor_contacts_vendor_id', $postdata['vendor_id']);
        $this->db->delete('vendor_contacts');
        $i = 1;
        while (isset($postdata['vendor_contacts_name' . $i]))
        {
            $vendor_contacts_id = $this->mastermodel->insertmasterdata();
            $tblValues_sub_document = array(
                'vendor_contacts_id' => $vendor_contacts_id,
                'vendor_contacts_vendor_id' => $postdata['vendor_id'],
                'vendor_contacts_name' => $postdata['vendor_contacts_name' . $i],
                'vendor_contacts_designation' => $postdata['vendor_contacts_designation' . $i],
                'vendor_contacts_mobile' => $postdata['vendor_contacts_mobile' . $i],
                'vendor_contacts_phone' => $postdata['vendor_contacts_phone' . $i],
                'vendor_contacts_email' => $postdata['vendor_contacts_email' . $i],
            );
            $i++;
            $output = $this->db->insert('vendor_contacts', $tblValues_sub_document);
        }
        $output = $this->mastermodel->save_user_activities('Edit Vendor',$postdata['vendor_id'], 'vendor');
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    function search_customer()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('contact');
        $this->db->join('master', 'master.master_id=contact.contact_id');
        $this->db->where('contact_status', 'active');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('contact.contact_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_customer($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $customer_code = $this->mastermodel->get_ref('contact_code', 'contact', 'contact_code');

        $set = $this->accountingmodel->get_account_settings('customer');
        $ledger_id = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'ledger_id' => $ledger_id,
            'account_group_id' => $set,
            'ledger_name' => $postdata['contact_first_name'] . " " . $postdata['contact_last_name'],
            'mailing_name' => $postdata['contact_last_name'] . " " . $postdata['contact_last_name'],
            'address' => $postdata['contact_address'],
            'phone' => $postdata['contact_official_phone'],
            'mobile' => $postdata['contact_mobile_1'],
            'email' => $postdata['contact_email'],
            'is_party' => 1,
        );
        $output = $this->db->insert('account_ledger', $tblValues);
        $tblValues = array(
            'contact_id' => $masterid,
            'contact_code' => $customer_code,
            'contact_status' => 'active',
            'contact_salutation_id' => $postdata['contact_salutation_id'],
            'contact_company_name' => $postdata['contact_company_name'],
            'contact_first_name' => $postdata['contact_first_name'],
            'contact_last_name' => $postdata['contact_last_name'],
            'contact_address' => $postdata['contact_address'],
            'contact_designation' => $postdata['contact_designation'],
            'contact_official_department' => $postdata['contact_official_department'],
            'contact_mobile_1' => $postdata['contact_mobile_1'],
            'contact_mobile_2' => $postdata['contact_mobile_2'],
            'contact_phone' => $postdata['contact_phone'],
            'contact_fax' => $postdata['contact_fax'],
            'contact_email' => $postdata['contact_email'],
            'contact_second_email' => $postdata['contact_second_email'],
            'contact_skype_id' => $postdata['contact_skype_id'],
            'contact_website' => $postdata['contact_website'],
            'customer_credit_period' => $postdata['customer_credit_period'],
            'customer_credit_limit' => $postdata['customer_credit_limit'],
            'contact_payment_terms' => $postdata['contact_payment_terms'],
            'contact_residential_address' => $postdata['contact_residential_address'],
            'contact_residential_street' => $postdata['contact_residential_street'],
            'contact_residential_zipcode' => $postdata['contact_residential_zipcode'],
            'contact_residential_country' => $postdata['contact_residential_country'],
            'contact_residential_city' => $postdata['contact_residential_city'],
            'contact_residential_state' => $postdata['contact_residential_state'],
            'contact_residential_phone' => $postdata['contact_residential_phone'],
            'contact_residential_DOB' => $this->mastermodel->convert_date_format($postdata['contact_residential_DOB']),
            'contact_official_location' => $postdata['address'],
            'contact_official_long' => $postdata['longclicked'],
            'contact_official_lat' => $postdata['latclicked'],
            'ledger' => $ledger_id,
        );
        $this->db->insert('contact', $tblValues);

        $i = 1;
        while (!empty($postdata['contact_sub_name' . $i]))
        {
            $contact = $this->mastermodel->insertmasterdata();
            $Values = array(
                'contact_sub_id' => $contact,
                'contact_sub_contact_id' => $masterid,
                'contact_sub_name' => $postdata['contact_sub_name' . $i],
                'contact_sub_designation' => $postdata['contact_sub_designation' . $i],
                'contact_sub_mobile' => $postdata['contact_sub_mobile' . $i],
                'contact_sub_phone' => $postdata['contact_sub_phone' . $i],
                'contact_sub_email' => $postdata['contact_sub_email' . $i],
            );
            $this->db->insert('contact_sub', $Values);
            $i++;
        }
        $output = $this->mastermodel->save_user_activities('Add Contact',$masterid, 'contact');
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_customer($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $set = $this->accountingmodel->get_account_settings('customer');
        $tblValues = array(
            'account_group_id' => $set,
            'ledger_name' => $postdata['contact_first_name'] . " " . $postdata['contact_last_name'],
            'mailing_name' => $postdata['contact_last_name'] . " " . $postdata['contact_last_name'],
            'address' => $postdata['contact_address'],
            'phone' => $postdata['contact_official_phone'],
            'mobile' => $postdata['contact_mobile_1'],
            'email' => $postdata['contact_email'],
            'is_party' => 1,
        );
        $this->db->where('ledger_id', $postdata['ledger_id']);
        $output = $this->db->update('account_ledger', $tblValues);
        $tblValues = array(
            'contact_salutation_id' => $postdata['contact_salutation_id'],
            'contact_company_name' => $postdata['contact_company_name'],
            'contact_first_name' => $postdata['contact_first_name'],
            'contact_last_name' => $postdata['contact_last_name'],
            'contact_address' => $postdata['contact_address'],
            'contact_designation' => $postdata['contact_designation'],
            'contact_official_department' => $postdata['contact_official_department'],
            'contact_mobile_1' => $postdata['contact_mobile_1'],
            'contact_mobile_2' => $postdata['contact_mobile_2'],
            'contact_phone' => $postdata['contact_phone'],
            'contact_fax' => $postdata['contact_fax'],
            'contact_email' => $postdata['contact_email'],
            'contact_second_email' => $postdata['contact_second_email'],
            'contact_skype_id' => $postdata['contact_skype_id'],
            'contact_website' => $postdata['contact_website'],
            'customer_credit_period' => $postdata['customer_credit_period'],
            'customer_credit_limit' => $postdata['customer_credit_limit'],
            'contact_payment_terms' => $postdata['contact_payment_terms'],
            'contact_residential_address' => $postdata['contact_residential_address'],
            'contact_residential_street' => $postdata['contact_residential_street'],
            'contact_residential_zipcode' => $postdata['contact_residential_zipcode'],
            'contact_residential_country' => $postdata['contact_residential_country'],
            'contact_residential_city' => $postdata['contact_residential_city'],
            'contact_residential_state' => $postdata['contact_residential_state'],
            'contact_residential_phone' => $postdata['contact_residential_phone'],
            'contact_residential_DOB' => $this->mastermodel->convert_date_format($postdata['contact_residential_DOB']),
            'contact_official_location' => $postdata['address'],
            'contact_official_long' => $postdata['longclicked'],
            'contact_official_lat' => $postdata['latclicked'],
            'ledger' => $ledger_id,
        );
        $this->db->where('contact_id', $postdata['contact_id']);
        $this->db->update('contact', $tblValues);

        $i = 1;
        $this->db->where('contact_sub_contact_id', $postdata['contact_id']);
        $this->db->delete('contact_sub');
        while (!empty($postdata['contact_sub_name' . $i]))
        {
            $contact = $this->mastermodel->insertmasterdata();
            $Values = array(
                'contact_sub_id' => $contact,
                'contact_sub_contact_id' => $postdata['contact_id'],
                'contact_sub_name' => $postdata['contact_sub_name' . $i],
                'contact_sub_designation' => $postdata['contact_sub_designation' . $i],
                'contact_sub_mobile' => $postdata['contact_sub_mobile' . $i],
                'contact_sub_phone' => $postdata['contact_sub_phone' . $i],
                'contact_sub_email' => $postdata['contact_sub_email' . $i],
            );
            $this->db->insert('contact_sub', $Values);
            $i++;
        }
$output = $this->mastermodel->save_user_activities('Edit Contact',$postdata['contact_id'], 'contact');
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function search_stock_unit()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('unit');
        $this->db->join('master', 'master.master_id=unit.unit_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('unit_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_stock_unit($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();

        $tblValues = array(
            'unit_id' => $masterid,
            'unit_name' => $postdata['pos_stock_unit_name'],
        );
        $this->db->insert('unit', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_stock_unit($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'unit_name' => $postdata['pos_stock_unit_name'],
        );
        $this->db->where('unit_id', $postdata['pos_stock_unit_id']);
        $this->db->update('unit', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    public function search_expense_type()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('pos_expense_type');
        $this->db->join('master', 'master.master_id=pos_expense_type.pos_expense_type_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('pos_expense_type_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_expense_type($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();

        $tblValues = array(
            'pos_expense_type_id' => $masterid,
            'pos_expense_type_name' => $postdata['pos_expense_type_name'],
        );
        $this->db->insert('pos_expense_type', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_expense_type($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'pos_expense_type_name' => $postdata['pos_expense_type_name'],
        );
        $this->db->where('pos_expense_type_id', $postdata['pos_expense_type_id']);
        $this->db->update('pos_expense_type', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    public function search_expense_details()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('expense_details');
        $this->db->join('master', 'master.master_id=expense_details.expense_details_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('expense_details_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function update_expense_details($postdata)
    {
        $this->db->trans_begin();
        $tblValues = array(
            'voucher_no' => $postdata['expense_details_voucher'],
            'voucher_date' => $this->mastermodel->convert_date_format($postdata['expense_details_date']),
        );
        $this->db->where('ledger_book_id', $postdata['ledger_book_id']);
        $output = $this->db->update('ledger_book', $tblValues);

        $set = $this->accountingmodel->get_account_settings('expense');
        $tblValues = array(
            'expense_type' => $postdata['expense_type'],
            'expense_details_voucher' => $postdata['expense_details_voucher'],
            'expense_details_description' => $postdata['expense_details_description'],
            'expense_details_date' => $this->mastermodel->convert_date_format($postdata['expense_details_date']),
            'from_account' => $postdata['from_account'],
            'to_account' => $set,
            'expense_details_amount' => $postdata['expense_details_amount'],
        );
        $this->db->where('expense_details_id', $postdata['expense_details_id']);
        $output = $this->db->update('expense_details', $tblValues);

        $this->db->where('ledger_book_id', $postdata['ledger_book_id']);
        $this->db->delete('ledger_book_details');

        $ledger_book_details_id = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'ledger_book_details_id' => $ledger_book_details_id,
            'ledger_book_id' => $postdata['ledger_book_id'],
            'account_ledger_id' => $postdata['from_account'],
            'debit' => $postdata['expense_details_amount'],
        );
        $output = $this->db->insert('ledger_book_details', $tblValues);
        $ledger_book_details_id = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'ledger_book_details_id' => $ledger_book_details_id,
            'ledger_book_id' => $postdata['ledger_book_id'],
            'account_ledger_id' => $set,
            'credit' => $postdata['expense_details_amount'],
        );
        $output = $this->db->insert('ledger_book_details', $tblValues);
$output = $this->mastermodel->save_user_activities('Edit expense details',$postdata['expense_details_id'], 'expense_details');
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = 'Error on adding record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = 'Record Added  successfully';
            return $data;
        }
    }

    public function insert_expense_details($postdata)
    {
        $this->db->trans_begin();

        $ledger_id = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'ledger_book_id' => $ledger_id,
            'voucher_no' => $postdata['expense_details_voucher'],
            'voucher_date' => $this->mastermodel->convert_date_format($postdata['expense_details_date']),
        );
        $output = $this->db->insert('ledger_book', $tblValues);

        $set = $this->accountingmodel->get_account_settings('expense');
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'expense_details_id' => $masterid,
            'expense_type' => $postdata['expense_type'],
            'expense_details_voucher' => $postdata['expense_details_voucher'],
            'expense_details_description' => $postdata['expense_details_description'],
            'expense_details_date' => $this->mastermodel->convert_date_format($postdata['expense_details_date']),
            'from_account' => $postdata['from_account'],
            'to_account' => $set,
            'expense_details_amount' => $postdata['expense_details_amount'],
            'expense_ledger' => $ledger_id,
        );
        $output = $this->db->insert('expense_details', $tblValues);

        $ledger_book_details_id = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'ledger_book_details_id' => $ledger_book_details_id,
            'ledger_book_id' => $ledger_id,
            'account_ledger_id' => $postdata['from_account'],
            'debit' => $postdata['expense_details_amount'],
        );
        $output = $this->db->insert('ledger_book_details', $tblValues);

        $ledger_book_details_id = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'ledger_book_details_id' => $ledger_book_details_id,
            'ledger_book_id' => $ledger_id,
            'account_ledger_id' => $set,
            'credit' => $postdata['expense_details_amount'],
        );
        $output = $this->db->insert('ledger_book_details', $tblValues);
$output = $this->mastermodel->save_user_activities('Add expense details',$masterid, 'expense_details');
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = 'Error on adding record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = 'Record Added  successfully';
            return $data;
        }
    }

    public function search_item()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('pos_item_master');
        $this->db->join('master', 'master.master_id=pos_item_master.product_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('product_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_item($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $item_code = $this->mastermodel->get_ref('product_code', 'pos_item_master', 'product_code');
//        if (isset($postdata['item_master_account']))
//        {
//            $item_master_account = $postdata['item_master_account'];
//        } else
//        {
//            $item_master_account = NULL;
        if (empty($postdata['expiry_date']))
            $postdata['expiry_date'] = '0000-00-00';
        $tblValues = array(
            'product_id' => $masterid,
            'product_code' => $item_code,
            'barcode' => $postdata['barcode'],
            'product_name' => $postdata['product_name'],
            'short_name' => $postdata['short_name'],
            'description' => $postdata['description'],
            'hsn_code' => $postdata['hsn_code'],
            'main_category' => $postdata['main_category'],
            'sub_category' => $postdata['sub_category'],
            'shelf_life' => $postdata['shelf_life'],
            'short_expiry' => $postdata['short_expiry'],
            'product_name' => $postdata['product_name'],
            'short_name' => $postdata['short_name'],
            'description' => $postdata['description'],
            'hsn_code' => $postdata['hsn_code'],
            'main_category' => $postdata['main_category'],
            'sub_category' => $postdata['sub_category'],
            'shelf_life' => $postdata['shelf_life'],
            'short_expiry' => $postdata['short_expiry'],
            'tax_percentage_id' => $postdata['tax_percentage_id'],
            'tax_percentage' => $postdata['tax_percentage'],
            'trading_connection' => $postdata['trading_connection'],
            'batch_no' => $postdata['batch_no'],
            'expiry_date' => $postdata['expiry_date'],
            'purchase_price' => $postdata['purchase_price'],
            'last_purchase_price' => $postdata['purchase_price'],
            'purchase_tax_amt' => $postdata['purchase_tax_amt'],
            'other_expense' => $postdata['other_expense'],
            'cost' => $postdata['cost'],
            'margin_percentage' => $postdata['margin_percentage'],
            'margin_fixed' => $postdata['margin_fixed'],
            'sale_price' => $postdata['sale_price'],
            'last_sale_rate' => $postdata['sale_price'],
            'wholeSale_price' => $postdata['wholeSale_price'],
            'sale_tax_amt' => $postdata['sale_tax_amt'],
            'sale_net_price' => $postdata['sale_net_price'],
            'wholeSale_net_price' => $postdata['wholeSale_net_price'],
            'max_retail_price' => $postdata['max_retail_price'],
            'max_discount_perc' => $postdata['max_discount_perc'],
            'sale_promotion_perc' => $postdata['sale_promotion_perc'],
            'bin' => $postdata['bin'],
            'reorder_required' => $postdata['reorder_required'],
            'reorder_level' => $postdata['reorder_level'],
            'reorder_qty' => $postdata['reorder_qty'],
            'min_stock_level' => $postdata['min_stock_level'],
            'max_stock_level' => $postdata['max_stock_level'],
            'item_status' => $postdata['item_status'],
            'discontinue_reason' => $postdata['discontinue_reason'],
            'purchase_unit' => $postdata['purchase_unit'],
            'sale_unit' => $postdata['purchase_unit'],
            'lowest_unit' => $postdata['purchase_unit'],
//            'purchase_type' => $postdata['purchase_type'],
            'default_supplier' => $postdata['default_supplier'],
        );
        $this->db->insert('pos_item_master', $tblValues);

        $batch_id = $this->mastermodel->insertmasterdata();
        if (empty($postdata['batch_no']))
            $batch_no = $this->mastermodel->get_ref('batch_no', 'pos_item_batch', 'batch_no');
        else
            $batch_no = $postdata['batch_no'];
        $batchTbl = array(
            'batch_id' => $batch_id,
            'batch_no' => $batch_no,
            'item_id' => $masterid,
            'sale_price' => $postdata['sale_price'],
            'expiry_date' => $postdata['expiry_date'],
        );
        $this->db->insert('pos_item_batch', $batchTbl);

        $stock_id = $this->mastermodel->insertmasterdata();
        $stockTbl = array(
            'stock_id' => $stock_id,
            'batch_id' => $batch_id,
            'quantity' => 0,
            'sale_price' => $postdata['sale_price'],
            'last_purchase' => $postdata['purchase_price'],
            'weighted_avg' => 0,
            'date' => date('Y-m-d'),
        );
        $this->db->insert('pos_item_stock', $stockTbl);
        $i = 1;
//        while (isset($postdata['from_unit_' . $i]))
//        {
        $item_sub_unit_id = $this->mastermodel->insertmasterdata();
        $tbleSubUnit = array(
            'item_sub_unit_id' => $item_sub_unit_id,
            'item_id' => $masterid,
            'from_unit' => $postdata['purchase_unit'],
            'to_unit' => $postdata['purchase_unit'],
            'unit_count' => $postdata['purchase_unit'],
            'unit_count' => 1,
        );
        $this->db->insert('pos_item_sub_unit', $tbleSubUnit);
//            $i++;
//        }
        $output = $this->mastermodel->save_user_activities('Add item',$masterid, 'pos_item_master');
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_item($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'barcode' => $postdata['barcode'],
            'product_name' => $postdata['product_name'],
            'short_name' => $postdata['short_name'],
            'description' => $postdata['description'],
            'hsn_code' => $postdata['hsn_code'],
            'main_category' => $postdata['main_category'],
            'sub_category' => $postdata['sub_category'],
            'shelf_life' => $postdata['shelf_life'],
            'short_expiry' => $postdata['short_expiry'],
            'product_name' => $postdata['product_name'],
            'short_name' => $postdata['short_name'],
            'description' => $postdata['description'],
            'hsn_code' => $postdata['hsn_code'],
            'main_category' => $postdata['main_category'],
            'sub_category' => $postdata['sub_category'],
            'shelf_life' => $postdata['shelf_life'],
            'short_expiry' => $postdata['short_expiry'],
            'tax_percentage_id' => $postdata['tax_percentage_id'],
            'tax_percentage' => $postdata['tax_percentage'],
            'trading_connection' => $postdata['trading_connection'],
            'purchase_price' => $postdata['purchase_price'],
            'last_purchase_price' => $postdata['purchase_price'],
            'purchase_tax_amt' => $postdata['purchase_tax_amt'],
            'other_expense' => $postdata['other_expense'],
            'cost' => $postdata['cost'],
            'margin_percentage' => $postdata['margin_percentage'],
            'margin_fixed' => $postdata['margin_fixed'],
            'sale_price' => $postdata['sale_price'],
            'last_sale_rate' => $postdata['sale_price'],
            'wholeSale_price' => $postdata['wholeSale_price'],
            'sale_tax_amt' => $postdata['sale_tax_amt'],
            'sale_net_price' => $postdata['sale_net_price'],
            'wholeSale_net_price' => $postdata['wholeSale_net_price'],
            'max_retail_price' => $postdata['max_retail_price'],
            'max_discount_perc' => $postdata['max_discount_perc'],
            'sale_promotion_perc' => $postdata['sale_promotion_perc'],
            'bin' => $postdata['bin'],
            'reorder_required' => $postdata['reorder_required'],
            'reorder_level' => $postdata['reorder_level'],
            'reorder_qty' => $postdata['reorder_qty'],
            'min_stock_level' => $postdata['min_stock_level'],
            'max_stock_level' => $postdata['max_stock_level'],
            'item_status' => $postdata['item_status'],
            'discontinue_reason' => $postdata['discontinue_reason'],
            'purchase_unit' => $postdata['purchase_unit'],
            'sale_unit' => $postdata['sale_unit'],
            'lowest_unit' => $postdata['lowest_unit'],
//            'purchase_type' => $postdata['purchase_type'],
            'default_supplier' => $postdata['default_supplier'],
        );
        $this->db->where('product_id', $postdata['product_id']);
        $this->db->update('pos_item_master', $tblValues);

        $this->db->where('item_id', $postdata['product_id']);
        $this->db->delete('pos_item_sub_unit');
        $i = 1;
        while (isset($postdata['from_unit_' . $i]))
        {
            $item_sub_unit_id = $this->mastermodel->insertmasterdata();
            $tbleSubUnit = array(
                'item_sub_unit_id' => $item_sub_unit_id,
                'item_id' => $postdata['product_id'],
                'from_unit' => $postdata['from_unit_' . $i],
                'to_unit' => $postdata['lowest_unit'],
                'unit_count' => $postdata['unit_count_' . $i],
            );
            $this->db->insert('pos_item_sub_unit', $tbleSubUnit);
            $i++;
        }
        $output = $this->mastermodel->save_user_activities('Edit item',$postdata['product_id'], 'pos_item_master');
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    public function search_lpr()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('pos_lpr');
        $this->db->join('master', 'master.master_id=pos_lpr.rfq_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('rfq_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_lpr($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $code = $this->mastermodel->get_ref('rfq_no', 'pos_lpr', 'rfq_no');
        $limit = $this->accountingmodel->get_account_settings('md_approval_limit');

        $tblValues = array(
            'rfq_id' => $masterid,
            'rfq_no' => $code,
            'rfq_date' => $this->mastermodel->convert_date_format($postdata['rfq_date']),
            'vendor' => $postdata['vendor'],
            'rfq_address' => $postdata['rfq_address'],
            'purpose' => $postdata['purpose'],
            'rfq_remarks' => $postdata['rfq_remarks'],
            'rfq_amount' => $postdata['rfq_amount'],
            'created_by' => $postdata['created_by'],
            'payment_term' => $postdata['payment_term'],
            'contact_person' => $postdata['contact_person'],
            'contact_no' => $postdata['contact_no'],
        );
        $output = $this->db->insert('pos_lpr', $tblValues);

        $x = 1;
        while (isset($postdata['product_master_code_' . $x]))
        {
            if ($postdata['product_master_code_' . $x] != '')
            {
                $is_percentage = '0';
                if (isset($postdata['is_percentage_' . $x]))
                {
                    $is_percentage = '1';
                }
                $rfq_details_id = $this->mastermodel->insertmasterdata();
                $tblValues = array(
                    'rfq_details_id' => $rfq_details_id,
                    'rfq' => $masterid,
                    'rfq_item' => $postdata['product_master_code_' . $x],
                    'quantity' => $postdata['qnt_' . $x],
                    'price' => $postdata['purchase_rate_' . $x],
                    'total' => $postdata['amount_' . $x],
                    'sale_rate' => $postdata['sale_rate_' . $x],
//                    'prev_price' => $postdata['prev_purchase_rate_' . $x],
                    'discount' => $postdata['discount_' . $x],
                    'is_percentage' => $is_percentage,
                );
                $this->db->insert('pos_lpr_details', $tblValues);
                $x++;
            }
        }
//        $output = $this->mastermodel->save_user_activities('Add LPR', $masterid, 'lpr');
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_lpr($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $limit = $this->accountingmodel->get_account_settings('md_approval_limit');

        $tblValues = array(
            'rfq_date' => $this->mastermodel->convert_date_format($postdata['rfq_date']),
            'vendor' => $postdata['vendor'],
            'rfq_address' => $postdata['rfq_address'],
            'purpose' => $postdata['purpose'],
            'rfq_remarks' => $postdata['rfq_remarks'],
            'rfq_amount' => $postdata['rfq_amount'],
            'created_by' => $postdata['created_by'],
            'payment_term' => $postdata['payment_term'],
            'contact_person' => $postdata['contact_person'],
            'contact_no' => $postdata['contact_no'],
        );

        if ($postdata['rfq_amount'] < $limit)
        {
//            $md_approval_status ='Approved';
            $tblValues = array(
                'md_approval_status' => 'Approved',
            );
        }
        $this->db->where('rfq_id', $postdata['rfq_id']);
        $output = $this->db->update('pos_lpr', $tblValues);

        $this->db->where('rfq', $postdata['rfq_id']);
        $output = $this->db->delete('pos_lpr_details');
        $masterid = $postdata['rfq_id'];
        $x = 1;
        while (isset($postdata['product_master_code_' . $x]))
        {
            if ($postdata['product_master_code_' . $x] != '')
            {
                $is_percentage = '0';
                if (isset($postdata['is_percentage_' . $x]))
                {
                    $is_percentage = '1';
                }
                $rfq_details_id = $this->mastermodel->insertmasterdata();
                $tblValues = array(
                    'rfq_details_id' => $rfq_details_id,
                    'rfq' => $masterid,
                    'rfq_item' => $postdata['product_master_code_' . $x],
                    'quantity' => $postdata['qnt_' . $x],
                    'price' => $postdata['purchase_rate_' . $x],
                    'total' => $postdata['amount_' . $x],
                    'sale_rate' => $postdata['sale_rate_' . $x],
//                    'prev_price' => $postdata['prev_purchase_rate_' . $x],
                    'discount' => $postdata['discount_' . $x],
                    'is_percentage' => $is_percentage,
                );
                $this->db->insert('pos_lpr_details', $tblValues);
                $x++;
            }
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    function get_vendor_by_id($id)
    {
        $this->db->select('*');
        $this->db->from('vendor');
        $this->db->where('vendor.vendor_id', $id);
        $data = $this->db->get()->row();
        return $data;
    }

    function get_item_by_id($id)
    {
        $this->db->select('pos_item_batch.item_id,pos_item_master.*, pos_item_stock.last_purchase,pos_item_batch.batch_no as pos_batch_no,pos_item_stock.sale_price as pos_sale_price,pos_item_batch.batch_id,pos_item_batch.expiry_date,pos_item_stock.quantity as quantity,unit.unit_name');
        $this->db->from('pos_item_stock');
        $this->db->join('pos_item_batch', 'pos_item_batch.batch_id=pos_item_stock.batch_id', 'left');
        $this->db->join('pos_item_master', 'pos_item_master.product_id=pos_item_batch.item_id', 'left');
        $this->db->join('unit', 'unit.unit_id=pos_item_master.purchase_unit', 'left');
        $this->db->where('pos_item_stock.stock_id', $id);
        $data = $this->db->get()->row();

        return $data;
    }

    function get_po_by_id($id)
    {
        $this->db->select('*');
        $this->db->from('pos_po');
        $this->db->where('pos_po.po_management_id', $id);
        $data = $this->db->get()->row();
        return $data;
    }

    function get_search_product($val)
    {
        $this->db->select('pos_item_stock.stock_id as id,pos_item_master.product_name,pos_item_batch.batch_no  as pos_batch_no,pos_item_stock.sale_price  as pos_sale_price');
        $this->db->from('pos_item_stock');
        $this->db->join('pos_item_batch', 'pos_item_batch.batch_id=pos_item_stock.batch_id', 'left');
        $this->db->join('pos_item_master', 'pos_item_master.product_id=pos_item_batch.item_id', 'left');
        $this->db->join('master', 'master.master_id=pos_item_master.product_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->like('pos_item_master.product_name', $val);
        $this->db->order_by('pos_item_stock.stock_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }

    function get_product_details($id)
    {
        $this->db->select('*');
        $this->db->from('pos_purchase_details');
        $this->db->join('item_master', 'item_master.item_master_id=pos_purchase_details.product_master', 'right');
        $this->db->join('unit', 'unit.unit_id=item_master.item_master_unit_id', 'left');
        $this->db->where('item_master.item_master_id', $id);
        $this->db->order_by('pos_purchase_details.purchase_details_id', 'desc');
        $data = $this->db->get()->row();
        return $data;
    }

    function get_inventory_settings_details($id)
    {
        $this->db->select('*');
        $this->db->from('pos_inventory_settings');
        $this->db->join('pos_fill_price', 'pos_fill_price.fill_price_id=pos_inventory_settings.fill_price', 'left');
        $this->db->where('pos_inventory_settings.inventory_settings_id', $id);
        $this->db->order_by('pos_inventory_settings.inventory_settings_id', 'desc');
        $data = $this->db->get()->row();
        return $data;
    }

    function get_pos_product_details($id)
    {
        $this->db->select('*');
        $this->db->from('pos_item_master');
        $this->db->join('pos_item_category', 'pos_item_category.item_category_id=pos_item_master.sub_category', 'left');
        $this->db->join('unit', 'unit.unit_id=pos_item_master.purchase_unit', 'left');
        $this->db->where('pos_item_master.product_id', $id);
        $this->db->order_by('pos_item_master.product_id', 'desc');
        $data = $this->db->get()->row();
        return $data;
    }

    //function to load product details based on inventory settings
    function get_pos_pdt_dtals_inventory($id)
    {
        $this->db->select('*');
        $this->db->from('pos_item_master');
        $this->db->join('pos_item_category', 'pos_item_category.item_category_id=pos_item_master.sub_category', 'left');
        $this->db->join('unit', 'unit.unit_id=pos_item_master.purchase_unit', 'left');
        $this->db->where('pos_item_master.product_id', $id);
        $this->db->order_by('pos_item_master.product_id', 'desc');
        $data['product'] = $this->db->get()->row();

        $data['godown'] = $this->mastermodel->selected_data('godown', array('godown_id', 'godown_name'));
        return $data;
    }

    function check_item_existence($g_id, $i_id)
    {
        $this->db->select('prop_item_stock.prop_item_stock_qty');
        $this->db->from('prop_item_stock');
        $this->db->where('prop_item_stock.prop_item_id', $i_id);
        $this->db->where('prop_item_stock.prop_godown_id', $g_id);
        $data = $this->db->get()->row()->prop_item_stock_qty;
        ($data == NULL) ? $data = 0 : $data;
        return $data;
    }

    function get_pos_rfq_det($id)
    {
        $this->db->select('pos_lpr_details.*, pos_lpr_details.quantity as lpr_quntiry')
                ->select('IFNULL(SUM(pos_po_details.quantity),"0") as po_qty', FALSE);
        $this->db->from('pos_lpr_details');
        $this->db->join('pos_po_details', 'pos_po_details.rfq_details_id=pos_lpr_details.rfq_details_id', 'left');
        $this->db->where('pos_lpr_details.rfq', $id);
        $this->db->group_by('pos_lpr_details.rfq_details_id');
        $data = $this->db->get()->result();
        return $data;
    }

    function get_pos_po_det($id)
    {
        $this->db->select('*');
        $this->db->from('pos_po_details');
//        $this->db->join('master', 'master.master_id=pos_po_details.po_details_id');
//        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->where('pos_po_details.po_management', $id);
        $this->db->order_by('pos_po_details.po_details_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }

    function get_product_unit_det($id)
    {
        $this->db->select('*');
        $this->db->from('unit');
        $this->db->join('item_master', 'unit.unit_id=item_master.item_master_unit_id', 'inner');
        $this->db->where('item_master.item_master_id', $id);
        $data = $this->db->get()->row();
        return $data;
    }

    public function search_purchase_order()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('pos_po');
        $this->db->join('master', 'master.master_id=pos_po.po_management_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('po_management_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_purchase_order($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $po_code = $this->mastermodel->get_ref('pos_purchase_order', 'pos_po', 'po_no', $postdata['po_category']);
        $tblValues = array(
            'po_management_id' => $masterid,
            'po_no' => $po_code,
            'po_date' => $this->mastermodel->convert_date_format($postdata['po_date']),
            'vendor' => $postdata['vendor'],
            'po_category_id' => $postdata['po_category'],
            'ref_no' => $postdata['ref_no'],
            'ref_date' => $this->mastermodel->convert_date_format($postdata['ref_date']),
            'po_amount' => $postdata['po_amount'],
            'payment_mode' => $postdata['payment_mode'],
            'payment_terms' => $postdata['payment_terms'],
            'contact_person' => $postdata['contact_person'],
            'priority' => $postdata['priority'],
            'terms_conditions' => $postdata['terms_conditions'],
            'prepared_by' => $postdata['prepared_by'],
            'authorised_by' => $postdata['authorised_by'],
        );
        $this->db->insert('pos_po', $tblValues);
        $x = 1;
        while (isset($postdata['product_master_code_' . $x]))
        {
            if ($postdata['product_master_code_' . $x] != '')
            {
                $is_percentage = '0';
                if (isset($postdata['is_percentage_' . $x]))
                {
                    $is_percentage = '1';
                }
                $sub_masterid = $this->mastermodel->insertmasterdata();
                $tblValues = array(
                    'po_details_id' => $sub_masterid,
                    'po_management' => $masterid,
                    'stock' => $postdata['product_master_code_' . $x],
                    'po_item' => $postdata['item_' . $x],
                    'quantity' => $postdata['qnt_' . $x],
                    'price' => $postdata['purchase_rate_' . $x],
                    'discount' => $postdata['discount_' . $x],
                    'is_percentage' => $is_percentage,
                    'total' => $postdata['total_' . $x],
                    'tax' => $postdata['tax_amount_' . $x],
                    'po_description' => $postdata['remarks_' . $x],
                    'tax_percentage' => $postdata['tax_percentage_' . $x],
                    'unit' => $postdata['unit_id_' . $x],
                );
                $this->db->insert('pos_po_details', $tblValues);
            }
            $x++;
        }
         $output = $this->mastermodel->save_user_activities('Add PO',$masterid, 'pos_po');
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_purchase_order($postdata)
    {


        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'po_date' => $this->mastermodel->convert_date_format($postdata['po_date']),
            'vendor' => $postdata['vendor'],
            'ref_no' => $postdata['ref_no'],
            'ref_date' => $this->mastermodel->convert_date_format($postdata['ref_date']),
            'po_amount' => $postdata['po_amount'],
            'payment_mode' => $postdata['payment_mode'],
            'payment_terms' => $postdata['payment_terms'],
            'contact_person' => $postdata['contact_person'],
            'priority' => $postdata['priority'],
            'terms_conditions' => $postdata['terms_conditions'],
            'prepared_by' => $postdata['prepared_by'],
            'authorised_by' => $postdata['authorised_by'],
        );
        $this->db->where('po_management_id', $postdata['po_management_id']);
        $this->db->update('pos_po', $tblValues);


        $masterid = $postdata['po_management_id'];
        $i = 1;
        while (isset($postdata['product_master_code_' . $i]))
        {

            if ($postdata['product_master_code_' . $i] != '')
            {
                $is_percentage = '0';
                if (isset($postdata['is_percentage_' . $i]))
                {
                    $is_percentage = '1';
                }
//                $is_percentage_tax = '0';
//                if (isset($postdata['is_percentage_tax_' . $i]))
//                {
//                    $is_percentage_tax = '1';
//                }
                if ($postdata['status_' . $i] == "0")
                {


                    $po_item = $postdata['item_' . $i];
                    $po_details_id = $postdata['po_details_id_' . $i];


                    $tblValues_po_details_id = array(
                        'po_item' => $po_item,
                        'stock' => $postdata['product_master_code_' . $i],
                        'quantity' => $postdata['qnt_' . $i],
                        'price' => $postdata['purchase_rate_' . $i],
                        'discount' => $postdata['discount_' . $i],
                        'total' => $postdata['total_' . $i],
                        'tax' => $postdata['tax_amount_' . $i],
                        'is_percentage' => $is_percentage,
                        'po_description' => $postdata['remarks_' . $i],
                        'tax_percentage' => $postdata['tax_percentage_' . $i],
                        'unit' => $postdata['unit_id_' . $i],
                    );

                    $this->db->where('pos_po_details.po_details_id', $postdata['po_details_id_' . $i]);
                    $this->db->update('pos_po_details', $tblValues_po_details_id);
                } elseif ($postdata['status_' . $i] == "1")
                {
                    $sub_masterid = $this->mastermodel->insertmasterdata();
                    $tblValues = array(
                        'po_details_id' => $sub_masterid,
                        'po_management' => $masterid,
                        'stock' => $postdata['product_master_code_' . $i],
                        'po_item' => $postdata['item_' . $i],
                        'quantity' => $postdata['qnt_' . $i],
                        'price' => $postdata['purchase_rate_' . $i],
                        'discount' => $postdata['discount_' . $i],
                        'total' => $postdata['total_' . $i],
                        'tax' => $postdata['tax_amount_' . $i],
                        'is_percentage' => $is_percentage,
                        'po_description' => $postdata['remarks_' . $i],
                        'tax_percentage' => $postdata['tax_percentage_' . $i],
                        'unit' => $postdata['unit_id_' . $i],
                    );
                    $this->db->insert('pos_po_details', $tblValues);
                } else
                {

                    $this->db->where('po_details_id', $postdata['po_details_id_' . $i]);
                    $this->db->delete('pos_po_details');
                }
            }
            $i++;
        }
$output = $this->mastermodel->save_user_activities('Edit PO',$masterid, 'pos_po');
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    public function search_receipt_note()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('pos_purchase');
        $this->db->join('master', 'master.master_id=pos_purchase.purchase_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('purchase_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    function get_unused_po_no_by_vendor($id)
    {

        $this->db->select('po_management_id,po_no');
        $this->db->from('pos_po');
        $this->db->join('vendor', 'pos_po.vendor=vendor.vendor_id');
        $this->db->join('pos_po_details', 'pos_po_details.po_management=pos_po.po_management_id');
        $this->db->where('pos_po.vendor IN ( ' . $id . ')', null, true);
        $this->db->where('pos_po.po_management_id in', '(SELECT  `pos_po`.`po_management_id` 
                            FROM `pos_po`
                            INNER JOIN `pos_po_details` ON `pos_po`.`po_management_id` = `pos_po_details`.`po_management`
        
                            WHERE `po_completed_qty` < `quantity`)', false);

        $this->db->where('pos_po.po_manager_approval', 1);
        $this->db->where('pos_po.po_gm_approval', 1);
        $this->db->group_by('pos_po.po_management_id');
        $data = $this->db->get()->result();
//                echo $this->db->last_query();
        return $data;
    }

    function get_product_master_by_id($id)
    {
        $this->db->select('*');
        $this->db->from('item_master');
        $this->db->where('item_master.item_master_id', $id);
        $data = $this->db->get()->row();
        return $data;
    }

    function get_product()
    {
        $this->db->select('item_master_id,item_master_name,item_master_code');
        $this->db->from('item_master');
        $this->db->join('master', 'master.master_id=item_master.item_master_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('item_master.item_master_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }

    function get_lpr_by_id($id)
    {
        $this->db->select('*');
        $this->db->from('pos_lpr');
        $this->db->where('pos_lpr.rfq_id', $id);
        $data = $this->db->get()->row();
        return $data;
    }

    public function verified_lpr($postdata)
    {
        $this->db->trans_begin();
        $rfq_amt = $this->mastermodel->get_single_field_value("pos_lpr", "rfq_amount", "rfq_id", $postdata['rfq_id']);
        $limit = $this->accountingmodel->get_account_settings('md_approval_limit');
        if ($rfq_amt < $limit)
        {
            $md_approval_status = 'Approved';
        } else
        {
            $md_approval_status = 'Waiting';
        }

        $tblValues = array(
            'verified_by' => $_SESSION['user_name'],
            'md_approval_status' => $md_approval_status,
        );
        $this->db->where('rfq_id', $postdata['rfq_id']);
        $output = $this->db->update('pos_lpr', $tblValues);

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = 'Error on adding record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = 'Record Verified  successfully';
            return $data;
        }
    }

    public function approve_lpr($postdata)
    {
        $this->db->trans_begin();
        $tblValues = array(
            'md_approval' => $_SESSION['user_name'],
            'rfq_remarks' => $postdata['rfq_remarks'],
            'md_approval_status' => 'Approved',
        );
        $this->db->where('rfq_id', $postdata['rfq_id']);
        $output = $this->db->update('pos_lpr', $tblValues);

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = 'Error on adding record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = 'Record Approved  successfully';
            return $data;
        }
    }

    public function rejected_lpr($postdata)
    {
        $this->db->trans_begin();
        $tblValues = array(
            'md_approval' => $_SESSION['user_name'],
            'rfq_remarks' => $postdata['rfq_remarks'],
            'md_approval_status' => 'Rejected',
        );
        $this->db->where('rfq_id', $postdata['rfq_id']);
        $output = $this->db->update('pos_lpr', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = 'Error on adding record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = 'Record Rejected  successfully';
            return $data;
        }
    }

    function get_vendor($v_id)
    {
        $this->db->select('*');
        $this->db->from('vendor');
        $this->db->where('vendor_id', $v_id);
        $data['vendor'] = $this->db->get()->row();
//        $this->db->select('pos_lpr.*, (pos_lpr_details.quantity) as lpr_qty')
//                ->select('IFNULL(SUM(pos_po_details.quantity),0) as po_qty',FALSE);
//         $this->db->from('pos_lpr_details');
//         $this->db->join('pos_lpr','pos_lpr.rfq_id = pos_lpr_details.rfq');
//          $this->db->join('pos_po_details','pos_po_details.rfq_details_id = pos_lpr_details.rfq_details_id','left');
//          $this->db->join('vendor','pos_lpr.vendor = vendor.vendor_id');
//           $this->db->where('pos_lpr.vendor',$v_id);
//            $this->db->where('pos_lpr.md_approval_status','Approved');
//              $this->db->where('pos_lpr.verified_by <>','');
//              $this->db->group_by('pos_lpr_details.rfq_details_id');
//              $this->db->having('lpr_qty > po_qty',false);
//              $this->db->order_by('pos_lpr.rfq_id', 'desc');
//                $table = $this->db->get()->result();
//             $query = "SELECT distinct rfq_id,rfq_no from  ($table) as Tbl";
//        $query = "SELECT distinct rfq_id,rfq_no from (SELECT pos_lpr.*, (pos_lpr_details.quantity) as lpr_qty, IFNULL(SUM(pos_po_details.quantity),0) as po_qty FROM `pos_lpr_details" ."`JOIN `pos_lpr` ON `pos_lpr`.`rfq_id`=`pos_lpr_details`.`rfq` LEFT JOIN `pos_po_details` ON `pos_po_details`.`rfq_details_id`=`pos_lpr_details`.`rfq_details_id` JOIN `vendor` ON `pos_lpr`.`vendor`=`vendor`.`vendor_id`WHERE pos_lpr.vendor = '$v_id' and pos_lpr.md_approval_status ='Approved' and pos_lpr.verified_by <>'' GROUP BY `pos_lpr_details`.`rfq_details_id` having lpr_qty > po_qty ORDER BY `pos_lpr`.`rfq_id` DESC) as Tbl";
        $query = "SELECT distinct rfq_id,rfq_no from (SELECT pos_lpr.*, (pos_lpr_details.quantity) as lpr_qty, IFNULL(SUM(pos_po_details.quantity),0) as po_qty FROM `pos_lpr_details`JOIN `pos_lpr` ON `pos_lpr`.`rfq_id`=`pos_lpr_details`.`rfq` LEFT JOIN `pos_po_details` ON `pos_po_details`.`rfq_details_id`=`pos_lpr_details`.`rfq_details_id`JOIN `vendor` ON `pos_lpr`.`vendor`=`vendor`.`vendor_id`WHERE pos_lpr.vendor = '$v_id' and pos_lpr.md_approval_status ='Approved' and pos_lpr.verified_by <>'' GROUP BY `pos_lpr_details`.`rfq_details_id` having lpr_qty > po_qty ORDER BY `pos_lpr`.`rfq_id` DESC) as Tbl";

        $result = $this->db->query($query);

        $data['lpr'] = $result->result();
//        $this->db->select('rfq_id,rfq_no');
//        $this->db->from('pos_lpr');
//        $this->db->where('vendor', $data['vendor']->vendor_id);
//        $data['lpr'] = $this->db->get()->result();
        return $data;
    }

    function get_pos_po_purchased_quantity($id, $val)
    {

        $this->db->select('sum(pos_purchase_details.quantity) as purchased_quantity');
        $this->db->from('pos_purchase_details');

        $this->db->join('pos_purchase', 'pos_purchase_details.purchase_id=pos_purchase.purchase_id', 'inner');
        $this->db->where('pos_purchase_details.product_master', $val);
        $this->db->where('pos_purchase.po_management', $id);

        $data = $this->db->get()->row()->purchased_quantity;

        return $data;
    }

    function search_godown()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('godown');
        $this->db->join('master', 'master.master_id=godown.godown_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('godown_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_godown($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $i = 1;
        $master_godown_id = $this->mastermodel->insertmasterdata();
        $godownValues = array(
            'godown_id' => $master_godown_id,
            'godown_name' => $postdata['godown_name'],
        );
        $this->db->insert('godown', $godownValues);
        while (isset($postdata['godown_rack_name' . $i]))
        {
            $master_rack_id = $this->mastermodel->insertmasterdata();
            $rackValues = array(
                'godown_rack_id' => $master_rack_id,
                'godown_rack_godown_id' => $master_godown_id,
                'godown_rack_name' => $postdata['godown_rack_name' . $i]
            );
            $this->db->insert('godown_rack', $rackValues);
            $i++;
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    public function update_godown($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $i = 1;
        $godownValues = array(
            'godown_name' => $postdata['godown_name']
        );
        $this->db->where('godown_id', $postdata['godown_id']);
        $this->db->update('godown', $godownValues);


        $this->db->where('godown_rack_godown_id', $postdata['godown_id']);
        $this->db->delete('godown_rack');


        while (isset($postdata['godown_rack_name' . $i]))
        {
            $master_rack_id = $this->mastermodel->insertmasterdata();
            $rackValues = array(
                'godown_rack_id' => $master_rack_id,
                'godown_rack_godown_id' => $postdata['godown_id'],
                'godown_rack_name' => $postdata['godown_rack_name' . $i]
            );
            $this->db->insert('godown_rack', $rackValues);
            $i++;
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    function get_batch_exist($item_id, $sale_rate)
    {
        $this->db->select('pos_item_batch.*');
        $this->db->from('pos_item_batch');
        $this->db->join('master', 'master.master_id=pos_item_batch.batch_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->where('item_id', $item_id);
        $this->db->where('sale_price', $sale_rate);
        $data = $this->db->get()->row();
        return $data;
    }

    //function to check if batch exist (if batch no is typed)
    function get_batch_exist_byBatchNo($item_id, $batch_no)
    {
        $this->db->select('pos_item_batch.*');
        $this->db->from('pos_item_batch');
        $this->db->join('master', 'master.master_id=pos_item_batch.batch_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->where('item_id', $item_id);
        $this->db->where('BINARY batch_no =', "'$batch_no'", FALSE);

        $data = $this->db->get()->row();
        return $data;
    }

    function get_stock_detail($batch_id)
    {
        $this->db->select('*');
        $this->db->from('pos_item_stock');
        $this->db->join('master', 'master.master_id=pos_item_stock.stock_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->where('batch_id', $batch_id);
        $data = $this->db->get()->row();
        return $data;
    }

    function get_stock_qty_multiplayer($product_master, $unit, $lowest_unit)
    {
        $this->db->select('unit_count');
        $this->db->from('pos_item_sub_unit');
        $this->db->join('master', 'master.master_id=pos_item_sub_unit.item_sub_unit_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->where('item_id', $product_master);
        $this->db->where('from_unit', $unit);
        $this->db->where('to_unit', $lowest_unit);
        $data = $this->db->get()->row();
        return $data;
    }

    public function insert_purchase($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $dcode = $this->mastermodel->get_ref('pos_purchase', 'pos_purchase', 'purchase_no', $postdata['inventory_settings_id']);
        $masterid = $this->mastermodel->insertmasterdata();
        if ($postdata['po_management'] != '')
        {
            $po = $postdata['po_management'];
        } else
        {
            $po = NULL;
        }
//        $ledger_id = $this->mastermodel->insertmasterdata();
//         $tblValues = array(
//            'ledger_book_id' => $ledger_id,
//            'voucher_no' => $postdata['purchase_voucher_no'],
//            'voucher_date' => $this->mastermodel->convert_date_format($postdata['vendor_bill_date']),
//        );
//         $output = $this->db->insert('ledger_book', $tblValues);
        $tblValues = array(
            'purchase_id' => $masterid,
            'purchase_no' => $dcode,
            'po_management' => $po,
            'purchase_vendor' => $postdata['purchase_vendor'],
            'exchange_rate' => $postdata['exchange_rate'],
            'purchase_voucher_no' => $postdata['purchase_voucher_no'],
            'purchase_date' => $this->mastermodel->convert_date_format($postdata['purchase_date']),
            'vendor_bill_date' => $this->mastermodel->convert_date_format($postdata['vendor_bill_date']),
            'do_date' => $this->mastermodel->convert_date_format($postdata['do_date']),
            'purchase_discount' => $postdata['purchase_discount'],
            'purchase_total' => $postdata['po_amount'],
            'do_no' => $postdata['do_no'],
//            'purchase_ledger' => $ledger_id,
            'payment_mode' => $postdata['payment_mode'],
            'payment_terms' => $postdata['payment_terms'],
            'cheque_no' => $postdata['cheque_no'],
            'cheque_date' => $this->mastermodel->convert_date_format($postdata['cheque_date']),
            'inventory_settings_id' => $postdata['inventory_settings_id'],
            'work_order' => $postdata['work_order'],
        );

        $output = $this->db->insert('pos_purchase', $tblValues);

//          if($postdata['payment_mode']=='Credit')
//        {
//            $ret = $this->accountingmodel->get_accountmaster_id('vendor', 'vendor_id', 'vendor_ledger', $postdata['purchase_vendor']);
//            $ret_name = $this->mastermodel->get_single_field_value('vendor', 'vendor_name', 'vendor_id', $postdata['purchase_vendor']);
//
//            $x = 1;
//            $sum = $postdata['po_amount'];
//
//            $tblValues_led = array(
//            'ledger_book_id' => $ledger_id,
//            'account_ledger_id' => $ret,
//            'credit' => $sum,
//            );
//            $output = $this->db->insert('ledger_book_details', $tblValues_led);
//            $cdet_id = $this->db->insert_id();
//        }
//        else
//            {
//            $cash_account=  $this->accountingmodel->get_account_settings('cash_account');
//            $x = 1;
//            $sum = $postdata['po_amount'];
//
//            $tblValues_led = array(
//            'ledger_book_id' => $ledger_id,
//            'account_ledger_id' => $cash_account,
//            'credit' => $sum,
//            );
//            $output = $this->db->insert('ledger_book_details', $tblValues_led);
//            $cdet_id = $this->db->insert_id();
//         }
        $x = 1;
        while (isset($postdata['product_master_' . $x]))
        {
            if (isset($postdata['po_details_id_' . $x]))
            {
                $po_details_id[$x] = $this->db->escape_str($postdata['po_details_id_' . $x]);
            }
            if (isset($postdata['expiry_date_' . $x]))
            {
                $expiry_date[$x] = $this->mastermodel->convert_date_format($postdata['expiry_date_' . $x]);
            } else
            {
                $expiry_date[$x] = '0000-00-00';
            }

            if (isset($postdata['batch_no_' . $x]))
            {
                $batch_no[$x] = $this->db->escape_str($postdata['batch_no_' . $x]);
            }
            $stock_detl_id[$x] = $this->db->escape_str($postdata['product_master_' . $x]);
            $product_master[$x] = $this->db->escape_str($postdata['item_id_' . $x]);
            $account_connection[$x] = $this->db->escape_str($postdata['account_connection_' . $x]);
            $lowest_unit[$x] = $this->db->escape_str($postdata['lowest_unit_' . $x]);
            $godown_id[$x] = $this->db->escape_str($postdata['godown_id_' . $x]);

            $quantity[$x] = $this->db->escape_str($postdata['quantity_' . $x]);
            $unit[$x] = $this->db->escape_str($postdata['unit_' . $x]);
            $lowest_unit[$x] = $this->db->escape_str($postdata['lowest_unit_' . $x]);
            $purchase_rate[$x] = $this->db->escape_str($postdata['purchase_rate_' . $x]);
            $sale_rate[$x] = $this->db->escape_str($postdata['sale_rate_' . $x]);
            $is_percentage[$x] = $this->db->escape_str($postdata['is_percentage_' . $x]);
            $discount[$x] = $this->db->escape_str($postdata['discount_' . $x]);
            $percentage_tax[$x] = $this->db->escape_str($postdata['percentage_tax_' . $x]);
            $tax_amount[$x] = $this->db->escape_str($postdata['tax_amount_' . $x]);
            $amount[$x] = $this->db->escape_str($postdata['amount_' . $x]);
            $sub_total[$x] = $this->db->escape_str($postdata['sub_total_' . $x]);
            $po_details_id[$x] = $this->db->escape_str($postdata['po_details_id_' . $x]);
            $mrp[$x] = $postdata['mrp_' . $x];
            $whole_sale_price[$x] = $postdata['whole_sale_price_' . $x];
            $x++;
        }

        $discount_sum = 0;
        $i = 1;
        // $disc = $this->accountingmodel->get_account_settings('purchase_discounts');
        while ($x != 1)
        {
            $stock_qty_multiplayer = $this->posmodel->get_stock_qty_multiplayer($product_master[$i], $unit[$i], $lowest_unit[$i]);
            $stock_quantity = $quantity[$i] * $stock_qty_multiplayer->unit_count;
            if (empty($batch_no[$i]))
            {
                $batch_id = 0;
                $batch_detail = $this->posmodel->get_batch_exist($product_master[$i], $sale_rate[$i]);
                if (empty($batch_detail))
                {
                    $batch_id = $this->mastermodel->insertmasterdata();

                    $batch_no = $this->mastermodel->get_ref('batch_no', 'pos_item_batch', 'batch_no');
                    $batchTbl = array(
                        'batch_id' => $batch_id,
                        'batch_no' => $batch_no,
                        'item_id' => $product_master[$i],
                        'sale_price' => $sale_rate[$i],
                        'whole_sale' => $whole_sale_price[$i],
                        'mrp' => $mrp[$i],
                        'expiry_date' => $expiry_date[$i],
                    );
                    $this->db->insert('pos_item_batch', $batchTbl);


                    $stock_id = $this->mastermodel->insertmasterdata();
                    $stockTbl = array(
                        'stock_id' => $stock_id,
                        'batch_id' => $batch_id,
                        'quantity' => $stock_quantity,
                        'sale_price' => $sale_rate[$i],
                        'last_purchase' => $purchase_rate[$i],
                        'weighted_avg' => $purchase_rate[$i],
                        'date' => date('Y-m-d'),
                    );
                    $this->db->insert('pos_item_stock', $stockTbl);
                } else
                {
                    $batch_id = $batch_detail->batch_id;
                    $stock_detail = $this->posmodel->get_stock_detail($batch_id);
                    $stock_id = $stock_detail->stock_id;
                    $new_quantity = $stock_detail->quantity + $stock_quantity;

                    $avg1 = $stock_detail->quantity * $stock_detail->last_purchase;
                    $avg2 = $new_quantity * $purchase_rate[$i];
                    $weighted_avg = ($avg1 + $avg2) / ($stock_detail->quantity + $new_quantity);
                    $stockTbl = array(
                        'quantity' => $new_quantity,
                        'sale_price' => $sale_rate[$i],
                        'last_purchase' => $purchase_rate[$i],
                        'weighted_avg' => $weighted_avg,
                        'date' => date('Y-m-d'),
                    );
                    $this->db->where('stock_id', $stock_id);
                    $this->db->where('batch_id', $batch_id);
                    $output = $this->db->update('pos_item_stock', $stockTbl);
                }
            } else
            {
                $batch_id = 0;
                $batch_detail = $this->posmodel->get_batch_exist_byBatchNo($product_master[$i], $batch_no[$i]);
                if (empty($batch_detail))
                {
                    $batch_id = $this->mastermodel->insertmasterdata();

                    $batch_no = $batch_no[$i];
                    $batchTbl = array(
                        'batch_id' => $batch_id,
                        'batch_no' => $batch_no[$i],
                        'item_id' => $product_master[$i],
                        'sale_price' => $sale_rate[$i],
                        'whole_sale' => $whole_sale_price[$i],
                        'mrp' => $mrp[$i],
                        'expiry_date' => $expiry_date[$i],
                    );
                    $this->db->insert('pos_item_batch', $batchTbl);


                    $stock_id = $this->mastermodel->insertmasterdata();
                    $stockTbl = array(
                        'stock_id' => $stock_id,
                        'batch_id' => $batch_id,
                        'quantity' => $stock_quantity,
                        'sale_price' => $sale_rate[$i],
                        'last_purchase' => $purchase_rate[$i],
                        'weighted_avg' => $purchase_rate[$i],
                        'date' => date('Y-m-d'),
                    );
                    $this->db->insert('pos_item_stock', $stockTbl);
                } else
                {
                    $batch_id = $batch_detail->batch_id;
                    $stock_detail = $this->posmodel->get_stock_detail($batch_id);
                    $stock_id = $stock_detail->stock_id;
                    $new_quantity = $stock_detail->quantity + $stock_quantity;

                    $avg1 = $stock_detail->quantity * $stock_detail->last_purchase;
                    $avg2 = $new_quantity * $purchase_rate[$i];
                    $weighted_avg = ($avg1 + $avg2) / ($stock_detail->quantity + $new_quantity);
                    $stockTbl = array(
                        'quantity' => $new_quantity,
                        'sale_price' => $sale_rate[$i],
                        'last_purchase' => $purchase_rate[$i],
                        'weighted_avg' => $weighted_avg,
                        'date' => date('Y-m-d'),
                    );
                    $this->db->where('stock_id', $stock_id);
                    $this->db->where('batch_id', $batch_id);
                    $output = $this->db->update('pos_item_stock', $stockTbl);
                }
            }
            $purchase_details_id = $this->mastermodel->insertmasterdata();
            $detailsTbl = array(
                'purchase_details_id' => $purchase_details_id,
                'purchase_id' => $masterid,
                'product_master' => $product_master[$i],
                'purchase_rate' => $purchase_rate[$i],
                'purchase_description' => 0,
                'sale_rate' => $sale_rate[$i],
                'quantity' => $quantity[$i],
                'discount' => $discount[$i],
                'is_percentage' => $is_percentage[$i],
                'amount' => $amount[$i],
                'stock_id' => $stock_id,
                'batch_id' => $batch_id,
                'batch_no' => $batch_no,
                'po_details_id' => $po_details_id[$i],
                'percentage_tax' => $percentage_tax[$i],
                'tax_amount' => $tax_amount[$i],
                'godown_id' => $godown_id[$i],
                'expiry_date' => $expiry_date[$i],
                'unit' => $unit[$i],
                'sub_total' => $sub_total[$i],
                'mrp' => $mrp[$i],
                'whole_sale_price' => $whole_sale_price[$i],
                'item_acc_conn_id' => $account_connection[$i]
            );
            $this->db->insert('pos_purchase_details', $detailsTbl);

            //stock register insert
            $stock_register_id = $this->mastermodel->insertmasterdata();
            $stockRegtbl = array(
                'stock_register_id' => $stock_register_id,
                'trans_id' => $masterid,
                'trans_details_id' => $purchase_details_id,
                'trans_date' => $this->mastermodel->convert_date_format($postdata['purchase_date']),
                'qty' => $stock_quantity,
                'stock_type' => 1,
                'item_id' => $product_master[$i],
//                'bar_code' => $discount[$i],
                'batch_id' => $batch_id,
                'expiry_date' => $expiry_date[$i],
                'price' => $purchase_rate[$i],
                'trans_category' => 1,
                'godown_id' => $godown_id[$i],
//                'rack_id' => $expiry_date[$i],
//                'bin' => $unit[$i],
//                'status' => $sub_total[$i],
            );
            $this->db->insert('pos_stock_register', $stockRegtbl);

            if (!empty($po_details_id[$i]))
            {
                $output = $this->db->query("UPDATE pos_po_details SET po_completed_qty = po_completed_qty +" . $quantity[$i] . " WHERE po_details_id = " . $po_details_id[$i]);
            }

            $itemTbl = array(
                'last_purchase_price' => $purchase_rate[$i],
                'last_sale_rate' => $sale_rate[$i],
            );
            $this->db->where('product_id', $product_master[$i]);
            $output = $this->db->update('pos_item_master', $itemTbl);


//                 $account_ledgers = $this->mastermodel->get_data_srow('pos_trading_acc_conn',$account_connection[$i],'trading_conn_id');
//                $tblValues = array(
//                'ledger_book_id' => $ledger_id,
//                'account_ledger_id' => $account_ledgers->purchase_acc,
//                'debit' => $sub_total[$i],
//            );
//            $output = $this->db->insert('ledger_book_details', $tblValues);
//             $tblValues = array(
//                'ledger_book_id' => $ledger_id,
//                'account_ledger_id' => $account_ledgers->purchase_tax_acc,
//                'debit' => $tax_amount[$i],
//            );
//            $output = $this->db->insert('ledger_book_details', $tblValues);
            $x--;
            $i++;
        }
//         if ($postdata['purchase_discount'] != "0")
//        {
//            $tblValues = array(
//                'ledger_book_id' => $ledger_id,
//                'account_ledger_id' => $disc,
//                'credit' => $postdata['purchase_discount'],
//            );
//            $output = $this->db->insert('ledger_book_details', $tblValues);
//        }

$output = $this->mastermodel->save_user_activities('Add Purchase',$masterid, 'pos_purchase');
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = 'Error on adding record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = 'Record Added  successfully';
            return $data;
        }
    }

    public function update_purchase($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        if ($postdata['po_management'] != '')
        {
            $po = $postdata['po_management'];
        } else
        {
            $po = NULL;
        }


        $tblValues = array(
            'exchange_rate' => $postdata['exchange_rate'],
            'purchase_voucher_no' => $postdata['purchase_voucher_no'],
            'purchase_date' => $this->mastermodel->convert_date_format($postdata['purchase_date']),
            'vendor_bill_date' => $this->mastermodel->convert_date_format($postdata['vendor_bill_date']),
            'do_date' => $this->mastermodel->convert_date_format($postdata['do_date']),
            'purchase_discount' => $postdata['purchase_discount'],
            'purchase_total' => $postdata['po_amount'],
            'do_no' => $postdata['do_no'],
            'payment_terms' => $postdata['payment_terms'],
            'cheque_no' => $postdata['cheque_no'],
            'cheque_date' => $this->mastermodel->convert_date_format($postdata['cheque_date']),
            'work_order' => $postdata['work_order']
        );
        $this->db->where('purchase_id', $postdata['purchase_id']);
        $output = $this->db->update('pos_purchase', $tblValues);

        $masterid = $postdata['purchase_id'];


        $x = 1;
        while (isset($postdata['product_master_' . $x]))
        {
            if (isset($postdata['po_details_id_' . $x]))
            {
                $po_details_id[$x] = $this->db->escape_str($postdata['po_details_id_' . $x]);
            }
            if (isset($postdata['expiry_date_' . $x]))
            {
                $expiry_date[$x] = $this->mastermodel->convert_date_format($postdata['expiry_date_' . $x]);
            } else
            {
                $expiry_date[$x] = '0000-00-00';
            }

            if (isset($postdata['batch_no_' . $x]))
            {
                $batch_no[$x] = $this->db->escape_str($postdata['batch_no_' . $x]);
            }
            $stock_detl_id[$x] = $this->db->escape_str($postdata['product_master_' . $x]);
            $product_master[$x] = $this->db->escape_str($postdata['item_id_' . $x]);
            $account_connection[$x] = $this->db->escape_str($postdata['account_connection_' . $x]);
            $lowest_unit[$x] = $this->db->escape_str($postdata['lowest_unit_' . $x]);
            $godown_id[$x] = $this->db->escape_str($postdata['godown_id_' . $x]);
            $quantity[$x] = $this->db->escape_str($postdata['quantity_' . $x]);
            $unit[$x] = $this->db->escape_str($postdata['unit_' . $x]);
            $lowest_unit[$x] = $this->db->escape_str($postdata['lowest_unit_' . $x]);
            $purchase_rate[$x] = $this->db->escape_str($postdata['purchase_rate_' . $x]);
            $sale_rate[$x] = $this->db->escape_str($postdata['sale_rate_' . $x]);
            $is_percentage[$x] = $this->db->escape_str($postdata['is_percentage_' . $x]);
            $discount[$x] = $this->db->escape_str($postdata['discount_' . $x]);
            $percentage_tax[$x] = $this->db->escape_str($postdata['percentage_tax_' . $x]);
            $tax_amount[$x] = $this->db->escape_str($postdata['tax_amount_' . $x]);
            $amount[$x] = $this->db->escape_str($postdata['amount_' . $x]);
            $sub_total[$x] = $this->db->escape_str($postdata['sub_total_' . $x]);
            $po_details_id[$x] = $this->db->escape_str($postdata['po_details_id_' . $x]);
            $mrp[$x] = $postdata['mrp_' . $x];
            $whole_sale_price[$x] = $postdata['whole_sale_price_' . $x];

            $x++;
        }

        $discount_sum = 0;
        $i = 1;
        $disc = $this->accountingmodel->get_account_settings('purchase_discounts');
        while ($x != 1)
        {
            $stock_qty_multiplayer = $this->posmodel->get_stock_qty_multiplayer($product_master[$i], $unit[$i], $lowest_unit[$i]);
            if (!empty($postdata['prev_q_qnty_' . $i]))
            {

                $prev_q_qnty = $postdata['prev_q_qnty_' . $i] * $stock_qty_multiplayer->unit_count;
                $this->db->set('quantity', 'quantity -' . $prev_q_qnty, false);
                $this->db->where('stock_id', $stock_detl_id[$i]);
                $this->db->update('pos_item_stock');
                if (!empty($po_details_id[$i]))
                {
                    $output = $this->db->query("UPDATE pos_po_details SET po_completed_qty = po_completed_qty -" . $postdata['prev_q_qnty_' . $i] . " WHERE po_details_id = " . $po_details_id[$i]);
                }
            }


            $stock_quantity = $quantity[$i] * $stock_qty_multiplayer->unit_count;
            if (empty($batch_no[$i]))
            {
                $batch_id = 0;
                $batch_detail = $this->posmodel->get_batch_exist($product_master[$i], $sale_rate[$i]);
                if ($postdata['status_' . $i] == 0)
                {
                    if (empty($batch_detail))
                    {
                        $batch_id = $this->mastermodel->insertmasterdata();
                        $batch_no = $this->mastermodel->get_ref('batch_no', 'pos_item_batch', 'batch_no');
                        $batchTbl = array(
                            'batch_id' => $batch_id,
                            'batch_no' => $batch_no,
                            'item_id' => $product_master[$i],
                            'sale_price' => $sale_rate[$i],
                        );
                        $this->db->insert('pos_item_batch', $batchTbl);


                        $stock_id = $this->mastermodel->insertmasterdata();
                        $stockTbl = array(
                            'stock_id' => $stock_id,
                            'batch_id' => $batch_id,
                            'quantity' => $stock_quantity,
                            'sale_price' => $sale_rate[$i],
                            'last_purchase' => $purchase_rate[$i],
                            'weighted_avg' => 0,
                            'date' => date('Y-m-d'),
                        );
                        $this->db->insert('pos_item_stock', $stockTbl);
                    } else
                    {
                        $batch_id = $batch_detail->batch_id;
                        $stock_detail = $this->posmodel->get_stock_detail($batch_id);
                        $stock_id = $stock_detail->stock_id;
                        $new_quantity = $stock_detail->quantity + $stock_quantity;
                        $stockTbl = array(
                            'quantity' => $new_quantity,
                            'sale_price' => $sale_rate[$i],
                            'last_purchase' => $purchase_rate[$i],
                            'weighted_avg' => 0,
                            'date' => date('Y-m-d'),
                        );
                        $this->db->where('stock_id', $stock_id);
                        $this->db->where('batch_id', $batch_id);
                        $output = $this->db->update('pos_item_stock', $stockTbl);
                    }
                    $detailsTbl = array(
                        'product_master' => $product_master[$i],
                        'purchase_rate' => $purchase_rate[$i],
                        'purchase_description' => 0,
                        'sale_rate' => $sale_rate[$i],
                        'quantity' => $quantity[$i],
                        'discount' => $discount[$i],
                        'is_percentage' => $is_percentage[$i],
                        'amount' => $amount[$i],
                        'stock_id' => $stock_id,
                        'batch_id' => $batch_id,
//                        'batch_no' => $batch_no,
                        'po_details_id' => $po_details_id[$i],
                        'percentage_tax' => $percentage_tax[$i],
                        'tax_amount' => $tax_amount[$i],
                        'godown_id' => $godown_id[$i],
                        'expiry_date' => $expiry_date[$i],
                        'unit' => $unit[$i],
                        'mrp' => $mrp[$i],
                        'whole_sale_price' => $whole_sale_price[$i],
                        'item_acc_conn_id' => $account_connection[$i]
                    );
                    $this->db->where('purchase_details_id', $postdata['purchase_details_id_' . $i]);
                    $this->db->update('pos_purchase_details', $detailsTbl);

                    $stockRegtbl = array(
                        'trans_date' => $this->mastermodel->convert_date_format($postdata['purchase_date']),
                        'qty' => $quantity[$i],
                        'stock_type' => 1,
                        'item_id' => $product_master[$i],
//                'bar_code' => $discount[$i],
                        'batch_id' => $batch_id,
                        'expiry_date' => $expiry_date[$i],
                        'price' => $purchase_rate[$i],
                        'trans_category' => 1,
                        'godown_id' => $godown_id[$i],
//                'rack_id' => $expiry_date[$i],
//                'bin' => $unit[$i],
//                'status' => $sub_total[$i],
                    );
                    $this->db->where('trans_details_id', $postdata['purchase_details_id_' . $i]);
                    $this->db->update('pos_stock_register', $stockRegtbl);

                    if (!empty($po_details_id[$i]))
                    {
                        $output = $this->db->query("UPDATE pos_po_details SET po_completed_qty = po_completed_qty +" . $quantity[$i] . " WHERE po_details_id = " . $po_details_id[$i]);
                    }
                } elseif ($postdata['status_' . $i] == 1)
                {
                    if (empty($batch_detail))
                    {
                        $batch_id = $this->mastermodel->insertmasterdata();
                        $batch_no = $this->mastermodel->get_ref('batch_no', 'pos_item_batch', 'batch_no');
                        $batchTbl = array(
                            'batch_id' => $batch_id,
                            'batch_no' => $batch_no,
                            'item_id' => $product_master[$i],
                            'sale_price' => $sale_rate[$i],
                        );
                        $this->db->insert('pos_item_batch', $batchTbl);


                        $stock_id = $this->mastermodel->insertmasterdata();
                        $stockTbl = array(
                            'stock_id' => $stock_id,
                            'batch_id' => $batch_id,
                            'quantity' => $stock_quantity,
                            'sale_price' => $sale_rate[$i],
                            'last_purchase' => $purchase_rate[$i],
                            'weighted_avg' => 0,
                            'date' => date('Y-m-d'),
                        );
                        $this->db->insert('pos_item_stock', $stockTbl);
                    } else
                    {
                        $batch_id = $batch_detail->batch_id;
                        $stock_detail = $this->posmodel->get_stock_detail($batch_id);
                        $stock_id = $stock_detail->stock_id;
                        $new_quantity = $stock_detail->quantity + $stock_quantity;
                        $stockTbl = array(
                            'quantity' => $new_quantity,
                            'sale_price' => $sale_rate[$i],
                            'last_purchase' => $purchase_rate[$i],
                            'weighted_avg' => 0,
                            'date' => date('Y-m-d'),
                        );
                        $this->db->where('stock_id', $stock_id);
                        $this->db->where('batch_id', $batch_id);
                        $output = $this->db->update('pos_item_stock', $stockTbl);
                    }

                    $purchase_details_id = $this->mastermodel->insertmasterdata();
                    $detailsTbl = array(
                        'purchase_details_id' => $purchase_details_id,
                        'purchase_id' => $masterid,
                        'product_master' => $product_master[$i],
                        'purchase_rate' => $purchase_rate[$i],
                        'purchase_description' => 0,
                        'sale_rate' => $sale_rate[$i],
                        'quantity' => $quantity[$i],
                        'discount' => $discount[$i],
                        'is_percentage' => $is_percentage[$i],
                        'amount' => $amount[$i],
                        'stock_id' => $stock_id,
                        'batch_id' => $batch_id,
//                        'batch_no' => $batch_no,
                        'po_details_id' => $po_details_id[$i],
                        'percentage_tax' => $percentage_tax[$i],
                        'tax_amount' => $tax_amount[$i],
                        'godown_id' => $godown_id[$i],
                        'expiry_date' => $expiry_date[$i],
                        'unit' => $unit[$i],
                        'mrp' => $mrp[$i],
                        'whole_sale_price' => $whole_sale_price[$i],
                        'item_acc_conn_id' => $account_connection[$i]
                    );
                    $this->db->insert('pos_purchase_details', $detailsTbl);
                    if (!empty($po_details_id[$i]))
                    {
                        $output = $this->db->query("UPDATE pos_po_details SET po_completed_qty = po_completed_qty +" . $quantity[$i] . " WHERE po_details_id = " . $po_details_id[$i]);
                    }
                    $stock_register_id = $this->mastermodel->insertmasterdata();
                    $stockRegtbl = array(
                        'stock_register_id' => $stock_register_id,
                        'trans_id' => $masterid,
                        'trans_details_id' => $postdata['purchase_details_id_' . $i],
                        'trans_date' => $this->mastermodel->convert_date_format($postdata['purchase_date']),
                        'qty' => $stock_quantity,
                        'stock_type' => 1,
                        'item_id' => $product_master[$i],
//                'bar_code' => $discount[$i],
                        'batch_id' => $batch_id,
                        'expiry_date' => $expiry_date[$i],
                        'price' => $purchase_rate[$i],
                        'trans_category' => 1,
                        'godown_id' => $godown_id[$i],
//                'rack_id' => $expiry_date[$i],
//                'bin' => $unit[$i],
//                'status' => $sub_total[$i],
                    );
                    $this->db->insert('pos_stock_register', $stockRegtbl);
                } else
                {

                    $this->db->where('purchase_details_id', $postdata['purchase_details_id_' . $i]);
                    $this->db->delete('pos_purchase_details');

                    $this->db->where('trans_details_id', $postdata['purchase_details_id_' . $i]);
                    $this->db->update('pos_stock_register');
                }
            } else
            {
                $batch_id = 0;
                $batch_detail = $this->posmodel->get_batch_exist_byBatchNo($product_master[$i], $batch_no[$i]);
                if ($postdata['status_' . $i] == 0)
                {
                    $batch_id = $batch_detail->batch_id;
                    $stock_detail = $this->posmodel->get_stock_detail($batch_id);
                    $stock_id = $stock_detail->stock_id;
                    $new_quantity = $stock_detail->quantity + $stock_quantity;
                    $stockTbl = array(
                        'quantity' => $new_quantity,
                        'sale_price' => $sale_rate[$i],
                        'last_purchase' => $purchase_rate[$i],
                        'weighted_avg' => 0,
                        'date' => date('Y-m-d'),
                    );
                    $this->db->where('stock_id', $stock_id);
                    $this->db->where('batch_id', $batch_id);
                    $output = $this->db->update('pos_item_stock', $stockTbl);

                    $detailsTbl = array(
                        'product_master' => $product_master[$i],
                        'purchase_rate' => $purchase_rate[$i],
                        'purchase_description' => 0,
                        'sale_rate' => $sale_rate[$i],
                        'quantity' => $quantity[$i],
                        'discount' => $discount[$i],
                        'is_percentage' => $is_percentage[$i],
                        'amount' => $amount[$i],
                        'stock_id' => $stock_id,
                        'batch_id' => $batch_id,
                        'po_details_id' => $po_details_id[$i],
                        'percentage_tax' => $percentage_tax[$i],
                        'tax_amount' => $tax_amount[$i],
                        'godown_id' => $godown_id[$i],
                        'expiry_date' => $expiry_date[$i],
                        'unit' => $unit[$i],
                        'mrp' => $mrp[$i],
                        'whole_sale_price' => $whole_sale_price[$i],
                        'item_acc_conn_id' => $account_connection[$i]
                    );
                    $this->db->where('purchase_details_id', $postdata['purchase_details_id_' . $i]);
                    $this->db->update('pos_purchase_details', $detailsTbl);

                    $stockRegtbl = array(
                        'trans_date' => $this->mastermodel->convert_date_format($postdata['purchase_date']),
                        'qty' => $quantity[$i],
                        'stock_type' => 1,
                        'item_id' => $product_master[$i],
//                'bar_code' => $discount[$i],
                        'batch_id' => $batch_id,
                        'expiry_date' => $expiry_date[$i],
                        'price' => $purchase_rate[$i],
                        'trans_category' => 1,
                        'godown_id' => $godown_id[$i],
//                'rack_id' => $expiry_date[$i],
//                'bin' => $unit[$i],
//                'status' => $sub_total[$i],
                    );
                    $this->db->where('trans_details_id', $postdata['purchase_details_id_' . $i]);
                    $this->db->update('pos_stock_register', $stockRegtbl);
                    if (!empty($po_details_id[$i]))
                    {
                        $output = $this->db->query("UPDATE pos_po_details SET po_completed_qty = po_completed_qty +" . $quantity[$i] . " WHERE po_details_id = " . $po_details_id[$i]);
                    }
                } elseif ($postdata['status_' . $i] == 1)
                {
                    if (empty($batch_detail))
                    {
                        $batch_no = $batch_no[$i];
                        $batch_id = $this->mastermodel->insertmasterdata();
                        $batchTbl = array(
                            'batch_id' => $batch_id,
                            'batch_no' => $batch_no,
                            'item_id' => $product_master[$i],
                            'sale_price' => $sale_rate[$i],
                        );
                        $this->db->insert('pos_item_batch', $batchTbl);


                        $stock_id = $this->mastermodel->insertmasterdata();
                        $stockTbl = array(
                            'stock_id' => $stock_id,
                            'batch_id' => $batch_id,
                            'quantity' => $stock_quantity,
                            'sale_price' => $sale_rate[$i],
                            'last_purchase' => $purchase_rate[$i],
                            'weighted_avg' => 0,
                            'date' => date('Y-m-d'),
                        );
                        $this->db->insert('pos_item_stock', $stockTbl);
                    } else
                    {
                        $batch_id = $batch_detail->batch_id;
                        $stock_detail = $this->posmodel->get_stock_detail($batch_id);
                        $stock_id = $stock_detail->stock_id;
                        $new_quantity = $stock_detail->quantity + $stock_quantity;
                        $stockTbl = array(
                            'quantity' => $new_quantity,
                            'sale_price' => $sale_rate[$i],
                            'last_purchase' => $purchase_rate[$i],
                            'weighted_avg' => 0,
                            'date' => date('Y-m-d'),
                        );
                        $this->db->where('stock_id', $stock_id);
                        $this->db->where('batch_id', $batch_id);
                        $output = $this->db->update('pos_item_stock', $stockTbl);
                    }

                    $purchase_details_id = $this->mastermodel->insertmasterdata();
                    $detailsTbl = array(
                        'purchase_details_id' => $purchase_details_id,
                        'purchase_id' => $masterid,
                        'product_master' => $product_master[$i],
                        'purchase_rate' => $purchase_rate[$i],
                        'purchase_description' => 0,
                        'sale_rate' => $sale_rate[$i],
                        'quantity' => $quantity[$i],
                        'discount' => $discount[$i],
                        'is_percentage' => $is_percentage[$i],
                        'amount' => $amount[$i],
                        'stock_id' => $stock_id,
                        'batch_id' => $batch_id,
                        'po_details_id' => $po_details_id[$i],
                        'percentage_tax' => $percentage_tax[$i],
                        'tax_amount' => $tax_amount[$i],
                        'godown_id' => $godown_id[$i],
                        'expiry_date' => $expiry_date[$i],
                        'unit' => $unit[$i],
                        'mrp' => $mrp[$i],
                        'whole_sale_price' => $whole_sale_price[$i],
                        'item_acc_conn_id' => $account_connection[$i]
                    );
                    $this->db->insert('pos_purchase_details', $detailsTbl);
                    $stock_register_id = $this->mastermodel->insertmasterdata();
                    $stockRegtbl = array(
                        'stock_register_id' => $stock_register_id,
                        'trans_id' => $masterid,
                        'trans_details_id' => $postdata['purchase_details_id_' . $i],
                        'trans_date' => $this->mastermodel->convert_date_format($postdata['purchase_date']),
                        'qty' => $stock_quantity,
                        'stock_type' => 1,
                        'item_id' => $product_master[$i],
//                'bar_code' => $discount[$i],
                        'batch_id' => $batch_id,
                        'expiry_date' => $expiry_date[$i],
                        'price' => $purchase_rate[$i],
                        'trans_category' => 1,
                        'godown_id' => $godown_id[$i],
//                'rack_id' => $expiry_date[$i],
//                'bin' => $unit[$i],
//                'status' => $sub_total[$i],
                    );
                    $this->db->insert('pos_stock_register', $stockRegtbl);
                    if (!empty($po_details_id[$i]))
                    {
                        $output = $this->db->query("UPDATE pos_po_details SET po_completed_qty = po_completed_qty +" . $quantity[$i] . " WHERE po_details_id = " . $po_details_id[$i]);
                    }
                } else
                {

                    $this->db->where('purchase_details_id', $postdata['purchase_details_id_' . $i]);
                    $this->db->delete('pos_purchase_details');
                }
            }
            $itemTbl = array(
                'last_purchase_price' => $purchase_rate[$i],
                'last_sale_rate' => $sale_rate[$i],
            );
            $this->db->where('product_id', $product_master[$i]);
            $output = $this->db->update('pos_item_master', $itemTbl);



            $x--;
            $i++;
        }


$output = $this->mastermodel->save_user_activities('Edit Purchase',$masterid, 'pos_purchase');
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = 'Error on adding record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = 'Record Added  successfully';
            return $data;
        }
    }

    public function update_purchase1($postdata)
    {

        $data = array();
        $this->db->trans_begin();
        if ($postdata['po_management'] != '')
        {
            $po = $postdata['po_management'];
        } else
        {
            $po = NULL;
        }

        $tblValues = array(
            'voucher_no' => $postdata['purchase_voucher_no'],
            'voucher_date' => $this->mastermodel->convert_date_format($postdata['vendor_bill_date']),
        );
        $this->db->where('ledger_book_id', $postdata['ledger_book_id']);
        $output = $this->db->update('ledger_book', $tblValues);

        $tblValues = array(
            'exchange_rate' => $postdata['exchange_rate'],
            'purchase_voucher_no' => $postdata['purchase_voucher_no'],
            'purchase_date' => $this->mastermodel->convert_date_format($postdata['purchase_date']),
            'vendor_bill_date' => $this->mastermodel->convert_date_format($postdata['vendor_bill_date']),
            'do_date' => $this->mastermodel->convert_date_format($postdata['do_date']),
            'purchase_discount' => $postdata['purchase_discount'],
            'purchase_total' => $postdata['po_amount'],
            'do_no' => $postdata['do_no'],
            'payment_terms' => $postdata['payment_terms'],
            'cheque_no' => $postdata['cheque_no'],
            'cheque_date' => $this->mastermodel->convert_date_format($postdata['cheque_date']),
            'work_order' => $postdata['work_order']
        );
        $this->db->where('purchase_id', $postdata['purchase_id']);
        $output = $this->db->update('pos_purchase', $tblValues);

        $masterid = $postdata['purchase_id'];
        $ledger_id = $postdata['ledger_book_id'];
        $pid = $this->db->query("select ledger_book_details_id from ledger_book_details where ledger_book_id='$ledger_id'order by ledger_book_details_id desc");
        $result = $pid->result();
        if (!empty($result))
        {
            foreach ($result as $value)
            {
                $pdetid = $value->ledger_book_details_id;
                $this->db->where('ledger_book_reference.ledger_book_details', $pdetid);
                $output = $this->db->delete('ledger_book_reference');
            }
        }
        $this->db->where('ledger_book_id', $postdata['ledger_book_id']);
        $this->db->delete('ledger_book_details');

        if ($postdata['payment_mode'] == 'Credit')
        {
            $ret = $this->accountingmodel->get_accountmaster_id('vendor', 'vendor_id', 'vendor_ledger', $postdata['purchase_vendor']);
            $ret_name = $this->mastermodel->get_single_field_value('vendor', 'vendor_name', 'vendor_id', $postdata['purchase_vendor']);

            $x = 1;
            $sum = $postdata['po_amount'];

            $tblValues_led = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $ret,
                'credit' => $sum,
            );
            $output = $this->db->insert('ledger_book_details', $tblValues_led);
            $cdet_id = $this->db->insert_id();
        } else
        {
            $cash_account = $this->accountingmodel->get_account_settings('cash_account');
            $x = 1;
            $sum = $postdata['po_amount'];

            $tblValues_led = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $cash_account,
                'credit' => $sum,
            );
            $output = $this->db->insert('ledger_book_details', $tblValues_led);
            $cdet_id = $this->db->insert_id();
        }
        while (isset($postdata['product_master_' . $x]))
        {
            if (isset($postdata['po_details_id_' . $x]))
            {
                $po_details_id[$x] = $this->db->escape_str($postdata['po_details_id_' . $x]);
            }
            if (isset($postdata['expiry_date_' . $x]))
            {
                $expiry_date[$x] = $this->mastermodel->convert_date_format($postdata['expiry_date_' . $x]);
            }
            $product_master[$x] = $this->db->escape_str($postdata['product_master_' . $x]);
            $account_connection[$x] = $this->db->escape_str($postdata['account_connection_' . $x]);
            $lowest_unit[$x] = $this->db->escape_str($postdata['lowest_unit_' . $x]);
            $godown_id[$x] = $this->db->escape_str($postdata['godown_id_' . $x]);
            $batch_id[$x] = $this->db->escape_str($postdata['batch_id_' . $x]);
            $quantity[$x] = $this->db->escape_str($postdata['quantity_' . $x]);
            $unit[$x] = $this->db->escape_str($postdata['unit_' . $x]);
            $lowest_unit[$x] = $this->db->escape_str($postdata['lowest_unit_' . $x]);
            $purchase_rate[$x] = $this->db->escape_str($postdata['purchase_rate_' . $x]);
            $sale_rate[$x] = $this->db->escape_str($postdata['sale_rate_' . $x]);
            $is_percentage[$x] = $this->db->escape_str($postdata['is_percentage_' . $x]);
            $discount[$x] = $this->db->escape_str($postdata['discount_' . $x]);
            $percentage_tax[$x] = $this->db->escape_str($postdata['percentage_tax_' . $x]);
            $tax_amount[$x] = $this->db->escape_str($postdata['tax_amount_' . $x]);
            $amount[$x] = $this->db->escape_str($postdata['amount_' . $x]);
            $sub_total[$x] = $this->db->escape_str($postdata['sub_total_' . $x]);
            $po_details_id[$x] = $this->db->escape_str($postdata['po_details_id_' . $x]);
            $mrp[$x] = $postdata['mrp_' . $x];
            $whole_sale_price[$x] = $postdata['whole_sale_price_' . $x];

            $x++;
        }

        $discount_sum = 0;
        $i = 1;
        $disc = $this->accountingmodel->get_account_settings('purchase_discounts');
        while ($x != 1)
        {
            $stock_qty_multiplayer = $this->posmodel->get_stock_qty_multiplayer($product_master[$i], $unit[$i], $lowest_unit[$i]);
            if (!empty($postdata['prev_q_qnty_' . $i]))
            {

                $prev_q_qnty = $postdata['prev_q_qnty_' . $i] * $stock_qty_multiplayer->unit_count;
                $this->db->set('quantity', 'quantity -' . $prev_q_qnty, false);
                $this->db->where('stock_id', $postdata['stock_id_' . $i]);
                $this->db->update('pos_item_stock');
                $output = $this->db->query("UPDATE pos_po_details SET po_completed_qty = po_completed_qty -" . $postdata['prev_q_qnty_' . $i] . " WHERE po_details_id = " . $po_details_id[$i]);
            }


            $stock_quantity = $quantity[$i] * $stock_qty_multiplayer->unit_count;
            $batch_id = 0;
            $batch_detail = $this->posmodel->get_batch_exist($product_master[$i], $sale_rate[$i]);
            if ($postdata['status_' . $i] == 0)
            {
                if (empty($batch_detail))
                {
                    $batch_id = $this->mastermodel->insertmasterdata();
                    $batch_no = $this->mastermodel->get_ref('batch_no', 'pos_item_batch', 'batch_no');
                    $batchTbl = array(
                        'batch_id' => $batch_id,
                        'batch_no' => $batch_no,
                        'item_id' => $product_master[$i],
                        'sale_price' => $sale_rate[$i],
                    );
                    $this->db->insert('pos_item_batch', $batchTbl);


                    $stock_id = $this->mastermodel->insertmasterdata();
                    $stockTbl = array(
                        'stock_id' => $stock_id,
                        'batch_id' => $batch_id,
                        'quantity' => $stock_quantity,
                        'sale_price' => $sale_rate[$i],
                        'last_purchase' => $purchase_rate[$i],
                        'weighted_avg' => 0,
                        'date' => date('Y-m-d'),
                    );
                    $this->db->insert('pos_item_stock', $stockTbl);
                } else
                {
                    $batch_id = $batch_detail->batch_id;
                    $stock_detail = $this->posmodel->get_stock_detail($batch_id);
                    $stock_id = $stock_detail->stock_id;
                    $new_quantity = $stock_detail->quantity + $stock_quantity;
                    $stockTbl = array(
                        'quantity' => $new_quantity,
                        'sale_price' => $sale_rate[$i],
                        'last_purchase' => $purchase_rate[$i],
                        'weighted_avg' => 0,
                        'date' => date('Y-m-d'),
                    );
                    $this->db->where('stock_id', $stock_id);
                    $this->db->where('batch_id', $batch_id);
                    $output = $this->db->update('pos_item_stock', $stockTbl);
                }
                $detailsTbl = array(
                    'product_master' => $product_master[$i],
                    'purchase_rate' => $purchase_rate[$i],
                    'purchase_description' => 0,
                    'sale_rate' => $sale_rate[$i],
                    'quantity' => $quantity[$i],
                    'discount' => $discount[$i],
                    'is_percentage' => $is_percentage[$i],
                    'amount' => $amount[$i],
                    'stock_id' => $stock_id,
                    'batch_id' => $batch_id,
                    'po_details_id' => $po_details_id[$i],
                    'percentage_tax' => $percentage_tax[$i],
                    'tax_amount' => $tax_amount[$i],
                    'godown_id' => $godown_id[$i],
                    'expiry_date' => $expiry_date[$i],
                    'unit' => $unit[$i],
                    'mrp' => $mrp[$i],
                    'whole_sale_price' => $whole_sale_price[$i],
                );
                $this->db->where('purchase_details_id', $postdata['purchase_details_id_' . $i]);
                $this->db->update('pos_purchase_details', $detailsTbl);
                if (!empty($po_details_id[$i]))
                {
                    $output = $this->db->query("UPDATE pos_po_details SET po_completed_qty = po_completed_qty +" . $quantity[$i] . " WHERE po_details_id = " . $po_details_id[$i]);
                }
            } elseif ($postdata['status_' . $i] == 1)
            {
                if (empty($batch_detail))
                {
                    $batch_id = $this->mastermodel->insertmasterdata();
                    $batch_no = $this->mastermodel->get_ref('batch_no', 'pos_item_batch', 'batch_no');
                    $batchTbl = array(
                        'batch_id' => $batch_id,
                        'batch_no' => $batch_no,
                        'item_id' => $product_master[$i],
                        'sale_price' => $sale_rate[$i],
                    );
                    $this->db->insert('pos_item_batch', $batchTbl);


                    $stock_id = $this->mastermodel->insertmasterdata();
                    $stockTbl = array(
                        'stock_id' => $stock_id,
                        'batch_id' => $batch_id,
                        'quantity' => $stock_quantity,
                        'sale_price' => $sale_rate[$i],
                        'last_purchase' => $purchase_rate[$i],
                        'weighted_avg' => 0,
                        'date' => date('Y-m-d'),
                    );
                    $this->db->insert('pos_item_stock', $stockTbl);
                } else
                {
                    $batch_id = $batch_detail->batch_id;
                    $stock_detail = $this->posmodel->get_stock_detail($batch_id);
                    $stock_id = $stock_detail->stock_id;
                    $new_quantity = $stock_detail->quantity + $stock_quantity;
                    $stockTbl = array(
                        'quantity' => $new_quantity,
                        'sale_price' => $sale_rate[$i],
                        'last_purchase' => $purchase_rate[$i],
                        'weighted_avg' => 0,
                        'date' => date('Y-m-d'),
                    );
                    $this->db->where('stock_id', $stock_id);
                    $this->db->where('batch_id', $batch_id);
                    $output = $this->db->update('pos_item_stock', $stockTbl);
                }

                $purchase_details_id = $this->mastermodel->insertmasterdata();
                $detailsTbl = array(
                    'purchase_details_id' => $purchase_details_id,
                    'purchase_id' => $masterid,
                    'product_master' => $product_master[$i],
                    'purchase_rate' => $purchase_rate[$i],
                    'purchase_description' => 0,
                    'sale_rate' => $sale_rate[$i],
                    'quantity' => $quantity[$i],
                    'discount' => $discount[$i],
                    'is_percentage' => $is_percentage[$i],
                    'amount' => $amount[$i],
                    'stock_id' => $stock_id,
                    'batch_id' => $batch_id,
                    'po_details_id' => $po_details_id[$i],
                    'percentage_tax' => $percentage_tax[$i],
                    'tax_amount' => $tax_amount[$i],
                    'godown_id' => $godown_id[$i],
                    'expiry_date' => $expiry_date[$i],
                    'unit' => $unit[$i],
                    'mrp' => $mrp[$i],
                    'whole_sale_price' => $whole_sale_price[$i],
                );
                $this->db->insert('pos_purchase_details', $detailsTbl);
                if (!empty($po_details_id[$i]))
                {
                    $output = $this->db->query("UPDATE pos_po_details SET po_completed_qty = po_completed_qty +" . $quantity[$i] . " WHERE po_details_id = " . $po_details_id[$i]);
                }
            } else
            {

                $this->db->where('purchase_details_id', $postdata['purchase_details_id_' . $i]);
                $this->db->delete('pos_purchase_details');
            }

            $itemTbl = array(
                'last_purchase_price' => $purchase_rate[$i],
                'last_sale_rate' => $sale_rate[$i],
            );
            $this->db->where('product_id', $product_master[$i]);
            $output = $this->db->update('pos_item_master', $itemTbl);


            $account_ledgers = $this->mastermodel->get_data_srow('pos_trading_acc_conn', $account_connection[$i], 'trading_conn_id');
            $tblValues = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $account_ledgers->purchase_acc,
                'debit' => $sub_total[$i],
            );
            $output = $this->db->insert('ledger_book_details', $tblValues);

            $tblValues = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $account_ledgers->purchase_tax_acc,
                'debit' => $tax_amount[$i],
            );
            $output = $this->db->insert('ledger_book_details', $tblValues);
            $x--;
            $i++;
        }
        if ($postdata['purchase_discount'] != "0")
        {
            $tblValues = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $disc,
                'credit' => $postdata['purchase_discount'],
            );
            $output = $this->db->insert('ledger_book_details', $tblValues);
        }


        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = 'Error on adding record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = 'Record Added  successfully';
            return $data;
        }
    }

    public function search_purchase_invoice()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('pos_purchase_invoice');
        $this->db->join('master', 'master.master_id=vendor_invoice_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('vendor_invoice_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    function get_po_no_by_vendor($id)
    {
        $this->db->select('*');
        $this->db->from('pos_po');
        $this->db->join('vendor', 'pos_po.vendor=vendor.vendor_id');
        $this->db->where('pos_po.vendor', $id);
        $this->db->where('po_manager_approval', 1);
        $this->db->where('po_gm_approval', 1);
        // $this->db->where('purchase.invoice', 0);
        $data = $this->db->get()->result();
        return $data;
    }

    public function get_ledger_balance($id)
    {
        $data = $this->db->select('*')
                        ->from('ledger_book_details')
                        ->where('ledger_book_details.account_ledger_id', $id)
                        ->get()->result();
        return $data;
    }

    function get_purchase_no_by_po_for_add($id)
    {
        $this->db->select('*');
        $this->db->from('pos_purchase');
        $this->db->join('vendor', 'pos_purchase.purchase_vendor=vendor.vendor_id');
        $this->db->where('pos_purchase.po_management', $id);
        $this->db->where('pos_purchase.invoice', '0');
        $this->db->where('pos_purchase.do_no !=', '');
        $data = $this->db->get()->result();

        return $data;
    }

    function get_purchase_no_by_vendor_for_add($id)
    {
        $this->db->select('*');
        $this->db->from('pos_purchase');
        $this->db->join('vendor', 'pos_purchase.purchase_vendor=vendor.vendor_id');
        $this->db->where('pos_purchase.purchase_vendor', $id);
        $this->db->where('pos_purchase.invoice', '0');
        $this->db->where('pos_purchase.do_no !=', '');
        $this->db->where('pos_purchase.po_management', NULL);
        $data = $this->db->get()->result();

        return $data;
    }

    function search_purchase_return()
    {
        $this->db->select('*, ac1.ledger_name as debit_account');
        $this->db->from('pos_purchase_return');
        $this->db->join('account_ledger ac1', 'pos_purchase_return.debit_account=ac1.ledger_id');
//        $this->db->join('account_ledger ac2', 'pos_purchase_return.credit_account=ac2.ledger_id');
        $this->db->join('vendor', 'pos_purchase_return.vendor=vendor.vendor_id');
        $this->db->join('pos_purchase', 'pos_purchase_return.purchase_id=pos_purchase.purchase_id');
        $this->db->order_by('pos_purchase_return.purchase_return_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    function get_purchase_id()
    {
        $this->db->select('purchase_id,purchase_no');
        $this->db->from('pos_purchase');
        $this->db->order_by('pos_purchase.purchase_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }

    function get_purchase_by_id($id)
    {
        $this->db->select('*');
        $this->db->from('pos_purchase');
        $this->db->where('pos_purchase.purchase_id', $id);
        $data = $this->db->get()->row();
        return $data;
    }

    function get_purchase_detail_by_id($id)
    {
        $this->db->select('*');
        $this->db->from('pos_purchase_details');
        $this->db->join('item_master', 'item_master.item_master_id=pos_purchase_details.product_master');
        $this->db->where('pos_purchase_details.purchase_id', $id);
        $data = $this->db->get()->result();
        return $data;
    }

    function get_purchase_details_by_id($id)
    {
        $this->db->select('*');
        $this->db->from('pos_purchase_details');
        $this->db->join('item_master', 'item_master.item_master_id=pos_purchase_details.product_master');
        $this->db->where('pos_purchase_details.purchase_details_id', $id);
        $data = $this->db->get()->row();
        return $data;
    }

    public function insert_purchase_return($postdata)
    {
        $this->db->trans_begin();

        $return_code = $this->mastermodel->get_ref('return_voucher_no', 'pos_purchase_return', 'return_voucher_no');
        $ledger_id = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'ledger_book_id' => $ledger_id,
            'voucher_no' => $return_code,
            'voucher_date' => $this->mastermodel->convert_date_format($postdata['return_date']),
        );
        $output = $this->db->insert('ledger_book', $tblValues);
        $ret = $this->accountingmodel->get_accountmaster_id('vendor', 'vendor_id', 'vendor_ledger', $postdata['vendor']);
//        $set = $this->accountingmodel->get_account_settings('purchase');
        $vendor_invoice = $this->mastermodel->get_single_field_value('pos_purchase_invoice_details', 'vendor_invoice', 'purchase', $postdata['purchase_id']);
        $payment_mode = $this->mastermodel->get_single_field_value('pos_purchase_invoice', 'payment_mode', 'vendor_invoice_id', $vendor_invoice);
        
        if ($payment_mode == 'Cash')
        {
            $cash_account = $this->accountingmodel->get_account_settings('cash_account');
            $debit_account = $cash_account;
            $x = 1;


            $tblValues_led = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $cash_account,
                'debit' => $postdata['return_amount'],
            );
            $output = $this->db->insert('ledger_book_details', $tblValues_led);
            $cdet_id = $this->db->insert_id();
        } else
        {
            $ret = $this->accountingmodel->get_accountmaster_id('vendor', 'vendor_id', 'vendor_ledger', $postdata['vendor']);
            $ret_name = $this->mastermodel->get_single_field_value('vendor', 'vendor_name', 'vendor_id', $postdata['vendor']);
            $debit_account = $ret;
            $x = 1;


            $tblValues_led = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $ret,
                'debit' => $postdata['return_amount'],
            );
            $output = $this->db->insert('ledger_book_details', $tblValues_led);
            $cdet_id = $this->db->insert_id();
        }
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'purchase_return_id' => $masterid,
            'purchase_id' => $postdata['purchase_id'],
            'receipt_return_category_id' =>  $postdata['receipt_return_category_id'],
            'return_date' => $this->mastermodel->convert_date_format($postdata['return_date']),
            'vendor' => $postdata['vendor'],
            'return_voucher_no' => $return_code,
            'debit_account' => $debit_account,
//            'credit_account' => $set,
            'return_amount' => $postdata['return_amount'],
            'return_discount' => $postdata['return_discount'],
            'return_ledger' => $ledger_id,
            'return_note' => $postdata['return_note'],
        );
        $output = $this->db->insert('pos_purchase_return', $tblValues);




//        $tblValues = array(
//            'ledger_book_id' => $ledger_id,
//            'account_ledger_id' => $ret,
//            'debit' => $postdata['return_amount'],
//        );
//        $output = $this->db->insert('ledger_book_details', $tblValues);
        $disc = $this->accountingmodel->get_account_settings('purchase_discounts');
        $tblValues = array(
            'ledger_book_id' => $ledger_id,
            'account_ledger_id' => $disc,
            'credit' => $postdata['return_discount'],
        );
        $output = $this->db->insert('ledger_book_details', $tblValues);
//        $tblValues = array(
//            'ledger_book_id' => $ledger_id,
//            'account_ledger_id' => $set,
//            'credit' => ($postdata['return_amount'] - $postdata['return_discount']),
//        );
//        $output = $this->db->insert('ledger_book_details', $tblValues);


        $x = 1;
        while (isset($postdata['item_id_' . $x]))
        {
            $product_master[$x] = $this->db->escape_str($postdata['item_id_' . $x]);
            $product_stock[$x] = $this->db->escape_str($postdata['product_stock_id_' . $x]);
            $purchase_rate[$x] = $this->db->escape_str($postdata['item_price_' . $x]);
            $purchase_description[$x] = $this->db->escape_str($postdata['purchase_description_' . $x]);

            $qnt[$x] = $this->db->escape_str($postdata['quantity_' . $x]);
//            $hd = $this->mastermodel->get_single_field_value('item_master', 'item_sales_unit', 'item_master_id', $product_master[$x]);
//            $qnt_stock[$x] = $hd * $qnt[$x];
            $unit[$x] = $this->db->escape_str($postdata['unit_id_' . $x]);
            $godown[$x] = $this->db->escape_str($postdata['godown_id_' . $x]);
            $amount[$x] = $this->db->escape_str($postdata['amount_' . $x]);
            $pid[$x] = $postdata['purchase_details_id_' . $x];
            $x++;
        }
        $i = 1;
        while ($x != 1)
        {
            $query = $this->db->query("insert into pos_purchase_return_details(`purchase_details_id`,`product_master`,`product_stock_id`,`purchase_rate`,`quantity`,`amount`,`purchase_return_id`,`godown_id`,`unit_id`) values ('$pid[$i]','$product_master[$i]','$product_stock[$i]','$purchase_rate[$i]','$qnt[$i]','$amount[$i]','$masterid','$godown[$i]',' $unit[$i]')");

            $query = $this->db->query("UPDATE pos_item_stock SET quantity = quantity -" . $qnt[$i] . " WHERE stock_id= " . $postdata['product_stock_id_' . $i]);

            $query = $this->db->query("UPDATE  pos_purchase_details SET return_qty= return_qty +" . $qnt[$i] . " WHERE purchase_details_id = " . $pid[$i]);



            $account_ledgers = $this->mastermodel->get_data_srow('pos_trading_acc_conn', $postdata['item_acc_conn_id_' . $i], 'trading_conn_id');

            $tblValues = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $account_ledgers->purchase_return_acc,
                'credit' => $postdata['sub_total_' . $i],
            );
            $output = $this->db->insert('ledger_book_details', $tblValues);
            $tblValues = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $account_ledgers->purchase_tax_return_acc,
                'credit' => $postdata['tax_amount_' . $i],
            );
            $output = $this->db->insert('ledger_book_details', $tblValues);

            $x--;
            $i++;
        }
        $output = $this->mastermodel->save_user_activities('Add Purchase Return',$masterid, 'pos_purchase_return');
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = 'Error on Inserted record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = 'Record Updated successfully';
            return $data;
        }
    }

    function get_purchase_return_det_by_id($id)
    {
        $this->db->select('*');
        $this->db->from('pos_purchase_return_details');
        $this->db->where('pos_purchase_return_details.purchase_return_id', $id);
        $data = $this->db->get()->result();
        return $data;
    }

    function get_purchase_det_id($id)
    {
        $this->db->select('item_master_id,item_master_code,purchase_details_id,item_master_name');
        $this->db->from('pos_purchase_details');
        $this->db->join('item_master', 'item_master.item_master_id=pos_purchase_details.product_master');
        $this->db->where('pos_purchase_details.purchase_id', $id);
        $this->db->order_by('pos_purchase_details.purchase_details_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }

    public function update_purchase_return($postdata)
    {
        $this->db->trans_begin();

        $ret = $this->accountingmodel->get_accountmaster_id('vendor', 'vendor_id', 'vendor_ledger', $postdata['vendor']);
//        $set = $this->accountingmodel->get_account_settings('purchase');
        $vendor_invoice = $this->mastermodel->get_single_field_value('pos_purchase_invoice_details', 'vendor_invoice', 'purchase', $postdata['purchase_id']);
        
        $payment_mode = $this->mastermodel->get_single_field_value('pos_purchase_invoice', 'payment_mode', 'vendor_invoice_id', $vendor_invoice);

        $tblValues = array(
            'voucher_date' => $this->mastermodel->convert_date_format($postdata['return_date']),
        );
        $this->db->where('ledger_book.ledger_book_id',$postdata['ledger_book_id']);
        $this->db->update('ledger_book', $tblValues);
        
        $this->db->where('ledger_book_details.ledger_book_id', $postdata['ledger_book_id']);
        $this->db->delete('ledger_book_details');
        if ($payment_mode == 'Cash')
        {
            $cash_account = $this->accountingmodel->get_account_settings('cash_account');
            $debit_account = $cash_account;
            $x = 1;


            $tblValues_led = array(
                'ledger_book_id' => $postdata['ledger_book_id'],
                'account_ledger_id' => $cash_account,
                'debit' => $postdata['return_amount'],
            );
            $output = $this->db->insert('ledger_book_details', $tblValues_led);
            $cdet_id = $this->db->insert_id();
        } else
        {
            $ret = $this->accountingmodel->get_accountmaster_id('vendor', 'vendor_id', 'vendor_ledger', $postdata['vendor']);
            $ret_name = $this->mastermodel->get_single_field_value('vendor', 'vendor_name', 'vendor_id', $postdata['vendor']);
            $debit_account = $ret;
            $x = 1;

            $tblValues_led = array(
                'ledger_book_id' => $postdata['ledger_book_id'],
                'account_ledger_id' => $ret,
                'debit' => $postdata['return_amount'],
            );
            $output = $this->db->insert('ledger_book_details', $tblValues_led);
            $cdet_id = $this->db->insert_id();
        }
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'return_date' => $this->mastermodel->convert_date_format($postdata['return_date']),
            'debit_account' => $debit_account,
//            'credit_account' => $set,
            'return_amount' => $postdata['return_amount'],
            'return_discount' => $postdata['return_discount'],
            'return_ledger' => $postdata['ledger_book_id'],
            'return_note' => $postdata['return_note'],
        );
        $this->db->where('purchase_return_id',$postdata['purchase_return_id']);
        $output = $this->db->update('pos_purchase_return', $tblValues);




//        $tblValues = array(
//            'ledger_book_id' => $ledger_id,
//            'account_ledger_id' => $ret,
//            'debit' => $postdata['return_amount'],
//        );
//        $output = $this->db->insert('ledger_book_details', $tblValues);
        $disc = $this->accountingmodel->get_account_settings('purchase_discounts');
        $tblValues = array(
            'ledger_book_id' => $postdata['ledger_book_id'],
            'account_ledger_id' => $disc,
            'credit' => $postdata['return_discount'],
        );
        $output = $this->db->insert('ledger_book_details', $tblValues);
//        $tblValues = array(
//            'ledger_book_id' => $ledger_id,
//            'account_ledger_id' => $set,
//            'credit' => ($postdata['return_amount'] - $postdata['return_discount']),
//        );
//        $output = $this->db->insert('ledger_book_details', $tblValues);


        $x = 1;
        while (isset($postdata['product_master' . $x]))
        {
            $product_master[$x] = $this->db->escape_str($postdata['product_master' . $x]);
            
            $product_stock[$x] = $this->db->escape_str($postdata['product_stock_id' . $x]);
            $purchase_rate[$x] = $this->db->escape_str($postdata['purchase_rate' . $x]);
//            $purchase_description[$x] = $this->db->escape_str($postdata['purchase_description_' . $x]);

            $new_qty[$x] = $this->db->escape_str($postdata['quantity' . $x]);
            $prev_qty[$x] = $this->db->escape_str($postdata['prev_qty' . $x]);
//            $hd = $this->mastermodel->get_single_field_value('item_master', 'item_sales_unit', 'item_master_id', $product_master[$x]);
//            $qnt_stock[$x] = $hd * $qnt[$x];
            $unit[$x] = $this->db->escape_str($postdata['unit_id' . $x]);
            $amount[$x] = $this->db->escape_str($postdata['amount' . $x]);
            $pid[$x] = $postdata['purchase_details_id' . $x];
            $x++;
        }
        $pr_id = $postdata['purchase_return_id'];
        $i = 1;
        $this->db->where('pos_purchase_return_details.purchase_return_id', $pr_id);
        $this->db->delete('pos_purchase_return_details');
        while ($x != 1)
        {
            $crct_qty = $prev_qty[$i] - $new_qty[$i];
            
            $query = $this->db->query("UPDATE pos_item_stock SET quantity = quantity +" . $crct_qty . " WHERE stock_id= " . $postdata['product_stock_id' . $i]);
           
            $query = $this->db->query("UPDATE  pos_purchase_details SET return_qty= return_qty -" . $crct_qty . " WHERE purchase_details_id = " . $pid[$i]);
           
            if($new_qty[$i] > 0)
            { 
                $query = $this->db->query("insert into pos_purchase_return_details(`purchase_details_id`,`product_master`,`product_stock_id`,`purchase_rate`,`unit_id`,`quantity`,`amount`,`purchase_return_id`) values ('$pid[$i]','$product_master[$i]','$product_stock[$i]','$purchase_rate[$i]','$unit[$i]','$new_qty[$i]','$amount[$i]','$pr_id')");

                $account_ledgers = $this->mastermodel->get_data_srow('pos_trading_acc_conn', $postdata['item_acc_conn_id' . $i], 'trading_conn_id');

                $tblValues = array(
                    'ledger_book_id' => $postdata['ledger_book_id'],
                    'account_ledger_id' => $account_ledgers->purchase_return_acc,
                    'credit' => $postdata['sub_total' . $i],
                );
                $output = $this->db->insert('ledger_book_details', $tblValues);
                $tblValues = array(
                    'ledger_book_id' => $postdata['ledger_book_id'],
                    'account_ledger_id' => $account_ledgers->purchase_tax_return_acc,
                    'credit' => $postdata['tax_amount' . $i],
                );
                $output = $this->db->insert('ledger_book_details', $tblValues);

            }
                $x--;
                $i++;
        }
        $output = $this->mastermodel->save_user_activities('Edit Purchase Return',$postdata['purchase_return_id'], 'pos_purchase_return');
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = 'Error on Updating record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = 'Record Updated  successfully';
            return $data;
        }
    }

    function get_purchase_det_by_id($id)
    {
        $this->db->select('*');
        $this->db->from('pos_purchase_details');
        $this->db->where('pos_purchase_details.purchase_id', $id);
        $data = $this->db->get()->result();
        return $data;
    }

    function get_purchase_det_by_poid($id)
    {
        $this->db->select('*,sum(pos_purchase_details.quantity) as purchased_quantity');
        $this->db->from('pos_purchase_details');

        $this->db->join('pos_purchase', 'pos_purchase_details.purchase_id=pos_purchase.purchase_id', 'inner');
        $this->db->where('pos_purchase.po_management', $id);
        $this->db->group_by("pos_purchase_details.product_master");
        $data = $this->db->get()->result();
        return $data;
    }

    public function insert_purchase_invoice($postdata)
    {
        $this->db->trans_begin();
        $voucher_no = $this->mastermodel->autogen_code('VI', 'pos_purchase_invoice', 'vendor_invoice_no', 'vendor_invoice_id');
        $ledger_id = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'ledger_book_id' => $ledger_id,
            'voucher_no' => $voucher_no,
            'voucher_date' => $this->mastermodel->convert_date_format($postdata['vendor_invoice_date']),
        );
        $output = $this->db->insert('ledger_book', $tblValues);




        $disc = $this->accountingmodel->get_account_settings('purchase_discounts');

        $discount = $postdata['total_discount'];

        if ($discount != 0)
        {
            $tblValues = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $disc,
                'credit' => $discount,
            );
            $output = $this->db->insert('ledger_book_details', $tblValues);
        }

        if ($postdata['payment_mode'] == 'Cash')
        {

            $cash_account = $this->accountingmodel->get_account_settings('cash_account');
            $x = 1;
            $sum = $postdata['amount'];

            $tblValues_led = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $cash_account,
                'credit' => $sum,
            );
            $output = $this->db->insert('ledger_book_details', $tblValues_led);
            $cdet_id = $this->db->insert_id();
        } else
        {
            $ret = $this->accountingmodel->get_accountmaster_id('vendor', 'vendor_id', 'vendor_ledger', $postdata['vendor']);
            $ret_name = $this->mastermodel->get_single_field_value('vendor', 'vendor_name', 'vendor_id', $postdata['vendor']);

            $x = 1;
            $sum = $postdata['amount'];

            $tblValues_led = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $ret,
                'credit' => $sum,
            );
            $output = $this->db->insert('ledger_book_details', $tblValues_led);
            $cdet_id = $this->db->insert_id();
        }





        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'vendor_invoice_id' => $masterid,
            'vendor_invoice_no' => $voucher_no,
            'vendor_invoice_ref_no' => $postdata['vendor_invoice_ref_no'],
            'vendor_invoice_date' => $this->mastermodel->convert_date_format($postdata['vendor_invoice_date']),
            'vendor' => $postdata['vendor'],
            'po_management' => $postdata['po_management'],
            'amount' => $postdata['amount'],
            'vendor_invoice_discount' => $postdata['total_discount'],
            'generated_by' => $postdata['generated_by'],
            'vendor_invoice_remarks' => $postdata['vendor_invoice_remarks'],
            'invoice_ledger' => $ledger_id,
            'payment_mode' => $postdata['payment_mode'],
            'payment_terms' => $postdata['payment_terms'],
            'cheque_no' => $postdata['cheque_no'],
            'cheque_date' => $this->mastermodel->convert_date_format($postdata['cheque_date']),
            'ref_date' => $this->mastermodel->convert_date_format($postdata['ref_date']),
            'exchange_rate' => $postdata['exchange_rate'],
        );
        $output = $this->db->insert('pos_purchase_invoice', $tblValues);

        $tblValues = array(
            'invoice_reference_id' => $masterid,
            'invoice_no' => $voucher_no,
            'reference_no' => $postdata['vendor_invoice_ref_no'],
            'vendor' => $postdata['vendor'],
            'invoice_date' => $this->mastermodel->convertdateformat($postdata['vendor_invoice_date']),
            'amount' => $postdata['amount'],
            'discount' => $discount,
            'payable_amount' => $postdata['amount'] - $postdata['total_discount'],
        );
        $output = $this->db->insert('pos_purchase_invoice_bills', $tblValues);


        $i = 1;
        while (isset($postdata['purchase_' . $i]))
        {
            if ($postdata['purchase_' . $i] != '')
            {


                $tblValues = array(
                    'invoice' => 1,
                );
                $this->db->where('purchase_id', $postdata['purchase_' . $i]);
                $output = $this->db->update('pos_purchase', $tblValues);


                $purchase_detailes = $this->mastermodel->select_data_by_id('pos_purchase_details', 'purchase_id', $postdata['purchase_' . $i]);
                foreach ($purchase_detailes as $purchase_detailes)
                {
                    $account_ledgers = $this->mastermodel->get_data_srow('pos_trading_acc_conn', $purchase_detailes->item_acc_conn_id, 'trading_conn_id');
                    $tblValues = array(
                        'ledger_book_id' => $ledger_id,
                        'account_ledger_id' => $account_ledgers->purchase_acc,
                        'debit' => $purchase_detailes->sub_total,
                    );
                    $output = $this->db->insert('ledger_book_details', $tblValues);
                    $tblValues = array(
                        'ledger_book_id' => $ledger_id,
                        'account_ledger_id' => $account_ledgers->purchase_tax_acc,
                        'debit' => $purchase_detailes->tax_amount,
                    );
                    $output = $this->db->insert('ledger_book_details', $tblValues);
                }
                $tblValues = array(
                    'vendor_invoice' => $masterid,
                    'purchase' => $postdata['purchase_' . $i],
                    'total_amount' => $postdata['total_' . $i],
                );
                $output = $this->db->insert('pos_purchase_invoice_details', $tblValues);
                $i++;
            }
        }
        $output = $this->mastermodel->save_user_activities('Add Purchase Invoice',$masterid, 'pos_purchase_invoice');
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = 'Error on adding record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = 'Record Added  successfully';
            return $data;
        }
    }

    function get_vendor_invoice_details_by_id($id)
    {
        $this->db->select('*');
        $this->db->from('pos_purchase_invoice_details');
        $this->db->join('pos_purchase', 'pos_purchase_invoice_details.purchase=pos_purchase.purchase_id');
        $this->db->where('pos_purchase_invoice_details.vendor_invoice', $id);
        $data = $this->db->get()->result();
        return $data;
    }

    function get_purchase_no_by_vendor($id)
    {
        $this->db->select('*');
        $this->db->from('pos_purchase');
        $this->db->join('vendor', 'pos_purchase.purchase_vendor=vendor.vendor_id');
        $this->db->where('pos_purchase.purchase_vendor', $id);
        $data = $this->db->get()->result();
        return $data;
    }

    function get_purchase_payment_amount($id)
    {
        $this->db->select('pos_purchase.*,COALESCE(SUM(pos_vendor_payment_details.paid),"0")as total_paid', FALSE);
        $this->db->from('pos_purchase');
        $this->db->join('vendor', 'pos_purchase.purchase_vendor=vendor.vendor_id');
        $this->db->join('pos_vendor_payment', 'pos_purchase.purchase_vendor=pos_vendor_payment.vendor', 'left');
        $this->db->join('pos_vendor_payment_details', 'pos_vendor_payment_details.vendor_payment=pos_vendor_payment.vendor_payment_id', 'left');
        $this->db->where('pos_purchase.purchase_id', $id);
        $data = $this->db->get()->row();
        return $data;
    }

    public function update_purchase_invoice($postdata)
    {
        $this->db->trans_begin();

        $tblValues = array(
            'voucher_date' => $this->mastermodel->convert_date_format($postdata['vendor_invoice_date']),
        );
        $this->db->where('ledger_book_id', $postdata['ledger_book_id']);
        $output = $this->db->update('ledger_book', $tblValues);
        $ret = $this->accountingmodel->get_accountmaster_id('vendor', 'vendor_id', 'vendor_ledger', $postdata['vendor']);
        $set = $this->accountingmodel->get_account_settings('purchase');
        $disc = $this->accountingmodel->get_account_settings('purchase_discounts');
        $ledger_id = $postdata['ledger_book_id'];
        $this->db->query("delete from ledger_book_details where ledger_book_id=" . $ledger_id);
        $discount = $postdata['vendor_invoice_discount'];
        $is_percentage = '0';
        if (isset($postdata['is_percentage']))
        {
            $is_percentage = '1';
            $discount = $postdata['vendor_invoice_discount'] * $postdata['amount'] / 100;
        }
        $tblValues = array(
            'ledger_book_id' => $ledger_id,
            'account_ledger_id' => $set,
            'debit' => $postdata['amount'],
        );
        $output = $this->db->insert('ledger_book_details', $tblValues);
        if ($discount != 0)
        {
            $tblValues = array(
                'ledger_book_id' => $ledger_id,
                'account_ledger_id' => $disc,
                'credit' => $discount,
            );
            $output = $this->db->insert('ledger_book_details', $tblValues);
        }
        $tblValues = array(
            'ledger_book_id' => $ledger_id,
            'account_ledger_id' => $ret,
            'credit' => ($postdata['amount'] - $discount),
        );
        $output = $this->db->insert('ledger_book_details', $tblValues);

        $tblValues = array(
            'vendor_invoice_ref_no' => $postdata['vendor_invoice_ref_no'],
            'vendor_invoice_date' => $this->mastermodel->convert_date_format($postdata['vendor_invoice_date']),
            'vendor' => $postdata['vendor'],
            'amount' => $postdata['amount'],
            'vendor_invoice_discount' => $postdata['vendor_invoice_discount'],
            'is_percentage' => $is_percentage,
            'generated_by' => $postdata['generated_by'],
            'vendor_invoice_remarks' => $postdata['vendor_invoice_remarks'],
        );
        $this->db->where('vendor_invoice_id', $postdata['vendor_invoice_id']);
        $output = $this->db->update('pos_purchase_invoice', $tblValues);


        $masterid = $postdata['vendor_invoice_id'];

        $tblValues = array(
            'vendor' => $postdata['vendor'],
            'reference_no' => $postdata['vendor_invoice_ref_no'],
            'invoice_date' => $this->mastermodel->convert_date_format($postdata['vendor_invoice_date']),
            'amount' => $postdata['amount'],
            'discount' => $discount,
            'payable_amount' => $postdata['amount'] - $discount,
        );
        $this->db->where('invoice_reference_id', $postdata['vendor_invoice_id']);
        $output = $this->db->update('pos_purchase_invoice_bills', $tblValues);


        $pid = $this->db->query("select vendor_invoice_details_id,purchase from pos_purchase_invoice_details where vendor_invoice='$masterid'order by vendor_invoice_details_id desc");
        $result = $pid->result();
        if (!empty($result))
        {
            foreach ($result as $value)
            {
                $pdetid = $value->purchase;

                $tblValues = array(
                    'invoice' => 0,
                );
                $this->db->where('purchase_id', $pdetid);
                $output = $this->db->update('pos_purchase', $tblValues);
            }
        }


        $this->db->where('vendor_invoice', $postdata['vendor_invoice_id']);
        $this->db->delete('pos_purchase_invoice_details');
        $i = 1;
        while (isset($postdata['purchase_' . $i]))
        {
            if ($postdata['purchase_' . $i] != '')
            {


                $tblValues = array(
                    'invoice' => 1,
                );
                $this->db->where('purchase_id', $postdata['purchase_' . $i]);
                $output = $this->db->update('pos_purchase', $tblValues);


                $tblValues = array(
                    'vendor_invoice' => $masterid,
                    'purchase' => $postdata['purchase_' . $i],
                    'total_amount' => $postdata['total_' . $i],
                );
                $output = $this->db->insert('pos_purchase_invoice_details', $tblValues);
                $i++;
            }
        }
        $output = $this->mastermodel->save_user_activities('Edit Purchase Invoice',$postdata['vendor_invoice_id'], 'pos_purchase_invoice');
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = 'Error on Updating record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = 'Record Updated  successfully';
            return $data;
        }
    }

    function search_vendor_payment()
    {
        $this->db->select('*, ac1.ledger_name as debit_account,ac2.ledger_name as credit_account');
        $this->db->from('pos_vendor_payment');
        $this->db->join('account_ledger ac1', 'pos_vendor_payment.vendor_payment_debit_account=ac1.ledger_id');
        $this->db->join('account_ledger ac2', 'pos_vendor_payment.vendor_payment_credit_account=ac2.ledger_id');
        $this->db->join('vendor', 'pos_vendor_payment.vendor=vendor.vendor_id');
        $this->db->join('master', 'master.master_id=pos_vendor_payment.vendor_payment_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('pos_vendor_payment.vendor_payment_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    function get_last_paiddate_by_vendor($id)
    {
        $this->db->select('invoice_date');
        $this->db->from('pos_purchase_invoice_bills');
        $this->db->where('vendor', $id);
        $this->db->order_by('invoice_reference_id', 'desc');
        $this->db->limit('1');
        $data = $this->db->get()->row();
        return $data;
    }

    function get_invoice_no_by_vendor_for_bills($id)
    {
        $this->db->select('*');
        $this->db->from('pos_purchase_invoice_bills');
        $this->db->join('vendor', 'pos_purchase_invoice_bills.vendor=vendor.vendor_id');
        $this->db->where('pos_purchase_invoice_bills.vendor', $id);
        $this->db->where('pos_purchase_invoice_bills.paid', 0);
        $data = $this->db->get()->result();
        return $data;
    }

    function get_vendor_payment_amount($id)
    {
        $this->db->select('pos_purchase_invoice_bills.*')->select('COALESCE(SUM(pos_vendor_payment_details.paid),"0")as total_paid', FALSE);
        $this->db->from('pos_purchase_invoice_bills');
        $this->db->join('pos_vendor_payment_details', 'pos_vendor_payment_details.invoice=pos_purchase_invoice_bills.invoice_reference_id', 'left');
        $this->db->where('pos_purchase_invoice_bills.invoice_reference_id', $id);
        $this->db->group_by('pos_purchase_invoice_bills.invoice_reference_id');
        $data = $this->db->get()->row();
        return $data;
    }

    function get_vendor_invoice_by_id($id)
    {
        $this->db->select('*');
        $this->db->from('pos_purchase_invoice');
        $this->db->where('pos_purchase_invoice.vendor_invoice_id', $id);
        $data = $this->db->get()->row();
        return $data;
    }

    function get_print_vendor_details_invoice_by_id($id)
    {
        $this->db->select('*');
        $this->db->from('pos_purchase_invoice_details');
        $this->db->where('pos_purchase_invoice_details.vendor_invoice', $id);
        $data = $this->db->get()->result();
        return $data;
    }

    public function insert_vendor_payment($postdata)
    {
        $this->db->trans_begin();
        $voucher_no = $this->mastermodel->autogen_code('VP', 'pos_vendor_payment', 'vendor_payment_voucher_no', 'vendor_payment_id');
        $pdc = 0;
        $cheque_ref_no = "";
        $cheque_date = "00/00/0000";
        $posted = 1;
        if ($postdata['payment_mode'] == 'Bank')
        {

            $cheque_ref_no = $postdata['ref_no'];
            $cheque_date = $postdata['cheque_date'];
            if (isset($postdata['is_pdc']))
            {
                $pdc = 1;
            }
            if (isset($postdata['is_cdc']))
            {
                $pdc = 1;
                $cheque_date = $postdata['vendor_payment_date'];
            }
            if (isset($postdata['is_posted']))
            {
                $posted = 1;
            } else
            {
                $posted = 0;
            }
        }


        $ledger_id = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'ledger_book_id' => $ledger_id,
            'voucher_no' => $voucher_no,
            'voucher_date' => $this->mastermodel->convert_date_format($postdata['vendor_payment_date']),
            'is_pdc' => $pdc,
            'is_posted' => $posted,
            'cheque_ref_no' => $cheque_ref_no,
            'cheque_date' => $this->mastermodel->convert_date_format($cheque_date),
        );
        $output = $this->db->insert('ledger_book', $tblValues);
        $ret = $this->accountingmodel->get_accountmaster_id('vendor', 'vendor_id', 'vendor_ledger', $postdata['vendor']);

        $set = $postdata['credit_account'];
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'vendor_payment_id' => $masterid,
            'vendor_payment_date' => $this->mastermodel->convert_date_format($postdata['vendor_payment_date']),
            'vendor_last_paid_date' => $this->mastermodel->convert_date_format($postdata['vendor_last_paid_date']),
            'vendor' => $postdata['vendor'],
            'vendor_payment_voucher_no' => $voucher_no,
            'vendor_payment_debit_account' => $ret,
            'vendor_payment_credit_account' => $set,
            'balance' => $postdata['balance'],
            'amount' => $postdata['amount'],
            'vendor_payment_description' => $postdata['vendor_payment_description'],
            'payment_mode' => $postdata['payment_mode'],
            'is_pdc' => $pdc,
            'is_posted' => $posted,
            'cheque_ref_no' => $cheque_ref_no,
            'cheque_date' => $this->mastermodel->convert_date_format($cheque_date),
            'vendor_payment_ledger' => $ledger_id,
        );

        $output = $this->db->insert('pos_vendor_payment', $tblValues);
        $tblValues = array(
            'ledger_book_id' => $ledger_id,
            'account_ledger_id' => $ret,
            'debit' => $postdata['amount'],
        );
        $output = $this->db->insert('ledger_book_details', $tblValues);
        $tblValues = array(
            'ledger_book_id' => $ledger_id,
            'account_ledger_id' => $set,
            'credit' => $postdata['amount'],
        );
        $output = $this->db->insert('ledger_book_details', $tblValues);
        $i = 1;
        while (isset($postdata['invoice_' . $i]))
        {
            if ($postdata['invoice_' . $i] != '')
            {

                if ($postdata['pay_' . $i] == $postdata['total_' . $i])
                {
                    $tblValues = array(
                        'paid' => 1,
                    );
                    $this->db->where('invoice_reference_id', $postdata['invoice_' . $i]);
                    $output = $this->db->update('pos_purchase_invoice_bills', $tblValues);
                    $jid = $this->mastermodel->get_single_field_value('pos_purchase_invoice', 'vendor_invoice_id', 'vendor_invoice_id', $postdata['invoice_' . $i]);
                    if ($jid != "")
                    {

                        $tblValues = array(
                            'is_paid' => 1,
                        );
                        $this->db->where('vendor_invoice_id', $postdata['invoice_' . $i]);
                        $output = $this->db->update('pos_purchase_invoice', $tblValues);
                    }
                }


                $tblValues = array(
                    'vendor_payment' => $masterid,
                    'invoice' => $postdata['invoice_' . $i],
                    'paid' => $postdata['pay_' . $i],
                );
                $output = $this->db->insert('pos_vendor_payment_details', $tblValues);
                $this->db->where('invoice_reference_id', $postdata['invoice_' . $i]);
                $this->db->set('paid_amount', 'paid_amount+' . $postdata['pay_' . $i], FALSE);
                $this->db->update('pos_purchase_invoice_bills');
                $i++;
            }
        }
        $output = $this->mastermodel->save_user_activities('Add Vendor Payment',$masterid, 'pos_vendor_payment');
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = 'Error on adding record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = 'Record Added  successfully';
            return $data;
        }
    }

    function get_vendorpayment_details_by_id($id)
    {
        $this->db->select('*,pos_vendor_payment_details.paid as paid');
        $this->db->from('pos_vendor_payment_details');
        $this->db->join('pos_purchase_invoice_bills', 'pos_vendor_payment_details.invoice=pos_purchase_invoice_bills.invoice_reference_id');
        $this->db->where('pos_vendor_payment_details.vendor_payment', $id);
        $data = $this->db->get()->result();
        return $data;
    }

    function get_invoiceno_by_vendor($id)
    {
        $this->db->select('*');
        $this->db->from('pos_purchase_invoice_bills');
        $this->db->join('vendor', 'pos_purchase_invoice_bills.vendor=vendor.vendor_id');
        $this->db->where('pos_purchase_invoice_bills.vendor', $id);
        $data = $this->db->get()->result();
        return $data;
    }

    function get_invoice_no_by_vendor($id)
    {
        $this->db->select('*');
        $this->db->from('pos_purchase_invoice');
        $this->db->join('vendor', 'pos_purchase_invoice.vendor=vendor.vendor_id');
        $this->db->where('pos_purchase_invoice.vendor', $id);
        $data = $this->db->get()->result();
        return $data;
    }

    public function update_vendor_payment($postdata)
    {
        $this->db->trans_begin();
        $posted = 1;
        $pdc = 0;
        $cheque_ref_no = "";
        $cheque_date = "00-00-0000";
        if ($postdata['payment_mode'] == 'Bank')
        {

            $cheque_ref_no = $postdata['ref_no'];
            $cheque_date = $postdata['cheque_date'];
            if (isset($postdata['is_pdc']))
            {
                $pdc = 1;
            }
            if (isset($postdata['is_cdc']))
            {
                $pdc = 1;
                $cheque_date = $postdata['vendor_payment_date'];
            }
            if (isset($postdata['is_posted']))
            {
                $posted = 1;
            } else
            {
                $posted = 0;
            }
        }
        $tblValues = array(
            'voucher_date' => $this->mastermodel->convert_date_format($postdata['vendor_payment_date']),
            'is_pdc' => $pdc,
            'is_posted' => $posted,
            'cheque_ref_no' => $cheque_ref_no,
            'cheque_date' => $this->mastermodel->convert_date_format($cheque_date),
        );
        $this->db->where('ledger_book_id', $postdata['ledger_book_id']);
        $output = $this->db->update('ledger_book', $tblValues);
        $ret = $this->accountingmodel->get_accountmaster_id('vendor', 'vendor_id', 'vendor_ledger', $postdata['vendor']);

        $set = $postdata['credit_account'];
        $tblValues = array(
            'vendor_payment_date' => $this->mastermodel->convert_date_format($postdata['vendor_payment_date']),
            'vendor_last_paid_date' => $this->mastermodel->convert_date_format($postdata['vendor_last_paid_date']),
            'vendor' => $postdata['vendor'],
            'vendor_payment_debit_account' => $ret,
            'vendor_payment_credit_account' => $set,
            'balance' => $postdata['balance'],
            'amount' => $postdata['amount'],
            'vendor_payment_description' => $postdata['vendor_payment_description'],
            'payment_mode' => $postdata['payment_mode'],
            'is_pdc' => $pdc,
            'is_posted' => $posted,
            'cheque_ref_no' => $cheque_ref_no,
            'cheque_date' => $this->mastermodel->convert_date_format($cheque_date),
        );

        $this->db->where('vendor_payment_id', $postdata['vendor_payment_id']);
        $output = $this->db->update('pos_vendor_payment', $tblValues);
        $ledger_id = $postdata['ledger_book_id'];
        $this->db->query("delete from ledger_book_details where ledger_book_id=" . $ledger_id);
        $tblValues = array(
            'ledger_book_id' => $ledger_id,
            'account_ledger_id' => $ret,
            'debit' => $postdata['amount'],
        );
        $output = $this->db->insert('ledger_book_details', $tblValues);
        $tblValues = array(
            'ledger_book_id' => $ledger_id,
            'account_ledger_id' => $set,
            'credit' => $postdata['amount'],
        );
        $output = $this->db->insert('ledger_book_details', $tblValues);


        $masterid = $postdata['vendor_payment_id'];

        $pid = $this->db->query("select vendor_payment_details_id,invoice from pos_vendor_payment_details where vendor_payment='$masterid'order by vendor_payment_details_id desc");
        $result = $pid->result();
        $i = 1;
        if (!empty($result))
        {
            foreach ($result as $value)
            {
                $pdetid = $value->invoice;
                $tblValues = array(
                    'paid' => 0,
                );
                $this->db->where('invoice_reference_id', $postdata['invoice_' . $i]);
                $output = $this->db->update('pos_purchase_invoice_bills', $tblValues);
                $jid = $this->mastermodel->get_single_field_value('pos_purchase_invoice', 'vendor_invoice_id', 'vendor_invoice_id', $postdata['invoice_' . $i]);
                if ($jid != "")
                {
                    $tblValues = array(
                        'is_paid' => 0,
                    );
                    $this->db->where('vendor_invoice_id', $pdetid);
                    $output = $this->db->update('pos_purchase_invoice', $tblValues);
                }
            }
        }


        $this->db->where('vendor_payment', $postdata['vendor_payment_id']);
        $this->db->delete('pos_vendor_payment_details');
        $i = 1;
        while (isset($postdata['invoice_' . $i]))
        {
            if ($postdata['invoice_' . $i] != '')
            {

                if ($postdata['pay_' . $i] == $postdata['total_' . $i])
                {
                    $tblValues = array(
                        'paid' => 1,
                    );
                    $this->db->where('invoice_reference_id', $postdata['invoice_' . $i]);
                    $output = $this->db->update('pos_purchase_invoice_bills', $tblValues);
                    $jid = $this->mastermodel->get_single_field_value('pos_purchase_invoice', 'vendor_invoice_id', 'vendor_invoice_id', $postdata['invoice_' . $i]);
                    if ($jid != "")
                    {
                        $tblValues = array(
                            'is_paid' => 1,
                        );
                        $this->db->where('vendor_invoice_id', $postdata['invoice_' . $i]);
                        $output = $this->db->update('pos_purchase_invoice', $tblValues);
                    }
                }



                $tblValues = array(
                    'vendor_payment' => $masterid,
                    'invoice' => $postdata['invoice_' . $i],
                    'paid' => $postdata['pay_' . $i],
                );
                $output = $this->db->insert('pos_vendor_payment_details', $tblValues);

                $pay = $postdata['pay_' . $i] - $postdata['prev_pay_amount' . $i];
                $this->db->where('invoice_reference_id', $postdata['invoice_' . $i]);
                $this->db->set('paid_amount', 'paid_amount+' . $pay, FALSE);
                $this->db->update('pos_purchase_invoice_bills');
                $i++;
            }
        }
        $output = $this->mastermodel->save_user_activities('Edit Vendor Payment',$postdata['vendor_payment_id'], 'pos_vendor_payment');
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = 'Error on Updating record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = 'Record Updated  successfully';
            return $data;
        }
    }

    function search_account_connection()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('pos_trading_acc_conn');
        $this->db->join('master', 'master.master_id=pos_trading_acc_conn.trading_conn_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('trading_conn_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    function insert_account_connection($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $trading_conn_code = $this->mastermodel->get_ref('trading_conn_code', 'pos_trading_acc_conn', 'trading_conn_code');
        $tblValues = array(
            'trading_conn_id' => $masterid,
            'trading_conn_code' => $trading_conn_code,
            'connection_name' => $postdata['connection_name'],
            'opening_acc' => $postdata['opening_acc'],
            'purchase_acc' => $postdata['purchase_acc'],
            'purchase_return_acc' => $postdata['purchase_return_acc'],
            'purchase_tax_acc' => $postdata['purchase_tax_acc'],
            'purchase_tax_return_acc' => $postdata['purchase_tax_return_acc'],
            'sale_acc' => $postdata['sale_acc'],
            'sale_tax_acc' => $postdata['sale_tax_acc'],
            'sale_return_acc' => $postdata['sale_return_acc'],
            'sale_tax_return' => $postdata['sale_tax_return'],
            'item_damage_acc' => $postdata['item_damage_acc'],
            'tax_acc' => $postdata['tax_acc'],
        );
        $this->db->insert('pos_trading_acc_conn', $tblValues);
        $output = $this->mastermodel->save_user_activities('Add trading connection',$masterid, 'pos_trading_acc_conn');
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    function update_account_connection($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'connection_name' => $postdata['connection_name'],
            'opening_acc' => $postdata['opening_acc'],
            'purchase_acc' => $postdata['purchase_acc'],
            'purchase_return_acc' => $postdata['purchase_return_acc'],
            'purchase_tax_acc' => $postdata['purchase_tax_acc'],
            'purchase_tax_return_acc' => $postdata['purchase_tax_return_acc'],
            'sale_acc' => $postdata['sale_acc'],
            'sale_tax_acc' => $postdata['sale_tax_acc'],
            'sale_return_acc' => $postdata['sale_return_acc'],
            'sale_tax_return' => $postdata['sale_tax_return'],
            'item_damage_acc' => $postdata['item_damage_acc'],
            'tax_acc' => $postdata['tax_acc'],
        );
        $this->db->where('trading_conn_id', $postdata['trading_conn_id']);
        $this->db->update('pos_trading_acc_conn', $tblValues);
 $output = $this->mastermodel->save_user_activities('Edit trading connection',$postdata['trading_conn_id'], 'pos_trading_acc_conn');
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    function search_purchase_order_category()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('pos_inventory_settings');
        $this->db->join('master', 'master.master_id=inventory_settings_id');
        $this->db->like('inventory_settings_type', 'po_category');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('inventory_settings_id', 'desc');
        $data['results'] = $this->db->get();
//        echo $this->db->last_query();die();
        return $data;
    }

    function search_delevery_note_catg()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('pos_inventory_settings');
        $this->db->join('master', 'master.master_id=inventory_settings_id');
        $this->db->like('inventory_settings_type', 'delivery_note');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('inventory_settings_id', 'desc');
        $data['results'] = $this->db->get();
//        echo $this->db->last_query();die();
        return $data;
    }

    function insert_pos_inventory_settings($postdata)
    {

        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $category_code = $this->mastermodel->get_ref('pos_inventory_setting_code', 'pos_inventory_settings', 'category_code');

        $tblValues = array(
            'inventory_settings_id' => $masterid,
            'inventory_settings_type' => $postdata['form_for'],
            'category_code' => $category_code,
            'category_name' => $postdata['category_name'],
            'active' => $postdata['active'],
            'adjust_to' => $postdata['adjust_to'],
//            'adjust_account' => $postdata['adjust_account'],
            'default_godown' => $postdata['default_godown'],
            'fill_price' => $postdata['fill_price'],
            'reserve_stock' => $postdata['reserve_stock'],
            'reserve_stock_for' => $postdata['reserve_stock_for'],
            'free_bill' => $postdata['free_bill'],
            'show_stock' => $postdata['show_stock'],
            'bill_no' => $postdata['bill_no'],
        );
        $this->db->insert('pos_inventory_settings', $tblValues);

        $numbers = preg_replace('/[^0-9]/', '', $category_code);

        $tblPrefix = array(
            'starting_no' => $postdata['starting'],
            'inventory_settings_id' => $masterid,
        );
        if ($postdata['form_for'] == 'po_category')
        {
            $tblPrefix['prefix_code'] = 'PO' . $numbers;
            $tblPrefix['prefix_name'] = 'pos_purchase_order';
            $tblPrefix['description'] = 'pos purchase order code';
        } elseif ($postdata['form_for'] == 'order_acceptance')
        {
            $tblPrefix['prefix_code'] = 'OA' . $numbers;
            $tblPrefix['prefix_name'] = 'pos_order_acceptance';
            $tblPrefix['description'] = 'pos  order acceptance code';
        } elseif ($postdata['form_for'] == 'purchase_category')
        {
            $tblPrefix['prefix_code'] = 'PUR' . $numbers;
            $tblPrefix['prefix_name'] = 'pos_purchase';
            $tblPrefix['description'] = 'pos  Purchase  code';
        } elseif ($postdata['form_for'] == 'purchase_return_category')
        {
            $tblPrefix['prefix_code'] = 'PURTN' . $numbers;
            $tblPrefix['prefix_name'] = 'pos_purchase_return';
            $tblPrefix['description'] = 'pos  purchase return code';
        } elseif ($postdata['form_for'] == 'sale_category')
        {
            $tblPrefix['prefix_code'] = 'SALE' . $numbers;
            $tblPrefix['prefix_name'] = 'pos_sale';
            $tblPrefix['description'] = 'pos  sale code';
        } elseif ($postdata['form_for'] == 'delivery_note')
        {
            $tblPrefix['prefix_code'] = 'DN' . $numbers;
            $tblPrefix['prefix_name'] = 'pos_delivery_note';
            $tblPrefix['description'] = 'pos  delivery note code';
        } else
        {
            $tblPrefix['prefix_code'] = 'SLRTN' . $numbers;
            $tblPrefix['prefix_name'] = 'pos_sale_return';
            $tblPrefix['description'] = 'pos  sale return code';
        }
        $this->db->insert('prefix', $tblPrefix);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    function update_pos_inventory_settings($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();

        $tblValues = array(
            'category_name' => $postdata['category_name'],
            'active' => $postdata['active'],
            'adjust_to' => $postdata['adjust_to'],
//            'adjust_account' => $postdata['adjust_account'],
            'default_godown' => $postdata['default_godown'],
            'fill_price' => $postdata['fill_price'],
            'reserve_stock' => $postdata['reserve_stock'],
            'reserve_stock_for' => $postdata['reserve_stock_for'],
            'free_bill' => $postdata['free_bill'],
            'show_stock' => $postdata['show_stock'],
//            'bill_no' => $postdata['bill_no'],
        );
        $this->db->where('inventory_settings_id', $postdata['inventory_settings_id']);
        $this->db->update('pos_inventory_settings', $tblValues);


        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    function search_purchase_category()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('pos_inventory_settings');
        $this->db->join('master', 'master.master_id=inventory_settings_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->like('inventory_settings_type', 'purchase_category');
        $this->db->order_by('inventory_settings_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    function search_purchase_return_category()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('pos_inventory_settings');
        $this->db->join('master', 'master.master_id=inventory_settings_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->like('inventory_settings_type', 'purchase_return_category');
        $this->db->order_by('inventory_settings_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    function search_sale_category()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('pos_inventory_settings');
        $this->db->join('master', 'master.master_id=inventory_settings_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->like('inventory_settings_type', 'sale_category');
        $this->db->order_by('inventory_settings_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    function search_sale_return_category()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('pos_inventory_settings');
        $this->db->join('master', 'master.master_id=inventory_settings_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->like('inventory_settings_type', 'sale_return_category');
        $this->db->order_by('inventory_settings_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    function search_tax_settings()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('pos_tax_master');
        $this->db->join('master', 'master.master_id=pos_tax_master.pos_tax_master_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('pos_tax_master.pos_tax_master_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_tax_settings($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();

        $tblValues = array(
            'pos_tax_master_id' => $masterid,
            'pos_tax_master_name' => $postdata['pos_tax_master_name'],
            'pos_tax_master_value' => $postdata['pos_tax_master_value'],
        );
        $this->db->insert('pos_tax_master', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_tax_settings($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'pos_tax_master_name' => $postdata['pos_tax_master_name'],
            'pos_tax_master_value' => $postdata['pos_tax_master_value'],
        );
        $this->db->where('pos_tax_master_id', $postdata['pos_tax_master_id']);
        $this->db->update('pos_tax_master', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Updating Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    public function get_subcategory($id)
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('pos_item_category');
        $this->db->where_in('item_category_parent', $id);
        $this->db->order_by('item_category_id', 'desc');
        $data = $this->db->get()->result();
        return $data;
    }

    public function search_pos_general_settings()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('pos_inventory_general_settings');
        $this->db->join('master', 'master.master_id=pos_inventory_general_settings.inventory_general_settings_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('inventory_general_settings_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_pos_general_settings($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        if ($postdata['maintain_manual_batch'])
            $maintain_manual_batch = 'yes';
        else
        {
            $maintain_manual_batch = 'no';
        }
        $tblValues = array(
            'inventory_general_settings_id' => $masterid,
            'qty_format' => $postdata['qty_format'],
            'currency_format' => $postdata['currency_format'],
            'creditors_ageing_analsis' => $postdata['creditors_ageing_analsis'],
            'debtors_ageing_analsis' => $postdata['debtors_ageing_analsis'],
            'stock_validation_price' => $postdata['stock_validation_price'],
            'maintain_manual_batch' => $maintain_manual_batch,
        );
        $this->db->insert('pos_inventory_general_settings', $tblValues);
        $output = $this->mastermodel->save_user_activities('Add inventory general settings',$masterid, 'pos_inventory_general_settings');
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_pos_general_settings($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        if ($postdata['maintain_manual_batch'])
            $maintain_manual_batch = 'yes';
        else
        {
            $maintain_manual_batch = 'no';
        }
        $tblValues = array(
            'qty_format' => $postdata['qty_format'],
            'currency_format' => $postdata['currency_format'],
            'creditors_ageing_analsis' => $postdata['creditors_ageing_analsis'],
            'debtors_ageing_analsis' => $postdata['debtors_ageing_analsis'],
            'stock_validation_price' => $postdata['stock_validation_price'],
            'maintain_manual_batch' => $maintain_manual_batch,
        );
        $this->db->where('inventory_general_settings_id', $postdata['inventory_general_settings_id']);
        $this->db->update('pos_inventory_general_settings', $tblValues);
        $output = $this->mastermodel->save_user_activities('Edit inventory general settings',$postdata['inventory_general_settings_id'], 'pos_inventory_general_settings');
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    function set_managerapproval($po_management_id)
    {
        $tblValues = array(
            'po_manager_approval' => 1
        );
        $this->db->where('po_management_id', $po_management_id);
        $data = $this->db->update('pos_po', $tblValues);
        if ($data == 1)
        {
            $output = $this->search_purchase_order();
            return $output;
        } else
        {
            return 0;
        }
    }

    function set_gmapproval($po_gm_id)
    {
        $tblValues = array(
            'po_gm_approval' => 1
        );
        $this->db->where('po_management_id', $po_gm_id);
        $data = $this->db->update('pos_po', $tblValues);
        if ($data == 1)
        {
            $output = $this->search_purchase_order();

            return $output;
        } else
        {
            return 0;
        }
    }

    function get_trading_conn_id($id)
    {
        $this->db->select('*');
        $this->db->from('pos_trading_acc_conn');
        $this->db->where('pos_trading_acc_conn.trading_conn_id', $id);
        $data = $this->db->get()->row();
        return $data;
    }

    public function search_production_expense_item()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('pos_production_expense_item');
//        $this->db->join('master', 'master.master_id=pos_production_expense_item.expense_item_id');
//        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('expense_item_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_production_expense_item($postdata)
    {
        $data = array();
        $this->db->trans_begin();

        $masterid = $this->mastermodel->insertmasterdata();
        $expense_code = $this->mastermodel->get_ref('expense_item_code', 'pos_production_expense_item', 'expense_item_code');
        $tblValues = array(
            'expense_item_id' => $masterid,
            'expense_item_code' => $expense_code,
            'expense_item_name' => $postdata['expense_item_name'],
            'expense_item_unit_id' => $postdata['expense_item_unit_id'],
        );
        $this->db->insert('pos_production_expense_item', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_production_expense_item($postdata)
    {
        $data = array();
        $this->db->trans_begin();

        $tblValues = array(
            'expense_item_name' => $postdata['expense_item_name'],
            'expense_item_unit_id' => $postdata['expense_item_unit_id'],
        );
        $this->db->where('expense_item_id', $postdata['expense_item_id']);
        $this->db->update('pos_production_expense_item', $tblValues);

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function search_product_master()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('pos_item_master');
        $this->db->join('master', 'master.master_id=pos_item_master.product_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->where('pos_item_master.production', '1');
        $this->db->order_by('product_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_product_master($postdata)
    {
        $data = array();
        $this->db->trans_begin();

        $masterid = $this->mastermodel->insertmasterdata();
        $item_code = $this->mastermodel->get_ref('product_code', 'pos_item_master', 'product_code');
        $tblValues = array(
            'product_id' => $masterid,
            'product_code' => $item_code,
            'product_name' => $postdata['product_name'],
            'main_category' => $postdata['main_category'],
            'sub_category' => $postdata['sub_category'],
            'lowest_unit' => $postdata['lowest_unit'],
            'sale_unit' => $postdata['sale_unit'],
            'purchase_unit' => $postdata['purchase_unit'],
//            'shelf_life' => $postdata['shelf_life'],
            'hsn_code' => $postdata['hsn_code'],
            'tax_percentage' => $postdata['tax_percentage'],
            'production' => '1'
        );
        $this->db->insert('pos_item_master', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_product_master($postdata)
    {
        $data = array();
        $this->db->trans_begin();

        $tblValues = array(
            'product_name' => $postdata['product_name'],
            'sub_category' => $postdata['sub_category'],
            'main_category' => $postdata['main_category'],
            'lowest_unit' => $postdata['lowest_unit'],
            'sale_unit' => $postdata['sale_unit'],
            'purchase_unit' => $postdata['purchase_unit'],
//            'shelf_life' => $postdata['shelf_life'],
            'hsn_code' => $postdata['hsn_code'],
            'tax_percentage' => $postdata['tax_percentage']
        );
        $this->db->where('product_id', $postdata['product_id']);
        $this->db->update('pos_item_master', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    public function search_bom()
    {
        $data = array();
        $this->db->select('pos_production_bom.*');
        $this->db->from('pos_production_bom');
        $this->db->join('master', 'master.master_id=pos_production_bom.bom_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('pos_production_bom.bom_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_bom($postdata)
    {
        $data = array();
        $this->db->trans_begin();

        $masterid = $this->mastermodel->insertmasterdata();
//        $item_code = $this->mastermodel->get_ref('product_code', 'pos_item_master', 'product_code');
        $tblValues = array(
            'bom_id' => $masterid,
            'bom_product_id' => $postdata['bom_product_id'],
            'bom_product_unit_id' => $postdata['bom_product_unit_id']
        );
        $this->db->insert('pos_production_bom', $tblValues);

        $i = 1;
        while (!empty($postdata['bom_material_qty' . $i]))
        {
            $contact = $this->mastermodel->insertmasterdata();
            $Values = array(
                'bom_details_id' => $contact,
                'bom_id' => $masterid,
                'bom_material_id' => $postdata['bom_material_id' . $i],
                'bom_material_qty' => $postdata['bom_material_qty' . $i],
                'bom_material_unit_id' => $postdata['bom_material_unit_id' . $i]
            );
            $this->db->insert('pos_production_bom_details', $Values);
            $i++;
        }

        $i = 1;
        while (!empty($postdata['bom_expense_item_id' . $i]))
        {
            $contact = $this->mastermodel->insertmasterdata();
            $Values = array(
                'bom_expense_id' => $contact,
                'bom_id' => $masterid,
                'bom_expense_item_id' => $postdata['bom_expense_item_id' . $i],
                'bom_expense_item_qty' => $postdata['bom_expense_item_qty' . $i],
                'bom_expense_item_unit_id' => $postdata['bom_expense_item_unit_id' . $i]
            );
            $this->db->insert('pos_production_bom_expense', $Values);
            $i++;
        }

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_bom($postdata)
    {
        $data = array();
        $this->db->trans_begin();

        $tblValues = array(
            'bom_product_id' => $postdata['bom_product_id'],
            'bom_product_unit_id' => $postdata['bom_product_unit_id']
        );
        $this->db->where('bom_id', $postdata['bom_id']);
        $this->db->update('pos_production_bom', $tblValues);

        $this->db->where('bom_id', $postdata['bom_id']);
        $this->db->delete('pos_production_bom_details');
        $i = 1;
        while (!empty($postdata['bom_material_id' . $i]))
        {
            $contact = $this->mastermodel->insertmasterdata();
            $Values = array(
                'bom_details_id' => $contact,
                'bom_id' => $postdata['bom_id'],
                'bom_material_id' => $postdata['bom_material_id' . $i],
                'bom_material_qty' => $postdata['bom_material_qty' . $i],
                'bom_material_unit_id' => $postdata['bom_material_unit_id' . $i]
            );
            $this->db->insert('pos_production_bom_details', $Values);
            $i++;
        }

        $this->db->where('bom_id', $postdata['bom_id']);
        $this->db->delete('pos_production_bom_expense');
        $i = 1;
        while (!empty($postdata['bom_expense_item_id' . $i]))
        {
            $contact = $this->mastermodel->insertmasterdata();
            $Values = array(
                'bom_expense_id' => $contact,
                'bom_id' => $postdata['bom_id'],
                'bom_expense_item_id' => $postdata['bom_expense_item_id' . $i],
                'bom_expense_item_qty' => $postdata['bom_expense_item_qty' . $i],
                'bom_expense_item_unit_id' => $postdata['bom_expense_item_unit_id' . $i]
            );
            $this->db->insert('pos_production_bom_expense', $Values);
            $i++;
        }

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    function get_product_entry_details($id)
    {
        $this->db->select('*');
        $this->db->from('pos_production_bom');
        $this->db->where('bom_product_id', $id['id']);
        $this->db->join('pos_production_bom_details', 'pos_production_bom_details.bom_id=pos_production_bom.bom_id');
        $this->db->join('pos_production_bom_expense', 'pos_production_bom_expense.bom_id=pos_production_bom.bom_id');
        $data = $this->db->get()->result();
        return $data;
    }

    function get_unit($id)
    {
        $this->db->select('*');
        $this->db->from('unit');
        $this->db->where('unit_id', $id);
        $data = $this->db->get()->row();
        return $data;
    }

    public function search_production_entry()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('pos_production_entry');
//        $this->db->join('master', 'master.master_id=pos_item_master.product_id');
//        $this->db->where('master.project_id', $_SESSION['project_id']);
//        $this->db->where('pos_item_master.production', '1');
        $this->db->order_by('pos_production_entry_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_production_entry($postdata)
    {
        $data = array();
        $this->db->trans_begin();

        $masterid = $this->mastermodel->insertmasterdata();
        $item_code = $this->mastermodel->get_ref('pos_production_entry_code', 'pos_production_entry', 'pos_production_entry_code');
        $tblValues = array(
            'pos_production_entry_id' => $masterid,
            'pos_production_entry_code' => $item_code,
            'pos_production_entry_date' => $this->mastermodel->convert_date_format($postdata['pos_production_entry_date']),
            'pos_production_entry_item_id' => $postdata['pos_production_entry_item_id'],
            'pos_production_entry_item_unit_id' => $postdata['pos_production_entry_item_unit_id'],
            'pos_production_entry_qty' => $postdata['pos_production_entry_qty'],
            'pos_production_entry_work_order_id' => $postdata['pos_production_entry_work_order_id'],
            'pos_production_entry_bom_total' => $postdata['pos_production_entry_bom_total'],
            'pos_production_entry_expense_total' => $postdata['pos_production_entry_expense_total'],
            'pos_production_entry_other_expense_total' => $postdata['pos_production_entry_other_expense_total'],
            'pos_production_entry_sub_total1' => $postdata['pos_production_entry_sub_total1'],
            'pos_production_entry_cost_per_item' => $postdata['pos_production_entry_cost_per_item'],
            'pos_production_entry_margin_percent' => $postdata['pos_production_entry_margin_percent'],
            'pos_production_entry_margin_fixed' => $postdata['pos_production_entry_margin_fixed'],
            'pos_production_entry_sale_rate' => $postdata['pos_production_entry_sale_rate'],
            'pos_production_entry_godown_id' => $postdata['pos_production_entry_godown_id']
        );
        $this->db->insert('pos_production_entry', $tblValues);

        $this->db->set('completed_qty', 'completed_qty+' . $postdata['pos_production_entry_qty'], FALSE);
        $this->db->where('details_item_id', $postdata['pos_production_entry_item_id']);
        $this->db->where('details_workorder_id', $postdata['pos_production_entry_work_order_id']);
        $this->db->update('pos_production_order_acceptance_details');

        $item_master_data = array(
            'purchase_price' => $postdata['pos_production_entry_cost_per_item'],
            'last_purchase_price' => $postdata['pos_production_entry_cost_per_item'],
            'sale_price' => $postdata['pos_production_entry_sale_rate'],
            'last_sale_rate' => $postdata['pos_production_entry_sale_rate']
        );
        $this->db->where('product_id', $postdata['pos_production_entry_item_id']);
        $this->db->update('pos_item_master', $item_master_data);

//        for item stock calcution

        $stock_qty_multiplayer = $this->posmodel->get_stock_qty_multiplayer($postdata['pos_production_entry_item_id'], $postdata['pos_production_entry_item_unit_id'], $postdata['pos_production_entry_item_lowest_unit']);
        $stock_quantity = $postdata['pos_production_entry_qty'] * $stock_qty_multiplayer->unit_count;

        $batch_id = 0;
        $batch_detail = $this->posmodel->get_batch_exist($postdata['pos_production_entry_item_id'], $postdata['pos_production_entry_sale_rate']);
        if (empty($batch_detail))
        {
            $batch_id = $this->mastermodel->insertmasterdata();
            $batch_no = $this->mastermodel->get_ref('batch_no', 'pos_item_batch', 'batch_no');
            $batchTbl = array(
                'batch_id' => $batch_id,
                'batch_no' => $batch_no,
                'item_id' => $postdata['pos_production_entry_item_id'],
                'sale_price' => $postdata['pos_production_entry_sale_rate'],
            );
            $this->db->insert('pos_item_batch', $batchTbl);


            $stock_id = $this->mastermodel->insertmasterdata();
            $stockTbl = array(
                'stock_id' => $stock_id,
                'batch_id' => $batch_id,
                'quantity' => $postdata['pos_production_entry_qty'],
                'sale_price' => $postdata['pos_production_entry_sale_rate'],
                'last_purchase' => $postdata['pos_production_entry_cost_per_item'],
                'weighted_avg' => 0,
                'date' => date('Y-m-d'),
            );
            $this->db->insert('pos_item_stock', $stockTbl);
        } else
        {
            $batch_id = $batch_detail->batch_id;
            $stock_detail = $this->posmodel->get_stock_detail($batch_id);
            $stock_id = $stock_detail->stock_id;
            $new_quantity = $stock_detail->quantity + $stock_quantity;
            $stockTbl = array(
                'quantity' => $new_quantity,
                'sale_price' => $postdata['pos_production_entry_sale_rate'],
                'last_purchase' => $postdata['pos_production_entry_cost_per_item'],
                'weighted_avg' => 0,
                'date' => date('Y-m-d'),
            );
            $this->db->where('stock_id', $stock_id);
            $this->db->where('batch_id', $batch_id);
            $output = $this->db->update('pos_item_stock', $stockTbl);
        }
        $i = 0;
        while (!empty($postdata['pos_production_entry_bom_material_id' . ++$i]))
        {
            $contact = $this->mastermodel->insertmasterdata();
            $Values = array(
                'pos_production_entry_bom_id' => $contact,
                'pos_production_entry_id' => $masterid,
                'pos_production_entry_bom_material_id' => $postdata['pos_production_entry_bom_material_id' . $i],
                'pos_production_entry_bom_material_unit_id' => $postdata['pos_production_entry_bom_material_unit_id' . $i],
                'pos_production_entry_bom_material_qty' => $postdata['pos_production_entry_bom_material_qty' . $i],
                'pos_production_entry_bom_material_price' => $postdata['pos_production_entry_bom_material_price' . $i],
                'pos_production_entry_bom_material_total' => $postdata['pos_production_entry_bom_material_total' . $i],
                'pos_production_entry_bom_godown_id' => $postdata['pos_production_entry_bom_godown_id' . $i],
            );
            $this->db->insert('pos_production_entry_bom_details', $Values);

//            for stock purpose
            //            for stock purpose starts here
            $stock_qty_multiplayer = $this->posmodel->get_stock_qty_multiplayer($postdata['pos_production_entry_bom_material_id' . $i], $postdata['pos_production_entry_bom_material_unit_id' . $i], $this->mastermodel->get_single_field_value('pos_item_master', 'lowest_unit', 'product_id', $postdata['pos_production_entry_bom_material_id' . $i]));
            $stock_quantity = ($postdata['pos_production_entry_bom_material_qty' . $i] * $stock_qty_multiplayer->unit_count) * $postdata['pos_production_entry_qty'];

            $prev_batch_detail = $this->posmodel->get_batch_exist($postdata['pos_production_entry_bom_material_id' . $i], 0);
            $prev_stock_detail = $this->posmodel->get_stock_detail($prev_batch_detail->batch_id);


            $this->db->where('stock_id', $prev_stock_detail->stock_id);
            $this->db->set('quantity', 'quantity -' . $stock_quantity, FALSE);
            $this->db->update('pos_item_stock');
        }

        $i = 0;
        while (!empty($postdata['pos_production_entry_expense_item_id' . ++$i]))
        {
            $contact = $this->mastermodel->insertmasterdata();
            $Values = array(
                'pos_production_entry_expense_item_details_id' => $contact,
                'pos_production_entry_id' => $masterid,
                'pos_production_entry_expense_item_id' => $postdata['pos_production_entry_expense_item_id' . $i],
                'pos_production_entry_expense_item_unit_id' => $postdata['pos_production_entry_expense_item_unit_id' . $i],
                'pos_production_entry_expense_item_qty' => $postdata['pos_production_entry_expense_item_qty' . $i],
                'pos_production_entry_expense_item_price' => $postdata['pos_production_entry_expense_item_price' . $i],
                'pos_production_entry_expense_item_total' => $postdata['pos_production_entry_expense_item_total' . $i]
            );
            $this->db->insert('pos_production_entry_expense_item_details', $Values);
        }

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function update_production_entry($postdata)
    {
        $data = array();
        $this->db->trans_begin();

//        $masterid = $this->mastermodel->insertmasterdata();
//        $item_code = $this->mastermodel->get_ref('pos_production_entry_code', 'pos_production_entry', 'pos_production_entry_code');
        $tblValues = array(
//            'pos_production_entry_id' => $masterid,
//            'pos_production_entry_code' => $item_code,
            'pos_production_entry_date' => $this->mastermodel->convert_date_format($postdata['pos_production_entry_date']),
//            'pos_production_entry_item_id' => $postdata['pos_production_entry_item_id'],
//            'pos_production_entry_item_unit_id' => $postdata['pos_production_entry_item_unit_id'],
            'pos_production_entry_qty' => $postdata['pos_production_entry_qty'],
            'pos_production_entry_work_order_id' => $postdata['pos_production_entry_work_order_id'],
            'pos_production_entry_bom_total' => $postdata['pos_production_entry_bom_total'],
            'pos_production_entry_expense_total' => $postdata['pos_production_entry_expense_total'],
            'pos_production_entry_other_expense_total' => $postdata['pos_production_entry_other_expense_total'],
            'pos_production_entry_sub_total1' => $postdata['pos_production_entry_sub_total1'],
            'pos_production_entry_cost_per_item' => $postdata['pos_production_entry_cost_per_item'],
            'pos_production_entry_margin_percent' => $postdata['pos_production_entry_margin_percent'],
            'pos_production_entry_margin_fixed' => $postdata['pos_production_entry_margin_fixed'],
            'pos_production_entry_sale_rate' => $postdata['pos_production_entry_sale_rate'],
            'pos_production_entry_godown_id' => $postdata['pos_production_entry_godown_id']
        );
        $this->db->where('pos_production_entry_id', $postdata['pos_production_entry_id']);
        $this->db->update('pos_production_entry', $tblValues);


        $item_master_data = array(
            'purchase_price' => $postdata['pos_production_entry_cost_per_item'],
            'last_purchase_price' => $postdata['pos_production_entry_cost_per_item'],
//            'sale_price'=> $postdata['pos_production_entry_sale_rate'],
            'last_sale_rate' => $postdata['pos_production_entry_sale_rate']
        );
        $this->db->where('product_id', $postdata['pos_production_entry_item_id']);
        $this->db->update('pos_item_master', $item_master_data);

//        for unit convertion of production item

        $stock_qty_multiplayer = $this->posmodel->get_stock_qty_multiplayer($postdata['pos_production_entry_item_id'], $postdata['pos_production_entry_item_unit_id'], $postdata['pos_production_entry_item_lowest_unit']);
        $stock_quantity = $postdata['pos_production_entry_qty'] * $stock_qty_multiplayer->unit_count;

//        for stock purpose
        $prev_batch_detail = $this->posmodel->get_batch_exist($postdata['pos_production_entry_item_id'], $postdata['prev_pos_production_entry_sale_rate']);
        $prev_stock_detail = $this->posmodel->get_stock_detail($prev_batch_detail->batch_id);

        $new_prev_qty = $prev_stock_detail->quantity - ($postdata['prev_production_qty'] * $stock_qty_multiplayer->unit_count);
        $this->db->where('stock_id', $prev_stock_detail->stock_id);
        $this->db->update('pos_item_stock', array('quantity' => $new_prev_qty));

        $this->db->set('completed_qty', 'completed_qty+' . ($postdata['pos_production_entry_qty'] - $postdata['prev_production_qty']), FALSE);
        $this->db->where('details_item_id', $postdata['pos_production_entry_item_id']);
        $this->db->where('details_workorder_id', $postdata['pos_production_entry_work_order_id']);
        $this->db->update('pos_production_order_acceptance_details');

        $batch_id = 0;
        $batch_detail = $this->posmodel->get_batch_exist($postdata['pos_production_entry_item_id'], $postdata['pos_production_entry_sale_rate']);
        if (empty($batch_detail))
        {
            $batch_id = $this->mastermodel->insertmasterdata();
            $batch_no = $this->mastermodel->get_ref('batch_no', 'pos_item_batch', 'batch_no');
            $batchTbl = array(
                'batch_id' => $batch_id,
                'batch_no' => $batch_no,
                'item_id' => $postdata['pos_production_entry_item_id'],
                'sale_price' => $postdata['pos_production_entry_sale_rate'],
            );
            $this->db->insert('pos_item_batch', $batchTbl);


            $stock_id = $this->mastermodel->insertmasterdata();
            $stockTbl = array(
                'stock_id' => $stock_id,
                'batch_id' => $batch_id,
                'quantity' => $stock_quantity,
                'sale_price' => $postdata['pos_production_entry_sale_rate'],
                'last_purchase' => $postdata['pos_production_entry_cost_per_item'],
                'weighted_avg' => 0,
                'date' => date('Y-m-d'),
            );
            $this->db->insert('pos_item_stock', $stockTbl);
        } else
        {
            $batch_id = $batch_detail->batch_id;
            $stock_detail = $this->posmodel->get_stock_detail($batch_id);
            $stock_id = $stock_detail->stock_id;
            $new_quantity = $stock_detail->quantity + $stock_quantity;
            $stockTbl = array(
                'quantity' => $new_quantity,
                'sale_price' => $postdata['pos_production_entry_sale_rate'],
                'last_purchase' => $postdata['pos_production_entry_cost_per_item'],
                'weighted_avg' => 0,
                'date' => date('Y-m-d'),
            );
            $this->db->where('stock_id', $stock_id);
            $this->db->where('batch_id', $batch_id);
            $output = $this->db->update('pos_item_stock', $stockTbl);
        }
//        echo $this->db->last_query();die();
        $this->db->where('pos_production_entry_id', $postdata['pos_production_entry_id']);
        $this->db->delete('pos_production_entry_bom_details');
        $i = 0;
        while (!empty($postdata['pos_production_entry_bom_material_id' . ++$i]))
        {
            $contact = $this->mastermodel->insertmasterdata();
            $Values = array(
                'pos_production_entry_bom_id' => $contact,
                'pos_production_entry_id' => $postdata['pos_production_entry_id'],
                'pos_production_entry_bom_material_id' => $postdata['pos_production_entry_bom_material_id' . $i],
                'pos_production_entry_bom_material_unit_id' => $postdata['pos_production_entry_bom_material_unit_id' . $i],
                'pos_production_entry_bom_material_qty' => $postdata['pos_production_entry_bom_material_qty' . $i],
                'pos_production_entry_bom_material_price' => $postdata['pos_production_entry_bom_material_price' . $i],
                'pos_production_entry_bom_material_total' => $postdata['pos_production_entry_bom_material_total' . $i],
                'pos_production_entry_bom_godown_id' => $postdata['pos_production_entry_bom_godown_id' . $i]
            );
            $this->db->insert('pos_production_entry_bom_details', $Values);

//            for stock purpose starts here
            $stock_qty_multiplayer = $this->posmodel->get_stock_qty_multiplayer($postdata['pos_production_entry_bom_material_id' . $i], $postdata['pos_production_entry_bom_material_unit_id' . $i], $this->mastermodel->get_single_field_value('pos_item_master', 'lowest_unit', 'product_id', $postdata['pos_production_entry_bom_material_id' . $i]));
            $stock_quantity = ($postdata['pos_production_entry_bom_material_qty' . $i] * $stock_qty_multiplayer->unit_count) * $postdata['pos_production_entry_qty'];
            $prev_stock_quantity = ($postdata['prev_bom_qty' . $i] * $stock_qty_multiplayer->unit_count) * $postdata['prev_production_qty'];

            $prev_batch_detail = $this->posmodel->get_batch_exist($postdata['pos_production_entry_bom_material_id' . $i], 0);
            $prev_stock_detail = $this->posmodel->get_stock_detail($prev_batch_detail->batch_id);

            $new_prev_qty = $stock_quantity - $prev_stock_quantity;

            $this->db->where('stock_id', $prev_stock_detail->stock_id);
            $this->db->set('quantity', 'quantity -' . $new_prev_qty, FALSE);
            $this->db->update('pos_item_stock');
        }

        $this->db->where('pos_production_entry_id', $postdata['pos_production_entry_id']);
        $this->db->delete('pos_production_entry_expense_item_details');
        $i = 1;
        while (!empty($postdata['pos_production_entry_expense_item_id' . $i]))
        {
            $contact = $this->mastermodel->insertmasterdata();
            $Values = array(
                'pos_production_entry_expense_item_details_id' => $contact,
                'pos_production_entry_id' => $postdata['pos_production_entry_id'],
                'pos_production_entry_expense_item_id' => $postdata['pos_production_entry_expense_item_id' . $i],
                'pos_production_entry_expense_item_unit_id' => $postdata['pos_production_entry_expense_item_unit_id' . $i],
                'pos_production_entry_expense_item_qty' => $postdata['pos_production_entry_expense_item_qty' . $i],
                'pos_production_entry_expense_item_price' => $postdata['pos_production_entry_expense_item_price' . $i],
                'pos_production_entry_expense_item_total' => $postdata['pos_production_entry_expense_item_total' . $i]
            );
            $this->db->insert('pos_production_entry_expense_item_details', $Values);
            $i++;
        }

        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }

    public function search_item_stock()
    {
        $data = array();
        $this->db->select('pos_item_master.product_code,pos_item_master.product_name,pos_item_stock.sale_price,pos_item_stock.quantity,pos_item_master.lowest_unit,pos_item_batch.batch_no,pos_item_stock.stock_id');
        $this->db->from('pos_item_stock');
        $this->db->join('pos_item_batch', 'pos_item_batch.batch_id=pos_item_stock.batch_id');
        $this->db->join('pos_item_master', 'pos_item_master.product_id=pos_item_batch.item_id','right');


        $this->db->join('master', 'master.master_id=pos_item_stock.stock_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->where('pos_item_stock.quantity >', 0);
        $this->db->order_by('pos_item_stock.stock_id', 'desc');
        $data['results'] = $this->db->get();
//        echo $this->db->last_query();
        return $data;
    }

    function load_purchase_item_details($item_id)
    {
        $this->db->select('*');
        $this->db->from('pos_purchase_details');
        $this->db->join('pos_purchase', 'pos_purchase.purchase_id=pos_purchase_details.purchase_id');
        $this->db->where('product_master', $item_id);
        $this->db->order_by('purchase_details_id', "desc");
        $this->db->limit(5);
        return $this->db->get()->result();
    }

    function load_product_item_details($item_id)
    {
        $this->db->select('*');
        $this->db->from('pos_production_entry');
        $this->db->where('pos_production_entry_item_id', $item_id);
        $this->db->order_by('pos_production_entry_id', "desc");
        $this->db->limit(5);
        return $this->db->get()->result();
    }

    function search_order_acceptance()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('pos_inventory_settings');
        $this->db->join('master', 'master.master_id=inventory_settings_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->like('inventory_settings_type', 'order_acceptance');
        $this->db->order_by('inventory_settings_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    function delete_purchase_id($id)
    {
        $this->db->trans_begin();

        $pid = $this->db->query("select ledger_book_details_id from ledger_book_details where ledger_book_id='$id'order by ledger_book_details_id desc");
        $result = $pid->result();
        if (!empty($result))
        {
            foreach ($result as $value)
            {
                $pdetid = $value->ledger_book_details_id;
                $this->db->where('ledger_book_reference.ledger_book_details', $pdetid);
                $output = $this->db->delete('ledger_book_reference');
            }
        }
        $this->db->where('ledger_book_details.ledger_book_id', $id);
        $output = $this->db->delete('ledger_book_details');
        $q = $this->db->query("select purchase_id from pos_purchase where purchase_ledger='$id'order by purchase_ledger desc limit 1");
        $result = $q->row();
        if (!empty($result))
        {
            $jno = $result->purchase_id;
        }
        $pdet = $this->db->query("select po_details_id,quantity from pos_purchase_details where purchase_id='$jno'order by purchase_details_id desc");
        $result = $pdet->result();
        if (!empty($result))
        {
            foreach ($result as $value)
            {
                if (!empty($value->po_details_id))
                {
                    $pdetid = $value->po_details_id;

                    $prev_qnt = $value->quantity;

                    if (!empty($pdetid))
                    {
                        $output = $this->db->query("UPDATE pos_po_details SET po_completed_qty = po_completed_qty -" . $prev_qnt . " WHERE po_details_id = " . $pdetid);
                    }
                }
            }
        }
        $purchase_stock = $this->mastermodel->selected_data_by_id('pos_purchase_details', array('product_master', 'stock_id', 'quantity', 'unit'), 'purchase_id', $jno);
        foreach ($purchase_stock as $value)
        {
            $lowest_unit = $this->mastermodel->get_single_field_value('pos_item_master', 'lowest_unit', 'product_id', $value->product_master);

            $stock_qty_multiplayer = $this->posmodel->get_stock_qty_multiplayer($value->product_master, $value->unit, $lowest_unit);
            $stock_quantity = $value->quantity * $stock_qty_multiplayer->unit_count;

            $output = $this->db->query("UPDATE pos_item_stock SET quantity = quantity -" . $stock_quantity . " WHERE stock_id = " . $value->stock_id);
        }
        $this->db->where('pos_purchase_details.purchase_id', $jno);
        $output = $this->db->delete('pos_purchase_details');
        $this->db->where('pos_purchase.purchase_id', $jno);
        $output = $this->db->delete('pos_purchase');
        $this->db->where('ledger_book.ledger_book_id', $id);
        $output = $this->db->delete('ledger_book');


        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['status'] = $output;
            $data['msg'] = "Unable to delete Record..!";
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['status'] = $output;
            $data['msg'] = "Data Deleted Successfully..!";
            return $data;
        }
    }

    function get_notcompleted_orders()
    {
        $this->db->select('pos_production_order_acceptance.order_date,pos_production_order_acceptance.order_id,pos_production_order_acceptance.order_code,pos_production_order_acceptance_details.details_item_qty');
        $this->db->from('pos_production_order_acceptance');
        $this->db->where('pos_production_order_acceptance.order_show_in_goods_reciept', 1);
        $this->db->join('pos_production_order_acceptance_details', 'pos_production_order_acceptance_details.details_workorder_id=pos_production_order_acceptance.order_id');
        $this->db->where('pos_production_order_acceptance_details.details_item_qty > pos_production_order_acceptance_details.completed_qty');
        $this->db->group_by('pos_production_order_acceptance.order_id');
        $data = $this->db->get()->result();
        return $data;
    }

    function get_complete_orders()
    {
        $this->db->select('pos_production_order_acceptance.*');
        $this->db->from('pos_production_order_acceptance');
        $this->db->join('pos_production_order_acceptance_details', 'pos_production_order_acceptance_details.details_workorder_id=pos_production_order_acceptance.order_id');
        $this->db->group_by('pos_production_order_acceptance.order_id');
        $data = $this->db->get()->result();
        return $data;
    }

    function load_items()
    {
        $this->db->select('pos_item_batch.*,pos_item_master.product_name,pos_item_stock.stock_id');
        $this->db->from('pos_item_batch');
        $this->db->join('pos_item_stock', 'pos_item_stock.batch_id=pos_item_batch.batch_id');
        $this->db->join('pos_item_master', 'pos_item_master.product_id=pos_item_batch.item_id');
        $this->db->order_by('pos_item_batch.item_id');
        $data = $this->db->get()->result();

        return $data;
    }

    function item_details_purchaseEdit($stock_id)
    {
        $this->db->select('pos_item_batch.batch_no,pos_item_batch.sale_price,pos_item_batch.whole_sale,pos_item_batch.mrp,pos_item_master.product_name,pos_item_master.lowest_unit,pos_item_batch.expiry_date,pos_item_stock.quantity,unit.unit_name,pos_item_batch.batch_id,pos_item_master.trading_connection,pos_item_master.barcode');
        $this->db->from('pos_item_batch');
        $this->db->join('pos_item_stock', 'pos_item_stock.batch_id=pos_item_batch.batch_id');
        $this->db->join('pos_item_master', 'pos_item_master.product_id=pos_item_batch.item_id');
        $this->db->join('unit', 'unit_id=pos_item_master.lowest_unit');
        $this->db->where('pos_item_stock.stock_id', $stock_id);
//        $this->db->order_by('pos_item_batch.item_id');
        $data = $this->db->get()->row();

        return $data;
    }

    function get_purchase_details($id)
    {
        $this->db->select('pos_purchase.do_no,pos_purchase.purchase_total,pos_purchase.purchase_discount,pos_purchase.do_date  ,pos_purchase.exchange_rate,vendor.vendor_name,vendor.vendor_address,vendor.vendor_id');
        $this->db->from('pos_purchase');
        $this->db->where('pos_purchase.purchase_id', $id);
        $this->db->join('vendor', 'vendor.vendor_id=pos_purchase.purchase_vendor');
        $data['purchase'] = $this->db->get()->row();

        $this->db->select('*');
        $this->db->from('pos_purchase');
        $this->db->where('pos_purchase.purchase_id', $id);
        $this->db->join('pos_purchase_details', 'pos_purchase.purchase_id=pos_purchase_details.purchase_id');
        $data['details'] = $this->db->get()->result();

        return $data;
    }

    function select_item_report()
    {
        $this->db->select('product_id,product_name');
        $this->db->from('pos_item_master');
        $this->db->order_by('pos_item_master.product_id', 'desc');
        $data = $this->db->get()->result();
        
        return $data;
    }

    public function search_stock_adjust()
    {
        $data = array();
        $this->db->select('pos_stock_adjust.*,user.user_name');
        $this->db->from('pos_stock_adjust');
        $this->db->join('master', 'master.master_id=pos_stock_adjust.stock_adjust_id');
        $this->db->join('user', 'user.user_id=pos_stock_adjust.in_charge');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('pos_stock_adjust.stock_adjust_id', 'asc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_stock_adjust($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $stock_adjust_no = $this->mastermodel->get_ref('stock_adjust_no', 'pos_stock_adjust', 'stock_adjust_no');
        $stock_adjust_id = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'stock_adjust_id' => $stock_adjust_id,
            'stock_adjust_no' => $stock_adjust_no,
            'date' => $this->mastermodel->convert_date_format($postdata['date']),
            'note' => $postdata['note'],
            'in_charge' => $postdata['in_charge'],
        );
        $output = $this->db->insert('pos_stock_adjust', $tblValues);
        $i = 1;
        while (isset($postdata['product_master_' . $i]))
        {

            $dtls_tble = array(
                'stock_adjust_id' => $stock_adjust_id,
                'item_id' => $postdata['item_id_' . $i],
                'stock_id' => $postdata['product_master_' . $i],
                'godown_id' => $postdata['godown_id_' . $i],
                'unit_id' => $postdata['unit_id_' . $i],
                'less_qty' => $postdata['less_qty_' . $i],
                'add_qty' => $postdata['add_qty_' . $i],
            );
            $output = $this->db->insert('pos_stock_adjust_details', $dtls_tble);
            $cdet_id = $this->db->insert_id();
            if (($postdata['less_qty_' . $i]) > 0)
            {
                $this->db->set('quantity', 'quantity -' . $postdata['less_qty_' . $i], false);
                $this->db->where('stock_id', $postdata['product_master_' . $i]);
                $this->db->update('pos_item_stock');
                $s_qty = $postdata['less_qty_' . $i];
                $stock_type = -1;
            } elseif (($postdata['add_qty_' . $i]) > 0)
            {
                $this->db->set('quantity', 'quantity +' . $postdata['add_qty_' . $i], false);
                $this->db->where('stock_id', $postdata['product_master_' . $i]);
                $this->db->update('pos_item_stock');
                $s_qty = $postdata['add_qty_' . $i];
                $stock_type = 1;
            }
            $stock_register_id = $this->mastermodel->insertmasterdata();
            $stockRegtbl = array(
                'stock_register_id' => $stock_register_id,
                'trans_id' => $stock_adjust_id,
                'trans_details_id' => $cdet_id,
                'trans_date' => $this->mastermodel->convert_date_format($postdata['date']),
                'qty' => $s_qty,
                'stock_type' => $stock_type,
                'item_id' => $postdata['item_id_' . $i],
//                'bar_code' => $discount[$i],
                'batch_id' => $postdata['batch_id_' . $i],
                'expiry_date' => $postdata['expiry_date_' . $i],
//                        'price' => $postdata['batch_id_'.$i],
                'trans_category' => 6,
                'godown_id' => $postdata['godown_id_' . $i],
//                'rack_id' => $expiry_date[$i],
//                'bin' => $unit[$i],
//                'status' => $sub_total[$i],
            );
            $this->db->insert('pos_stock_register', $stockRegtbl);
            $i++;
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }

    public function update_stock_adjust($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $stock_adjust_id = $postdata['stock_adjust_id'];
        $tblValues = array(
            'date' => $this->mastermodel->convert_date_format($postdata['date']),
            'note' => $postdata['note'],
        );
        $this->db->where('stock_adjust_id', $stock_adjust_id);
        $output = $this->db->update('pos_stock_adjust', $tblValues);
        $i = 1;
        while (isset($postdata['product_master_' . $i]))
        {

            $dtls_tble = array(
                'godown_id' => $postdata['godown_id_' . $i],
                'less_qty' => $postdata['less_qty_' . $i],
                'add_qty' => $postdata['add_qty_' . $i],
            );
            $this->db->where('details_id', $postdata['details_id_' . $i]);
            $output = $this->db->update('pos_stock_adjust_details', $dtls_tble);
            if (($postdata['less_qty_' . $i]) > 0)
            {

                $prev_qty = $postdata['prev_less_qty_' . $i];
                $curr_qty = $postdata['less_qty_' . $i];
                $new_qty = $prev_qty - $curr_qty;


                $this->db->set('quantity', 'quantity +' . $new_qty, false);
                $this->db->where('stock_id', $postdata['product_master_' . $i]);
                $this->db->update('pos_item_stock');
                $s_qty = $postdata['less_qty_' . $i];
            } elseif (($postdata['add_qty_' . $i]) > 0)
            {

                $prev_qty = $postdata['prev_add_qty_' . $i];
                $curr_qty = $postdata['add_qty_' . $i];
                $new_qty = $prev_qty - $curr_qty;

                $this->db->set('quantity', 'quantity -' . $new_qty, false);
                $this->db->where('stock_id', $postdata['product_master_' . $i]);
                $this->db->update('pos_item_stock');
                $s_qty = $postdata['add_qty_' . $i];
            }
            $stockRegtbl = array(
                'trans_date' => $this->mastermodel->convert_date_format($postdata['date']),
                'qty' => $s_qty,
//                        'price' => $postdata['batch_id_'.$i],
                'trans_category' => 6,
                'godown_id' => $postdata['godown_id_' . $i],
//                'rack_id' => $expiry_date[$i],
//                'bin' => $unit[$i],
//                'status' => $sub_total[$i],
            );
            $this->db->where('trans_details_id', $postdata['details_id_' . $i]);
            $this->db->update('pos_stock_register', $stockRegtbl);
            $i++;
        }
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
    public function search_root_creation()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('pos_root');
        $this->db->join('master', 'master.master_id=pos_root.root_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('pos_root.root_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }

    public function insert_root_creation($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $item_code = $this->mastermodel->get_ref('root_code', 'pos_root', 'root_code');
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'root_id' => $masterid,
            'root_code' => $item_code,
            'root_name' => $postdata['root_name'],
            'roote_note' => $postdata['roote_note'],
        );
        $this->db->insert('pos_root', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    public function update_root_creation($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'root_name' => $postdata['root_name'],
            'roote_note' => $postdata['roote_note'],
        );
        $this->db->where('root_id', $postdata['root_id']);
        $this->db->update('pos_root', $tblValues);
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    public function search_customer_rootsettings()
    {
        $data = array();
        $this->db->select('*');
        $this->db->from('pos_rootsettings');
        $this->db->join('master', 'master.master_id=pos_rootsettings.rootsettings_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('pos_rootsettings.rootsettings_id', 'desc');
        $this->db->order_by('pos_rootsettings.root_id', 'desc');
        $data['results'] = $this->db->get();
        return $data;
    }
      public function insert_customer_rootsettings($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $masterid = $this->mastermodel->insertmasterdata();
        $tblValues = array(
            'rootsettings_id' => $masterid,
            'root_id' => $postdata['root_id']
        );
        $this->db->insert('pos_rootsettings', $tblValues);
        $i = 0;
        while (!empty($postdata['customer_id' . ++$i]))
        {
            $contact = $this->mastermodel->insertmasterdata();
            $Values = array(
                'details_id' => $contact,
                'rootsettings_id' => $masterid,
                'customer_id' => $postdata['customer_id' . $i],
                'order_no' => $postdata['order_no' . $i]
            );
            $this->db->insert('pos_rootsettings_details', $Values);
        }
        
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
      public function update_customer_rootsettings($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'root_id' => $postdata['root_id']
        );
        $this->db->where('pos_rootsettings.rootsettings_id', $postdata['rootsettings_id']);
        $this->db->update('pos_rootsettings', $tblValues);
        
        $this->db->where('pos_rootsettings_details.rootsettings_id', $postdata['rootsettings_id']);
        $this->db->delete('pos_rootsettings_details');
        $i = 0;
        while (!empty($postdata['customer_id' . ++$i]))
        {
            $contact = $this->mastermodel->insertmasterdata();
            $Values = array(
                'details_id' => $contact,
                'rootsettings_id' => $postdata['rootsettings_id'],
                'customer_id' => $postdata['customer_id' . $i],
                'order_no' => $postdata['order_no' . $i]
            );
            $this->db->insert('pos_rootsettings_details', $Values);
        }
        
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Added Successfully';
            return $data;
        }
    }
    function batch_data_by_stock_id($id)
    {
        $this->db->select('*');
        $this->db->from('pos_item_stock');
        $this->db->where('pos_item_stock.stock_id', $id);
        $this->db->join('pos_item_batch','pos_item_batch.batch_id=pos_item_stock.batch_id');
        $data = $this->db->get()->row();
        return $data;
    }
    function search_price_change()
    {
        $data = array();
        $this->db->select('*,pos_item_batch.sale_price as prize');
        $this->db->from('pos_item_batch');
         $this->db->join('pos_item_master', 'pos_item_master.product_id=pos_item_batch.item_id');
        $this->db->join('master', 'master.master_id=pos_item_master.product_id');
        $this->db->where('master.project_id', $_SESSION['project_id']);
        $this->db->order_by('pos_item_batch.batch_id', 'desc');
        $data['results'] = $this->db->get();
        return $data; 
    }
    function update_price_change($postdata)
    {
        $data = array();
        $this->db->trans_begin();
        $tblValues = array(
            'sale_price' => $postdata['new_sale_price']
        );
        $this->db->where('pos_item_batch.batch_id', $postdata['batch_id']);
        $this->db->update('pos_item_batch', $tblValues);
        
          $this->db->where('pos_item_stock.batch_id', $postdata['batch_id']);
        $this->db->update('pos_item_stock', $tblValues);
        
       
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
            $data['res'] = 0;
            $data['msg'] = 'Error On Adding Record';
            return $data;
        } else
        {
            $this->db->trans_commit();
            $data['res'] = 1;
            $data['msg'] = 'Record Updated Successfully';
            return $data;
        }
    }
}

?>
