<!DOCTYPE html>
<html>


    <style>

        #map {
            width: 100%;
            height: 400px;
        }
        #searchInput{
            width:50%;
            margin-left:2px;
            margin-top: 10px;
        }

    </style>
    <body>
        <input id="searchInput" class="controls" type="text" placeholder="Enter a location">


        <div id="mapdiv" style="width:100%;height:300px"></div>

        <script async defer
                src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDVeTV1_nMBIJPD8fgeX39mcfwhcIrx3B0&libraries=places&callback=myMap">
        </script>
        <script>

            var map;
            function myMap()
            {

                var opts = {'center': new google.maps.LatLng(21.4735, 55.9754),
                    'zoom': 6, 'mapTypeId': google.maps.MapTypeId.ROADMAP}
                geocoder = new google.maps.Geocoder();
                map = new google.maps.Map(document.getElementById('mapdiv'), opts);

                var input = document.getElementById('searchInput');
                map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);

                var autocomplete = new google.maps.places.Autocomplete(input);
                autocomplete.bindTo('bounds', map);

                var infowindow = new google.maps.InfoWindow();
                var marker = new google.maps.Marker({
                    map: map,
                    anchorPoint: new google.maps.Point(0, -29),
                });
                $("#lng").blur(function () {
                    var lat = $('#lat').val();
                    var lng = $('#lng').val();
                    var latlng = new google.maps.LatLng(lat, lng);
                    marker = new google.maps.Marker({map: map, icon: image, position: new google.maps.LatLng(lat, lng)});
                    map.setCenter(new google.maps.LatLng(lat, lng));
                });
                $("#address").blur(function () {
                    var address = $('#address').val();
                    geocoder.geocode({address: address}, function (results, status)
                    {
                        if (status == google.maps.GeocoderStatus.OK) {
                            var p = results[0].geometry.location;
                            var lat = p.lat();
                            var lng = p.lng();
                            var latlng = new google.maps.LatLng(lat, lng);
                            marker = new google.maps.Marker({map: map, icon: image, position: new google.maps.LatLng(lat, lng)});
                            map.setCenter(new google.maps.LatLng(lat, lng));
                        }
                    }
                    );
                });
                autocomplete.addListener('place_changed', function () {
                    infowindow.close();
                    marker.setVisible(false);
                    var place = autocomplete.getPlace();
                    if (!place.geometry) {
                        window.alert("Autocomplete's returned place contains no geometry");
                        return;
                    }
                    if (place.geometry.viewport) {
                        map.fitBounds(place.geometry.viewport);
                    } else {
                        map.setCenter(place.geometry.location);
                        map.setZoom(17);
                    }
                    document.getElementById('lat').value = place.geometry.location.lat();
                    document.getElementById('lng').value = place.geometry.location.lng();
                    //marker.setPosition(location);
                    getAddress(place.geometry.location);
                    marker.setPosition(place.geometry.location);
                    marker.setVisible(true);

                    var address = '';
                    if (place.address_components) {
                        address = [
                            (place.address_components[0] && place.address_components[0].short_name || ''),
                            (place.address_components[1] && place.address_components[1].short_name || ''),
                            (place.address_components[2] && place.address_components[2].short_name || '')
                        ].join(' ');
                    }

                    infowindow.setContent('<div><strong>' + place.name + '</strong><br>' + address);


                    //        for (var i = 0; i < place.address_components.length; i++) {
                    //
                    //            if(place.address_components[i].types[0] == 'country'){
                    //                document.getElementById('country').innerHTML = place.formatted_address_components[i].long_name;
                    //            }
                    //        }
                    //        document.getElementById('lat').value = place.geometry.location.lat();
                    //        document.getElementById('lng').value = place.geometry.location.lng();
                });
                google.maps.event.addListener(map, 'click', function (event) {
                    placeMarker(event.latLng, marker);
                });
                function placeMarker(location) {
                    if (marker) { //on vérifie si le marqueur existe
                        marker.setPosition(location); //on change sa position
                    } else {
                        marker = new google.maps.Marker({//on créé le marqueur
                            position: location,
                            map: map
                        });
                    }
                    document.getElementById('lat').value = location.lat();
                    document.getElementById('lng').value = location.lng();
                    //marker.setPosition(location);
                    getAddress(location);
                }

                function getAddress(latLng) {
                    geocoder.geocode({'latLng': latLng},
                    function (results, status) {
                        if (status == google.maps.GeocoderStatus.OK) {
                            if (results[0]) {
                                //marker.setPosition(latLng); 
                                document.getElementById("address").value = results[0].formatted_address;
                            }
                            else {
                                document.getElementById("address").value = "No results";
                            }
                        }
                        else {
                            document.getElementById("address").value = status;
                        }
                    });
                }

            }

        </script>



        <br>        
        <div class="row">
            <div class="col-md-6">
               <div class="form-group">
                    <label for="latclicked" class="col-sm-4 control-label">NorthEast</label> 
                     <div class="col-sm-6">             
                        <input type="text"  name="latclicked" id="lat" class="m-wrap span12  form-control" style="width:100px"/>
                    </div>
                </div>  </div>
            <div class="col-md-6">
               <div class="form-group">
                    <label for="longclicked" class="col-sm-4 control-label">SouthEast</label> 
                     <div class="col-sm-6">             
                        <input type="text"  name="longclicked" id="lng" class="m-wrap span12  form-control" style="width:100px"/>
                    </div>
                </div>  </div>
             </div> 
        <div class="row">
            <div class="col-md-6">
               <div class="form-group">
                    <label for="latclicked" class="col-sm-4 control-label">Location</label> 
                     <div class="col-sm-6">             
                       <textarea   name="address" id="address" class="m-wrap span12  form-control" style="width:300px" /></textarea>
                    </div>
                </div>  </div>
            
        </div>

        <ul id="geoData"  hidden="true">
            <li>Full Address: <span id="location"></span></li>
            <li>Postal Code: <span id="postal_code"></span></li>
            <li>Country: <span id="country"></span></li>
            <li>Latitude: <span id="lat"></span></li>
            <li>Longitude: <span id="lon"></span></li>
        </ul>


    </body>
</html>

