<!DOCTYPE html>
<html>
<head>
    <?php
    $this->load->view('header');
    $this->load->view('commonfunctions');
    $this->load->view('commonjsfiles');
    ?>
    <link rel="stylesheet" href="https://cdn.rawgit.com/t4t5/sweetalert/v0.2.0/lib/sweet-alert.css">
    <script src="https://cdn.rawgit.com/t4t5/sweetalert/v0.2.0/lib/sweet-alert.min.js"></script>
    <style>
        .dashboard-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            grid-gap: 20px;
        }
        .card {
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
            padding: 20px;
            text-align: center;
            border-top: 5px solid #d66d00;
        }
        .card-icon img {
            height: 50px;
            margin-bottom: 15px;
        }
        .card-title {
            font-size: 1.5rem;
            margin-bottom: 10px;
        }
        .card-number {
            font-size: 2rem;
            font-weight: bold;
        }
        .bg-hash {
            background: #f8fafb;
        }
        .dashboard-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr); /* 4 tiles in a single row */
    grid-gap: 20px;
}

    </style>
</head>
<body class="hold-transition skin-blue sidebar-mini" style="overflow: scroll;">
<div class="wrapper" style="overflow: hidden;">
    <?php $this->load->view('top'); ?>
    <aside class="main-sidebar">
        <section class="sidebar">
            <div class="user-panel">
                <div class="pull-left image">
                    <?php if(!empty($_SESSION['user_prof'])): ?>
                        <img src="<?= base_url() ?>assets/uploads/profile.png" class="img-circle" alt="User Image">
                    <?php else: ?>
                        <img src="<?= base_url() ?>assets/uploads/profile.png" class="img-circle" alt="User Image">
                    <?php endif; ?>
                </div>
                <div class="pull-left info">
                    <p><?= $_SESSION['user_name'] ?></p>
                    <a href="#"><i class="fa fa-circle text-success"></i> Online</a>
                </div>
            </div>
            <?php $this->load->view('menu'); ?>
        </section>
    </aside>
    <div class="content-wrapper">
        <section class="content-header">
            <h1>Dashboard <small>Control panel</small></h1>
            <ol class="breadcrumb">
                <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
                <li class="active">Dashboard</li>
            </ol>
        </section>
        <section class="content">
            <div class="dashboard-grid">
                <!-- Active Legal Cases Card -->
                <div class="card">
                    <div class="card-icon bg-hash">
                        <img src="<?= base_url() ?>assets/img/legal-document.png">
                    </div>
                    <div class="card-title">Active Legal Cases</div>
                    <div class="card-number">
                        <?php
                        echo $this->clientmodel->get_complaints_dashboard('complaints_is_settled', '0', 'complaints_lawyer_id !=', '0');
                        ?>
                    </div>
                </div>

                <!-- Closed Cases Card -->
                <div class="card">
                    <div class="card-icon bg-hash">
                        <img src="<?= base_url() ?>assets/img/compliant.png">
                    </div>
                    <div class="card-title">Closed Cases</div>
                    <div class="card-number">
                        <?php
                        echo $this->clientmodel->get_complaints_dashboard('complaints_is_settled', '1');
                        ?>
                    </div>
                </div>
            </div>
        </section>
        

    </div>
    <?php $this->load->view('footer'); ?>
    <div class="control-sidebar-bg"></div>
</div>
</body>
</html>
