<?php
//============================================================+
// File name   : example_051.php
// Begin       : 2009-04-16
// Last Update : 2013-05-14
//
// Description : Example 051 for TCPDF class
//               Full page background
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Nicola Asuni
//               Tecnick.com LTD
//               www.tecnick.com
//               info@tecnick.com
//============================================================+

/**
 * Creates an example PDF TEST document using TCPDF
 * @package com.tecnick.tcpdf
 * @abstract TCPDF - Example: Full page background
 * @author Nicola Asuni
 * @since 2009-04-16
 */

// Include the main TCPDF library (search for installation path).



// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {
    //Page header
      public function Header() {
          
       
        // get the current page break margin
        $bMargin = $this->getBreakMargin();
        // get current auto-page-break mode
        $auto_page_break = $this->AutoPageBreak;
        // disable auto-page-break
        $this->SetAutoPageBreak(true,  PDF_MARGIN_BOTTOM);
        // set bacground image
         
        $img_file = base_url().'assets/uploads/'.$_SESSION['logo'];
        $this->Image($img_file, 0, 0, 80, 28, '', '', '', false, 300, '', false, false, 0);
        // restore auto-page-break status
        $this->SetAutoPageBreak($auto_page_break, $bMargin);
        // set the starting point for the page content
        $this->setPageMark();
    }
    // Page footer
    public function Footer() {
       
        $this->SetY(-15);
         $this->SetFont('helvetica', 'I', 8);
            $this->Cell(0, 15, $_SESSION['company_address'], 0, false, 'C', 0, '', 0, false, 'M', 'M');
         $this->Cell(0, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
        // Set font
        
            }
    
}

// create new PDF document
$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
$pdf->SetCreator(PDF_CREATOR);
//$pdf->SetAuthor('Nicola Asuni');
$pdf->SetTitle('Employee Shift  Report');
//$pdf->SetSubject('TCPDF Tutorial');
//$pdf->SetKeywords('TCPDF, PDF, example, test, guide');

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(0);
$pdf->SetFooterMargin(0);
$_SESSION['company_address'] = $company_address;
$_SESSION['logo'] = $logo;
// remove default footer
$pdf->setPrintFooter(false);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
    require_once(dirname(__FILE__).'/lang/eng.php');
    $pdf->setLanguageArray($l);
}

// ---------------------------------------------------------

// set font
$pdf->SetFont('times', '', 48);

$pdf->setPrintHeader(true);
$pdf->SetMargins(20, 40, 20, true);
// add a page
$page_format = array(
    'MediaBox' => array ('llx' => 0, 'lly' => 0, 'urx' => 210, 'ury' => 297),
    'CropBox' => array ('llx' => 0, 'lly' => 0, 'urx' => 210, 'ury' => 297),
    'BleedBox' => array ('llx' => 5, 'lly' => 5, 'urx' => 205, 'ury' => 292),
    'TrimBox' => array ('llx' => 10, 'lly' => 10, 'urx' => 200, 'ury' => 287),
    'ArtBox' => array ('llx' => 15, 'lly' => 15, 'urx' => 195, 'ury' => 282),
    'Dur' => 3,
    'trans' => array(
        'D' => 1.5,
        'S' => 'Split',
        'Dm' => 'V',
        'M' => 'O'
    ),
    'Rotate' => 90,
    'PZ' => 1,
);
$pdf->AddPage();
//'P', $page_format, false, false
$bMargin = $pdf->getBreakMargin();
// get current auto-page-break mode
$auto_page_break = $pdf->getAutoPageBreak();
// disable auto-page-break
$pdf->SetAutoPageBreak(true,PDF_MARGIN_BOTTOM);
// set bacground image
// restore auto-page-break status


//$pdf->SetAutoPageBreak($auto_page_break, $bMargin);
// set the starting point for the page content
$pdf->setPageMark();
// Print a text
// set some text to print

$pdf->SetFont('helvetica', 'B', 20);

$html = '<div style="text-align:center"><u>Shift Report</u></div><br>';
$pdf->writeHTML($html, true, false, true, false, '');

$pdf->SetFont('helvetica', '', 8);
//$pdf->StartTransform();
//$pdf->Rotate(90);
$tbl = '<table  cellpadding="4" border="1"  width="100%">
      
        <thead>';


function dateRange($first, $last, $step = '+1 month', $format = 'Y-m-d' ) {
    $dates = array();
    $current = strtotime($first);
    $last = strtotime($last);
    
    while( $current <= $last ) { 
        $dates[] = date($format, $current);
        $current = strtotime($step, $current);
    }
    return $dates;
}
$orderdate = explode('/', $frmdate);
$day = $orderdate[0];
$month   = $orderdate[1];
$year  = $orderdate[2];
$frmdate=$day.'-'.$month.'-'.$year;

$orderdate1 = explode('/', $todate);
$day1 = $orderdate1[0];
$month1   = $orderdate1[1];
$year1  = $orderdate1[2];
$todate=$day1.'-'.$month1.'-'.$year1;
$title= dateRange($frmdate, $todate ,"+1 day");
    
             $tbl.=' <tr nobr="true">
              <th style="font-style:italic;font-size:16px;" color="#000">Sl No</th>
                    <th style="font-style:italic;font-size:16px;" color="#000">Employee Name </th>';
             foreach ($title as $value) {
   $tbl.='  <th style="font-style:italic;font-size:16px;" color="#000">'.$this->mastermodel->convertdatenormalformat($value).' </th>';
             }
   
   $tbl.=' </tr>
        </thead>
        <tbody>';

            
           $i=1;
    
       
    foreach ($viewinfo as $key => $list) 
    {
            
               $tbl.='<tr nobr="true">
                   <td style="font-style:italic;font-size:16px;" color="#000" >'.$i.'</td>
                    <td style="font-style:italic;font-size:16px;" color="#000">'.$list->hr_employees_name.'</td>';
                foreach ($title as $value) {
                  $attendance = $this->hrreportmodel->get_attendance_check($list->hr_employees_id,$value);
                  if($attendance> 0)
                  {
                      $status="P";
                  }
                else {
                    $holiday = $this->hrreportmodel->get_holiday_check($value);
                        if($holiday> 0)
                      {
                          $status="H";
                      }
                        else {
                             $leave = $this->hrreportmodel->get_leave_check($list->hr_employees_id,$value);
//                             echo $leave;
                                if($leave> 0)
                                {
                                 $status="L";
                                }
                                else {
                                    $status="A";
                                }
                        }
                   
                    
                }
               
                  $tbl.=' <td style="font-style:italic;font-size:16px;" color="#000">'.$status.'</td>';
                      }
                      
                      $tbl.='  </tr>';
   $i++; }
        $tbl.='  </tbody>
    </table>';

$pdf->writeHTML($tbl, true, false, true, false, '');
//$pdf->StopTransform();

$pdf->setPrintFooter(true);

//Close and output PDF documentAll Files	/var/www/html/qzaakacc_new/assets/images
//$pdf->Output('/var/www/html/qzaakacc_new/assets/quotation/'.$id.'.pdf', 'F');
//$pdf->Output('/var/www/html/demo/qzaakacc_new/assets/quotation/'.$id.'.pdf', 'F');
//============================================================+
// END OF FILE
//============================================================+
$pdf->Output('ShiftReport.pdf', 'I');

//============================================================+
// END OF FILE
//============================================================+