<?php
// This file was auto-generated from sdk-root/src/data/pinpoint-email/2018-07-26/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2018-07-26', 'endpointPrefix' => 'email', 'jsonVersion' => '1.1', 'protocol' => 'rest-json', 'serviceAbbreviation' => 'Pinpoint Email', 'serviceFullName' => 'Amazon Pinpoint Email Service', 'serviceId' => 'Pinpoint Email', 'signatureVersion' => 'v4', 'signingName' => 'ses', 'targetPrefix' => 'com.amazonaws.services.pinpoint.email', 'uid' => 'pinpoint-email-2018-07-26', ], 'operations' => [ 'CreateConfigurationSet' => [ 'name' => 'CreateConfigurationSet', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/email/configuration-sets', ], 'input' => [ 'shape' => 'CreateConfigurationSetRequest', ], 'output' => [ 'shape' => 'CreateConfigurationSetResponse', ], 'errors' => [ [ 'shape' => 'AlreadyExistsException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'BadRequestException', ], ], ], 'CreateConfigurationSetEventDestination' => [ 'name' => 'CreateConfigurationSetEventDestination', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/email/configuration-sets/{ConfigurationSetName}/event-destinations', ], 'input' => [ 'shape' => 'CreateConfigurationSetEventDestinationRequest', ], 'output' => [ 'shape' => 'CreateConfigurationSetEventDestinationResponse', ], 'errors' => [ [ 'shape' => 'NotFoundException', ], [ 'shape' => 'AlreadyExistsException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'BadRequestException', ], ], ], 'CreateDedicatedIpPool' => [ 'name' => 'CreateDedicatedIpPool', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/email/dedicated-ip-pools', ], 'input' => [ 'shape' => 'CreateDedicatedIpPoolRequest', ], 'output' => [ 'shape' => 'CreateDedicatedIpPoolResponse', ], 'errors' => [ [ 'shape' => 'AlreadyExistsException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'BadRequestException', ], ], ], 'CreateEmailIdentity' => [ 'name' => 'CreateEmailIdentity', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/email/identities', ], 'input' => [ 'shape' => 'CreateEmailIdentityRequest', ], 'output' => [ 'shape' => 'CreateEmailIdentityResponse', ], 'errors' => [ [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'BadRequestException', ], ], ], 'DeleteConfigurationSet' => [ 'name' => 'DeleteConfigurationSet', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v1/email/configuration-sets/{ConfigurationSetName}', ], 'input' => [ 'shape' => 'DeleteConfigurationSetRequest', ], 'output' => [ 'shape' => 'DeleteConfigurationSetResponse', ], 'errors' => [ [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'BadRequestException', ], ], ], 'DeleteConfigurationSetEventDestination' => [ 'name' => 'DeleteConfigurationSetEventDestination', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v1/email/configuration-sets/{ConfigurationSetName}/event-destinations/{EventDestinationName}', ], 'input' => [ 'shape' => 'DeleteConfigurationSetEventDestinationRequest', ], 'output' => [ 'shape' => 'DeleteConfigurationSetEventDestinationResponse', ], 'errors' => [ [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'BadRequestException', ], ], ], 'DeleteDedicatedIpPool' => [ 'name' => 'DeleteDedicatedIpPool', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v1/email/dedicated-ip-pools/{PoolName}', ], 'input' => [ 'shape' => 'DeleteDedicatedIpPoolRequest', ], 'output' => [ 'shape' => 'DeleteDedicatedIpPoolResponse', ], 'errors' => [ [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'BadRequestException', ], ], ], 'DeleteEmailIdentity' => [ 'name' => 'DeleteEmailIdentity', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v1/email/identities/{EmailIdentity}', ], 'input' => [ 'shape' => 'DeleteEmailIdentityRequest', ], 'output' => [ 'shape' => 'DeleteEmailIdentityResponse', ], 'errors' => [ [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'BadRequestException', ], ], ], 'GetAccount' => [ 'name' => 'GetAccount', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/email/account', ], 'input' => [ 'shape' => 'GetAccountRequest', ], 'output' => [ 'shape' => 'GetAccountResponse', ], 'errors' => [ [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'BadRequestException', ], ], ], 'GetConfigurationSet' => [ 'name' => 'GetConfigurationSet', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/email/configuration-sets/{ConfigurationSetName}', ], 'input' => [ 'shape' => 'GetConfigurationSetRequest', ], 'output' => [ 'shape' => 'GetConfigurationSetResponse', ], 'errors' => [ [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'BadRequestException', ], ], ], 'GetConfigurationSetEventDestinations' => [ 'name' => 'GetConfigurationSetEventDestinations', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/email/configuration-sets/{ConfigurationSetName}/event-destinations', ], 'input' => [ 'shape' => 'GetConfigurationSetEventDestinationsRequest', ], 'output' => [ 'shape' => 'GetConfigurationSetEventDestinationsResponse', ], 'errors' => [ [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'BadRequestException', ], ], ], 'GetDedicatedIp' => [ 'name' => 'GetDedicatedIp', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/email/dedicated-ips/{IP}', ], 'input' => [ 'shape' => 'GetDedicatedIpRequest', ], 'output' => [ 'shape' => 'GetDedicatedIpResponse', ], 'errors' => [ [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'BadRequestException', ], ], ], 'GetDedicatedIps' => [ 'name' => 'GetDedicatedIps', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/email/dedicated-ips', ], 'input' => [ 'shape' => 'GetDedicatedIpsRequest', ], 'output' => [ 'shape' => 'GetDedicatedIpsResponse', ], 'errors' => [ [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'BadRequestException', ], ], ], 'GetEmailIdentity' => [ 'name' => 'GetEmailIdentity', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/email/identities/{EmailIdentity}', ], 'input' => [ 'shape' => 'GetEmailIdentityRequest', ], 'output' => [ 'shape' => 'GetEmailIdentityResponse', ], 'errors' => [ [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'BadRequestException', ], ], ], 'ListConfigurationSets' => [ 'name' => 'ListConfigurationSets', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/email/configuration-sets', ], 'input' => [ 'shape' => 'ListConfigurationSetsRequest', ], 'output' => [ 'shape' => 'ListConfigurationSetsResponse', ], 'errors' => [ [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'BadRequestException', ], ], ], 'ListDedicatedIpPools' => [ 'name' => 'ListDedicatedIpPools', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/email/dedicated-ip-pools', ], 'input' => [ 'shape' => 'ListDedicatedIpPoolsRequest', ], 'output' => [ 'shape' => 'ListDedicatedIpPoolsResponse', ], 'errors' => [ [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'BadRequestException', ], ], ], 'ListEmailIdentities' => [ 'name' => 'ListEmailIdentities', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/email/identities', ], 'input' => [ 'shape' => 'ListEmailIdentitiesRequest', ], 'output' => [ 'shape' => 'ListEmailIdentitiesResponse', ], 'errors' => [ [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'BadRequestException', ], ], ], 'PutAccountDedicatedIpWarmupAttributes' => [ 'name' => 'PutAccountDedicatedIpWarmupAttributes', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v1/email/account/dedicated-ips/warmup', ], 'input' => [ 'shape' => 'PutAccountDedicatedIpWarmupAttributesRequest', ], 'output' => [ 'shape' => 'PutAccountDedicatedIpWarmupAttributesResponse', ], 'errors' => [ [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'BadRequestException', ], ], ], 'PutAccountSendingAttributes' => [ 'name' => 'PutAccountSendingAttributes', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v1/email/account/sending', ], 'input' => [ 'shape' => 'PutAccountSendingAttributesRequest', ], 'output' => [ 'shape' => 'PutAccountSendingAttributesResponse', ], 'errors' => [ [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'BadRequestException', ], ], ], 'PutConfigurationSetDeliveryOptions' => [ 'name' => 'PutConfigurationSetDeliveryOptions', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v1/email/configuration-sets/{ConfigurationSetName}/delivery-options', ], 'input' => [ 'shape' => 'PutConfigurationSetDeliveryOptionsRequest', ], 'output' => [ 'shape' => 'PutConfigurationSetDeliveryOptionsResponse', ], 'errors' => [ [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'BadRequestException', ], ], ], 'PutConfigurationSetReputationOptions' => [ 'name' => 'PutConfigurationSetReputationOptions', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v1/email/configuration-sets/{ConfigurationSetName}/reputation-options', ], 'input' => [ 'shape' => 'PutConfigurationSetReputationOptionsRequest', ], 'output' => [ 'shape' => 'PutConfigurationSetReputationOptionsResponse', ], 'errors' => [ [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'BadRequestException', ], ], ], 'PutConfigurationSetSendingOptions' => [ 'name' => 'PutConfigurationSetSendingOptions', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v1/email/configuration-sets/{ConfigurationSetName}/sending', ], 'input' => [ 'shape' => 'PutConfigurationSetSendingOptionsRequest', ], 'output' => [ 'shape' => 'PutConfigurationSetSendingOptionsResponse', ], 'errors' => [ [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'BadRequestException', ], ], ], 'PutConfigurationSetTrackingOptions' => [ 'name' => 'PutConfigurationSetTrackingOptions', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v1/email/configuration-sets/{ConfigurationSetName}/tracking-options', ], 'input' => [ 'shape' => 'PutConfigurationSetTrackingOptionsRequest', ], 'output' => [ 'shape' => 'PutConfigurationSetTrackingOptionsResponse', ], 'errors' => [ [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'BadRequestException', ], ], ], 'PutDedicatedIpInPool' => [ 'name' => 'PutDedicatedIpInPool', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v1/email/dedicated-ips/{IP}/pool', ], 'input' => [ 'shape' => 'PutDedicatedIpInPoolRequest', ], 'output' => [ 'shape' => 'PutDedicatedIpInPoolResponse', ], 'errors' => [ [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'BadRequestException', ], ], ], 'PutDedicatedIpWarmupAttributes' => [ 'name' => 'PutDedicatedIpWarmupAttributes', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v1/email/dedicated-ips/{IP}/warmup', ], 'input' => [ 'shape' => 'PutDedicatedIpWarmupAttributesRequest', ], 'output' => [ 'shape' => 'PutDedicatedIpWarmupAttributesResponse', ], 'errors' => [ [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'BadRequestException', ], ], ], 'PutEmailIdentityDkimAttributes' => [ 'name' => 'PutEmailIdentityDkimAttributes', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v1/email/identities/{EmailIdentity}/dkim', ], 'input' => [ 'shape' => 'PutEmailIdentityDkimAttributesRequest', ], 'output' => [ 'shape' => 'PutEmailIdentityDkimAttributesResponse', ], 'errors' => [ [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'BadRequestException', ], ], ], 'PutEmailIdentityFeedbackAttributes' => [ 'name' => 'PutEmailIdentityFeedbackAttributes', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v1/email/identities/{EmailIdentity}/feedback', ], 'input' => [ 'shape' => 'PutEmailIdentityFeedbackAttributesRequest', ], 'output' => [ 'shape' => 'PutEmailIdentityFeedbackAttributesResponse', ], 'errors' => [ [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'BadRequestException', ], ], ], 'PutEmailIdentityMailFromAttributes' => [ 'name' => 'PutEmailIdentityMailFromAttributes', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v1/email/identities/{EmailIdentity}/mail-from', ], 'input' => [ 'shape' => 'PutEmailIdentityMailFromAttributesRequest', ], 'output' => [ 'shape' => 'PutEmailIdentityMailFromAttributesResponse', ], 'errors' => [ [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'BadRequestException', ], ], ], 'SendEmail' => [ 'name' => 'SendEmail', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/email/outbound-emails', ], 'input' => [ 'shape' => 'SendEmailRequest', ], 'output' => [ 'shape' => 'SendEmailResponse', ], 'errors' => [ [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'AccountSuspendedException', ], [ 'shape' => 'SendingPausedException', ], [ 'shape' => 'MessageRejected', ], [ 'shape' => 'MailFromDomainNotVerifiedException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'BadRequestException', ], ], ], 'UpdateConfigurationSetEventDestination' => [ 'name' => 'UpdateConfigurationSetEventDestination', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v1/email/configuration-sets/{ConfigurationSetName}/event-destinations/{EventDestinationName}', ], 'input' => [ 'shape' => 'UpdateConfigurationSetEventDestinationRequest', ], 'output' => [ 'shape' => 'UpdateConfigurationSetEventDestinationResponse', ], 'errors' => [ [ 'shape' => 'NotFoundException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'BadRequestException', ], ], ], ], 'shapes' => [ 'AccountSuspendedException' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'AlreadyExistsException' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'AmazonResourceName' => [ 'type' => 'string', ], 'BadRequestException' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'BehaviorOnMxFailure' => [ 'type' => 'string', 'enum' => [ 'USE_DEFAULT_VALUE', 'REJECT_MESSAGE', ], ], 'Body' => [ 'type' => 'structure', 'members' => [ 'Text' => [ 'shape' => 'Content', ], 'Html' => [ 'shape' => 'Content', ], ], ], 'Charset' => [ 'type' => 'string', ], 'CloudWatchDestination' => [ 'type' => 'structure', 'required' => [ 'DimensionConfigurations', ], 'members' => [ 'DimensionConfigurations' => [ 'shape' => 'CloudWatchDimensionConfigurations', ], ], ], 'CloudWatchDimensionConfiguration' => [ 'type' => 'structure', 'required' => [ 'DimensionName', 'DimensionValueSource', 'DefaultDimensionValue', ], 'members' => [ 'DimensionName' => [ 'shape' => 'DimensionName', ], 'DimensionValueSource' => [ 'shape' => 'DimensionValueSource', ], 'DefaultDimensionValue' => [ 'shape' => 'DefaultDimensionValue', ], ], ], 'CloudWatchDimensionConfigurations' => [ 'type' => 'list', 'member' => [ 'shape' => 'CloudWatchDimensionConfiguration', ], ], 'ConfigurationSetName' => [ 'type' => 'string', ], 'ConfigurationSetNameList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ConfigurationSetName', ], ], 'Content' => [ 'type' => 'structure', 'required' => [ 'Data', ], 'members' => [ 'Data' => [ 'shape' => 'MessageData', ], 'Charset' => [ 'shape' => 'Charset', ], ], ], 'CreateConfigurationSetEventDestinationRequest' => [ 'type' => 'structure', 'required' => [ 'ConfigurationSetName', 'EventDestinationName', 'EventDestination', ], 'members' => [ 'ConfigurationSetName' => [ 'shape' => 'ConfigurationSetName', 'location' => 'uri', 'locationName' => 'ConfigurationSetName', ], 'EventDestinationName' => [ 'shape' => 'EventDestinationName', ], 'EventDestination' => [ 'shape' => 'EventDestinationDefinition', ], ], ], 'CreateConfigurationSetEventDestinationResponse' => [ 'type' => 'structure', 'members' => [], ], 'CreateConfigurationSetRequest' => [ 'type' => 'structure', 'members' => [ 'ConfigurationSetName' => [ 'shape' => 'ConfigurationSetName', ], 'TrackingOptions' => [ 'shape' => 'TrackingOptions', ], 'DeliveryOptions' => [ 'shape' => 'DeliveryOptions', ], 'ReputationOptions' => [ 'shape' => 'ReputationOptions', ], 'SendingOptions' => [ 'shape' => 'SendingOptions', ], ], ], 'CreateConfigurationSetResponse' => [ 'type' => 'structure', 'members' => [], ], 'CreateDedicatedIpPoolRequest' => [ 'type' => 'structure', 'required' => [ 'PoolName', ], 'members' => [ 'PoolName' => [ 'shape' => 'PoolName', ], ], ], 'CreateDedicatedIpPoolResponse' => [ 'type' => 'structure', 'members' => [], ], 'CreateEmailIdentityRequest' => [ 'type' => 'structure', 'required' => [ 'EmailIdentity', ], 'members' => [ 'EmailIdentity' => [ 'shape' => 'Identity', ], ], ], 'CreateEmailIdentityResponse' => [ 'type' => 'structure', 'members' => [ 'IdentityType' => [ 'shape' => 'IdentityType', ], 'VerifiedForSendingStatus' => [ 'shape' => 'Enabled', ], 'DkimAttributes' => [ 'shape' => 'DkimAttributes', ], ], ], 'CustomRedirectDomain' => [ 'type' => 'string', ], 'DedicatedIp' => [ 'type' => 'structure', 'required' => [ 'Ip', 'WarmupStatus', 'WarmupPercentage', ], 'members' => [ 'Ip' => [ 'shape' => 'Ip', ], 'WarmupStatus' => [ 'shape' => 'WarmupStatus', ], 'WarmupPercentage' => [ 'shape' => 'Percentage100Wrapper', ], 'PoolName' => [ 'shape' => 'PoolName', ], ], ], 'DedicatedIpList' => [ 'type' => 'list', 'member' => [ 'shape' => 'DedicatedIp', ], ], 'DefaultDimensionValue' => [ 'type' => 'string', ], 'DeleteConfigurationSetEventDestinationRequest' => [ 'type' => 'structure', 'required' => [ 'ConfigurationSetName', 'EventDestinationName', ], 'members' => [ 'ConfigurationSetName' => [ 'shape' => 'ConfigurationSetName', 'location' => 'uri', 'locationName' => 'ConfigurationSetName', ], 'EventDestinationName' => [ 'shape' => 'EventDestinationName', 'location' => 'uri', 'locationName' => 'EventDestinationName', ], ], ], 'DeleteConfigurationSetEventDestinationResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteConfigurationSetRequest' => [ 'type' => 'structure', 'required' => [ 'ConfigurationSetName', ], 'members' => [ 'ConfigurationSetName' => [ 'shape' => 'ConfigurationSetName', 'location' => 'uri', 'locationName' => 'ConfigurationSetName', ], ], ], 'DeleteConfigurationSetResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteDedicatedIpPoolRequest' => [ 'type' => 'structure', 'required' => [ 'PoolName', ], 'members' => [ 'PoolName' => [ 'shape' => 'PoolName', 'location' => 'uri', 'locationName' => 'PoolName', ], ], ], 'DeleteDedicatedIpPoolResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteEmailIdentityRequest' => [ 'type' => 'structure', 'required' => [ 'EmailIdentity', ], 'members' => [ 'EmailIdentity' => [ 'shape' => 'Identity', 'location' => 'uri', 'locationName' => 'EmailIdentity', ], ], ], 'DeleteEmailIdentityResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeliveryOptions' => [ 'type' => 'structure', 'members' => [ 'SendingPoolName' => [ 'shape' => 'PoolName', ], ], ], 'Destination' => [ 'type' => 'structure', 'members' => [ 'ToAddresses' => [ 'shape' => 'EmailAddressList', ], 'CcAddresses' => [ 'shape' => 'EmailAddressList', ], 'BccAddresses' => [ 'shape' => 'EmailAddressList', ], ], ], 'DimensionName' => [ 'type' => 'string', ], 'DimensionValueSource' => [ 'type' => 'string', 'enum' => [ 'MESSAGE_TAG', 'EMAIL_HEADER', 'LINK_TAG', ], ], 'DkimAttributes' => [ 'type' => 'structure', 'members' => [ 'SigningEnabled' => [ 'shape' => 'Enabled', ], 'Status' => [ 'shape' => 'DkimStatus', ], 'Tokens' => [ 'shape' => 'DnsTokenList', ], ], ], 'DkimStatus' => [ 'type' => 'string', 'enum' => [ 'PENDING', 'SUCCESS', 'FAILED', 'TEMPORARY_FAILURE', 'NOT_STARTED', ], ], 'DnsToken' => [ 'type' => 'string', ], 'DnsTokenList' => [ 'type' => 'list', 'member' => [ 'shape' => 'DnsToken', ], ], 'EmailAddress' => [ 'type' => 'string', ], 'EmailAddressList' => [ 'type' => 'list', 'member' => [ 'shape' => 'EmailAddress', ], ], 'EmailContent' => [ 'type' => 'structure', 'members' => [ 'Simple' => [ 'shape' => 'Message', ], 'Raw' => [ 'shape' => 'RawMessage', ], ], ], 'Enabled' => [ 'type' => 'boolean', ], 'EventDestination' => [ 'type' => 'structure', 'required' => [ 'Name', 'MatchingEventTypes', ], 'members' => [ 'Name' => [ 'shape' => 'EventDestinationName', ], 'Enabled' => [ 'shape' => 'Enabled', ], 'MatchingEventTypes' => [ 'shape' => 'EventTypes', ], 'KinesisFirehoseDestination' => [ 'shape' => 'KinesisFirehoseDestination', ], 'CloudWatchDestination' => [ 'shape' => 'CloudWatchDestination', ], 'SnsDestination' => [ 'shape' => 'SnsDestination', ], 'PinpointDestination' => [ 'shape' => 'PinpointDestination', ], ], ], 'EventDestinationDefinition' => [ 'type' => 'structure', 'members' => [ 'Enabled' => [ 'shape' => 'Enabled', ], 'MatchingEventTypes' => [ 'shape' => 'EventTypes', ], 'KinesisFirehoseDestination' => [ 'shape' => 'KinesisFirehoseDestination', ], 'CloudWatchDestination' => [ 'shape' => 'CloudWatchDestination', ], 'SnsDestination' => [ 'shape' => 'SnsDestination', ], 'PinpointDestination' => [ 'shape' => 'PinpointDestination', ], ], ], 'EventDestinationName' => [ 'type' => 'string', ], 'EventDestinations' => [ 'type' => 'list', 'member' => [ 'shape' => 'EventDestination', ], ], 'EventType' => [ 'type' => 'string', 'enum' => [ 'SEND', 'REJECT', 'BOUNCE', 'COMPLAINT', 'DELIVERY', 'OPEN', 'CLICK', 'RENDERING_FAILURE', ], ], 'EventTypes' => [ 'type' => 'list', 'member' => [ 'shape' => 'EventType', ], ], 'GeneralEnforcementStatus' => [ 'type' => 'string', ], 'GetAccountRequest' => [ 'type' => 'structure', 'members' => [], ], 'GetAccountResponse' => [ 'type' => 'structure', 'members' => [ 'SendQuota' => [ 'shape' => 'SendQuota', ], 'SendingEnabled' => [ 'shape' => 'Enabled', ], 'DedicatedIpAutoWarmupEnabled' => [ 'shape' => 'Enabled', ], 'EnforcementStatus' => [ 'shape' => 'GeneralEnforcementStatus', ], 'ProductionAccessEnabled' => [ 'shape' => 'Enabled', ], ], ], 'GetConfigurationSetEventDestinationsRequest' => [ 'type' => 'structure', 'required' => [ 'ConfigurationSetName', ], 'members' => [ 'ConfigurationSetName' => [ 'shape' => 'ConfigurationSetName', 'location' => 'uri', 'locationName' => 'ConfigurationSetName', ], ], ], 'GetConfigurationSetEventDestinationsResponse' => [ 'type' => 'structure', 'members' => [ 'EventDestinations' => [ 'shape' => 'EventDestinations', ], ], ], 'GetConfigurationSetRequest' => [ 'type' => 'structure', 'required' => [ 'ConfigurationSetName', ], 'members' => [ 'ConfigurationSetName' => [ 'shape' => 'ConfigurationSetName', 'location' => 'uri', 'locationName' => 'ConfigurationSetName', ], ], ], 'GetConfigurationSetResponse' => [ 'type' => 'structure', 'members' => [ 'ConfigurationSetName' => [ 'shape' => 'ConfigurationSetName', ], 'TrackingOptions' => [ 'shape' => 'TrackingOptions', ], 'DeliveryOptions' => [ 'shape' => 'DeliveryOptions', ], 'ReputationOptions' => [ 'shape' => 'ReputationOptions', ], 'SendingOptions' => [ 'shape' => 'SendingOptions', ], ], ], 'GetDedicatedIpRequest' => [ 'type' => 'structure', 'required' => [ 'Ip', ], 'members' => [ 'Ip' => [ 'shape' => 'Ip', 'location' => 'uri', 'locationName' => 'IP', ], ], ], 'GetDedicatedIpResponse' => [ 'type' => 'structure', 'members' => [ 'DedicatedIp' => [ 'shape' => 'DedicatedIp', ], ], ], 'GetDedicatedIpsRequest' => [ 'type' => 'structure', 'members' => [ 'PoolName' => [ 'shape' => 'PoolName', ], 'NextToken' => [ 'shape' => 'NextToken', ], 'PageSize' => [ 'shape' => 'MaxItems', ], ], ], 'GetDedicatedIpsResponse' => [ 'type' => 'structure', 'members' => [ 'DedicatedIps' => [ 'shape' => 'DedicatedIpList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'GetEmailIdentityRequest' => [ 'type' => 'structure', 'required' => [ 'EmailIdentity', ], 'members' => [ 'EmailIdentity' => [ 'shape' => 'Identity', 'location' => 'uri', 'locationName' => 'EmailIdentity', ], ], ], 'GetEmailIdentityResponse' => [ 'type' => 'structure', 'members' => [ 'IdentityType' => [ 'shape' => 'IdentityType', ], 'FeedbackForwardingStatus' => [ 'shape' => 'Enabled', ], 'VerifiedForSendingStatus' => [ 'shape' => 'Enabled', ], 'DkimAttributes' => [ 'shape' => 'DkimAttributes', ], 'MailFromAttributes' => [ 'shape' => 'MailFromAttributes', ], ], ], 'Identity' => [ 'type' => 'string', ], 'IdentityInfo' => [ 'type' => 'structure', 'members' => [ 'IdentityType' => [ 'shape' => 'IdentityType', ], 'IdentityName' => [ 'shape' => 'Identity', ], 'SendingEnabled' => [ 'shape' => 'Enabled', ], ], ], 'IdentityInfoList' => [ 'type' => 'list', 'member' => [ 'shape' => 'IdentityInfo', ], ], 'IdentityType' => [ 'type' => 'string', 'enum' => [ 'EMAIL_ADDRESS', 'DOMAIN', 'MANAGED_DOMAIN', ], ], 'Ip' => [ 'type' => 'string', ], 'KinesisFirehoseDestination' => [ 'type' => 'structure', 'required' => [ 'IamRoleArn', 'DeliveryStreamArn', ], 'members' => [ 'IamRoleArn' => [ 'shape' => 'AmazonResourceName', ], 'DeliveryStreamArn' => [ 'shape' => 'AmazonResourceName', ], ], ], 'LastFreshStart' => [ 'type' => 'timestamp', ], 'LimitExceededException' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'ListConfigurationSetsRequest' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', ], 'PageSize' => [ 'shape' => 'MaxItems', ], ], ], 'ListConfigurationSetsResponse' => [ 'type' => 'structure', 'members' => [ 'ConfigurationSets' => [ 'shape' => 'ConfigurationSetNameList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListDedicatedIpPoolsRequest' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', ], 'PageSize' => [ 'shape' => 'MaxItems', ], ], ], 'ListDedicatedIpPoolsResponse' => [ 'type' => 'structure', 'members' => [ 'DedicatedIpPools' => [ 'shape' => 'ListOfDedicatedIpPools', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListEmailIdentitiesRequest' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', ], 'PageSize' => [ 'shape' => 'MaxItems', ], ], ], 'ListEmailIdentitiesResponse' => [ 'type' => 'structure', 'members' => [ 'EmailIdentities' => [ 'shape' => 'IdentityInfoList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListOfDedicatedIpPools' => [ 'type' => 'list', 'member' => [ 'shape' => 'PoolName', ], ], 'MailFromAttributes' => [ 'type' => 'structure', 'required' => [ 'MailFromDomain', 'MailFromDomainStatus', 'BehaviorOnMxFailure', ], 'members' => [ 'MailFromDomain' => [ 'shape' => 'MailFromDomainName', ], 'MailFromDomainStatus' => [ 'shape' => 'MailFromDomainStatus', ], 'BehaviorOnMxFailure' => [ 'shape' => 'BehaviorOnMxFailure', ], ], ], 'MailFromDomainName' => [ 'type' => 'string', ], 'MailFromDomainNotVerifiedException' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'MailFromDomainStatus' => [ 'type' => 'string', 'enum' => [ 'PENDING', 'SUCCESS', 'FAILED', 'TEMPORARY_FAILURE', ], ], 'Max24HourSend' => [ 'type' => 'double', ], 'MaxItems' => [ 'type' => 'integer', ], 'MaxSendRate' => [ 'type' => 'double', ], 'Message' => [ 'type' => 'structure', 'required' => [ 'Subject', 'Body', ], 'members' => [ 'Subject' => [ 'shape' => 'Content', ], 'Body' => [ 'shape' => 'Body', ], ], ], 'MessageData' => [ 'type' => 'string', ], 'MessageRejected' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'MessageTag' => [ 'type' => 'structure', 'required' => [ 'Name', 'Value', ], 'members' => [ 'Name' => [ 'shape' => 'MessageTagName', ], 'Value' => [ 'shape' => 'MessageTagValue', ], ], ], 'MessageTagList' => [ 'type' => 'list', 'member' => [ 'shape' => 'MessageTag', ], ], 'MessageTagName' => [ 'type' => 'string', ], 'MessageTagValue' => [ 'type' => 'string', ], 'NextToken' => [ 'type' => 'string', ], 'NotFoundException' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], 'OutboundMessageId' => [ 'type' => 'string', ], 'Percentage100Wrapper' => [ 'type' => 'integer', ], 'PinpointDestination' => [ 'type' => 'structure', 'members' => [ 'ApplicationArn' => [ 'shape' => 'AmazonResourceName', ], ], ], 'PoolName' => [ 'type' => 'string', ], 'PutAccountDedicatedIpWarmupAttributesRequest' => [ 'type' => 'structure', 'members' => [ 'AutoWarmupEnabled' => [ 'shape' => 'Enabled', ], ], ], 'PutAccountDedicatedIpWarmupAttributesResponse' => [ 'type' => 'structure', 'members' => [], ], 'PutAccountSendingAttributesRequest' => [ 'type' => 'structure', 'members' => [ 'SendingEnabled' => [ 'shape' => 'Enabled', ], ], ], 'PutAccountSendingAttributesResponse' => [ 'type' => 'structure', 'members' => [], ], 'PutConfigurationSetDeliveryOptionsRequest' => [ 'type' => 'structure', 'required' => [ 'ConfigurationSetName', ], 'members' => [ 'ConfigurationSetName' => [ 'shape' => 'ConfigurationSetName', 'location' => 'uri', 'locationName' => 'ConfigurationSetName', ], 'SendingPoolName' => [ 'shape' => 'SendingPoolName', ], ], ], 'PutConfigurationSetDeliveryOptionsResponse' => [ 'type' => 'structure', 'members' => [], ], 'PutConfigurationSetReputationOptionsRequest' => [ 'type' => 'structure', 'required' => [ 'ConfigurationSetName', ], 'members' => [ 'ConfigurationSetName' => [ 'shape' => 'ConfigurationSetName', 'location' => 'uri', 'locationName' => 'ConfigurationSetName', ], 'ReputationMetricsEnabled' => [ 'shape' => 'Enabled', ], ], ], 'PutConfigurationSetReputationOptionsResponse' => [ 'type' => 'structure', 'members' => [], ], 'PutConfigurationSetSendingOptionsRequest' => [ 'type' => 'structure', 'required' => [ 'ConfigurationSetName', ], 'members' => [ 'ConfigurationSetName' => [ 'shape' => 'ConfigurationSetName', 'location' => 'uri', 'locationName' => 'ConfigurationSetName', ], 'SendingEnabled' => [ 'shape' => 'Enabled', ], ], ], 'PutConfigurationSetSendingOptionsResponse' => [ 'type' => 'structure', 'members' => [], ], 'PutConfigurationSetTrackingOptionsRequest' => [ 'type' => 'structure', 'required' => [ 'ConfigurationSetName', ], 'members' => [ 'ConfigurationSetName' => [ 'shape' => 'ConfigurationSetName', 'location' => 'uri', 'locationName' => 'ConfigurationSetName', ], 'CustomRedirectDomain' => [ 'shape' => 'CustomRedirectDomain', ], ], ], 'PutConfigurationSetTrackingOptionsResponse' => [ 'type' => 'structure', 'members' => [], ], 'PutDedicatedIpInPoolRequest' => [ 'type' => 'structure', 'required' => [ 'Ip', 'DestinationPoolName', ], 'members' => [ 'Ip' => [ 'shape' => 'Ip', 'location' => 'uri', 'locationName' => 'IP', ], 'DestinationPoolName' => [ 'shape' => 'PoolName', ], ], ], 'PutDedicatedIpInPoolResponse' => [ 'type' => 'structure', 'members' => [], ], 'PutDedicatedIpWarmupAttributesRequest' => [ 'type' => 'structure', 'required' => [ 'Ip', 'WarmupPercentage', ], 'members' => [ 'Ip' => [ 'shape' => 'Ip', 'location' => 'uri', 'locationName' => 'IP', ], 'WarmupPercentage' => [ 'shape' => 'Percentage100Wrapper', ], ], ], 'PutDedicatedIpWarmupAttributesResponse' => [ 'type' => 'structure', 'members' => [], ], 'PutEmailIdentityDkimAttributesRequest' => [ 'type' => 'structure', 'required' => [ 'EmailIdentity', ], 'members' => [ 'EmailIdentity' => [ 'shape' => 'Identity', 'location' => 'uri', 'locationName' => 'EmailIdentity', ], 'SigningEnabled' => [ 'shape' => 'Enabled', ], ], ], 'PutEmailIdentityDkimAttributesResponse' => [ 'type' => 'structure', 'members' => [], ], 'PutEmailIdentityFeedbackAttributesRequest' => [ 'type' => 'structure', 'required' => [ 'EmailIdentity', ], 'members' => [ 'EmailIdentity' => [ 'shape' => 'Identity', 'location' => 'uri', 'locationName' => 'EmailIdentity', ], 'EmailForwardingEnabled' => [ 'shape' => 'Enabled', ], ], ], 'PutEmailIdentityFeedbackAttributesResponse' => [ 'type' => 'structure', 'members' => [], ], 'PutEmailIdentityMailFromAttributesRequest' => [ 'type' => 'structure', 'required' => [ 'EmailIdentity', ], 'members' => [ 'EmailIdentity' => [ 'shape' => 'Identity', 'location' => 'uri', 'locationName' => 'EmailIdentity', ], 'MailFromDomain' => [ 'shape' => 'MailFromDomainName', ], 'BehaviorOnMxFailure' => [ 'shape' => 'BehaviorOnMxFailure', ], ], ], 'PutEmailIdentityMailFromAttributesResponse' => [ 'type' => 'structure', 'members' => [], ], 'RawMessage' => [ 'type' => 'structure', 'required' => [ 'Data', ], 'members' => [ 'Data' => [ 'shape' => 'RawMessageData', ], ], ], 'RawMessageData' => [ 'type' => 'blob', ], 'ReputationOptions' => [ 'type' => 'structure', 'members' => [ 'ReputationMetricsEnabled' => [ 'shape' => 'Enabled', ], 'LastFreshStart' => [ 'shape' => 'LastFreshStart', ], ], ], 'SendEmailRequest' => [ 'type' => 'structure', 'required' => [ 'Destination', 'Content', ], 'members' => [ 'FromEmailAddress' => [ 'shape' => 'EmailAddress', ], 'Destination' => [ 'shape' => 'Destination', ], 'ReplyToAddresses' => [ 'shape' => 'EmailAddressList', ], 'FeedbackForwardingEmailAddress' => [ 'shape' => 'EmailAddress', ], 'Content' => [ 'shape' => 'EmailContent', ], 'EmailTags' => [ 'shape' => 'MessageTagList', ], 'ConfigurationSetName' => [ 'shape' => 'ConfigurationSetName', ], ], ], 'SendEmailResponse' => [ 'type' => 'structure', 'members' => [ 'MessageId' => [ 'shape' => 'OutboundMessageId', ], ], ], 'SendQuota' => [ 'type' => 'structure', 'members' => [ 'Max24HourSend' => [ 'shape' => 'Max24HourSend', ], 'MaxSendRate' => [ 'shape' => 'MaxSendRate', ], 'SentLast24Hours' => [ 'shape' => 'SentLast24Hours', ], ], ], 'SendingOptions' => [ 'type' => 'structure', 'members' => [ 'SendingEnabled' => [ 'shape' => 'Enabled', ], ], ], 'SendingPausedException' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'SendingPoolName' => [ 'type' => 'string', ], 'SentLast24Hours' => [ 'type' => 'double', ], 'SnsDestination' => [ 'type' => 'structure', 'required' => [ 'TopicArn', ], 'members' => [ 'TopicArn' => [ 'shape' => 'AmazonResourceName', ], ], ], 'TooManyRequestsException' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], 'TrackingOptions' => [ 'type' => 'structure', 'required' => [ 'CustomRedirectDomain', ], 'members' => [ 'CustomRedirectDomain' => [ 'shape' => 'CustomRedirectDomain', ], ], ], 'UpdateConfigurationSetEventDestinationRequest' => [ 'type' => 'structure', 'required' => [ 'ConfigurationSetName', 'EventDestinationName', 'EventDestination', ], 'members' => [ 'ConfigurationSetName' => [ 'shape' => 'ConfigurationSetName', 'location' => 'uri', 'locationName' => 'ConfigurationSetName', ], 'EventDestinationName' => [ 'shape' => 'EventDestinationName', 'location' => 'uri', 'locationName' => 'EventDestinationName', ], 'EventDestination' => [ 'shape' => 'EventDestinationDefinition', ], ], ], 'UpdateConfigurationSetEventDestinationResponse' => [ 'type' => 'structure', 'members' => [], ], 'WarmupStatus' => [ 'type' => 'string', 'enum' => [ 'IN_PROGRESS', 'DONE', ], ], ],];
